<?php
/**
 * @package     Expose Baase Theme
 * @version     2.4
 * @author      ThemeXpert http://www.themexpert.com
 * @copyright   Copyright (C) 2010 - 2011 ThemeXpert
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3
 *
 **/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted index access' );

//framework bootstrap
if( file_exists( JPATH_LIBRARIES . '/expose/expose.php' ) ){

    require_once JPATH_LIBRARIES . '/expose/expose.php';

}else{
    echo JText::_('Unable to find Expose library. Please make sure you have it installed.');
    die();
}

?>
<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $expose->direction ;?>" class="no-js">
    <head>
<?php
ini_set('zlib.output_compression', 'On');
ini_set('zlib.output_compression_level', '1');
?>
        <?php
            $expose->displayHead();
            $expose->addLink(array('typography.less',
                                    'template.less',
                                    'responsive.less',
                                    'xperttabs.less',
                                    'xpertslider.less',
                                    'vmsite-ltr.less'),'less');
            $expose->addLink( array('template.js','bootstrap.min.js') ,'js', 11 );

        ?>

        <!--[if (gte IE 6) & (lte IE 8)]>
            <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
            <script src="<?php echo $expose->exposeUrl; ?>/interface/js/respond.js"></script>
            <script src="<?php echo $expose->exposeUrl; ?>/interface/js/selectivizr.js"></script>
        <![endif]-->

    </head>
    
    <body <?php echo $expose->generateBodyClass();?> >
        <section class="container">

            <?php /**Begin Roof**/ if($expose->countModules('roof')): ?>
            <!--Start Roof Modules-->
            <section id="roof" class="row">
                <?php $expose->renderModules('roof'); ?>
            </section>
            <!--End Roof Modules-->
            <?php /**End Roof**/ endif;?>

            <header id="header-wrap">

                <?php /**Begin Top**/ if($expose->countModules('top')): ?>
                <!--Start Top Modules-->
                <section id="top" class="row">
                        <?php $expose->renderModules('top'); ?>
                </section>
                <!--End Top Modules-->
                <?php /**End Top**/ endif;?>

                <?php /**Begin Header**/ if($expose->countModules('header')): ?>
                <!--Start Header Modules-->
                <section id="header" class="row">
                    <?php $expose->renderModules('header'); ?>
                </section>
                <!--End Header Modules-->
                <?php /**End Header**/ endif;?>

            </header>

            <?php /**Begin Utility**/ if($expose->countModules('utility')): ?>
            <!--Start Utility Modules-->
            <section id="utility" class="row">
                <?php $expose->renderModules('utility'); ?>
            </section>          
            <!--End Utility Modules-->
            <?php /**End Utility**/ endif;?>

            <section id="middle-wrap">
    
                <?php /**Begin Feature**/ if($expose->countModules('feature')): ?>
                <!--Start Feature Modules-->
                <section id="feature" class="row">
                    <?php $expose->renderModules('feature'); ?>
                </section>
                <!--End Feature Modules-->
                <?php /**End Feature**/ endif;?>
        
                <?php /**Begin Main-Top**/ if($expose->countModules('maintop')): ?>
                <!--Start Main-Top Modules-->
                <section id="main-top" class="row">
                    <?php $expose->renderModules('maintop'); ?>
                </section>
                <!--End Main-Top Modules-->
                <?php /**End Main-Top**/ endif;?>
        
                <?php /**Begin Breadcrumbs**/ if($expose->countModules('breadcrumbs')): ?>
                <!--Start Breadcrumbs Module-->
                <section id="breadcrumbs" class="row">
                    <?php $expose->renderModules('breadcrumbs'); ?>
                </section>
                <!--End Breadcrumbs Module-->
                <?php /**End Breadcrumbs**/ endif;?>
        
                <!--Start Main Body-->
                <section id="main" class="row">
                    <?php $expose->renderBody();?>
                </section>
                <!--End Main Body Modules-->
        
                <?php /**Begin Main-Bottom**/ if($expose->countModules('mainbottom')): ?>
                <!--Start Main-Bottom Modules-->
                <section id="main-bottom" class="row">
                    <?php $expose->renderModules('mainbottom'); ?>
                </section>
                <!--End Main Bottom Modules-->
                <?php /**End Main Bottom**/ endif;?>

            </section>
    
            
            <footer id="footer-wrap">

                <?php /**Begin Bottom**/ if($expose->countModules('bottom')): ?>
                <!--Start Bottom Modules-->
                <section id="bottom" class="row">
                    <?php $expose->renderModules('bottom'); ?>
                </section>
                <!--End Bottom Modules-->
                <?php /**End Bottom**/ endif;?>

                <?php /**Begin Footer**/ if($expose->countModules('footer')): ?>
                <!--Start Footer Modules-->
                <section id="footer" class="row">
                    <?php $expose->renderModules('footer'); ?>                
                </section>
                <!--End Footer Modules-->
                <?php /**End Footer**/ endif;?>

                <?php /**Begin Copyright**/ if($expose->countModules('copyright')): ?>
                <section id="copyright" class="row">
                <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr>
    <td align="center"><iframe src="//www.facebook.com/plugins/likebox.php?href=https%3A%2F%2Fwww.facebook.com%2Fcodinter&amp;width=950&amp;height=270&amp;colorscheme=light&amp;show_faces=true&amp;header=true&amp;stream=false&amp;show_border=true&amp;appId=166964833497896" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:950px; height:270px;" allowTransparency="true"></iframe></td>
  </tr>
</table>
                    <table width="560" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td width="40"><a href="http://www.Guatedominios.com" target="_blank"><img src="http://www.guatedominios.com/images/logofooter.png" alt="Guatedominios.com" border="0" class="pngfix" width="40" height="41" align="left"/></a></td>
    <td width="520">Dise&ntilde;o: <a href="http://www.Guatedominios.com" target="_blank"><strong> Guatedominios.com</strong></a><br />
      Copyright &copy; Codinter. Todos los Derechos Reservados.</td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
              </table>
                            
              </section>
                <?php /**End Copyright**/ endif;?>

            </footer>

            <?php /**Begin Absolute**/ if($expose->countModules('absolute')): ?>
            <div id="absolute">
                <?php $expose->renderModules('absolute'); ?>
            </div>
            <?php /**End Absolute**/ endif;?>

            <?php /** Begin Off-canvas **/ if($expose->countModules('offcanvas')): ?>
            <div id="offcanvas" class="uk-offcanvas">
                <div class="uk-offcanvas-bar">
                    <?php $expose->renderModules('offcanvas'); ?>
                </div>
            </div>
            <?php /** End Offcanvas **/ endif;?> 

        </section> <!-- End of Container -->
    </body>
</html>
<?php
$expose->finalizedExpose();
?>