<?php
#####################################################################################################
#
#					Module pour la plateforme de paiement Systempay
#						Version : 1.2 (révision 33398)
#									########################
#					Développé pour VirtueMart
#						Version : 2.0.0
#						Compatibilité plateforme : V2
#									########################
#					Développé par Lyra Network
#						http://www.lyra-network.com/
#						20/02/2012
#						Contact : supportvad@lyra-network.com
#
#####################################################################################################

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();

/**
 * Renders a multiple item select element
 *
 */

class JElementSystempayMultiList extends JElement
{
	/**
	 * Element name
	 *
	 * @access       protected
	 * @var          string
	 */
	var $_name = 'SystempayMultiList';

	function fetchElement ($name, $value, &$node, $control_name)
	{
		// Base name of the HTML control.
		$ctrl = $control_name . '[' . $name . ']';

		// Construct an array of the HTML OPTION statements.
		$options = array();
		foreach ($node->children() as $option) {
			$val = $option->attributes('value');
			$text = $option->data();
			$options[] = JHTML::_('select.option', $val, JText::_($text));
		}

		// Construct the various argument calls that are supported.
		$attribs = ' ';
		if ($v = $node->attributes('size')) {
			$attribs .= 'size="' . $v . '"';
		}
		if ($v = $node->attributes('class')) {
			$attribs .= 'class="' . $v . '"';
		} else {
			$attribs .= 'class="inputbox"';
		}
		if ($m = $node->attributes('multiple')) {
			$attribs = 'multiple="true"   data-placeholder="' . JText::_('COM_VIRTUEMART_DRDOWN_SELECT_SOME_OPTIONS') . '"';

			$ctrl .= '[]';
		}

		// Render the HTML SELECT list.
		return JHTML::_('select.genericlist', $options, $ctrl, $attribs, 'value', 'text', $value, $control_name . $name);
	}
}