<?php
/**
* @version 2.0.7
* @package PWebFBLinkArticleImages
* @copyright © 2013 Majestic Media sp. z o.o., All rights reserved. http://www.perfect-web.co
* @license GNU General Public Licence http://www.gnu.org/licenses/gpl-3.0.html
* @author Piotr Moćko
*/

defined('_JEXEC') or die( 'Restricted access' );

JFormHelper::loadFieldClass('Radio');

/**
 * Perfect-Web
 *
 * @subpackage	plg_fblinkcontentimage
 * @since		2.5
 */
class JFormFieldPweb extends JFormFieldRadio
{
	protected $extension = 'plg_fblinkcontentimage_core';
	protected $documentation = 'http://www.perfect-web.co/joomla/plugins/link-with-article-images-facebook/documentation';
	protected $home = 'http://www.perfect-web.co/joomla/plugins/link-with-article-images-facebook';
	
	protected function getInput()
	{		
		$app = JFactory::getApplication();
		$doc = JFactory::getDocument();
		
		// add documentation and upgrade toolbar button
		if (version_compare(JVERSION, '3.0.0') == -1) {
			$button = '<a href="'.$this->documentation.'" style="font-weight:bold;border-color:#025A8D;background-color:#DBE4E9;" target="_blank"><span class="icon-32-help"> </span> '.JText::_('PLG_PWEB_FBARTICLEIMAGES_DOCUMENTATION').'</a>';
			
			$button_upgrade = '<a href="'.$this->home.'" style="font-weight:bold;border-color:#025A8D;background-color:#DBE4E9;" target="_blank"><span class="icon-32-upload"> </span> '.JText::_('PLG_PWEB_FBARTICLEIMAGES_UPGRADE_PRO').'</a>';
		} else {
			$button = '<a href="'.$this->documentation.'" class="btn btn-small btn-info" target="_blank"><i class="icon-support"> </i> </span> '.JText::_('PLG_PWEB_FBARTICLEIMAGES_DOCUMENTATION').'</a>';
			
			$button_upgrade = '<a href="'.$this->home.'" class="btn btn-small btn-info" target="_blank"><i class="icon-upload "> </i> </span> '.JText::_('PLG_PWEB_FBARTICLEIMAGES_UPGRADE_PRO').'</a>';
		}
		$bar = JToolBar::getInstance();
		$bar->appendButton('Custom', $button, $this->extension.'-docs');
		$bar->appendButton('Custom', $button_upgrade, $this->extension.'-upgrade');
		
		// Check if SEF is enabled
		if (!$app->getCfg('sef')) 
		{
			$app->enqueueMessage('Enable <a href="index.php?option=com_config" onclick="Cookie.write(\'configuration\',\'site\')" target="_blank">Search Engine Friendly URLs</a> in SEO Settings on Site tab for better experience on Facebook', 'warning');
		}

		// Core version disabled fields
		if (version_compare(JVERSION, '3.0.0') == -1) {
			JHtml::_('behavior.framework');
			$doc->addScriptDeclaration(
				'window.addEvent("domready",function(){'.
					'$$("form[name=adminForm] input:disabled").each(function(el){'.
						'$$("label[for="+el.get("id")+"]").addClass("disabled").removeEvents("click");'.
					'});'.
				'});'
			);
			$doc->addStyleDeclaration(
				'label.disabled{color:#aaa}'
			);
		} else {
			$doc->addScriptDeclaration(
				'jQuery(document).ready(function($){'.
					'$("form[name=adminForm] input:disabled").each(function(){'.
						'$("label[for="+$(this).attr("id")+"]").addClass("disabled").unbind("click");'.
					'});'.
				'});'
			);
		}
		
		// add feed script
		if ($this->value)
		{
			$doc->addScriptDeclaration(
				'(function(){'.
				'var pw=document.createElement("script");pw.type="text/javascript";pw.async=true;'.
				'pw.src="//www.perfect-web.co/updates/feed.js?ext='.$this->extension.'&j='.JVERSION.'";'.
				'var s=document.getElementsByTagName("script")[0];s.parentNode.insertBefore(pw,s);'.
				'})();'
			);
		}
		
		return parent::getInput();
	}
}