--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=252 ;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 1, 404, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":[],"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 2, 3, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 4, 11, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 12, 13, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 14, 15, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 16, 17, 1, 'com_config', 'com_config', '{}'),
(7, 1, 18, 87, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(8, 1, 88, 277, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 278, 279, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 280, 281, 1, 'com_installer', 'com_installer', '{"core.admin":{"7":1},"core.manage":{"7":1},"core.create":[],"core.delete":[],"core.edit.state":[]}'),
(11, 1, 282, 283, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 284, 285, 1, 'com_login', 'com_login', '{}'),
(13, 1, 286, 287, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 288, 289, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 290, 291, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1},"core.edit":[],"core.edit.state":[]}'),
(16, 1, 292, 293, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 37, 38, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 296, 297, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 298, 305, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(20, 1, 306, 307, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 308, 309, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 310, 311, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 312, 313, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 314, 315, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(25, 1, 316, 333, 1, 'com_weblinks', 'com_weblinks', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1,"10":0,"12":0},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1}}'),
(26, 1, 334, 335, 1, 'com_wrapper', 'com_wrapper', '{}'),
(34, 8, 105, 108, 2, 'com_content.category.9', 'Uncategorised', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(35, 3, 7, 8, 2, 'com_banners.category.10', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(36, 7, 23, 24, 2, 'com_contact.category.11', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(37, 19, 301, 302, 2, 'com_newsfeeds.category.12', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(38, 25, 323, 324, 2, 'com_weblinks.category.13', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(39, 8, 109, 166, 2, 'com_content.category.14', 'Sample Data-Articles', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(40, 3, 9, 10, 2, 'com_banners.category.15', 'Sample Data-Banners', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 7, 25, 86, 2, 'com_contact.category.16', 'Sample Data-Contact', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 19, 303, 304, 2, 'com_newsfeeds.category.17', 'Sample Data-Newsfeeds', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(43, 25, 325, 332, 2, 'com_weblinks.category.18', 'Sample Data-Weblinks', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(44, 39, 110, 125, 3, 'com_content.category.19', 'Joomla!', '{"core.create":{"10":0,"12":0},"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(56, 43, 326, 327, 3, 'com_weblinks.category.31', 'Park Links', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(57, 43, 328, 331, 3, 'com_weblinks.category.32', 'Joomla! Specific Links', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(58, 57, 329, 330, 4, 'com_weblinks.category.33', 'Other Resources', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(59, 41, 26, 27, 3, 'com_contact.category.34', 'Park Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(60, 41, 28, 85, 3, 'com_contact.category.35', 'Shop Site', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(61, 60, 29, 30, 4, 'com_contact.category.36', 'Staff', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(62, 60, 31, 84, 4, 'com_contact.category.37', 'Fruit Encyclopedia', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(63, 62, 32, 33, 5, 'com_contact.category.38', 'A', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(64, 62, 34, 35, 5, 'com_contact.category.39', 'B', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(65, 62, 36, 37, 5, 'com_contact.category.40', 'C', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(66, 62, 38, 39, 5, 'com_contact.category.41', 'D', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(67, 62, 40, 41, 5, 'com_contact.category.42', 'E', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(68, 62, 42, 43, 5, 'com_contact.category.43', 'F', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(69, 62, 44, 45, 5, 'com_contact.category.44', 'G', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(70, 62, 46, 47, 5, 'com_contact.category.45', 'H', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(71, 62, 48, 49, 5, 'com_contact.category.46', 'I', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(72, 62, 50, 51, 5, 'com_contact.category.47', 'J', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(73, 62, 52, 53, 5, 'com_contact.category.48', 'K', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(74, 62, 54, 55, 5, 'com_contact.category.49', 'L', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(75, 62, 56, 57, 5, 'com_contact.category.50', 'M', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(76, 62, 58, 59, 5, 'com_contact.category.51', 'N', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(77, 62, 60, 61, 5, 'com_contact.category.52', 'O', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(78, 62, 62, 63, 5, 'com_contact.category.53', 'P', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(79, 62, 64, 65, 5, 'com_contact.category.54', 'Q', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(80, 62, 66, 67, 5, 'com_contact.category.55', 'R', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(81, 62, 68, 69, 5, 'com_contact.category.56', 'S', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(82, 62, 70, 71, 5, 'com_contact.category.57', 'T', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(83, 62, 72, 73, 5, 'com_contact.category.58', 'U', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(84, 62, 74, 75, 5, 'com_contact.category.59', 'V', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(85, 62, 76, 77, 5, 'com_contact.category.60', 'W', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(86, 62, 78, 79, 5, 'com_contact.category.61', 'X', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(87, 62, 80, 81, 5, 'com_contact.category.62', 'Y', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(88, 62, 82, 83, 5, 'com_contact.category.63', 'Z', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(104, 44, 111, 112, 4, 'com_content.article.8', 'Beginners', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(119, 44, 113, 114, 4, 'com_content.article.21', 'Getting Help', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(120, 44, 115, 116, 4, 'com_content.article.22', 'Getting Started', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(122, 44, 117, 118, 4, 'com_content.article.24', 'Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(133, 44, 119, 120, 4, 'com_content.article.35', 'Professionals', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(146, 44, 121, 122, 4, 'com_content.article.48', 'The Joomla! Project', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(147, 169, 129, 130, 4, 'com_content.article.49', 'Template Typography', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(151, 44, 123, 124, 4, 'com_content.article.53', 'Using Joomla!', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(168, 34, 106, 107, 3, 'com_content.article.67', 'What''s New in 1.5?', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(169, 39, 128, 165, 3, 'com_content.category.77', 'Features', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(170, 169, 131, 132, 4, 'com_content.article.68', 'Module Variations', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(173, 1, 398, 399, 1, 'com_finder', 'com_finder', '{"core.admin":[],"core.manage":[]}'),
(175, 169, 133, 134, 4, 'com_content.article.69', 'Module Positions', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(176, 169, 135, 136, 4, 'com_content.article.70', 'Expose Base Template', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(177, 169, 137, 138, 4, 'com_content.article.71', 'Preset Styles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(178, 169, 139, 140, 4, 'com_content.article.72', 'Custom Styling', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(179, 169, 141, 142, 4, 'com_content.article.73', 'Offline Page', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(180, 169, 143, 164, 4, 'com_content.category.78', 'Typography', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(181, 180, 144, 145, 5, 'com_content.article.74', 'Typography', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(182, 180, 146, 147, 5, 'com_content.article.75', 'List', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(183, 180, 148, 149, 5, 'com_content.article.76', 'Table', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(184, 180, 150, 151, 5, 'com_content.article.77', 'Forms', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(185, 180, 152, 153, 5, 'com_content.article.78', 'Buttons', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(186, 180, 154, 155, 5, 'com_content.article.79', 'Notice & Alerts', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(187, 180, 156, 157, 5, 'com_content.article.80', 'Icons', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(188, 180, 158, 159, 5, 'com_content.article.81', 'Thumbnail & Media', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(189, 180, 160, 161, 5, 'com_content.article.82', 'Label & Badges', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(190, 180, 162, 163, 5, 'com_content.article.83', 'Misc', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(191, 8, 167, 176, 2, 'com_content.category.79', 'Slider', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(192, 191, 168, 169, 3, 'com_content.article.84', 'Expose Framework', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(193, 191, 170, 171, 3, 'com_content.article.85', 'Rich Theme Documentation', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(194, 191, 172, 173, 3, 'com_content.article.86', 'Build Your Site Within A Minute', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(195, 191, 174, 175, 3, 'com_content.article.87', 'Joomla ecommerce template', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(196, 8, 177, 194, 2, 'com_content.category.80', 'Campus Gallery', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(197, 196, 178, 179, 3, 'com_content.article.88', 'Phasellus', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(198, 196, 180, 181, 3, 'com_content.article.89', 'Gravida odio', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(199, 196, 182, 183, 3, 'com_content.article.90', 'Parallax', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(200, 196, 184, 185, 3, 'com_content.article.91', 'Vestibulum', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(201, 196, 186, 187, 3, 'com_content.article.92', 'Streamx', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(202, 196, 188, 189, 3, 'com_content.article.93', 'Maximus', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(203, 196, 190, 191, 3, 'com_content.article.94', 'Vibration', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(204, 196, 192, 193, 3, 'com_content.article.95', 'Scelerisque', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(205, 8, 195, 212, 2, 'com_content.category.81', 'Team Members', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(206, 205, 196, 197, 3, 'com_content.article.96', 'John', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(207, 205, 198, 199, 3, 'com_content.article.97', 'Ricardo', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(208, 205, 200, 201, 3, 'com_content.article.98', 'Bob', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(209, 205, 202, 203, 3, 'com_content.article.99', 'Biddut', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(210, 205, 204, 205, 3, 'com_content.article.100', 'Rakib', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(211, 205, 206, 207, 3, 'com_content.article.101', 'Morgan', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(212, 205, 208, 209, 3, 'com_content.article.102', 'Bablu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(214, 8, 213, 230, 2, 'com_content.category.82', 'Pages', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(215, 214, 214, 215, 3, 'com_content.article.103', 'Who we are', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(216, 214, 216, 217, 3, 'com_content.article.104', 'Our Service', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(217, 214, 218, 219, 3, 'com_content.article.105', 'Portfolio', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(218, 8, 231, 244, 2, 'com_content.category.83', 'Extensions', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(219, 218, 232, 233, 3, 'com_content.article.106', 'Extensions', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(220, 218, 234, 235, 3, 'com_content.article.107', 'Xpert Slider', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(221, 218, 236, 237, 3, 'com_content.article.108', 'Xpert Scroller', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(222, 218, 238, 239, 3, 'com_content.article.109', 'Xpert Tabs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(223, 205, 210, 211, 3, 'com_content.article.110', 'Kamal', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(224, 8, 245, 250, 2, 'com_content.category.84', 'Frontpage', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(225, 224, 246, 247, 3, 'com_content.article.111', 'Flexible Layout System', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(226, 224, 248, 249, 3, 'com_content.article.112', 'SEO Optimized ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(227, 8, 251, 258, 2, 'com_content.category.85', 'Xpert Accordion', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(228, 227, 252, 253, 3, 'com_content.article.113', 'Fast Loading', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(229, 227, 254, 255, 3, 'com_content.article.114', 'Cross browser Compatible', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(230, 227, 256, 257, 3, 'com_content.article.115', 'Unique Design', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(231, 8, 259, 268, 2, 'com_content.category.86', 'Scroller - Meet Professor', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(232, 231, 260, 261, 3, 'com_content.article.116', 'Neil Braine', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(233, 231, 262, 263, 3, 'com_content.article.117', 'Keith Morgan', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(234, 8, 269, 276, 2, 'com_content.category.87', 'Slider - About Us', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(235, 234, 270, 271, 3, 'com_content.article.118', 'Nullam Lobortis', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(236, 234, 272, 273, 3, 'com_content.article.119', 'Aliquam', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(237, 234, 274, 275, 3, 'com_content.article.120', 'Mauris a orci', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(239, 231, 264, 265, 3, 'com_content.article.121', 'Albert Ryan', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(240, 231, 266, 267, 3, 'com_content.article.122', 'Jonathon', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(243, 218, 240, 241, 3, 'com_content.article.123', 'Xpert Captions', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(244, 218, 242, 243, 3, 'com_content.article.124', 'Xpert Accordion', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(245, 214, 220, 229, 3, 'com_content.category.88', 'About Us', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(246, 245, 221, 222, 4, 'com_content.article.125', 'Simon Ding', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(247, 245, 223, 224, 4, 'com_content.article.126', 'Albert braine', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(248, 245, 225, 226, 4, 'com_content.article.127', 'Neil Morgan', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(249, 245, 227, 228, 4, 'com_content.article.128', 'John Ryan', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(250, 1, 400, 401, 1, 'com_virtuemart', 'virtuemart', '{}'),
(251, 1, 402, 403, 1, 'com_virtuemart_allinone', 'virtuemart_allinone', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE `#__associations` (
  `id` varchar(50) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `#__banners`
--

INSERT INTO `#__banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`) VALUES
(2, 1, 0, 'Shop 1', 'shop-1', 0, 16, 0, 'http://shop.joomla.org/amazoncom-bookstores.html', 1, 15, 'Get books about Joomla! at the Joomla! book shop.', '', 0, 1, '', '{"imageurl":"images\\/banners\\/shop-ad-books.jpg","width":"","height":"","alt":"Joomla! Books"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2011-01-01 00:00:01', 'en-GB'),
(3, 1, 0, 'Shop 2', 'shop-2', 0, 22, 0, 'http://shop.joomla.org', 1, 15, 'T Shirts, caps and more from the Joomla! Shop.', '', 0, 2, '', '{"imageurl":"images\\/banners\\/shop-ad.jpg","width":"","height":"","alt":"Joomla! Shop"}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2011-01-01 00:00:01', 'en-GB'),
(4, 1, 0, 'Support Joomla!', 'support-joomla', 0, 19, 0, 'http://contribute.joomla.org', 1, 15, 'Your contributions of time, talent and money make Joomla! possible.', '', 0, 3, '', '{"imageurl":"images\\/banners\\/white.png","width":"","height":"","alt":""}', 0, '', -1, 0, 0, 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 'en-GB');

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `#__banner_clients`
--

INSERT INTO `#__banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES
(1, 'Joomla!', 'Administrator', 'email@email.com', '', 1, 0, '0000-00-00 00:00:00', '', 0, '', -1, -1, -1);

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned DEFAULT NULL,
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=89 ;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES
(1, 0, 0, 0, 113, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(9, 34, 1, 91, 92, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, '*'),
(10, 35, 1, 89, 90, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(11, 36, 1, 85, 86, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(12, 37, 1, 21, 22, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(13, 38, 1, 17, 18, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(14, 39, 1, 9, 16, 1, 'sample-data-articles', 'com_content', 'Sample Data-Articles', 'sample-data-articles', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(15, 40, 1, 87, 88, 1, 'sample-data-banners', 'com_banners', 'Sample Data-Banners', 'sample-data-banners', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":"","foobar":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(16, 41, 1, 23, 84, 1, 'sample-data-contact', 'com_contact', 'Sample Data-Contact', 'sample-data-contact', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(17, 42, 1, 19, 20, 1, 'sample-data-newsfeeds', 'com_newsfeeds', 'Sample Data-Newsfeeds', 'sample-data-newsfeeds', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(18, 43, 1, 1, 8, 1, 'sample-data-weblinks', 'com_weblinks', 'Sample Data-Weblinks', 'sample-data-weblinks', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(19, 44, 14, 10, 11, 2, 'sample-data-articles/joomla', 'com_content', 'Joomla!', 'joomla', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, '*'),
(31, 56, 18, 2, 3, 2, 'sample-data-weblinks/park-links', 'com_weblinks', 'Park Links', 'park-links', '', '<p>Here are links to some of my favorite parks.</p>\r\n<p><em>The weblinks component provides an easy way to make links to external sites that are consistently formatted and categorised. You can create weblinks from the front end of your site.</em></p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"images\\/sampledata\\/parks\\/banner_cradle.jpg"}', '', '', '{"author":"","robots":""}', 968, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, 'en-GB'),
(32, 57, 18, 4, 7, 2, 'sample-data-weblinks/joomla-specific-links', 'com_weblinks', 'Joomla! Specific Links', 'joomla-specific-links', '', '<p><div style="font-family: Tahoma, Helvetica, Arial, sans-serif; font-size: 76%; background-color: #ffffff; background-image: initial; background-attachment: initial; background-origin: initial; background-clip: initial; line-height: 1.3em; color: #333333;"><p>A selection of links that are all related to the Joomla! Project.</p></div></p>', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(33, 58, 32, 5, 6, 3, 'sample-data-weblinks/joomla-specific-links/other-resources', 'com_weblinks', 'Other Resources', 'other-resources', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(34, 59, 16, 24, 25, 2, 'sample-data-contact/park-site', 'com_contact', 'Park Site', 'park-site', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 42, '2011-01-01 00:00:01', 0, 'en-GB'),
(35, 60, 16, 26, 83, 2, 'sample-data-contact/shop-site', 'com_contact', 'Shop Site', 'shop-site', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(36, 61, 35, 27, 28, 3, 'sample-data-contact/shop-site/staff', 'com_contact', 'Staff', 'staff', '', '<p>Please feel free to contact our staff at any time should you need assistance.</p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(37, 62, 35, 29, 82, 3, 'sample-data-contact/shop-site/fruit-encyclopedia', 'com_contact', 'Fruit Encyclopedia', 'fruit-encyclopedia', '', '<p> </p><p>Our directory of information about different kinds of fruit.</p><p>We love fruit and want the world to know more about all of its many varieties.</p><p>Although it is small now, we work on it whenever we have a chance.</p><p>All of the images can be found in <a href="http://commons.wikimedia.org/wiki/Main_Page">Wikimedia Commons</a>.</p><p><img src="images/sampledata/fruitshop/apple.jpg" border="0" alt="Apples" title="Apples" /></p><p><em>This encyclopedia is implemented using the contact component, each fruit a separate contact and a category for each letter. A CSS style is used to create the horizontal layout of the alphabet headings. </em></p><p><em>If you wanted to, you could allow some users (such as your growers) to have access to just this category in the contact component and let them help you to create new content for the encyclopedia.</em></p><p> </p>', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(38, 63, 37, 30, 31, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/a', 'com_contact', 'A', 'a', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(39, 64, 37, 32, 33, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/b', 'com_contact', 'B', 'b', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(40, 65, 37, 34, 35, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/c', 'com_contact', 'C', 'c', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(41, 66, 37, 36, 37, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/d', 'com_contact', 'D', 'd', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(42, 67, 37, 38, 39, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/e', 'com_contact', 'E', 'e', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(43, 68, 37, 40, 41, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/f', 'com_contact', 'F', 'f', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(44, 69, 37, 42, 43, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/g', 'com_contact', 'G', 'g', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(45, 70, 37, 44, 45, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/h', 'com_contact', 'H', 'h', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(46, 71, 37, 46, 47, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/i', 'com_contact', 'I', 'i', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(47, 72, 37, 48, 49, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/j', 'com_contact', 'J', 'j', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(48, 73, 37, 50, 51, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/k', 'com_contact', 'K', 'k', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(49, 74, 37, 52, 53, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/l', 'com_contact', 'L', 'l', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(50, 75, 37, 54, 55, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/m', 'com_contact', 'M', 'm', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(51, 76, 37, 56, 57, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/n', 'com_contact', 'N', 'n', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(52, 77, 37, 58, 59, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/o', 'com_contact', 'O', 'o', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(53, 78, 37, 60, 61, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/p', 'com_contact', 'P', 'p', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(54, 79, 37, 62, 63, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/q', 'com_contact', 'Q', 'q', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(55, 80, 37, 64, 65, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/r', 'com_contact', 'R', 'r', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(56, 81, 37, 66, 67, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/s', 'com_contact', 'S', 's', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(57, 82, 37, 68, 69, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/t', 'com_contact', 'T', 't', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(58, 83, 37, 70, 71, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/u', 'com_contact', 'U', 'u', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(59, 84, 37, 72, 73, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/v', 'com_contact', 'V', 'v', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(60, 85, 37, 74, 75, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/w', 'com_contact', 'W', 'w', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(61, 86, 37, 76, 77, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/x', 'com_contact', 'X', 'x', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(62, 87, 37, 78, 79, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/y', 'com_contact', 'Y', 'y', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(63, 88, 37, 80, 81, 4, 'sample-data-contact/shop-site/fruit-encyclopedia/z', 'com_contact', 'Z', 'z', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"target":"","image":""}', '', '', '{"page_title":"","author":"","robots":""}', 968, '2011-01-01 00:00:01', 0, '2011-01-01 00:00:01', 0, '*'),
(77, 169, 14, 12, 15, 2, 'sample-data-articles/features', 'com_content', 'Features', 'features', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2011-06-11 06:18:31', 0, '0000-00-00 00:00:00', 0, '*'),
(78, 180, 77, 13, 14, 3, 'sample-data-articles/features/typography', 'com_content', 'Typography', 'typography', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2012-11-18 12:35:11', 0, '0000-00-00 00:00:00', 0, '*'),
(79, 191, 1, 93, 94, 1, 'slider', 'com_content', 'Slider', 'slider', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-01-20 02:54:55', 0, '0000-00-00 00:00:00', 0, '*'),
(80, 196, 1, 95, 96, 1, 'recent-work', 'com_content', 'Campus Gallery', 'recent-work', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-01-20 23:30:20', 154, '2013-06-22 09:57:30', 0, '*'),
(81, 205, 1, 97, 98, 1, 'team-members', 'com_content', 'Team Members', 'team-members', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-01-21 00:35:19', 0, '0000-00-00 00:00:00', 0, '*'),
(82, 214, 1, 99, 102, 1, 'pages', 'com_content', 'Pages', 'pages', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-01-30 08:24:13', 0, '0000-00-00 00:00:00', 0, '*'),
(83, 218, 1, 103, 104, 1, 'extensions', 'com_content', 'Extensions', 'extensions', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-02-04 09:37:07', 0, '0000-00-00 00:00:00', 0, '*'),
(84, 224, 1, 105, 106, 1, 'frontpage', 'com_content', 'Frontpage', 'frontpage', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-06-20 12:36:23', 154, '2013-06-20 12:37:06', 0, '*'),
(85, 227, 1, 107, 108, 1, 'xpert-accordion', 'com_content', 'Xpert Accordion', 'xpert-accordion', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-06-22 06:55:17', 0, '0000-00-00 00:00:00', 0, '*'),
(86, 231, 1, 109, 110, 1, 'scroller-meet-professor', 'com_content', 'Scroller - Meet Professor', 'scroller-meet-professor', '', '', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-06-22 08:50:03', 0, '0000-00-00 00:00:00', 0, '*'),
(87, 234, 1, 111, 112, 1, 'slider-about-us', 'com_content', 'Slider - About Us', 'slider-about-us', '', '\r\n', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-07-02 06:41:28', 0, '0000-00-00 00:00:00', 0, '*'),
(88, 245, 82, 100, 101, 2, 'pages/about-us', 'com_content', 'About Us', 'about-us', '', '\r\n', -2, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 968, '2013-07-17 07:45:48', 0, '0000-00-00 00:00:00', 0, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned DEFAULT NULL,
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `imagepos`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`) VALUES
(1, 'Contact Name Here', 'name', 'Position', 'Street Address', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Information about or by the contact.</p>', 'images/powered_by.png', 'top', 'email@email.com', 1, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Twitter","linka":"http:\\/\\/twitter.com\\/joomla","linkb_name":"YouTube","linkb":"http:\\/\\/www.youtube.com\\/user\\/joomla","linkc_name":"Facebook","linkc":"http:\\/\\/www.facebook.com\\/joomla","linkd_name":"FriendFeed","linkd":"http:\\/\\/friendfeed.com\\/joomla","linke_name":"Scribed","linke":"http:\\/\\/www.scribd.com\\/people\\/view\\/504592-joomla","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 16, 1, '', '', 'last', 'first', 'middle', 'en-GB', '2011-01-01 00:00:01', 968, '', '2011-01-08 17:39:00', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 'Webmaster', 'webmaster', '', '', '', '', '', '', '', '', '', '', NULL, 'webmaster@example.com', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"","redirect":""}', 0, 34, 1, '', '', '', '', '', 'en-GB', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 'Owner', 'owner', '', '', '', '', '', '', '', '', '<p>I''m the owner of this store.</p>', '', NULL, '', 0, -2, 0, '0000-00-00 00:00:00', 2, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 'Buyer', 'buyer', '', '', '', '', '', '', '', '', '<p>I am in charge of buying fruit. If you sell good fruit, contact me.</p>', '', NULL, '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"0","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 36, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(5, 'Bananas', 'bananas', 'Scientific Name: Musa', 'Image Credit: Enzik\r\nRights: Creative Commons Share Alike Unported 3.0\r\nSource: http://commons.wikimedia.org/wiki/File:Bananas_-_Morocco.jpg', '', 'Type: Herbaceous', 'Large Producers: India, China, Brasil', '', '', '', '<p>Bananas are a great source of potassium.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/bananas_2.jpg', NULL, '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"show_with_link","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"1","show_email":"","show_street_address":"","show_suburb":"","show_state":"1","show_postcode":"","show_country":"1","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Banana English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Banana","linkb_name":"Wikipedia:  \\u0939\\u093f\\u0928\\u094d\\u0926\\u0940 \\u0915\\u0947\\u0932\\u093e","linkb":"http:\\/\\/hi.wikipedia.org\\/wiki\\/%E0%A4%95%E0%A5%87%E0%A4%B2%E0%A4%BE","linkc_name":"Wikipedia:Banana Portugu\\u00eas","linkc":"http:\\/\\/pt.wikipedia.org\\/wiki\\/Banana","linkd_name":"Wikipedia: \\u0411\\u0430\\u043d\\u0430\\u043d  \\u0420\\u0443\\u0441\\u0441\\u043a\\u0438\\u0439","linkd":"http:\\/\\/ru.wikipedia.org\\/\\u0411\\u0430\\u043d\\u0430\\u043d","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 39, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(6, 'Apples', 'apples', 'Scientific Name: Malus domestica', 'Image Credit: Fievet\r\nRights: Public Domain\r\nSource: http://commons.wikimedia.org/wiki/File:Pommes_vertes.JPG', '', 'Family: Rosaceae', 'Large: Producers: China, United States', '', '', '', '<p>Apples are a versatile fruit, used for eating, cooking, and preserving.</p>\r\n<p>There are more that 7500 different kinds of apples grown around the world.</p>', 'images/sampledata/fruitshop/apple.jpg', NULL, '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Apples English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Apple","linkb_name":"Wikipedia: Manzana Espa\\u00f1ol ","linkb":"http:\\/\\/es.wikipedia.org\\/wiki\\/Manzana","linkc_name":"Wikipedia: \\u82f9\\u679c \\u4e2d\\u6587","linkc":"http:\\/\\/zh.wikipedia.org\\/zh\\/\\u82f9\\u679c","linkd_name":"Wikipedia: Tofaa Kiswahili","linkd":"http:\\/\\/sw.wikipedia.org\\/wiki\\/Tofaa","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 38, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(7, 'Tamarind', 'tamarind', 'Scientific Name: Tamarindus indica', 'Image Credit: Franz Eugen Köhler, Köhler''s Medizinal-Pflanzen \r\nRights: Public Domain\r\nSource:http://commons.wikimedia.org/wiki/File:Koeh-134.jpg', '', 'Family: Fabaceae', 'Large Producers: India, United States', '', '', '', '<p>Tamarinds are a versatile fruit used around the world. In its young form it is used in hot sauces; ripened it is the basis for many refreshing drinks.</p>\r\n<p> </p>', 'images/sampledata/fruitshop/tamarind.jpg', NULL, '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"plain","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"1","linka_name":"Wikipedia: Tamarind English","linka":"http:\\/\\/en.wikipedia.org\\/wiki\\/Tamarind","linkb_name":"Wikipedia: \\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2  \\u09ac\\u09be\\u0982\\u09b2\\u09be  ","linkb":"http:\\/\\/bn.wikipedia.org\\/wiki\\/\\u09a4\\u09c7\\u0981\\u09a4\\u09c1\\u09b2 ","linkc_name":"Wikipedia: Tamarinier Fran\\u00e7ais","linkc":"http:\\/\\/fr.wikipedia.org\\/wiki\\/Tamarinier","linkd_name":"Wikipedia:Tamaline lea faka-Tonga","linkd":"http:\\/\\/to.wikipedia.org\\/wiki\\/Tamaline","linke_name":"","linke":"","contact_layout":"beez5:encyclopedia"}', 0, 57, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 0, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(8, 'Shop Address', 'shop-address', '', '', 'Our City', 'Our Province', 'Our Country', '', '555-555-5555', '', '<p>Here are directions for how to get to our shop.</p>', '', NULL, '', 0, -2, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":"","linkb_name":"","linkb":"","linkc_name":"","linkc":"","linkd_name":"","linkd":"","linke_name":"","linke":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 0, 35, 1, '', '', '', '', '', '*', '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE `#__content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `title_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Deprecated in Joomla! 3.0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `sectionid` int(10) unsigned NOT NULL DEFAULT '0',
  `mask` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `parentid` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=129 ;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(8, 104, 'Beginners', 'beginners', '', '<p>If this is your first Joomla site or your first web site, you have come to the right place. Joomla will help you get your website up and running quickly and easily.</p>\r\n<p>Start off using your site by logging in using the administrator account you created when you installed Joomla!.</p>\r\n', '\r\n<p>Explore the articles and other resources right here on your site data to learn more about how Joomla works.(When you''re done reading, you can delete or archive all of this.) You will also probably want to visit the beginners'' areas of the <a href="http://docs.joomla.org/Beginners">Joomla documentation</a> and <a href="http://forum.joomla.org">support forums</a>.</p>\r\n<p>You''ll also want to sign up for the Joomla Security Mailing list and the Announcements mailing list. For inspiration visit the Joomla Site Showcase to see an amazing array of ways people use Joomla to tell their stories on the web.</p>\r\n<p>The basic Joomla! installation will let you get a great site up and running, but when you are ready for more features the power of Joomla! is in the creative ways that developers have extended it to do all kinds of things. Visit the Joomla! Extensions Directory to see thousands of extensions that can do almost anything you could want on a website. Can''t find what you need? You may want to find a Joomla professional on the Joomla! Resources Directory.</p>\r\n<p>Want to learn more? Consider attending a Joomla! Day or other event or joining a local Joomla! Users Group. Can''t find one near you? Start one yourself.</p>', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, 'Joomla!', '2011-01-09 16:41:00', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 3, 0, 4, '', '', 1, 53, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(21, 119, 'Getting Help', 'getting-help', '', '<p><img class="image-left" src="administrator/templates/hathor/images/header/icon-48-help_header.png" border="0" /> There are lots of places you can get help with Joomla!. In many places in your site administrator you will see the help icon. Click on this for more information about the options and functions of items on your screen. Other places to get help are:</p>\r\n<ul>\r\n<li><a href="http://forum.joomla.org">Support Forums</a></li>\r\n<li><a href="http://docs.joomla.org">Documentation</a></li>\r\n<li><a href="http://resources.joomla.org">Professionals</a></li>\r\n<li><a href="http://shop.joomla.org/amazoncom-bookstores.html">Books</a></li>\r\n</ul>', '', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, 'Joomla!', '2011-01-10 15:32:54', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 10, 0, 8, '', '', 1, 17, '', 0, '*', ''),
(22, 120, 'Getting Started', 'getting-started', '', '<p>It''s easy to get started creating your website. Knowing some of the basics will help.</p><h3>What is a Content Management System?</h3><p>A content management system is software that allows you to create and manage webpages easily by separating the creation of your content from the mechanics required to present it on the web.</p>\r\n', '\r\n<p>In this site, the content is stored in a <em>database</em>. The look and feel are created by a <em>template</em>. The Joomla! software brings together the template and the content to create web pages.</p>\r\n<h3>Site and Administrator</h3><p>Your site actually has two separate sites. The site (also called the front end) is what visitors to your site will see.  The administrator (also called the back end) is only used by people managing your site. You can access the administrator by clicking the "Site Administrator" link on the "This Site" menu or by adding /administrator to the end of you domain name.</p><p>Log in to the administrator using the username and password created during the installation of Joomla!.</p><h3>Logging in</h3><p>To login to the front end of your site use the login form or the login menu link on the "This Site" menu. Use the user name an password that were created as part of the installation process. Once logged in you will be able to create and edit articles.</p><p>In managing your site, you will be able to create content that only logged in users are able to see.</p><h3>Creating an article</h3><p>Once you are logged in, a new menu will be visible.  To create a new article, click on the "submit article" link on that menu.</p><p>The new article interface gives you a lot of options, but all you need to do is add a title an put something in the content area. To make it easy to find, set the state to published an put it in the Joomla! category.</p><div>You can edit an existing article by  clicking on the edit icon (this only displays to users who have the right to edit).</div><h3>Learn more</h3><p>There is much more to learn about how to use Joomla! to create the web site you envision. You can learn much more at the <a href="http://docs.joomla.org">Joomla! documentation site</a> and on the<a href="http://forum.joomla.org"> Joomla! forums</a>.</p>', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, 'Joomla!', '2012-03-21 08:46:52', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 9, '', '', 1, 23, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(24, 122, 'Joomla!', 'joomla', '', '<p>Congratulations! You have a Joomla! site! Joomla! makes your site easy to build a website just the way you want it and keep it simple to update and maintain.</p>\r\n<p>Joomla! is a flexible and powerful platform, whether you are building a small site for yourself or a huge site with hundreds of thousands of visitors. Joomla is open source, which means you can make it work just the way you want it to.</p>', '', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, 'Joomla!', '2011-01-01 00:00:01', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 0, 2, '', '', 1, 66, '', 0, '*', ''),
(35, 133, 'Professionals', 'professionals', '', '<p>Joomla! 1.6 continues development of the Joomla Framework and CMS as a powerful and flexible way to bring your vision of the web to reality. With the administrator now fully MVC, the ability to control its look and the management of extensions is now complete.</p>\r\n', '\r\n<p>Working with multiple template styles and overrides for the same views, creating the design you want is easier than it has ever been. Limiting support to PHP 5.2.4 and above and ending legacy support for Joomla 1.0 extensions makes Joomla! lighter and faster than ever. Languages files can now be overridden without having your changes lost during an upgrade.  With the proper xml your users update extensions with a single click.</p>\r\n<p>Access control lists are now incorporated using a new system developed for Joomla!. The ACL system is designed with developers in mind, so it is easy to incorporate into your extensions. The new nested sets libraries allow you to incorporate infinitely deep categories but also to use nested sets in a variety of other ways.</p>\r\n<p>A new forms library makes creating all kinds of user interaction simple. MooTools 1.3 provides a highly flexible javascript framework that is a major advance over MooTools 1.0.</p>\r\n<p>New events throughout the core make integration of your plugins where you want them a snap.</p>\r\n<p>Learn about:</p>\r\n<ul>\r\n<li><a href="http://docs.joomla.org/What''s_new_in_Joomla_1.6">Changes since 1.5</a></li>\r\n<li><a href="http://docs.joomla.org/ACL_Tutorial_for_Joomla_1.6">Working with ACL</a></li>\r\n<li><a href="http://docs.joomla.org/API16:JCategories">Working with nested categories</a></li>\r\n<li><a href="http://docs.joomla.org/API16:JForm">Forms library</a></li>\r\n<li><a href="http://docs.joomla.org/Working_with_Mootools_1.3">Working with Mootools 1.3</a></li>\r\n<li><a href="http://docs.joomla.org/Layout_Overrides_in_Joomla_1.6">Using new features of the override system</a></li>\r\n<li><a href="http://docs.joomla.org/API16:Framework">Joomla! 1.6 AP</a>I</li>\r\n<li><a href="http://docs.joomla.org/API16:JDatabaseQuery">Using JDatabaseQuery</a></li>\r\n<li><a href="http://docs.joomla.org/What''s_new_in_Joomla_1.6#Events">New and updated events</a></li>\r\n<li><a href="http://docs.joomla.org/Xml-rpc_changes_in_Joomla!_1.6">Xmlrpc</a></li>\r\n<li><a href="http://docs.joomla.org/What''s_new_in_Joomla_1.6#Extension_management">Installing and updating extensions</a></li>\r\n<li><a href="http://docs.joomla.org/Setting_up_your_workstation_for_Joomla!_development">Setting up your development environment</a></li>\r\n</ul>', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, 'Joomla!', '2011-01-09 16:41:13', 42, 0, '0000-00-00 00:00:00', '2011-01-09 16:41:13', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","alternative_readmore":"","article_layout":""}', 12, 0, 5, '', '', 1, 39, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(48, 146, 'The Joomla! Project', 'the-joomla-project', '', '<p>The Joomla! Project consists of all of the people who make and support the Joomla! Web Platform and Content Management System.</p><p>Our mission is to provide a flexible platform for digital publishing and collaboration.</p><p>The core values are:</p><ul><li>Freedom</li><li>Equality</li><li>Trust</li><li>Community</li><li>Collaboration</li><li>Usability</li></ul><p>In our vision, we see:</p><ul><li>People publishing and collaborating in their communities and around the world</li><li>Software that is free, secure, and high-quality</li><li>A community that is enjoyable and rewarding to participate in</li><li>People around the world using their preferred languages</li><li>A project that acts autonomously</li><li>A project that is socially responsible</li><li>A project dedicated to maintaining the trust of its users</li></ul><p>There are millions of users around the world and thousands of people who contribute to the Joomla! Project. They work in three main groups: the Production Working Group, responsible for everything that goes into software and documentation; the Community Working Group, responsible for creating a nurturing the community; and Open Source Matters, the non profit organization responsible for managing legal, financial and organizational issues.</p><p>Joomla! is a free and open source project, which uses the GNU General Public License version 2 or later.</p>', '', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, '', '2011-01-01 00:00:01', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 0, 1, '', '', 1, 2, '', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(49, 147, 'Template Typography', 'typography', '', '<p>Typography is a fundamental part of a template, providing you with the tools to characterize your content and bring it to life. Expose integrated and nicely blended with Bootstrap''s Typography to enhance your typography experience.</p>\r\n<div class="alert alert-info">\r\nIf you are using the TinyMCE editor for HTML typography, go to Extensions → Plugin Manager → TinyMCE 2.0 → Set Code Clean-up on Save to Never.\r\n</div>\r\n<section id="typography">\r\n  <div class="page-header">\r\n    <h1>Typography</h1>\r\n  </div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h2 id="headings">Headings</h2>\r\n  <p>All HTML headings, <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code> are available.</p>\r\n  <div class="bs-example">\r\n    <h1>h1. Heading 1</h1>\r\n    <h2>h2. Heading 2</h2>\r\n    <h3>h3. Heading 3</h3>\r\n    <h4>h4. Heading 4</h4>\r\n    <h5>h5. Heading 5</h5>\r\n    <h6>h6. Heading 6</h6>\r\n  </div>\r\n\r\n  <h3>Built with Less</h3>\r\n  <p>The typographic scale is based on two LESS variables in <strong>variables.less</strong>: <code>@baseFontSize</code> and <code>@baseLineHeight</code>. The first is the base font-size used throughout and the second is the base line-height. We use those variables and some simple math to create the margins, paddings, and line-heights of all our type and more. Customize them and Bootstrap adapts.</p>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h2 id="body-copy">Body copy</h2>\r\n  <p>Bootstrap''s global default <code>font-size</code> is <strong>14px</strong>, with a <code>line-height</code> of <strong>1.7em</strong>. This is applied to the <code>&lt;body&gt;</code> and all paragraphs. In addition, <code>&lt;p&gt;</code> (paragraphs) receive a bottom margin of half their line-height (9px by default).</p>\r\n  <div class="bs-example">\r\n    <p>Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.</p>\r\n  </div>\r\n  <pre class="prettyprint"><span class="tag">&lt;p&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n\r\n  <h3>Lead body copy</h3>\r\n  <p>Make a paragraph stand out by adding <code>.lead</code>.</p>\r\n  <div class="bs-example">\r\n    <p class="lead">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p>\r\n  </div>\r\n  <pre class="prettyprint"><span class="tag">&lt;p</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"lead"</span><span class="tag">&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n\r\n\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n\r\n  <h2 id="emphasis">Emphasis</h2>\r\n  <span>Make use of HTML''s default emphasis tags with lightweight styles.</span><br />\r\n\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h4><code>&lt;em&gt;</code></h4>\r\n  <p>For emphasizing a snippet of text with <em>stress</em></p>\r\n  <div class="bs-example">\r\n    <p>The following snippet of text is <em>rendered as italicized text</em>.</p>\r\n  </div>\r\n  <pre class="prettyprint"><span class="tag">&lt;em&gt;</span><span class="pln">rendered as italicized text</span><span class="tag">&lt;/em&gt;</span></pre>\r\n\r\n  <h4><code>&lt;strong&gt;</code></h4>\r\n  <p>For emphasizing a snippet of text with <strong>important</strong></p>\r\n  <div class="bs-example">\r\n    <p>The following snippet of text is <strong>rendered as bold text</strong>.</p>\r\n  </div>\r\n  <pre class="prettyprint"><span class="tag">&lt;strong&gt;</span><span class="pln">rendered as bold text</span><span class="tag">&lt;/strong&gt;</span></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h4><code>&lt;small&gt;</code></h4>\r\n  <p>For de-emphasizing inline or blocks of text, <small>use the small tag.</small></p>\r\n  <div class="bs-example">\r\n    <p><small>This line of text is meant to be treated as fine print.</small></p>\r\n  </div>\r\n<pre class="prettyprint"><span class="tag">&lt;p&gt;</span><span class="pln">\r\n  </span><span class="tag">&lt;small&gt;</span><span class="pln">This line of text is meant to be treated as fine print.</span><span class="tag">&lt;/small&gt;</span><span class="pln">\r\n</span><span class="tag">&lt;/p&gt;</span></pre><br />\r\n\r\n  <p><strong>Note:</strong> Feel free to use <code>&lt;b&gt;</code> and <code>&lt;i&gt;</code> in HTML5. <code>&lt;b&gt;</code> is meant to highlight words or phrases without conveying additional importance while <code>&lt;i&gt;</code> is mostly for voice, technical terms, etc.</p>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<h3>Notice Styles</h3>\r\n\r\n<p>Use the <code>&lt;p&gt;</code> tag with <code>.success</code>, <code>.warning</code>, <code>.info</code> or <code>.error</code> classes.</p>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n<div class="bs-example"><p class="success">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p></div>\r\n<pre class="prettyprint"><span class="tag">&lt;p</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"success"</span><span class="tag">&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n\r\n<div class="bs-example"><p class="info">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p></div>\r\n<pre class="prettyprint"><span class="tag">&lt;p</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"info"</span><span class="tag">&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n</div></div>    \r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n<div class="bs-example"><p class="warning">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p></div>\r\n<pre class="prettyprint"><span class="tag">&lt;p</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"warning"</span><span class="tag">&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n\r\n<div class="bs-example"><p class="error">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p></div>\r\n<pre class="prettyprint"><span class="tag">&lt;p</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"error"</span><span class="tag">&gt;</span><span class="pln">...</span><span class="tag">&lt;/p&gt;</span></pre>\r\n</div></div>\r\n\r\n<div class="clear"></div>\r\n\r\n\r\n<br />\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left" style="float: none;">\r\n  <h2 id="abbreviations">Abbreviations</h2>\r\n  <p>Stylized implementation of HTML''s <code>&lt;abbr&gt;</code> element for abbreviations and acronyms to show the expanded version on hover. Abbreviations with a <code>title</code> attribute have a light dotted bottom border and a help cursor on hover, providing additional context on hover.</p>\r\n\r\n  <h4><code>&lt;abbr&gt;</code></h4>\r\n  <p>For expanded text on long hover of an abbreviation, include the <code>title</code> attribute.</p>\r\n  <div class="bs-example">\r\n    <p>An abbreviation of the word attribute is <abbr title="attribute">attr</abbr>.</p>\r\n  </div>\r\n  <pre class="prettyprint"><span class="tag">&lt;abbr</span><span class="pln"> </span><span class="atn">title</span><span class="pun">=</span><span class="atv">"attribute"</span><span class="tag">&gt;</span><span class="pln">attr</span><span class="tag">&lt;/abbr&gt;</span></pre>\r\n\r\n  <h4><code>&lt;abbr class="initialism"&gt;</code></h4>\r\n  <p>Add <code>.initialism</code> to an abbreviation for a slightly smaller font-size.</p>\r\n  <div class="bs-example">\r\n    <p><abbr title="HyperText Markup Language" class="initialism">HTML</abbr> is the best thing since sliced bread.</p>\r\n  </div>\r\n  <pre class="prettyprint"><span class="tag">&lt;abbr</span><span class="pln"> </span><span class="atn">title</span><span class="pun">=</span><span class="atv">"attribute"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"initialism"</span><span class="tag">&gt;</span><span class="pln">attr</span><span class="tag">&lt;/abbr&gt;</span></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h2 id="addresses">Addresses</h2>\r\n  <p>Present contact information for the nearest ancestor or the entire body of work.</p>\r\n\r\n  <h4><code>&lt;address&gt;</code></h4>\r\n  <p>Preserve formatting by ending all lines with <code>&lt;br&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <address>\r\n      <strong>Twitter, Inc.</strong><br />\r\n      795 Folsom Ave, Suite 600<br />\r\n      San Francisco, CA 94107<br />\r\n      <abbr title="Phone">P:</abbr> (123) 456-7890\r\n    </address>\r\n    <address>\r\n      <strong>Full Name</strong><br />\r\n      <a href="mailto:#">\r\n \r\n !-\r\n var prefix = ''&#109;a'' + ''i&#108;'' + ''&#116;o'';\r\n var path = ''hr'' + ''ef'' + ''='';\r\n var addy78855 = ''f&#105;rst.l&#97;st'' + ''&#64;'';\r\n addy78855 = addy78855 + ''gm&#97;&#105;l'' + ''&#46;'' + ''c&#111;m'';\r\n document.write(''<a>'');\r\n document.write(addy78855);\r\n document.write('''');\r\n //-->\\n </a><a href="mailto:first.last@gmail.com">first.last@gmail.com</a>\r\n !-\r\n document.write(''<span style="''display:">'');\r\n //-->\r\n <span style="display: none;">This email address is being protected from spambots. You need JavaScript enabled to view it.\r\n \r\n !-\r\n document.write('''');\r\n //-->\r\n </span>\r\n    </address>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;address&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;strong&gt;</span><span class="pln">Twitter, Inc.</span><span class="tag">&lt;/strong&gt;&lt;br&gt;</span></li><li class="L2"><span class="pln">  795 Folsom Ave, Suite 600</span><span class="tag">&lt;br&gt;</span></li><li class="L3"><span class="pln">  San Francisco, CA 94107</span><span class="tag">&lt;br&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;abbr</span><span class="pln"> </span><span class="atn">title</span><span class="pun">=</span><span class="atv">"Phone"</span><span class="tag">&gt;</span><span class="pln">P:</span><span class="tag">&lt;/abbr&gt;</span><span class="pln"> (123) 456-7890</span></li><li class="L5"><span class="tag">&lt;/address&gt;</span></li><li class="L6"><span class="tag">&lt;address&gt;</span></li><li class="L7"><span class="pln">  </span><span class="tag">&lt;strong&gt;</span><span class="pln">Full Name</span><span class="tag">&lt;/strong&gt;&lt;br&gt;</span></li><li class="L8"><span class="pln">  </span><span class="tag">&lt;a</span><span class="pln"> </span><span class="atn">href</span><span class="pun">=</span><span class="atv">"mailto:#"</span><span class="tag">&gt;</span><span class="pln">first.last@gmail.com</span><span class="tag">&lt;/a&gt;</span></li><li class="L9"><span class="tag">&lt;/address&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n\r\n  <h2 id="blockquotes">Blockquotes</h2>\r\n  <p>For quoting blocks of content from another source within your document.</p>\r\n\r\n  <h3>Default blockqoute</h3>\r\n  <p>Wrap <code>&lt;blockquote&gt;</code> around any <abbr title="HyperText Markup Language">HTML</abbr> as the quote. For straight quotes we recommend a <code>&lt;p&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <blockquote>\r\n      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n    </blockquote>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;blockquote&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;p&gt;</span><span class="pln">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</span><span class="tag">&lt;/p&gt;</span></li><li class="L2"><span class="tag">&lt;/blockquote&gt;</span></li></ol></pre>\r\n\r\n  <h3>Blockquote options</h3>\r\n  <span>Style and content changes for simple variations on a standard blockquote.</span><br />\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h4>Naming a source</h4>\r\n  <p>Add <code>&lt;small&gt;</code> tag for identifying the source. Wrap the name of the source work in <code>&lt;cite&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <blockquote>\r\n      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n      <small>Someone famous in <cite title="Source Title">Source Title</cite></small>\r\n    </blockquote>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;blockquote&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;p&gt;</span><span class="pln">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</span><span class="tag">&lt;/p&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;small&gt;</span><span class="pln">Someone famous </span><span class="tag">&lt;cite</span><span class="pln"> </span><span class="atn">title</span><span class="pun">=</span><span class="atv">"Source Title"</span><span class="tag">&gt;</span><span class="pln">Source Title</span><span class="tag">&lt;/cite&gt;&lt;/small&gt;</span></li><li class="L3"><span class="tag">&lt;/blockquote&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h4>Alternate displays</h4>\r\n  <p>Use <code>.pull-right</code> for a floated, right-aligned blockquote.</p>\r\n  <div class="bs-example" style="overflow: hidden;">\r\n    <blockquote class="pull-right">\r\n      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n      <small>Someone famous in <cite title="Source Title">Source Title</cite></small>\r\n    </blockquote>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;blockquote</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"pull-right"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  ...</span></li><li class="L2"><span class="tag">&lt;/blockquote&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n\r\n  \r\n  <h2 id="lists">Lists</h2>\r\n\r\n<div class="width-block width-33">\r\n<div class="pull-left">\r\n  <h3>Unordered</h3>\r\n  <p>A list of items in which the order does <em>not</em> explicitly matter.</p>\r\n  <div class="bs-example">\r\n    <ul>\r\n      <li>Lorem ipsum dolor sit amet</li>\r\n      <li>Nulla volutpat aliquam velit\r\n        <ul>\r\n          <li>Phasellus iaculis neque</li>\r\n          <li>Purus sodales ultricies</li>\r\n          <li>Vestibulum laoreet porttitor sem</li>\r\n          <li>Ac tristique libero volutpat at</li>\r\n        </ul>\r\n      </li>\r\n      <li>Faucibus porta lacus fringilla vel</li>\r\n      <li>Eget porttitor lorem</li>\r\n    </ul>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;ul&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;li&gt;</span><span class="pln">...</span><span class="tag">&lt;/li&gt;</span></li><li class="L2"><span class="tag">&lt;/ul&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-33">\r\n<div class="pull-left">\r\n  <h3>Ordered</h3>\r\n  <p>A list of items in which the order <em>does</em> explicitly matter.</p>\r\n  <div class="bs-example">\r\n    <ol>\r\n      <li>Lorem ipsum dolor sit amet</li>\r\n      <li>Consectetur adipiscing elit</li>\r\n      <li>Integer molestie lorem at massa</li>\r\n      <li>Facilisis in pretium nisl aliquet</li>\r\n      <li>Nulla volutpat aliquam velit</li>\r\n      <li>Faucibus porta lacus fringilla vel</li>\r\n      <li>Aenean sit amet erat nunc</li>\r\n      <li>Eget porttitor lorem</li>\r\n    </ol>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;ol&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;li&gt;</span><span class="pln">...</span><span class="tag">&lt;/li&gt;</span></li><li class="L2"><span class="tag">&lt;/ol&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-33">\r\n<div class="pull-left">\r\n<h3>Unstyled</h3>\r\n<p>A list of items with no <code>list-style</code> or additional left padding.</p>\r\n<div class="bs-example">\r\n  <ul class="unstyled">\r\n      <li>Lorem ipsum dolor sit amet</li>\r\n      <li>Nulla volutpat aliquam velit\r\n        <ul>\r\n          <li>Phasellus iaculis neque</li>\r\n          <li>Purus sodales ultricies</li>\r\n          <li>Vestibulum laoreet porttitor sem</li>\r\n          <li>Ac tristique libero volutpat at</li>\r\n        </ul>\r\n      </li>\r\n      <li>Faucibus porta lacus fringilla vel</li>\r\n      <li>Eget porttitor lorem</li>\r\n  </ul>\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;ul</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"unstyled"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;li&gt;</span><span class="pln">...</span><span class="tag">&lt;/li&gt;</span></li><li class="L2"><span class="tag">&lt;/ul&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="clear"></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n<h3>Description</h3>\r\n<p>A list of terms with their associated descriptions.</p>\r\n<div class="bs-example">\r\n  <dl>\r\n    <dt>Description lists</dt>\r\n    <dd>A description list is perfect for defining terms.</dd>\r\n    <dt>Euismod</dt>\r\n    <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.</dd>\r\n    <dd>Donec id elit non mi porta gravida at eget metus.</dd>\r\n    <dt>Malesuada porta</dt>\r\n    <dd>Etiam porta sem malesuada magna mollis euismod.</dd>\r\n  </dl>\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;dl&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;dt&gt;</span><span class="pln">...</span><span class="tag">&lt;/dt&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;dd&gt;</span><span class="pln">...</span><span class="tag">&lt;/dd&gt;</span></li><li class="L3"><span class="tag">&lt;/dl&gt;</span></li></ol></pre><br />\r\n<p>\r\n  <strong>Note:</strong>\r\n  Horizontal description lists will truncate terms that are too long to fit in the left column fix <code>text-overflow</code>. In narrower viewports, they will change to the default stacked layout.\r\n</p>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n<h3>Horizontal description</h3>\r\n<p>Make terms and descriptions in <code>&lt;dl&gt;</code> line up side-by-side.</p>\r\n<div class="bs-example">\r\n  <dl class="dl-horizontal">\r\n    <dt>Description lists</dt>\r\n    <dd>A description list is perfect for defining terms.</dd>\r\n    <dt>Euismod</dt>\r\n    <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.</dd>\r\n    <dd>Donec id elit non mi porta gravida at eget metus.</dd>\r\n    <dt>Malesuada porta</dt>\r\n    <dd>Etiam porta sem malesuada magna mollis euismod.</dd>\r\n    <dt>Felis euismod semper eget lacinia</dt>\r\n    <dd>Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</dd>\r\n  </dl>\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;dl</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"dl-horizontal"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;dt&gt;</span><span class="pln">...</span><span class="tag">&lt;/dt&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;dd&gt;</span><span class="pln">...</span><span class="tag">&lt;/dd&gt;</span></li><li class="L3"><span class="tag">&lt;/dl&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n</section>\r\n\r\n\r\n\r\n\r\n<section id="code">\r\n  <div class="page-header">\r\n    <h1>Code</h1>\r\n  </div>\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h2>Inline</h2>\r\n  <p>Wrap inline snippets of code with <code>&lt;code&gt;</code>.</p>\r\n<div class="bs-example">\r\nFor example, <code>&lt;section&gt;</code> should be wrapped as inline.\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="typ">For</span><span class="pln"> example</span><span class="pun">,</span><span class="pln"> </span><span class="str">&lt;code&gt;&lt;section&gt;</span><span class="pun">&lt;/</span><span class="pln">code</span><span class="pun">&gt;</span><span class="pln"> should be wrapped </span><span class="kwd">as</span><span class="pln"> </span><span class="kwd">inline</span><span class="pun">.</span></li></ol></pre>\r\n<p><strong>Note:</strong> Be sure to keep code within <code>&lt;pre&gt;</code> tags as close to the left as possible; it will render all tabs.</p>\r\n<p>You may optionally add the <code>.pre-scrollable</code> class which will set a max-height of 350px and provide a y-axis scrollbar.</p>\r\n\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h2>Basic block</h2>\r\n  <p>Use <code>&lt;pre&gt;</code> for multiple lines of code. Be sure to escape any angle brackets in the code for proper rendering.</p>\r\n<div class="bs-example">\r\n<pre>&lt;p&gt;Sample text here...&lt;/p&gt;</pre>\r\n</div>\r\n<pre class="prettyprint linenums" style="margin-bottom: 9px;"><ol class="linenums"><li class="L0"><span class="tag">&lt;pre&gt;</span></li><li class="L1"><span class="pln">  &amp;lt;p&amp;gt;Sample text here...&amp;lt;/p&amp;gt;</span></li><li class="L2"><span class="tag">&lt;/pre&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<h2>Prettify</h2>\r\n<p>To add colored syntax highlight to the <code>&lt;pre&gt;</code> tag, then use the <code>.prettyprint</code> class or the <code>.prettyprint linenums</code> class.</p>\r\n\r\n<div class="bs-example">\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="pun">&lt;?</span><span class="pln">php </span><span class="com">/** Begin Debug **/</span><span class="pln"> </span><span class="kwd">if</span><span class="pln"> </span><span class="pun">(</span><span class="pln">$gantry</span><span class="pun">-&gt;</span><span class="pln">countModules</span><span class="pun">(</span><span class="str">''debug''</span><span class="pun">))</span><span class="pln"> </span><span class="pun">:</span><span class="pln"> </span><span class="pun">?&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"rt-debug"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">    </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"rt-container"</span><span class="tag">&gt;</span></li><li class="L3"><span class="pln">      </span><span class="pun">&lt;?</span><span class="pln">php echo $gantry</span><span class="pun">-&gt;</span><span class="pln">displayModules</span><span class="pun">(</span><span class="str">''debug''</span><span class="pun">,</span><span class="str">''standard''</span><span class="pun">,</span><span class="str">''standard''</span><span class="pun">);</span><span class="pln"> </span><span class="pun">?&gt;</span></li><li class="L4"><span class="pln">      </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"clear"</span><span class="tag">&gt;&lt;/div&gt;</span></li><li class="L5"><span class="pln">    </span><span class="tag">&lt;/div&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L7"><span class="pln">  </span><span class="pun">&lt;?</span><span class="pln">php </span><span class="com">/** End Debug **/</span><span class="pln"> endif</span><span class="pun">;</span><span class="pln"> </span><span class="pun">?&gt;</span></li></ol></pre>\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;pre</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"prettyprint linenums"</span><span class="tag">&gt;</span><span class="pun">&lt;?</span><span class="pln">php </span><span class="com">/** Begin Debug **/</span><span class="pln"> </span><span class="kwd">if</span><span class="pln"> </span><span class="pun">(</span><span class="pln">$gantry</span><span class="pun">-&gt;</span><span class="pln">countModules</span><span class="pun">(</span><span class="str">''debug''</span><span class="pun">))</span><span class="pln"> </span><span class="pun">:</span><span class="pln"> </span><span class="pun">?&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"rt-debug"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">    </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"rt-container"</span><span class="tag">&gt;</span></li><li class="L3"><span class="pln">      </span><span class="pun">&lt;?</span><span class="pln">php echo $gantry</span><span class="pun">-&gt;</span><span class="pln">displayModules</span><span class="pun">(</span><span class="str">''debug''</span><span class="pun">,</span><span class="str">''standard''</span><span class="pun">,</span><span class="str">''standard''</span><span class="pun">);</span><span class="pln"> </span><span class="pun">?&gt;</span></li><li class="L4"><span class="pln">      </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"clear"</span><span class="tag">&gt;&lt;/div&gt;</span></li><li class="L5"><span class="pln">    </span><span class="tag">&lt;/div&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L7"><span class="pln">  </span><span class="pun">&lt;?</span><span class="pln">php </span><span class="com">/** End Debug **/</span><span class="pln"> endif</span><span class="pun">;</span><span class="pln"> </span><span class="pun">?&gt;</span><span class="tag">&lt;/pre&gt;</span></li></ol></pre>\r\n</section>\r\n\r\n\r\n\r\n\r\n<section id="tables">\r\n  <div class="page-header">\r\n    <h1>Tables</h1>\r\n  </div>\r\n\r\n  <h2>Default styles</h2>\r\n  <p>For basic styling—light padding and only horizontal dividers—add the base class <code>.table</code> to any <code>&lt;table&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <table class="table">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td>Larry</td>\r\n          <td>the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;table</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"table"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  …</span></li><li class="L2"><span class="tag">&lt;/table&gt;</span></li></ol></pre>\r\n\r\n\r\n<br />\r\n\r\n  <h2>Optional classes</h2>\r\n  <span>Add any of the follow classes to the <code>.table</code> base class.</span><br />\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h4><code>.table-striped</code></h4>\r\n  <p>Adds zebra-striping to any table row within the <code>&lt;tbody&gt;</code> via the <code>:nth-child</code> CSS selector (not available in IE7-IE8).</p>\r\n  <div class="bs-example">\r\n    <table class="table table-striped">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td>Larry</td>\r\n          <td>the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n<pre class="prettyprint linenums" style="margin-bottom: 18px;"><ol class="linenums"><li class="L0"><span class="tag">&lt;table</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"table table-striped"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  …</span></li><li class="L2"><span class="tag">&lt;/table&gt;</span></li></ol></pre>\r\n  <h4><code>.table-hover</code></h4>\r\n  <p>Enable a hover state on table rows within a <code>&lt;tbody&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <table class="table table-hover">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td colspan="2">Larry the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n<pre class="prettyprint linenums" style="margin-bottom: 18px;"><ol class="linenums"><li class="L0"><span class="tag">&lt;table</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"table table-hover"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  …</span></li><li class="L2"><span class="tag">&lt;/table&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right" style="float: none;">\r\n  <h4><code>.table-bordered</code></h4>\r\n  <p>Add borders and rounded corners to the table.</p>\r\n  <div class="bs-example">\r\n    <table class="table table-bordered">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td rowspan="2">1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@TwBootstrap</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td colspan="2">Larry the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;table</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"table table-bordered"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  …</span></li><li class="L2"><span class="tag">&lt;/table&gt;</span></li></ol></pre>\r\n  <h4><code>.table-condensed</code></h4>\r\n  <p>Makes tables more compact by cutting cell padding in half.</p>\r\n  <div class="bs-example">\r\n    <table class="table table-condensed">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td colspan="2">Larry the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n<pre class="prettyprint linenums" style="margin-bottom: 18px;"><ol class="linenums"><li class="L0"><span class="tag">&lt;table</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"table table-condensed"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  …</span></li><li class="L2"><span class="tag">&lt;/table&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n  <h2>Optional row classes</h2>   \r\n  <p>Use contextual classes to color table rows.</p>\r\n     <table class="table table-bordered table-striped">\r\n        <colgroup>\r\n          <col class="span1">\r\n          <col class="span7">\r\n        </colgroup>\r\n        <thead>\r\n          <tr>\r\n            <th>Class</th>\r\n            <th>Description</th>\r\n          </tr>\r\n        </thead>\r\n        <tbody>\r\n          <tr>\r\n            <td>\r\n              <code>.success</code>\r\n            </td>\r\n            <td>Indicates a successful or positive action.</td>\r\n          </tr>\r\n          <tr>\r\n            <td>\r\n              <code>.error</code>\r\n            </td>\r\n            <td>Indicates a dangerous or potentially negative action.</td>\r\n          </tr>\r\n          <tr>\r\n            <td>\r\n              <code>.info</code>\r\n            </td>\r\n            <td>Used as an alternative to the default styles.</td>\r\n          </tr>\r\n        </tbody>\r\n      </table>\r\n\r\n  <div class="bs-example">\r\n       <table class="table">\r\n         <thead>\r\n           <tr>\r\n             <th>#</th>\r\n             <th>Product</th>\r\n             <th>Payment Taken</th>\r\n             <th>Status</th>\r\n           </tr>\r\n         </thead>\r\n         <tbody>\r\n           <tr class="success">\r\n             <td>1</td>\r\n             <td>TB - Monthly</td>\r\n             <td>01/04/2012</td>\r\n             <td>Approved</td>\r\n           </tr>\r\n           <tr class="error">\r\n             <td>2</td>\r\n             <td>TB - Monthly</td>\r\n             <td>02/04/2012</td>\r\n             <td>Declined</td>\r\n           </tr>\r\n           <tr class="warning">\r\n             <td>3</td>\r\n             <td>TB - Monthly</td>\r\n             <td>03/04/2012</td>\r\n             <td>Pending</td>\r\n           </tr>\r\n           <tr class="info">\r\n             <td>4</td>\r\n             <td>TB - Monthly</td>\r\n             <td>04/04/2012</td>\r\n             <td>Call in to confirm</td>\r\n           </tr>\r\n         </tbody>\r\n       </table>\r\n     </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="pun">...</span></li><li class="L1"><span class="pln">  </span><span class="pun">&lt;</span><span class="pln">tr </span><span class="kwd">class</span><span class="pun">=</span><span class="str">"success"</span><span class="pun">&gt;</span></li><li class="L2"><span class="pln">    </span><span class="str">&lt;td&gt;</span><span class="lit">1</span><span class="pun">&lt;</span><span class="str">/td&gt;</span></li><li class="L3"><span class="str">    &lt;td&gt;TB - Monthly&lt;/</span><span class="pln">td</span><span class="pun">&gt;</span></li><li class="L4"><span class="pln">    </span><span class="str">&lt;td&gt;</span><span class="lit">01</span><span class="pun">/</span><span class="lit">04</span><span class="pun">/</span><span class="lit">2012</span><span class="pun">&lt;</span><span class="str">/td&gt;</span></li><li class="L5"><span class="str">    &lt;td&gt;Approved&lt;/</span><span class="pln">td</span><span class="pun">&gt;</span></li><li class="L6"><span class="pln">  </span><span class="pun">&lt;/</span><span class="pln">tr</span><span class="pun">&gt;</span></li><li class="L7"><span class="pun">...</span></li></ol></pre>\r\n\r\n  <h2>Supported table markup</h2>\r\n  <p>List of supported table HTML elements and how they should be used.</p>\r\n  <table class="table table-bordered table-striped">\r\n    <colgroup>\r\n      <col class="span1">\r\n      <col class="span7">\r\n    </colgroup>\r\n    <thead>\r\n      <tr>\r\n        <th>Tag</th>\r\n        <th>Description</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;table&gt;</code>\r\n        </td>\r\n        <td>\r\n          Wrapping element for displaying data in a tabular format\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;thead&gt;</code>\r\n        </td>\r\n        <td>\r\n          Container element for table header rows (<code>&lt;tr&gt;</code>) to label table columns\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;tbody&gt;</code>\r\n        </td>\r\n        <td>\r\n          Container element for table rows (<code>&lt;tr&gt;</code>) in the body of the table\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;tr&gt;</code>\r\n        </td>\r\n        <td>\r\n          Container element for a set of table cells (<code>&lt;td&gt;</code> or <code>&lt;th&gt;</code>) that appears on a single row\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;td&gt;</code>\r\n        </td>\r\n        <td>\r\n          Default table cell\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;th&gt;</code>\r\n        </td>\r\n        <td>\r\n          Special table cell for column (or row, depending on scope and placement) labels<br />\r\n          Must be used within a <code>&lt;thead&gt;</code>\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;caption&gt;</code>\r\n        </td>\r\n        <td>\r\n          Description or summary of what the table holds, especially useful for screen readers\r\n        </td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;table&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;caption&gt;</span><span class="pln">...</span><span class="tag">&lt;/caption&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;thead&gt;</span></li><li class="L3"><span class="pln">    </span><span class="tag">&lt;tr&gt;</span></li><li class="L4"><span class="pln">      </span><span class="tag">&lt;th&gt;</span><span class="pln">...</span><span class="tag">&lt;/th&gt;</span></li><li class="L5"><span class="pln">      </span><span class="tag">&lt;th&gt;</span><span class="pln">...</span><span class="tag">&lt;/th&gt;</span></li><li class="L6"><span class="pln">    </span><span class="tag">&lt;/tr&gt;</span></li><li class="L7"><span class="pln">  </span><span class="tag">&lt;/thead&gt;</span></li><li class="L8"><span class="pln">  </span><span class="tag">&lt;tbody&gt;</span></li><li class="L9"><span class="pln">    </span><span class="tag">&lt;tr&gt;</span></li><li class="L0"><span class="pln">      </span><span class="tag">&lt;td&gt;</span><span class="pln">...</span><span class="tag">&lt;/td&gt;</span></li><li class="L1"><span class="pln">      </span><span class="tag">&lt;td&gt;</span><span class="pln">...</span><span class="tag">&lt;/td&gt;</span></li><li class="L2"><span class="pln">    </span><span class="tag">&lt;/tr&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;/tbody&gt;</span></li><li class="L4"><span class="tag">&lt;/table&gt;</span></li></ol></pre>\r\n\r\n</section>\r\n\r\n\r\n\r\n\r\n<section id="forms">\r\n  <div class="page-header">\r\n    <h1>Forms</h1>\r\n  </div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left" style="float: none;">                \r\n  <h2>Default styles</h2>\r\n  <p>Individual form controls receive styling, but without any required base class on the <code>&lt;form&gt;</code> or large changes in markup. Results in stacked, left-aligned labels on top of form controls.</p>\r\n\r\n  <form class="bs-example"><fieldset>\r\n    <legend>Legend</legend>\r\n    <label>Label name</label>\r\n    <input type="text" placeholder="Type something…" />\r\n    <span class="help-block">Example block-level help text here.</span>\r\n    <label class="checkbox">\r\n      <input type="checkbox" /> Check me out\r\n    </label>\r\n    <button type="submit" class="btn">Submit</button>\r\n  </fieldset></form>\r\n\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;form&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;legend&gt;</span><span class="pln">Legend</span><span class="tag">&lt;/legend&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;label&gt;</span><span class="pln">Label name</span><span class="tag">&lt;/label&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Type something…"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-block"</span><span class="tag">&gt;</span><span class="pln">Example block-level help text here.</span><span class="tag">&lt;/span&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span></li><li class="L6"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span><span class="pln"> Check me out</span></li><li class="L7"><span class="pln">  </span><span class="tag">&lt;/label&gt;</span></li><li class="L8"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Submit</span><span class="tag">&lt;/button&gt;</span></li><li class="L9"><span class="tag">&lt;/form&gt;</span></li></ol></pre><br />\r\n\r\n  <h2>Optional layouts</h2>\r\n  <p>Included with Bootstrap are three optional form layouts for common use cases.</p>\r\n\r\n  <h3>Search form</h3>\r\n  <p>Add <code>.form-search</code> to the form and <code>.search-query</code> to the <code>&lt;input&gt;</code> for an extra-rounded text input.</p>\r\n  <form class="bs-example form-search">\r\n    <input type="text" class="input-medium search-query" />\r\n    <button type="submit" class="btn">Search</button>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;form</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"form-search"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-medium search-query"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Search</span><span class="tag">&lt;/button&gt;</span></li><li class="L3"><span class="tag">&lt;/form&gt;</span></li></ol></pre>\r\n\r\n  <h3>Inline form</h3>\r\n  <p>Add <code>.form-inline</code> for left-aligned labels and inline-block controls for a compact layout.</p>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" class="input-small" placeholder="Email" />\r\n    <input type="password" class="input-small" placeholder="Password" />\r\n    <label class="checkbox">\r\n      <input type="checkbox" /> Remember me\r\n    </label>\r\n    <button type="submit" class="btn">Sign in</button>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;form</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"form-inline"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-small"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Email"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"password"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-small"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Password"</span><span class="tag">&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span><span class="pln"> Remember me</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;/label&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Sign in</span><span class="tag">&lt;/button&gt;</span></li><li class="L7"><span class="tag">&lt;/form&gt;</span></li></ol></pre>\r\n\r\n  <h3>Horizontal form</h3>\r\n  <p>Right align labels and float them to the left to make them appear on the same line as controls. Requires the most markup changes from a default form:</p>\r\n  <ul>\r\n    <li>Add <code>.form-horizontal</code> to the form</li>\r\n    <li>Wrap labels and controls in <code>.control-group</code></li>\r\n    <li>Add <code>.control-label</code> to the label</li>\r\n    <li>Wrap any associated controls in <code>.controls</code> for proper alignment</li>\r\n  </ul>\r\n  <form class="bs-example form-horizontal"><fieldset>\r\n    <legend>Legend</legend>\r\n    <div class="control-group">\r\n      <label class="control-label" for="inputEmail">Email</label>\r\n      <div class="controls">\r\n        <input type="text" id="inputEmail" placeholder="Email" />\r\n      </div>\r\n    </div>\r\n    <div class="control-group">\r\n      <label class="control-label" for="inputPassword">Password</label>\r\n      <div class="controls">\r\n        <input type="password" id="inputPassword" placeholder="Password" />\r\n      </div>\r\n    </div>\r\n    <div class="control-group">\r\n      <div class="controls">\r\n        <label class="checkbox">\r\n          <input type="checkbox" /> Remember me\r\n        </label>\r\n        <button type="submit" class="btn">Sign in</button>\r\n      </div>\r\n    </div></fieldset>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;form</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"form-horizontal"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">    </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-label"</span><span class="pln"> </span><span class="atn">for</span><span class="pun">=</span><span class="atv">"inputEmail"</span><span class="tag">&gt;</span><span class="pln">Email</span><span class="tag">&lt;/label&gt;</span></li><li class="L3"><span class="pln">    </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">      </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inputEmail"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Email"</span><span class="tag">&gt;</span></li><li class="L5"><span class="pln">    </span><span class="tag">&lt;/div&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L7"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group"</span><span class="tag">&gt;</span></li><li class="L8"><span class="pln">    </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-label"</span><span class="pln"> </span><span class="atn">for</span><span class="pun">=</span><span class="atv">"inputPassword"</span><span class="tag">&gt;</span><span class="pln">Password</span><span class="tag">&lt;/label&gt;</span></li><li class="L9"><span class="pln">    </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L0"><span class="pln">      </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"password"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inputPassword"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Password"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">    </span><span class="tag">&lt;/div&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">    </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L5"><span class="pln">      </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span></li><li class="L6"><span class="pln">        </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span><span class="pln"> Remember me</span></li><li class="L7"><span class="pln">      </span><span class="tag">&lt;/label&gt;</span></li><li class="L8"><span class="pln">      </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Sign in</span><span class="tag">&lt;/button&gt;</span></li><li class="L9"><span class="pln">    </span><span class="tag">&lt;/div&gt;</span></li><li class="L0"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L1"><span class="tag">&lt;/form&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h2>Supported form controls</h2>\r\n  <p>Examples of standard form controls supported in an example form layout.</p>\r\n\r\n  <h3>Inputs</h3>\r\n  <p>Most common form control, text-based input fields. Includes support for all HTML5 types: text, password, datetime, datetime-local, date, month, time, week, number, email, url, search, tel, and color.</p>\r\n  <p>Requires the use of a specified <code>type</code> at all times.</p>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" placeholder="Text input" />\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Text input"</span><span class="tag">&gt;</span></li></ol></pre>\r\n\r\n  <h3>Textarea</h3>\r\n  <p>Form control which supports multiple lines of text. Change <code>row</code> attribute as necessary.</p>\r\n  <form class="bs-example form-inline">\r\n    <textarea rows="3"></textarea>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;textarea</span><span class="pln"> </span><span class="atn">rows</span><span class="pun">=</span><span class="atv">"3"</span><span class="tag">&gt;&lt;/textarea&gt;</span></li></ol></pre>\r\n\r\n  <h3>Checkboxes and radios</h3>\r\n  <p>Checkboxes are for selecting one or several options in a list while radios are for selecting one option from many.</p>\r\n  <h4>Default (stacked)</h4>\r\n  <form class="bs-example">\r\n    <label class="checkbox">\r\n      <input type="checkbox" value="" />\r\n      Option one is this and that—be sure to include why it''s great\r\n    </label>\r\n    <br />\r\n    <label class="radio">\r\n      <input type="radio" name="optionsRadios" id="optionsRadios1" value="option1" checked="" />\r\n      Option one is this and that—be sure to include why it''s great\r\n    </label>\r\n    <label class="radio">\r\n      <input type="radio" name="optionsRadios" id="optionsRadios2" value="option2" />\r\n      Option two can be something else and selecting it will deselect option one\r\n    </label>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">""</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">  Option one is this and that—be sure to include why it''s great</span></li><li class="L3"><span class="tag">&lt;/label&gt;</span></li><li class="L4"><span class="pln">&nbsp;</span></li><li class="L5"><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"radio"</span><span class="tag">&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"radio"</span><span class="pln"> </span><span class="atn">name</span><span class="pun">=</span><span class="atv">"optionsRadios"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"optionsRadios1"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"option1"</span><span class="pln"> </span><span class="atn">checked</span><span class="tag">&gt;</span></li><li class="L7"><span class="pln">  Option one is this and that—be sure to include why it''s great</span></li><li class="L8"><span class="tag">&lt;/label&gt;</span></li><li class="L9"><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"radio"</span><span class="tag">&gt;</span></li><li class="L0"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"radio"</span><span class="pln"> </span><span class="atn">name</span><span class="pun">=</span><span class="atv">"optionsRadios"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"optionsRadios2"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"option2"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  Option two can be something else and selecting it will deselect option one</span></li><li class="L2"><span class="tag">&lt;/label&gt;</span></li></ol></pre>\r\n\r\n  <h4>Inline checkboxes</h4>\r\n  <p>Add the <code>.inline</code> class to a series of checkboxes or radios for controls appear on the same line.</p>\r\n  <form class="bs-example">\r\n    <label class="checkbox inline">\r\n      <input type="checkbox" id="inlineCheckbox1" value="option1" /> 1\r\n    </label>\r\n    <label class="checkbox inline">\r\n      <input type="checkbox" id="inlineCheckbox2" value="option2" /> 2\r\n    </label>\r\n    <label class="checkbox inline">\r\n      <input type="checkbox" id="inlineCheckbox3" value="option3" /> 3\r\n    </label>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox inline"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inlineCheckbox1"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"option1"</span><span class="tag">&gt;</span><span class="pln"> 1</span></li><li class="L2"><span class="tag">&lt;/label&gt;</span></li><li class="L3"><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox inline"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inlineCheckbox2"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"option2"</span><span class="tag">&gt;</span><span class="pln"> 2</span></li><li class="L5"><span class="tag">&lt;/label&gt;</span></li><li class="L6"><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"checkbox inline"</span><span class="tag">&gt;</span></li><li class="L7"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"checkbox"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inlineCheckbox3"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"option3"</span><span class="tag">&gt;</span><span class="pln"> 3</span></li><li class="L8"><span class="tag">&lt;/label&gt;</span></li></ol></pre>\r\n\r\n  <h3>Selects</h3>\r\n  <p>Use the default option or specify a <code>multiple="multiple"</code> to show multiple options at once.</p>\r\n  <form class="bs-example">\r\n    <select>\r\n      <option>1</option>\r\n      <option>2</option>\r\n      <option>3</option>\r\n      <option>4</option>\r\n      <option>5</option>\r\n    </select>\r\n    <br />\r\n    <select multiple="multiple">\r\n      <option>1</option>\r\n      <option>2</option>\r\n      <option>3</option>\r\n      <option>4</option>\r\n      <option>5</option>\r\n    </select>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;select&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">1</span><span class="tag">&lt;/option&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">2</span><span class="tag">&lt;/option&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">3</span><span class="tag">&lt;/option&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">4</span><span class="tag">&lt;/option&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">5</span><span class="tag">&lt;/option&gt;</span></li><li class="L6"><span class="tag">&lt;/select&gt;</span></li><li class="L7"><span class="pln">&nbsp;</span></li><li class="L8"><span class="tag">&lt;select</span><span class="pln"> </span><span class="atn">multiple</span><span class="pun">=</span><span class="atv">"multiple"</span><span class="tag">&gt;</span></li><li class="L9"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">1</span><span class="tag">&lt;/option&gt;</span></li><li class="L0"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">2</span><span class="tag">&lt;/option&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">3</span><span class="tag">&lt;/option&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">4</span><span class="tag">&lt;/option&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;option&gt;</span><span class="pln">5</span><span class="tag">&lt;/option&gt;</span></li><li class="L4"><span class="tag">&lt;/select&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n\r\n  <h2>Extending form controls</h2>\r\n  <p>Adding on top of existing browser controls, Bootstrap includes other useful form components.</p>\r\n\r\n  <h3>Prepended and appended inputs</h3>\r\n  <span>Add text or buttons before or after any text-based input. Do note that <code>select</code> elements are not supported here.</span><br />\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left" style="float: none;">\r\n  <h4>Default options</h4>\r\n  <p>Wrap an <code>.add-on</code> and an <code>input</code> with one of two classes to prepend or append text to an input.</p>\r\n  <form class="bs-example">\r\n    <div class="input-prepend">\r\n      <span class="add-on">@</span>\r\n      <input class="span2" id="prependedInput" size="16" type="text" placeholder="Username" />\r\n    </div>\r\n    <br />\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedInput" size="16" type="text" />\r\n      <span class="add-on">.00</span>\r\n    </div>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-prepend"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"add-on"</span><span class="tag">&gt;</span><span class="pln">@</span><span class="tag">&lt;/span&gt;&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"prependedInput"</span><span class="pln"> </span><span class="atn">size</span><span class="pun">=</span><span class="atv">"16"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Username"</span><span class="tag">&gt;</span></li><li class="L2"><span class="tag">&lt;/div&gt;</span></li><li class="L3"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-append"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"appendedInput"</span><span class="pln"> </span><span class="atn">size</span><span class="pun">=</span><span class="atv">"16"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="tag">&gt;&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"add-on"</span><span class="tag">&gt;</span><span class="pln">.00</span><span class="tag">&lt;/span&gt;</span></li><li class="L5"><span class="tag">&lt;/div&gt;</span></li></ol></pre>\r\n\r\n  <h4>Search form</h4>\r\n  <form class="bs-example form-search">\r\n    <div class="input-append">\r\n      <input type="text" class="span2 search-query" />\r\n      <button type="submit" class="btn">Search</button>\r\n    </div>\r\n    <br /><br /><div class="input-prepend">\r\n      <button type="submit" class="btn">Search</button>\r\n      <input type="text" class="span2 search-query" />\r\n    </div>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;form</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"form-search"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-append"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2 search-query"</span><span class="tag">&gt;</span></li><li class="L3"><span class="pln">    </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Search</span><span class="tag">&lt;/button&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-prepend"</span><span class="tag">&gt;</span></li><li class="L6"><span class="pln">    </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Search</span><span class="tag">&lt;/button&gt;</span></li><li class="L7"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2 search-query"</span><span class="tag">&gt;</span></li><li class="L8"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L9"><span class="tag">&lt;/form&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right" style="float: none;">\r\n  <h4>Combined</h4>\r\n  <p>Use both classes and two instances of <code>.add-on</code> to prepend and append an input.</p>\r\n  <form class="bs-example form-inline">\r\n    <div class="input-prepend input-append">\r\n      <span class="add-on">$</span>\r\n      <input class="span2" id="appendedPrependedInput" size="16" type="text" />\r\n      <span class="add-on">.00</span>\r\n    </div>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-prepend input-append"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"add-on"</span><span class="tag">&gt;</span><span class="pln">$</span><span class="tag">&lt;/span&gt;&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"appendedPrependedInput"</span><span class="pln"> </span><span class="atn">size</span><span class="pun">=</span><span class="atv">"16"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="tag">&gt;&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"add-on"</span><span class="tag">&gt;</span><span class="pln">.00</span><span class="tag">&lt;/span&gt;</span></li><li class="L2"><span class="tag">&lt;/div&gt;</span></li></ol></pre>\r\n\r\n  <h4>Buttons instead of text</h4>\r\n  <p>Instead of a <code>&lt;span&gt;</code> with text, use a <code>.btn</code> to attach a button (or two) to an input.</p>\r\n  <form class="bs-example">\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedInputButton" size="16" type="text" />\r\n      <button class="btn" type="button">Go!</button>\r\n    </div>\r\n    <br />\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedInputButtons" size="16" type="text" />\r\n      <button class="btn" type="button">Search</button>\r\n      <button class="btn" type="button">Options</button>\r\n    </div>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-append"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"appendedInputButton"</span><span class="pln"> </span><span class="atn">size</span><span class="pun">=</span><span class="atv">"16"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="tag">&gt;&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Go!</span><span class="tag">&lt;/button&gt;</span></li><li class="L2"><span class="tag">&lt;/div&gt;</span></li><li class="L3"><span class="pln">&nbsp;</span></li><li class="L4"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-append"</span><span class="tag">&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"span2"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"appendedInputButtons"</span><span class="pln"> </span><span class="atn">size</span><span class="pun">=</span><span class="atv">"16"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="tag">&gt;&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Search</span><span class="tag">&lt;/button&gt;&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Options</span><span class="tag">&lt;/button&gt;</span></li><li class="L6"><span class="tag">&lt;/div&gt;</span></li></ol></pre>\r\n\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h3>Form actions</h3>\r\n  <p>End a form with a group of actions (buttons). When placed within a <code>.form-horizontal</code>, the buttons will automatically indent to line up with the form controls.</p>\r\n  <form class="bs-example">\r\n    <div class="form-actions">\r\n      <button type="submit" class="btn btn-primary">Save changes</button>\r\n      <button type="button" class="btn">Cancel</button>\r\n    </div>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"form-actions"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-primary"</span><span class="tag">&gt;</span><span class="pln">Save changes</span><span class="tag">&lt;/button&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="tag">&gt;</span><span class="pln">Cancel</span><span class="tag">&lt;/button&gt;</span></li><li class="L3"><span class="tag">&lt;/div&gt;</span></li></ol></pre>\r\n\r\n  <h3>Help text</h3>\r\n  <p>Inline and block level support for help text that appears around form controls.</p>\r\n  <h4>Inline help</h4>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" /> <span class="help-inline">Inline help text</span>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="tag">&gt;&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-inline"</span><span class="tag">&gt;</span><span class="pln">Inline help text</span><span class="tag">&lt;/span&gt;</span></li></ol></pre>\r\n\r\n  <h4>Block help</h4>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" />\r\n    <span class="help-block">A longer block of help text that breaks onto a new line and may extend beyond one line.</span>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="tag">&gt;&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-block"</span><span class="tag">&gt;</span><span class="pln">A longer block of help text that breaks onto a new line and may extend beyond one line.</span><span class="tag">&lt;/span&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right" style="float: none;">\r\n  <h3>Control sizing</h3>\r\n  <p>Use relative sizing classes like <code>.input-large</code> or match your inputs to the grid column sizes using <code>.span*</code> classes.</p>\r\n\r\n  <h4>Relative sizing</h4>\r\n  <form class="bs-example" style="padding-bottom: 15px;">\r\n    <div class="controls docs-input-sizes">\r\n      <input class="input-mini" type="text" placeholder=".input-mini" /><br />\r\n      <input class="input-small" type="text" placeholder=".input-small" /><br />\r\n      <input class="input-medium" type="text" placeholder=".input-medium" /><br />\r\n      <input class="input-large" type="text" placeholder=".input-large" /><br />\r\n      <input class="input-xlarge" type="text" placeholder=".input-xlarge" /><br />\r\n      <input class="input-xxlarge" type="text" placeholder=".input-xxlarge" />\r\n    </div>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-mini"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">".input-mini"</span><span class="tag">&gt;</span></li><li class="L1"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-small"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">".input-small"</span><span class="tag">&gt;</span></li><li class="L2"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-medium"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">".input-medium"</span><span class="tag">&gt;</span></li><li class="L3"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-large"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">".input-large"</span><span class="tag">&gt;</span></li><li class="L4"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-xlarge"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">".input-xlarge"</span><span class="tag">&gt;</span></li><li class="L5"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-xxlarge"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">".input-xxlarge"</span><span class="tag">&gt;</span></li></ol></pre><br />\r\n  <p>\r\n    <strong>Note:</strong> In future versions, we''ll be altering the use of these relative input classes to match our button sizes. For example, <code>.input-large</code> will increase the padding and font-size of an input.\r\n  </p>\r\n\r\n  <h3>Uneditable inputs</h3>\r\n  <p>Present data in a form that''s not editable without using actual form markup.</p>\r\n  <form class="bs-example">\r\n    <span class="input-xlarge uneditable-input">Some value here</span>\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-xlarge uneditable-input"</span><span class="tag">&gt;</span><span class="pln">Some value here</span><span class="tag">&lt;/span&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n<br />\r\n\r\n\r\n  <h2>Form control states</h2>\r\n  <span>Provide feedback to users or visitors with basic feedback states on form controls and labels.</span><br />\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h3>Input focus</h3>\r\n  <p>We remove the default <code>outline</code> styles on some form controls and apply a <code>box-shadow</code> in its place for <code>:focus</code>.</p>\r\n  <form class="bs-example form-inline">\r\n    <input class="input-xlarge focused" id="focusedInput" type="text" value="This is focused..." />\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-xlarge"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"focusedInput"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"This is focused..."</span><span class="tag">&gt;</span></li></ol></pre>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h3>Disabled inputs</h3>\r\n  <p>Add the <code>disabled</code> attribute on an input to prevent user input and trigger a slightly different look.</p>\r\n  <form class="bs-example form-inline">\r\n    <input class="input-xlarge" id="disabledInput" type="text" placeholder="Disabled input here…" disabled="" />\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"input-xlarge"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"disabledInput"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">placeholder</span><span class="pun">=</span><span class="atv">"Disabled input here..."</span><span class="pln"> </span><span class="atn">disabled</span><span class="tag">&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>       \r\n\r\n<h3>Validation states</h3>\r\n<p>Bootstrap includes validation styles for error, warning, and success messages. To use, add the appropriate class to the surrounding <code>.control-group</code>.</p>\r\n\r\n<form class="bs-example form-horizontal">\r\n  <div class="control-group warning">\r\n    <label class="control-label" for="inputWarning">Input with warning</label>\r\n    <div class="controls">\r\n      <input type="text" id="inputWarning" />\r\n      <span class="help-inline">Something may have gone wrong</span>\r\n    </div>\r\n  </div>\r\n  <div class="control-group error">\r\n    <label class="control-label" for="inputError">Input with error</label>\r\n    <div class="controls">\r\n      <input type="text" id="inputError" />\r\n      <span class="help-inline">Please correct the error</span>\r\n    </div>\r\n  </div>\r\n  <div class="control-group info">\r\n    <label class="control-label" for="inputError">Input with info</label>\r\n    <div class="controls">\r\n      <input type="text" id="inputError" />\r\n      <span class="help-inline">Username is taken</span>\r\n    </div>\r\n  </div>\r\n  <div class="control-group success">\r\n    <label class="control-label" for="inputSuccess">Input with success</label>\r\n    <div class="controls">\r\n      <input type="text" id="inputSuccess" />\r\n      <span class="help-inline">Woohoo!</span>\r\n    </div>\r\n  </div>\r\n</form>   \r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group warning"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-label"</span><span class="pln"> </span><span class="atn">for</span><span class="pun">=</span><span class="atv">"inputWarning"</span><span class="tag">&gt;</span><span class="pln">Input with warning</span><span class="tag">&lt;/label&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L3"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inputWarning"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">    </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-inline"</span><span class="tag">&gt;</span><span class="pln">Something may have gone wrong</span><span class="tag">&lt;/span&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L6"><span class="tag">&lt;/div&gt;</span></li><li class="L7"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group error"</span><span class="tag">&gt;</span></li><li class="L8"><span class="pln">  </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-label"</span><span class="pln"> </span><span class="atn">for</span><span class="pun">=</span><span class="atv">"inputError"</span><span class="tag">&gt;</span><span class="pln">Input with error</span><span class="tag">&lt;/label&gt;</span></li><li class="L9"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L0"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inputError"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">    </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-inline"</span><span class="tag">&gt;</span><span class="pln">Please correct the error</span><span class="tag">&lt;/span&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L3"><span class="tag">&lt;/div&gt;</span></li><li class="L4"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group info"</span><span class="tag">&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-label"</span><span class="pln"> </span><span class="atn">for</span><span class="pun">=</span><span class="atv">"inputError"</span><span class="tag">&gt;</span><span class="pln">Input with info</span><span class="tag">&lt;/label&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L7"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inputError"</span><span class="tag">&gt;</span></li><li class="L8"><span class="pln">    </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-inline"</span><span class="tag">&gt;</span><span class="pln">Username is taken</span><span class="tag">&lt;/span&gt;</span></li><li class="L9"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L0"><span class="tag">&lt;/div&gt;</span></li><li class="L1"><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-group success"</span><span class="tag">&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;label</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"control-label"</span><span class="pln"> </span><span class="atn">for</span><span class="pun">=</span><span class="atv">"inputSuccess"</span><span class="tag">&gt;</span><span class="pln">Input with success</span><span class="tag">&lt;/label&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;div</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"controls"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">    </span><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"text"</span><span class="pln"> </span><span class="atn">id</span><span class="pun">=</span><span class="atv">"inputSuccess"</span><span class="tag">&gt;</span></li><li class="L5"><span class="pln">    </span><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"help-inline"</span><span class="tag">&gt;</span><span class="pln">Woohoo!</span><span class="tag">&lt;/span&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;/div&gt;</span></li><li class="L7"><span class="tag">&lt;/div&gt;</span></li></ol></pre>\r\n</section>\r\n\r\n\r\n\r\n\r\n<section id="buttons">\r\n  <div class="page-header">\r\n    <h1>Buttons</h1>\r\n  </div>\r\n\r\n  <h2>Default buttons</h2>\r\n  <p>Button styles can be applied to anything with the <code>.btn</code> class applied. However, typically you''ll want to apply these to only <code>&lt;a&gt;</code> and <code>&lt;button&gt;</code> elements for the best rendering.</p>\r\n<table class="table table-bordered table-striped">\r\n  <thead>\r\n    <tr>\r\n      <th>Button</th>\r\n      <th>class=""</th>\r\n      <th>Description</th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td><button type="button" class="btn">Default</button></td>\r\n      <td><code>btn</code></td>\r\n      <td>Standard gray button with gradient</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-primary">Primary</button></td>\r\n      <td><code>btn btn-primary</code></td>\r\n      <td>Provides extra visual weight and identifies the primary action in a set of buttons</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-info">Info</button></td>\r\n      <td><code>btn btn-info</code></td>\r\n      <td>Used as an alternative to the default styles</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-success">Success</button></td>\r\n      <td><code>btn btn-success</code></td>\r\n      <td>Indicates a successful or positive action</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-warning">Warning</button></td>\r\n      <td><code>btn btn-warning</code></td>\r\n      <td>Indicates caution should be taken with this action</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-danger">Danger</button></td>\r\n      <td><code>btn btn-danger</code></td>\r\n      <td>Indicates a dangerous or potentially negative action</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-inverse">Inverse</button></td>\r\n      <td><code>btn btn-inverse</code></td>\r\n      <td>Alternate dark gray button, not tied to a semantic action or use</td>\r\n    </tr>\r\n    <tr>\r\n      <td><button type="button" class="btn btn-link">Link</button></td>\r\n      <td><code>btn btn-link</code></td>\r\n      <td>Deemphasize a button by making it look like a link while maintaining button behavior</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n  <h4>Cross browser compatibility</h4>\r\n  <p>IE9 doesn''t crop background gradients on rounded corners, so we remove it. Related, IE9 jankifies disabled <code>button</code> elements, rendering text gray with a nasty text-shadow that we cannot fix.</p>\r\n\r\n\r\n  <h2>Button sizes</h2>\r\n  <p>Fancy larger or smaller buttons? Add <code>.btn-large</code>, <code>.btn-small</code>, or <code>.btn-mini</code> for additional sizes.</p>\r\n  <div class="bs-example">\r\n    <p>\r\n      <button type="button" class="btn btn-large btn-primary">Large button</button>\r\n      <button type="button" class="btn btn-large">Large button</button>\r\n    </p>\r\n    <p>\r\n      <button type="button" class="btn btn-primary">Default button</button>\r\n      <button type="button" class="btn">Default button</button>\r\n    </p>\r\n    <p>\r\n      <button type="button" class="btn btn-small btn-primary">Small button</button>\r\n      <button type="button" class="btn btn-small">Small button</button>\r\n    </p>\r\n    <p>\r\n      <button type="button" class="btn btn-mini btn-primary">Mini button</button>\r\n      <button type="button" class="btn btn-mini">Mini button</button>\r\n    </p>\r\n  </div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;p&gt;</span></li><li class="L1"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large btn-primary"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Large button</span><span class="tag">&lt;/button&gt;</span></li><li class="L2"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Large button</span><span class="tag">&lt;/button&gt;</span></li><li class="L3"><span class="tag">&lt;/p&gt;</span></li><li class="L4"><span class="tag">&lt;p&gt;</span></li><li class="L5"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-primary"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Default button</span><span class="tag">&lt;/button&gt;</span></li><li class="L6"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Default button</span><span class="tag">&lt;/button&gt;</span></li><li class="L7"><span class="tag">&lt;/p&gt;</span></li><li class="L8"><span class="tag">&lt;p&gt;</span></li><li class="L9"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-small btn-primary"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Small button</span><span class="tag">&lt;/button&gt;</span></li><li class="L0"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-small"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Small button</span><span class="tag">&lt;/button&gt;</span></li><li class="L1"><span class="tag">&lt;/p&gt;</span></li><li class="L2"><span class="tag">&lt;p&gt;</span></li><li class="L3"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-mini btn-primary"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Mini button</span><span class="tag">&lt;/button&gt;</span></li><li class="L4"><span class="pln">  </span><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-mini"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Mini button</span><span class="tag">&lt;/button&gt;</span></li><li class="L5"><span class="tag">&lt;/p&gt;</span></li></ol></pre>\r\n<p>Create block level buttons—those that span the full width of a parent— by adding <code>.btn-block</code>.</p>\r\n<div class="bs-example">\r\n  <div class="well" style="max-width: 400px; margin: 0 auto 10px;">\r\n    <button type="button" class="btn btn-large btn-block btn-primary">Block level button</button>\r\n    <button type="button" class="btn btn-large btn-block">Block level button</button>\r\n  </div>\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large btn-block btn-primary"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Block level button</span><span class="tag">&lt;/button&gt;</span></li><li class="L1"><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large btn-block"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="tag">&gt;</span><span class="pln">Block level button</span><span class="tag">&lt;/button&gt;</span></li></ol></pre>\r\n  \r\n  <h2>Disabled state</h2>\r\n  <p>Make buttons look unclickable by fading them back 50%.</p>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-left">\r\n  <h3>Anchor element</h3>\r\n  <p>Add the <code>.disabled</code> class to <code>&lt;a&gt;</code> buttons.</p>\r\n  <p class="bs-example">\r\n    <a href="#" class="btn btn-large btn-primary disabled">Primary link</a>\r\n    <a href="#" class="btn btn-large disabled">Link</a>\r\n  </p>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;a</span><span class="pln"> </span><span class="atn">href</span><span class="pun">=</span><span class="atv">"#"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large btn-primary disabled"</span><span class="tag">&gt;</span><span class="pln">Primary link</span><span class="tag">&lt;/a&gt;</span></li><li class="L1"><span class="tag">&lt;a</span><span class="pln"> </span><span class="atn">href</span><span class="pun">=</span><span class="atv">"#"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large disabled"</span><span class="tag">&gt;</span><span class="pln">Link</span><span class="tag">&lt;/a&gt;</span></li></ol></pre><br />\r\n  <p>\r\n    <strong>Note:</strong>\r\n    We use <code>.disabled</code> as a utility class here, similar to the common <code>.active</code> class, so no prefix is required.\r\n  </p>\r\n</div></div>\r\n\r\n<div class="width-block width-50">\r\n<div class="pull-right">\r\n  <h3>Button element</h3>\r\n  <p>Add the <code>disabled</code> attribute to <code>&lt;button&gt;</code> buttons.</p>\r\n  <p class="bs-example">\r\n    <button type="button" class="btn btn-large btn-primary disabled" disabled="disabled">Primary button</button>\r\n    <button type="button" class="btn btn-large" disabled="">Button</button>\r\n  </p>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large btn-primary disabled"</span><span class="pln"> </span><span class="atn">disabled</span><span class="pun">=</span><span class="atv">"disabled"</span><span class="tag">&gt;</span><span class="pln">Primary button</span><span class="tag">&lt;/button&gt;</span></li><li class="L1"><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn btn-large"</span><span class="pln"> </span><span class="atn">disabled</span><span class="tag">&gt;</span><span class="pln">Button</span><span class="tag">&lt;/button&gt;</span></li></ol></pre>\r\n</div></div>\r\n<div class="clear"></div>\r\n\r\n\r\n  <h2>One class, multiple tags</h2>\r\n  <p>Use the <code>.btn</code> class on an <code>&lt;a&gt;</code>, <code>&lt;button&gt;</code>, or <code>&lt;input&gt;</code> element.</p>\r\n  <form class="bs-example">\r\n    <a class="btn" href="/">Link</a>\r\n    <button class="btn" type="submit">Button</button>\r\n    <input class="btn" type="button" value="Input" />\r\n    <input class="btn" type="submit" value="Submit" />\r\n  </form>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;a</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">href</span><span class="pun">=</span><span class="atv">""</span><span class="tag">&gt;</span><span class="pln">Link</span><span class="tag">&lt;/a&gt;</span></li><li class="L1"><span class="tag">&lt;button</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="tag">&gt;</span><span class="pln">Button</span><span class="tag">&lt;/button&gt;</span></li><li class="L2"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"button"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"Input"</span><span class="tag">&gt;</span></li><li class="L3"><span class="tag">&lt;input</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"btn"</span><span class="pln"> </span><span class="atn">type</span><span class="pun">=</span><span class="atv">"submit"</span><span class="pln"> </span><span class="atn">value</span><span class="pun">=</span><span class="atv">"Submit"</span><span class="tag">&gt;</span></li></ol></pre><br />\r\n  <p>As a best practice, try to match the element for your context to ensure matching cross-browser rendering. If you have an <code>input</code>, use an <code>&lt;input type="submit"&gt;</code> for your button.</p>\r\n\r\n</section>\r\n\r\n\r\n<h1>Icons</h1>\r\n<h2>Font Awesome</h2>\r\n\r\n  <p>Font Awesome is a pictographic language of web-related actions which delivers 220 icons. The Font Awesome webfont, CSS, and LESS files are licensed under CC BY 3.0 and you can find the full examples of usage at <a href="http://fortawesome.github.com/Font-Awesome" target="_blank">Font Awesome - http://fortawesome.github.com/Font-Awesome</a></p>\r\n\r\n<p>Add <code>.icon-CLASS_NAME</code> to any element, best used with a <code>&lt;span&gt;</code>.</p>\r\n\r\n<div class="bs-example">\r\n<h3>Web Icons</h3>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-adjust"> icon-adjust</span><br /><br />\r\n      <span class="icon-asterisk"> icon-asterisk</span><br /><br />\r\n      <span class="icon-ban-circle"> icon-ban-circle</span><br /><br />\r\n      <span class="icon-bar-chart"> icon-bar-chart</span><br /><br />\r\n      <span class="icon-barcode"> icon-barcode</span><br /><br />\r\n      <span class="icon-beaker"> icon-beaker</span><br /><br />\r\n      <span class="icon-bell"> icon-bell</span><br /><br />\r\n      <span class="icon-bolt"> icon-bolt</span><br /><br />\r\n      <span class="icon-book"> icon-book</span><br /><br />\r\n      <span class="icon-bookmark"> icon-bookmark</span><br /><br />\r\n      <span class="icon-bookmark-empty"> icon-bookmark-empty</span><br /><br />\r\n      <span class="icon-briefcase"> icon-briefcase</span><br /><br />\r\n      <span class="icon-bullhorn"> icon-bullhorn</span><br /><br />\r\n      <span class="icon-calendar"> icon-calendar</span><br /><br />\r\n      <span class="icon-camera"> icon-camera</span><br /><br />\r\n      <span class="icon-camera-retro"> icon-camera-retro</span><br /><br />\r\n      <span class="icon-certificate"> icon-certificate</span><br /><br />\r\n      <span class="icon-check"> icon-check</span><br /><br />\r\n      <span class="icon-check-empty"> icon-check-empty</span><br /><br />\r\n      <span class="icon-cloud"> icon-cloud</span><br /><br />\r\n      <span class="icon-cog"> icon-cog</span><br /><br />\r\n      <span class="icon-cogs"> icon-cogs</span><br /><br />\r\n      <span class="icon-comment"> icon-comment</span><br /><br />\r\n      <span class="icon-comment-alt"> icon-comment-alt</span><br /><br />\r\n      <span class="icon-comments"> icon-comments</span><br /><br />\r\n      <span class="icon-comments-alt"> icon-comments-alt</span><br /><br />\r\n      <span class="icon-credit-card"> icon-credit-card</span><br /><br />\r\n      <span class="icon-dashboard"> icon-dashboard</span><br /><br />\r\n      <span class="icon-download"> icon-download</span><br /><br />\r\n      <span class="icon-download-alt"> icon-download-alt</span><br /><br />\r\n      <span class="icon-edit"> icon-edit</span><br /><br />\r\n      <span class="icon-envelope"> icon-envelope</span><br /><br />\r\n      <span class="icon-envelope-alt"> icon-envelope-alt</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-exclamation-sign"> icon-exclamation-sign</span><br /><br />\r\n      <span class="icon-external-link"> icon-external-link</span><br /><br />\r\n      <span class="icon-eye-close"> icon-eye-close</span><br /><br />\r\n      <span class="icon-eye-open"> icon-eye-open</span><br /><br />\r\n      <span class="icon-facetime-video"> icon-facetime-video</span><br /><br />\r\n      <span class="icon-film"> icon-film</span><br /><br />\r\n      <span class="icon-filter"> icon-filter</span><br /><br />\r\n      <span class="icon-fire"> icon-fire</span><br /><br />\r\n      <span class="icon-flag"> icon-flag</span><br /><br />\r\n      <span class="icon-folder-close"> icon-folder-close</span><br /><br />\r\n      <span class="icon-folder-open"> icon-folder-open</span><br /><br />\r\n      <span class="icon-gift"> icon-gift</span><br /><br />\r\n      <span class="icon-glass"> icon-glass</span><br /><br />\r\n      <span class="icon-globe"> icon-globe</span><br /><br />\r\n      <span class="icon-group"> icon-group</span><br /><br />\r\n      <span class="icon-hdd"> icon-hdd</span><br /><br />\r\n      <span class="icon-headphones"> icon-headphones</span><br /><br />\r\n      <span class="icon-heart"> icon-heart</span><br /><br />\r\n      <span class="icon-heart-empty"> icon-heart-empty</span><br /><br />\r\n      <span class="icon-home"> icon-home</span><br /><br />\r\n      <span class="icon-inbox"> icon-inbox</span><br /><br />\r\n      <span class="icon-info-sign"> icon-info-sign</span><br /><br />\r\n      <span class="icon-key"> icon-key</span><br /><br />\r\n      <span class="icon-leaf"> icon-leaf</span><br /><br />\r\n      <span class="icon-legal"> icon-legal</span><br /><br />\r\n      <span class="icon-lemon"> icon-lemon</span><br /><br />\r\n      <span class="icon-lock"> icon-lock</span><br /><br />\r\n      <span class="icon-unlock"> icon-unlock</span><br /><br />\r\n      <span class="icon-magic"> icon-magic</span><br /><br />\r\n      <span class="icon-magnet"> icon-magnet</span><br /><br />\r\n      <span class="icon-map-marker"> icon-map-marker</span><br /><br />\r\n      <span class="icon-minus"> icon-minus</span><br /><br />\r\n      <span class="icon-minus-sign"> icon-minus-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-money"> icon-money</span><br /><br />\r\n      <span class="icon-move"> icon-move</span><br /><br />\r\n      <span class="icon-music"> icon-music</span><br /><br />\r\n      <span class="icon-off"> icon-off</span><br /><br />\r\n      <span class="icon-ok"> icon-ok</span><br /><br />\r\n      <span class="icon-ok-circle"> icon-ok-circle</span><br /><br />\r\n      <span class="icon-ok-sign"> icon-ok-sign</span><br /><br />\r\n      <span class="icon-pencil"> icon-pencil</span><br /><br />\r\n      <span class="icon-picture"> icon-picture</span><br /><br />\r\n      <span class="icon-plane"> icon-plane</span><br /><br />\r\n      <span class="icon-plus"> icon-plus</span><br /><br />\r\n      <span class="icon-plus-sign"> icon-plus-sign</span><br /><br />\r\n      <span class="icon-print"> icon-print</span><br /><br />\r\n      <span class="icon-pushpin"> icon-pushpin</span><br /><br />\r\n      <span class="icon-qrcode"> icon-qrcode</span><br /><br />\r\n      <span class="icon-question-sign"> icon-question-sign</span><br /><br />\r\n      <span class="icon-random"> icon-random</span><br /><br />\r\n      <span class="icon-refresh"> icon-refresh</span><br /><br />\r\n      <span class="icon-remove"> icon-remove</span><br /><br />\r\n      <span class="icon-remove-circle"> icon-remove-circle</span><br /><br />\r\n      <span class="icon-remove-sign"> icon-remove-sign</span><br /><br />\r\n      <span class="icon-reorder"> icon-reorder</span><br /><br />\r\n      <span class="icon-resize-horizontal"> icon-resize-horizontal</span><br /><br />\r\n      <span class="icon-resize-vertical"> icon-resize-vertical</span><br /><br />\r\n      <span class="icon-retweet"> icon-retweet</span><br /><br />\r\n      <span class="icon-road"> icon-road</span><br /><br />\r\n      <span class="icon-rss"> icon-rss</span><br /><br />\r\n      <span class="icon-screenshot"> icon-screenshot</span><br /><br />\r\n      <span class="icon-search"> icon-search</span><br /><br />\r\n      <span class="icon-share"> icon-share</span><br /><br />\r\n      <span class="icon-share-alt"> icon-share-alt</span><br /><br />\r\n      <span class="icon-shopping-cart"> icon-shopping-cart</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-signal"> icon-signal</span><br /><br />\r\n      <span class="icon-signin"> icon-signin</span><br /><br />\r\n      <span class="icon-signout"> icon-signout</span><br /><br />\r\n      <span class="icon-sitemap"> icon-sitemap</span><br /><br />\r\n      <span class="icon-sort"> icon-sort</span><br /><br />\r\n      <span class="icon-sort-down"> icon-sort-down</span><br /><br />\r\n      <span class="icon-sort-up"> icon-sort-up</span><br /><br />\r\n      <span class="icon-star"> icon-star</span><br /><br />\r\n      <span class="icon-star-empty"> icon-star-empty</span><br /><br />\r\n      <span class="icon-star-half"> icon-star-half</span><br /><br />\r\n      <span class="icon-tag"> icon-tag</span><br /><br />\r\n      <span class="icon-tags"> icon-tags</span><br /><br />\r\n      <span class="icon-tasks"> icon-tasks</span><br /><br />\r\n      <span class="icon-thumbs-down"> icon-thumbs-down</span><br /><br />\r\n      <span class="icon-thumbs-up"> icon-thumbs-up</span><br /><br />\r\n      <span class="icon-time"> icon-time</span><br /><br />\r\n      <span class="icon-tint"> icon-tint</span><br /><br />\r\n      <span class="icon-trash"> icon-trash</span><br /><br />\r\n      <span class="icon-trophy"> icon-trophy</span><br /><br />\r\n      <span class="icon-truck"> icon-truck</span><br /><br />\r\n      <span class="icon-umbrella"> icon-umbrella</span><br /><br />\r\n      <span class="icon-upload"> icon-upload</span><br /><br />\r\n      <span class="icon-upload-alt"> icon-upload-alt</span><br /><br />\r\n      <span class="icon-user"> icon-user</span><br /><br />\r\n      <span class="icon-user-md"> icon-user-md</span><br /><br />\r\n      <span class="icon-volume-off"> icon-volume-off</span><br /><br />\r\n      <span class="icon-volume-down"> icon-volume-down</span><br /><br />\r\n      <span class="icon-volume-up"> icon-volume-up</span><br /><br />\r\n      <span class="icon-warning-sign"> icon-warning-sign</span><br /><br />\r\n      <span class="icon-wrench"> icon-wrench</span><br /><br />\r\n      <span class="icon-zoom-in"> icon-zoom-in</span><br /><br />\r\n      <span class="icon-zoom-out"> icon-zoom-out</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Text Editor Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-file"> icon-file</span><br /><br />\r\n      <span class="icon-cut"> icon-cut</span><br /><br />\r\n      <span class="icon-copy"> icon-copy</span><br /><br />\r\n      <span class="icon-paste"> icon-paste</span><br /><br />\r\n      <span class="icon-save"> icon-save</span><br /><br />\r\n      <span class="icon-undo"> icon-undo</span><br /><br />\r\n      <span class="icon-repeat"> icon-repeat</span><br /><br />\r\n      <span class="icon-paper-clip"> icon-paper-clip</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-text-height"> icon-text-height</span><br /><br />\r\n      <span class="icon-text-width"> icon-text-width</span><br /><br />\r\n      <span class="icon-align-left"> icon-align-left</span><br /><br />\r\n      <span class="icon-align-center"> icon-align-center</span><br /><br />\r\n      <span class="icon-align-right"> icon-align-right</span><br /><br />\r\n      <span class="icon-align-justify"> icon-align-justify</span><br /><br />\r\n      <span class="icon-indent-left"> icon-indent-left</span><br /><br />\r\n      <span class="icon-indent-right"> icon-indent-right</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-font"> icon-font</span><br /><br />\r\n      <span class="icon-bold"> icon-bold</span><br /><br />\r\n      <span class="icon-italic"> icon-italic</span><br /><br />\r\n      <span class="icon-strikethrough"> icon-strikethrough</span><br /><br />\r\n      <span class="icon-underline"> icon-underline</span><br /><br />\r\n      <span class="icon-link"> icon-link</span><br /><br />\r\n      <span class="icon-columns"> icon-columns</span><br /><br />\r\n      <span class="icon-table"> icon-table</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-th-large"> icon-th-large</span><br /><br />\r\n      <span class="icon-th"> icon-th</span><br /><br />\r\n      <span class="icon-th-list"> icon-th-list</span><br /><br />\r\n      <span class="icon-list"> icon-list</span><br /><br />\r\n      <span class="icon-list-ol"> icon-list-ol</span><br /><br />\r\n      <span class="icon-list-ul"> icon-list-ul</span><br /><br />\r\n      <span class="icon-list-alt"> icon-list-alt</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Directional Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-arrow-down"> icon-arrow-down</span><br /><br />\r\n      <span class="icon-arrow-left"> icon-arrow-left</span><br /><br />\r\n      <span class="icon-arrow-right"> icon-arrow-right</span><br /><br />\r\n      <span class="icon-arrow-up"> icon-arrow-up</span><br /><br />\r\n      <span class="icon-chevron-down"> icon-chevron-down</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-circle-arrow-down"> icon-circle-arrow-down</span><br /><br />\r\n      <span class="icon-circle-arrow-left"> icon-circle-arrow-left</span><br /><br />\r\n      <span class="icon-circle-arrow-right"> icon-circle-arrow-right</span><br /><br />\r\n      <span class="icon-circle-arrow-up"> icon-circle-arrow-up</span><br /><br />\r\n      <span class="icon-chevron-left"> icon-chevron-left</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-caret-down"> icon-caret-down</span><br /><br />\r\n      <span class="icon-caret-left"> icon-caret-left</span><br /><br />\r\n      <span class="icon-caret-right"> icon-caret-right</span><br /><br />\r\n      <span class="icon-caret-up"> icon-caret-up</span><br /><br />\r\n      <span class="icon-chevron-right"> icon-chevron-right</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-hand-down"> icon-hand-down</span><br /><br />\r\n      <span class="icon-hand-left"> icon-hand-left</span><br /><br />\r\n      <span class="icon-hand-right"> icon-hand-right</span><br /><br />\r\n      <span class="icon-hand-up"> icon-hand-up</span><br /><br />\r\n      <span class="icon-chevron-up"> icon-chevron-up</span><br /><br />\r\n    </div>\r\n  </div>\r\n<div class="clear"></div>\r\n  <div>\r\n    <h3>Video Player Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-play-circle"> icon-play-circle</span><br /><br />\r\n      <span class="icon-play"> icon-play</span><br /><br />\r\n      <span class="icon-pause"> icon-pause</span><br /><br />\r\n      <span class="icon-stop"> icon-stop</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-step-backward"> icon-step-backward</span><br /><br />\r\n      <span class="icon-fast-backward"> icon-fast-backward</span><br /><br />\r\n      <span class="icon-backward"> icon-backward</span><br /><br />\r\n      <span class="icon-forward"> icon-forward</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-fast-forward"> icon-fast-forward</span><br /><br />\r\n      <span class="icon-step-forward"> icon-step-forward</span><br /><br />\r\n      <span class="icon-eject"> icon-eject</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-fullscreen"> icon-fullscreen</span><br /><br />\r\n      <span class="icon-resize-full"> icon-resize-full</span><br /><br />\r\n      <span class="icon-resize-small"> icon-resize-small</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Social Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-phone"> icon-phone</span><br /><br />\r\n      <span class="icon-phone-sign"> icon-phone-sign</span><br /><br />\r\n      <span class="icon-facebook"> icon-facebook</span><br /><br />\r\n      <span class="icon-facebook-sign"> icon-facebook-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-twitter"> icon-twitter</span><br /><br />\r\n      <span class="icon-twitter-sign"> icon-twitter-sign</span><br /><br />\r\n      <span class="icon-github"> icon-github</span><br /><br />\r\n      <span class="icon-github-sign"> icon-github-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-linkedin"> icon-linkedin</span><br /><br />\r\n      <span class="icon-linkedin-sign"> icon-linkedin-sign</span><br /><br />\r\n      <span class="icon-pinterest"> icon-pinterest</span><br /><br />\r\n      <span class="icon-pinterest-sign"> icon-pinterest-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="width-spacer">\r\n      <span class="icon-google-plus"> icon-google-plus</span><br /><br />\r\n      <span class="icon-google-plus-sign"> icon-google-plus-sign</span><br /><br />\r\n      <span class="icon-sign-blank"> icon-sign-blank</span><br /><br />\r\n    </div>\r\n  </div>\r\n<div class="clear"></div>\r\n</div>\r\n<pre class="prettyprint linenums"><ol class="linenums"><li class="L0"><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"icon-CLASS_NAME"</span><span class="tag">&gt;</span></li><li class="L1"><span class="pln">  ...</span></li><li class="L2"><span class="tag">&lt;/span&gt;</span></li><li class="L3"><span class="tag">&lt;span</span><span class="pln"> </span><span class="atn">class</span><span class="pun">=</span><span class="atv">"icon-download"</span><span class="tag">&gt;</span></li><li class="L4"><span class="pln">  ...</span></li><li class="L5"><span class="tag">&lt;/span&gt;</span></li></ol></pre>\r\n\r\n<div class="clear"></div>\r\n\r\n\r\n<p><em>The documented typography above is a modified version of the reference guide available at: <a href="http://twitter.github.com/bootstrap/base-css.html">http://twitter.github.com/bootstrap/base-css.html</a></em></p>   \r\n</div>\r\n', '', -2, 0, 0, 77, '2011-01-01 00:00:01', 968, 'Joomla!', '2012-11-18 08:44:35', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 68, 0, 6, '', '', 1, 375, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(53, 151, 'Using Joomla!', 'using-joomla', '', '<p>With Joomla! You can create anything from a simple personal website to a complex ecommerce or social site with millions of visitors.</p><p>This section of the sample data provides you with a brief introduction to Joomla! concepts and reference material to help you understand how Joomla! works.</p><p><em>When you no longer need the sample data, you can can simply unpublish the sample data category found within each extension in the site administrator or you may completely delete each item and all of the categories. </em></p>', '', 1, 0, 0, 19, '2011-01-01 00:00:01', 968, 'Joomla!', '2011-01-01 00:00:01', 42, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 0, 7, '', '', 1, 178, '', 0, '*', ''),
(67, 168, 'What''s New in 1.5?', 'whats-new-in-15', '', '<p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>\r\n<p style="margin-bottom: 0in;">In Joomla! 1.5, you''''ll notice:</p>\r\n<ul>\r\n<li>Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</li>\r\n<li>Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</li>\r\n<li>Extended integration of external applications through Web services</li>\r\n<li>Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</li>\r\n<li>A more sustainable and flexible framework for Component and Extension developers</li>\r\n<li>Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</li>\r\n</ul>', '', 2, 0, 0, 9, '2011-01-01 00:00:01', 968, 'Joomla! 1.5', '2011-01-01 00:00:01', 0, 0, '0000-00-00 00:00:00', '2011-01-01 00:00:01', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_readmore":"","show_print_icon":"","show_email_icon":"","show_hits":"","page_title":"","alternative_readmore":"","layout":""}', 1, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(68, 170, 'Module Variations', 'module-variations', '', '<p>This theme comes with different module styles, badges and icons. For each module you can pick a style and combine it with an icon or badge to create your own unique look. Enter any available suffixes at Extensions → Module Manager → Module → Module Class Suffix.</p>\r\n', '', 1, 0, 0, 77, '2011-06-11 09:19:46', 968, '', '2012-08-25 05:24:12', 42, 0, '0000-00-00 00:00:00', '2011-06-11 09:19:46', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"","show_publish_date":"","show_item_navigation":"0","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"1","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, 5, '', '', 1, 808, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(69, 175, 'Module Positions', 'module-positions', '', '<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Roof</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Top</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Header</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Utility</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Feature</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>MainTop</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Breadcrumbs</h4></th>\r\n    </tr>\r\n  </thead>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="3"><h4>Component Area</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>\r\n        <table class="table table-bordered align-center" style="background: #F0FFFF">\r\n        <thead>\r\n          <tr>\r\n            <th colspan="4"><h4>Content Top</h4></th>\r\n          </tr>\r\n        </thead>\r\n        <tbody>\r\n          <tr>\r\n            <td>1</td>\r\n            <td>2</td>\r\n            <td>3</td>\r\n            <td>4</td>\r\n          </tr>\r\n        </tbody>\r\n        </table>\r\n      </td>\r\n    </tr>\r\n    \r\n    <tr>\r\n      <td>\r\n        <table class="table table-bordered align-center" style="background:#F8F8FF;">\r\n          <thead>\r\n            <tr>\r\n              <th colspan="6"><h4>Mainbody / Sidebar layouts below <i class="icon-arrow-down"></i></h4></th>\r\n            </tr>\r\n          </thead>\r\n        </table>\r\n      </td>\r\n    </tr>\r\n    \r\n    <tr>\r\n      <td>\r\n        <table class="table table-bordered align-center" style="background: #FFFAF0;">\r\n        <thead>\r\n          <tr>\r\n            <th colspan="4"><h4>Content Bottom</h4></th>\r\n          </tr>\r\n        </thead>\r\n        <tbody>\r\n          <tr>\r\n            <td>1</td>\r\n            <td>2</td>\r\n            <td>3</td>\r\n            <td>4</td>\r\n          </tr>\r\n        </tbody>\r\n        </table>\r\n      </td>\r\n    </tr>\r\n </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>MainBottom</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Footer</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Copyright</h4></th>\r\n    </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr>\r\n      <td>1</td>\r\n      <td>2</td>\r\n      <td>3</td>\r\n      <td>4</td>\r\n      <td>5</td>\r\n      <td>6</td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>Absolute</h4></th>\r\n    </tr>\r\n  </thead>\r\n</table>\r\n\r\n<table class="table table-bordered align-center">\r\n  <thead>\r\n    <tr>\r\n      <th colspan="6"><h4>OffCanvas</h4></th>\r\n    </tr>\r\n  </thead>\r\n</table>', '', 1, 0, 0, 77, '2012-03-21 08:02:30', 968, '', '2013-09-16 11:15:15', 968, 0, '0000-00-00 00:00:00', '2012-03-21 08:02:30', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 4, '', '', 1, 131, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(70, 176, 'Expose Base Template', 'bootstrap-theme', '', '<p>Base template is the solid theme based on Expose, our fast and slick theme framwork! It takes full advantage of all the latest Expose features like semantic xHTML markup, a nice and clean administration UI, Xpert Mega Menu and much more.</p>\r\n<p>Base template is an optimized and streamlined theme and serves as blueprint to build your own custom themes. It offers 4 different theme styles to get you started right away. Every bits of codes are well documented and we''ve added Less files which make your customization more faster.</p>\r\n<h3 class="title">Expose features</h3>\r\n<ul>\r\n  <li>Flexible &amp; powerful Layout system</li>\r\n  liRsponsive layout</li>\r\n  <li>Highly Customizable &amp; full Controll over styling</li>\r\n  <li>RTL support</li>\r\n  <li>HTML5 and CSS3</li>\r\n  <li>CSS and JS code compression</li>\r\n  <li>Domination over Typography</li>\r\n  <li>3 Menu system (Mega, Split, Dropine)</li>\r\n  <li>Menu based component disabling</li>\r\n  <li>Per Position module styling</li>\r\n  <li>Built in jQuery.</li>\r\n  <li>Cross-browser compatibility.</li>\r\n  <li>Extensible widgets</li>\r\n</ul>', '', 1, 0, 0, 77, '2012-03-21 08:44:19', 968, '', '2012-11-20 17:05:29', 42, 0, '0000-00-00 00:00:00', '2012-03-21 08:44:19', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 0, 3, '', '', 1, 115, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(71, 177, 'Preset Styles', 'preset-styles', '', '<p>Preset styles</p>', '', 1, 0, 0, 77, '2012-03-29 17:34:46', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-03-29 17:34:46', '0000-00-00 00:00:00', '', '', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(72, 178, 'Custom Styling', 'custom-styling', '', '<h2 style="margin-bottom: 10px; border-bottom: 1px solid #ddd;">Preset styles</h2>\r\n<p><img class="pull-right" src="images/features/presets.jpg" border="0" alt="Expose preset style" /> You can easily create your own preset styles. Just create a css file inside your templates <code>css/styles</code> folder and expose intellegent engine will automatically pull and show it in template settings.</p>\r\n<div class="clear"> </div>\r\n<h2 style="margin-bottom: 10px; border-bottom: 1px solid #ddd;">Custom styling</h2>\r\n<p><img class="pull-right" src="images/features/customstyle.jpg" border="0" alt="Custom Styling" /> If making preset style seems geeky to you hold on, Expose has custom styling feature right after it! Turn on the custom styling option and start changing the style. Expose made it as much easy as possible.</p>\r\n<p>If you need to insert your own background images just upload the image to <code>templates/TX_TEMPLATE_NAME/images/backgrounds</code> folder and refresh you template settings page. You will see your background image is listed under background dropdown menu.</p>\r\n<div class="clear"> </div>\r\n<h2 style="margin-bottom: 10px; border-bottom: 1px solid #ddd;">Custom CSS</h2>\r\n<p>Unlike custom styling, if you need more control over <strong>CSS</strong>, go to <code>Developer</code> tab and start writing your css code there. You won''t lost modifying a big template''s css files.</p>', '', 1, 0, 0, 77, '2012-07-13 09:56:40', 968, '', '2013-02-05 12:11:21', 42, 0, '0000-00-00 00:00:00', '2012-07-13 09:56:40', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, 1, '', '', 1, 17, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(73, 179, 'Offline Page', 'offline-page', '', '<p>Lorem ipsum dolor sit amet consectetuer nulla parturient ullamcorper volutpat nisl. Condimentum felis netus pede enim pellentesque semper sed laoreet turpis Nulla. Tellus tempor Curabitur augue elit mus pellentesque justo mauris cursus Nunc. Mollis mauris et In eleifend Quisque in nulla Integer dui quis. Nulla congue magna odio ullamcorper aliquam nascetur et sit eget fermentum. Purus mauris nunc ut.</p>\r\n<p><img src="images/features/offlinepage.jpg" border="0" alt="Expose Offline page" style="display: block; margin-left: auto; margin-right: auto;" /></p>', '', 1, 0, 0, 77, '2012-07-13 10:57:04', 968, '', '2013-02-05 12:41:54', 42, 0, '0000-00-00 00:00:00', '2012-07-13 10:57:04', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 0, '', '', 1, 14, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(74, 181, 'Typography', 'typography', '', '\r\n<h1 class="title">Typography</h1>\r\n\r\n<h2 id="headings">Headings</h2>\r\n<p>All HTML headings, <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code> are available.</p>\r\n<div class="bs-example">\r\n  <h1>h1. Heading 1</h1>\r\n  <h2>h2. Heading 2</h2>\r\n  <h3>h3. Heading 3</h3>\r\n  <h4>h4. Heading 4</h4>\r\n  <h5>h5. Heading 5</h5>\r\n  <h6>h6. Heading 6</h6>\r\n</div>\r\n\r\n<h2 id="body-copy">Body copy</h2>\r\n<p>Bootstrap''s global default <code>font-size</code> is <strong>14px</strong>, with a <code>line-height</code> of <strong>20px</strong>. This is applied to the <code>&lt;body&gt;</code> and all paragraphs. In addition, <code>&lt;p&gt;</code> (paragraphs) receive a bottom margin of half their line-height (10px by default).</p>\r\n<div class="bs-example">\r\n  <p>Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.</p>\r\n  <p>Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec ullamcorper nulla non metus auctor fringilla. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Donec ullamcorper nulla non metus auctor fringilla.</p>\r\n  <p>Maecenas sed diam eget risus varius blandit sit amet non magna. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit.</p>\r\n</div>\r\n<pre class="prettyprint">&lt;p&gt;...&lt;/p&gt;</pre>\r\n\r\n<h3>Lead body copy</h3>\r\n<p>Make a paragraph stand out by adding <code>.lead</code>.</p>\r\n<div class="bs-example">\r\n  <p class="lead">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p>\r\n</div>\r\n<pre class="prettyprint">&lt;p class="lead"&gt;...&lt;/p&gt;</pre>\r\n\r\n<h3>Built with Less</h3>\r\n<p>The typographic scale is based on two LESS variables in <strong>variables.less</strong>: <code>@baseFontSize</code> and <code>@baseLineHeight</code>. The first is the base font-size used throughout and the second is the base line-height. We use those variables and some simple math to create the margins, paddings, and line-heights of all our type and more. Customize them and Bootstrap adapts.</p>\r\n\r\n\r\n<hr class="bs-separator" />\r\n\r\n\r\n<h2 id="emphasis">Emphasis</h2>\r\n<p>Make use of HTML''s default emphasis tags with lightweight styles.</p>\r\n\r\n<h3><code>&lt;small&gt;</code></h3>\r\n<p>For de-emphasizing inline or blocks of text, <small>use the small tag.</small></p>\r\n<div class="bs-example">\r\n  <p><small>This line of text is meant to be treated as fine print.</small></p>\r\n</div>\r\n<pre class="prettyprint">\r\n&lt;p&gt;\r\n  &lt;small&gt;This line of text is meant to be treated as fine print.&lt;/small&gt;\r\n&lt;/p&gt;\r\n</pre>\r\n\r\n<h3>Bold</h3>\r\n<p>For emphasizing a snippet of text with a heavier font-weight.</p>\r\n<div class="bs-example">\r\n  <p>The following snippet of text is <strong>rendered as bold text</strong>.</p>\r\n</div>\r\n<pre class="prettyprint">&lt;strong&gt;rendered as bold text&lt;/strong&gt;</pre>\r\n\r\n<h3>Italics</h3>\r\n<p>For emphasizing a snippet of text with italics.</p>\r\n<div class="bs-example">\r\n  <p>The following snippet of text is <em>rendered as italicized text</em>.</p>\r\n</div>\r\n<pre class="prettyprint">&lt;em&gt;rendered as italicized text&lt;/em&gt;</pre>\r\n\r\n<p><span class="label label-info">Heads up!</span> Feel free to use <code>&lt;b&gt;</code> and <code>&lt;i&gt;</code> in HTML5. <code>&lt;b&gt;</code> is meant to highlight words or phrases without conveying additional importance while <code>&lt;i&gt;</code> is mostly for voice, technical terms, etc.</p>\r\n\r\n<h3>Emphasis classes</h3>\r\n<p>Convey meaning through color with a handful of emphasis utility classes.</p>\r\n<div class="bs-example">\r\n  <p class="muted">Fusce dapibus, tellus ac cursus commodo, tortor mauris nibh.</p>\r\n  <p class="text-warning">Etiam porta sem malesuada magna mollis euismod.</p>\r\n  <p class="text-error">Donec ullamcorper nulla non metus auctor fringilla.</p>\r\n  <p class="text-info">Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis.</p>\r\n  <p class="text-success">Duis mollis, est non commodo luctus, nisi erat porttitor ligula.</p>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;p class="muted"&gt;Fusce dapibus, tellus ac cursus commodo, tortor mauris nibh.&lt;/p&gt;\r\n&lt;p class="text-warning"&gt;Etiam porta sem malesuada magna mollis euismod.&lt;/p&gt;\r\n&lt;p class="text-error"&gt;Donec ullamcorper nulla non metus auctor fringilla.&lt;/p&gt;\r\n&lt;p class="text-info"&gt;Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis.&lt;/p&gt;\r\n&lt;p class="text-success"&gt;Duis mollis, est non commodo luctus, nisi erat porttitor ligula.&lt;/p&gt;\r\n</pre>\r\n\r\n\r\n<hr class="bs-separator" />\r\n\r\n\r\n<h2 id="abbreviations">Abbreviations</h2>\r\n<p>Stylized implemenation of HTML''s <code>&lt;abbr&gt;</code> element for abbreviations and acronyms to show the expanded version on hover. Abbreviations with a <code>title</code> attribute have a light dotted bottom border and a help cursor on hover, providing additional context on hover.</p>\r\n\r\n<h3><code>&lt;abbr&gt;</code></h3>\r\n<p>For expanded text on long hover of an abbreviation, include the <code>title</code> attribute.</p>\r\n<div class="bs-example">\r\n  <p>An abbreviation of the word attribute is <abbr title="attribute">attr</abbr>.</p>\r\n</div>\r\n<pre class="prettyprint">&lt;abbr title="attribute"&gt;attr&lt;/abbr&gt;</pre>\r\n\r\n<h3><code>&lt;abbr class="initialism"&gt;</code></h3>\r\n<p>Add <code>.initialism</code> to an abbreviation for a slightly smaller font-size.</p>\r\n<div class="bs-example">\r\n  <p><abbr title="HyperText Markup Language" class="initialism">HTML</abbr> is the best thing since sliced bread.</p>\r\n</div>\r\n<pre class="prettyprint">&lt;abbr title="HyperText Markup Language" class="initialism"&gt;HTML&lt;/abbr&gt;</pre>\r\n\r\n\r\n<hr class="bs-separator" />\r\n\r\n\r\n<h2 id="addresses">Addresses</h2>\r\n<p>Present contact information for the nearest ancestor or the entire body of work.</p>\r\n\r\n<h3><code>&lt;address&gt;</code></h3>\r\n<p>Preserve formatting by ending all lines with <code>&lt;br&gt;</code>.</p>\r\n<div class="bs-example">\r\n  <address>\r\n    <strong>Twitter, Inc.</strong><br />\r\n    795 Folsom Ave, Suite 600<br />\r\n    San Francisco, CA 94107<br />\r\n    <abbr title="Phone">P:</abbr> (123) 456-7890\r\n  </address>\r\n  <address>\r\n    <strong>Full Name</strong><br />\r\n    <a href="mailto:#">first.last@gmail.com</a>\r\n  </address>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;address&gt;\r\n  &lt;strong&gt;Twitter, Inc.&lt;/strong&gt;&lt;br&gt;\r\n  795 Folsom Ave, Suite 600&lt;br&gt;\r\n  San Francisco, CA 94107&lt;br&gt;\r\n  &lt;abbr title="Phone"&gt;P:&lt;/abbr&gt; (123) 456-7890\r\n&lt;/address&gt;\r\n\r\n&lt;address&gt;\r\n  &lt;strong&gt;Full Name&lt;/strong&gt;&lt;br&gt;\r\n  &lt;a href="mailto:#"&gt;first.last@gmail.com&lt;/a&gt;\r\n&lt;/address&gt;\r\n</pre>\r\n\r\n\r\n<hr class="bs-separator" />\r\n\r\n\r\n<h2 id="blockquotes">Blockquotes</h2>\r\n<p>For quoting blocks of content from another source within your document.</p>\r\n\r\n<h3>Default blockquote</h3>\r\n<p>Wrap <code>&lt;blockquote&gt;</code> around any <abbr title="HyperText Markup Language">HTML</abbr> as the quote. For straight quotes we recommend a <code>&lt;p&gt;</code>.</p>\r\n<div class="bs-example">\r\n  <blockquote>\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n  </blockquote>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;blockquote&gt;\r\n  &lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;\r\n&lt;/blockquote&gt;\r\n</pre>\r\n\r\n<h3>Blockquote options</h3>\r\n<p>Style and content changes for simple variations on a standard blockquote.</p>\r\n\r\n<h4>Naming a source</h4>\r\n<p>Add <code>&lt;small&gt;</code> tag for identifying the source. Wrap the name of the source work in <code>&lt;cite&gt;</code>.</p>\r\n<div class="bs-example">\r\n  <blockquote>\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n    <small>Someone famous in <cite title="Source Title">Source Title</cite></small>\r\n  </blockquote>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;blockquote&gt;\r\n  &lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;\r\n  &lt;small&gt;Someone famous &lt;cite title="Source Title"&gt;Source Title&lt;/cite&gt;&lt;/small&gt;\r\n&lt;/blockquote&gt;\r\n</pre>\r\n\r\n<h4>Alternate displays</h4>\r\n<p>Use <code>.pull-right</code> for a floated, right-aligned blockquote.</p>\r\n<div class="bs-example" style="overflow: hidden;">\r\n  <blockquote class="pull-right">\r\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n    <small>Someone famous in <cite title="Source Title">Source Title</cite></small>\r\n  </blockquote>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;blockquote class="pull-right"&gt;\r\n  ...\r\n&lt;/blockquote&gt;\r\n</pre>\r\n\r\n<h3>Description</h3>\r\n<p>A list of terms with their associated descriptions.</p>\r\n<div class="bs-example">\r\n  <dl>\r\n    <dt>Description lists</dt>\r\n    <dd>A description list is perfect for defining terms.</dd>\r\n    <dt>Euismod</dt>\r\n    <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.</dd>\r\n    <dd>Donec id elit non mi porta gravida at eget metus.</dd>\r\n    <dt>Malesuada porta</dt>\r\n    <dd>Etiam porta sem malesuada magna mollis euismod.</dd>\r\n  </dl>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;dl&gt;\r\n  &lt;dt&gt;...&lt;/dt&gt;\r\n  &lt;dd&gt;...&lt;/dd&gt;\r\n&lt;/dl&gt;\r\n</pre>\r\n\r\n<h4>Horizontal description</h4>\r\n<p>Make terms and descriptions in <code>&lt;dl&gt;</code> line up side-by-side.</p>\r\n<div class="bs-example">\r\n  <dl class="dl-horizontal">\r\n    <dt>Description lists</dt>\r\n    <dd>A description list is perfect for defining terms.</dd>\r\n    <dt>Euismod</dt>\r\n    <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.</dd>\r\n    <dd>Donec id elit non mi porta gravida at eget metus.</dd>\r\n    <dt>Malesuada porta</dt>\r\n    <dd>Etiam porta sem malesuada magna mollis euismod.</dd>\r\n    <dt>Felis euismod semper eget lacinia</dt>\r\n    <dd>Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</dd>\r\n  </dl>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;dl class="dl-horizontal"&gt;\r\n  &lt;dt&gt;...&lt;/dt&gt;\r\n  &lt;dd&gt;...&lt;/dd&gt;\r\n&lt;/dl&gt;\r\n</pre>\r\n<p>\r\n  <span class="label label-info">Heads up!</span>\r\n  Horizontal description lists will truncate terms that are too long to fit in the left column fix <code>text-overflow</code>. In narrower viewports, they will change to the default stacked layout.\r\n</p>\r\n', '', 1, 0, 0, 78, '2012-11-18 12:45:23', 968, '', '2012-11-21 08:12:24', 42, 0, '0000-00-00 00:00:00', '2012-11-18 12:45:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, 3, '', '', 1, 83, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(75, 182, 'List', 'list', '', '<h1 class="title">Lists</h1>\r\n\r\n<h2>Unordered</h2>\r\n<p>A list of items in which the order does <em>not</em> explicitly matter.</p>\r\n<div class="bs-example">\r\n  <ul>\r\n    <li>Lorem ipsum dolor sit amet</li>\r\n    <li>Consectetur adipiscing elit</li>\r\n    <li>Integer molestie lorem at massa</li>\r\n    <li>Facilisis in pretium nisl aliquet</li>\r\n    <li>Nulla volutpat aliquam velit\r\n      <ul>\r\n        <li>Phasellus iaculis neque</li>\r\n        <li>Purus sodales ultricies</li>\r\n        <li>Vestibulum laoreet porttitor sem</li>\r\n        <li>Ac tristique libero volutpat at</li>\r\n      </ul>\r\n    </li>\r\n    <li>Faucibus porta lacus fringilla vel</li>\r\n    <li>Aenean sit amet erat nunc</li>\r\n    <li>Eget porttitor lorem</li>\r\n  </ul>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;ul&gt;\r\n  &lt;li&gt;...&lt;/li&gt;\r\n&lt;/ul&gt;\r\n</pre>\r\n\r\n<h2>Ordered</h2>\r\n<p>A list of items in which the order <em>does</em> explicitly matter.</p>\r\n<div class="bs-example">\r\n  <ol>\r\n    <li>Lorem ipsum dolor sit amet</li>\r\n    <li>Consectetur adipiscing elit</li>\r\n    <li>Integer molestie lorem at massa</li>\r\n    <li>Facilisis in pretium nisl aliquet</li>\r\n    <li>Nulla volutpat aliquam velit</li>\r\n    <li>Faucibus porta lacus fringilla vel</li>\r\n    <li>Aenean sit amet erat nunc</li>\r\n    <li>Eget porttitor lorem</li>\r\n  </ol>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;ol&gt;\r\n  &lt;li&gt;...&lt;/li&gt;\r\n&lt;/ol&gt;\r\n</pre>\r\n\r\n<h2>Unstyled</h2>\r\n<p>A list of items with no <code>list-style</code> or additional left padding.</p>\r\n<div class="bs-example">\r\n  <ul class="unstyled">\r\n    <li>Lorem ipsum dolor sit amet</li>\r\n    <li>Consectetur adipiscing elit</li>\r\n    <li>Integer molestie lorem at massa</li>\r\n    <li>Facilisis in pretium nisl aliquet</li>\r\n    <li>Nulla volutpat aliquam velit\r\n      <ul>\r\n        <li>Phasellus iaculis neque</li>\r\n        <li>Purus sodales ultricies</li>\r\n        <li>Vestibulum laoreet porttitor sem</li>\r\n        <li>Ac tristique libero volutpat at</li>\r\n      </ul>\r\n    </li>\r\n    <li>Faucibus porta lacus fringilla vel</li>\r\n    <li>Aenean sit amet erat nunc</li>\r\n    <li>Eget porttitor lorem</li>\r\n  </ul>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;ul class="unstyled"&gt;\r\n  &lt;li&gt;...&lt;/li&gt;\r\n&lt;/ul&gt;\r\n</pre>', '', 1, 0, 0, 78, '2012-11-18 13:21:00', 968, '', '2012-11-21 08:12:24', 42, 0, '0000-00-00 00:00:00', '2012-11-18 13:21:00', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 4, '', '', 1, 22, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(76, 183, 'Table', 'table', '', '<section>\r\n  <h1 class="title">Tables</h1>\r\n  \r\n  <h2>Default styles</h2>\r\n  <p>For basic styling&mdash;light padding and only horizontal dividers&mdash;add the base class <code>.table</code> to any <code>&lt;table&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <table class="table">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td>Larry</td>\r\n          <td>the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n  <pre class="prettyprint linenums">\r\n&lt;table class="table"&gt;\r\n  …\r\n&lt;/table&gt;\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Optional classes</h2>\r\n  <p>Add any of the following classes to the <code>.table</code> base class.</p>\r\n  \r\n  <h3><code>.table-striped</code></h3>\r\n  <p>Adds zebra-striping to any table row within the <code>&lt;tbody&gt;</code> via the <code>:nth-child</code> CSS selector (not available in IE7-IE8).</p>\r\n  <div class="bs-example">\r\n    <table class="table table-striped">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td>Larry</td>\r\n          <td>the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n  <pre class="prettyprint linenums" style="margin-bottom: 18px;">\r\n&lt;table class="table table-striped"&gt;\r\n  …\r\n&lt;/table&gt;\r\n</pre>\r\n  \r\n  <h3><code>.table-bordered</code></h3>\r\n  <p>Add borders and rounded corners to the table.</p>\r\n  <div class="bs-example">\r\n    <table class="table table-bordered">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td rowspan="2">1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@TwBootstrap</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td colspan="2">Larry the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n  <pre class="prettyprint linenums">\r\n&lt;table class="table table-bordered"&gt;\r\n  …\r\n&lt;/table&gt;\r\n</pre>\r\n  \r\n  <h3><code>.table-hover</code></h3>\r\n  <p>Enable a hover state on table rows within a <code>&lt;tbody&gt;</code>.</p>\r\n  <div class="bs-example">\r\n    <table class="table table-hover">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td colspan="2">Larry the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n  <pre class="prettyprint linenums" style="margin-bottom: 18px;">\r\n&lt;table class="table table-hover"&gt;\r\n  …\r\n&lt;/table&gt;\r\n</pre>\r\n  \r\n  <h3><code>.table-condensed</code></h3>\r\n  <p>Makes tables more compact by cutting cell padding in half.</p>\r\n  <div class="bs-example">\r\n    <table class="table table-condensed">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>First Name</th>\r\n          <th>Last Name</th>\r\n          <th>Username</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr>\r\n          <td>1</td>\r\n          <td>Mark</td>\r\n          <td>Otto</td>\r\n          <td>@mdo</td>\r\n        </tr>\r\n        <tr>\r\n          <td>2</td>\r\n          <td>Jacob</td>\r\n          <td>Thornton</td>\r\n          <td>@fat</td>\r\n        </tr>\r\n        <tr>\r\n          <td>3</td>\r\n          <td colspan="2">Larry the Bird</td>\r\n          <td>@twitter</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n  <pre class="prettyprint linenums" style="margin-bottom: 18px;">\r\n&lt;table class="table table-condensed"&gt;\r\n  …\r\n&lt;/table&gt;\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Optional row classes</h2>\r\n  <p>Use contextual classes to color table rows.</p>\r\n  <table class="table table-bordered table-striped">\r\n    <colgroup>\r\n      <col class="span1">\r\n      <col class="span7">\r\n    </colgroup>\r\n    <thead>\r\n      <tr>\r\n        <th>Class</th>\r\n        <th>Description</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <tr>\r\n        <td>\r\n          <code>.success</code>\r\n        </td>\r\n        <td>Indicates a successful or positive action.</td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>.error</code>\r\n        </td>\r\n        <td>Indicates a dangerous or potentially negative action.</td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>.warning</code>\r\n        </td>\r\n        <td>Indicates a warning that might need attention.</td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>.info</code>\r\n        </td>\r\n        <td>Used as an alternative to the default styles.</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <div class="bs-example">\r\n    <table class="table">\r\n      <thead>\r\n        <tr>\r\n          <th>#</th>\r\n          <th>Product</th>\r\n          <th>Payment Taken</th>\r\n          <th>Status</th>\r\n        </tr>\r\n      </thead>\r\n      <tbody>\r\n        <tr class="success">\r\n          <td>1</td>\r\n          <td>TB - Monthly</td>\r\n          <td>01/04/2012</td>\r\n          <td>Approved</td>\r\n        </tr>\r\n        <tr class="error">\r\n          <td>2</td>\r\n          <td>TB - Monthly</td>\r\n          <td>02/04/2012</td>\r\n          <td>Declined</td>\r\n        </tr>\r\n        <tr class="warning">\r\n          <td>3</td>\r\n          <td>TB - Monthly</td>\r\n          <td>03/04/2012</td>\r\n          <td>Pending</td>\r\n        </tr>\r\n        <tr class="info">\r\n          <td>4</td>\r\n          <td>TB - Monthly</td>\r\n          <td>04/04/2012</td>\r\n          <td>Call in to confirm</td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n  <pre class="prettyprint linenums">\r\n...\r\n  &lt;tr class="success"&gt;\r\n    &lt;td&gt;1&lt;/td&gt;\r\n    &lt;td&gt;TB - Monthly&lt;/td&gt;\r\n    &lt;td&gt;01/04/2012&lt;/td&gt;\r\n    &lt;td&gt;Approved&lt;/td&gt;\r\n  &lt;/tr&gt;\r\n...\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Supported table markup</h2>\r\n  <p>List of supported table HTML elements and how they should be used.</p>\r\n  <table class="table table-bordered table-striped">\r\n    <colgroup>\r\n      <col class="span1">\r\n      <col class="span7">\r\n    </colgroup>\r\n    <thead>\r\n      <tr>\r\n        <th>Tag</th>\r\n        <th>Description</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;table&gt;</code>\r\n        </td>\r\n        <td>\r\n          Wrapping element for displaying data in a tabular format\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;thead&gt;</code>\r\n        </td>\r\n        <td>\r\n          Container element for table header rows (<code>&lt;tr&gt;</code>) to label table columns\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;tbody&gt;</code>\r\n        </td>\r\n        <td>\r\n          Container element for table rows (<code>&lt;tr&gt;</code>) in the body of the table\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;tr&gt;</code>\r\n        </td>\r\n        <td>\r\n          Container element for a set of table cells (<code>&lt;td&gt;</code> or <code>&lt;th&gt;</code>) that appears on a single row\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;td&gt;</code>\r\n        </td>\r\n        <td>\r\n          Default table cell\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;th&gt;</code>\r\n        </td>\r\n        <td>\r\n          Special table cell for column (or row, depending on scope and placement) labels<br />\r\n          Must be used within a <code>&lt;thead&gt;</code>\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td>\r\n          <code>&lt;caption&gt;</code>\r\n        </td>\r\n        <td>\r\n          Description or summary of what the table holds, especially useful for screen readers\r\n        </td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n  <pre class="prettyprint linenums">\r\n&lt;table&gt;\r\n  &lt;caption&gt;...&lt;/caption&gt;\r\n  &lt;thead&gt;\r\n    &lt;tr&gt;\r\n      &lt;th&gt;...&lt;/th&gt;\r\n      &lt;th&gt;...&lt;/th&gt;\r\n    &lt;/tr&gt;\r\n  &lt;/thead&gt;\r\n  &lt;tbody&gt;\r\n    &lt;tr&gt;\r\n      &lt;td&gt;...&lt;/td&gt;\r\n      &lt;td&gt;...&lt;/td&gt;\r\n    &lt;/tr&gt;\r\n  &lt;/tbody&gt;\r\n&lt;/table&gt;\r\n</pre>\r\n  \r\n</section>', '', 1, 0, 0, 78, '2012-11-18 13:45:04', 968, '', '2012-11-21 08:12:24', 42, 0, '0000-00-00 00:00:00', '2012-11-18 13:45:04', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, 5, '', '', 1, 11, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(77, 184, 'Forms', 'forms', '', '<section id="forms">\r\n  \r\n  <h1 class="title">Forms</h1>\r\n  \r\n  \r\n  <h2>Default styles</h2>\r\n  <p>Individual form controls receive styling, but without any required base class on the <code>&lt;form&gt;</code> or large changes in markup. Results in stacked, left-aligned labels on top of form controls.</p>\r\n  <form class="bs-example">\r\n    <fieldset>\r\n      <legend>Legend</legend>\r\n      <label>Label name</label>\r\n      <input type="text" placeholder="Type something…" />\r\n      <span class="help-block">Example block-level help text here.</span>\r\n      <label class="checkbox">\r\n        <input type="checkbox" /> Check me out\r\n      </label>\r\n      <button type="submit" class="btn">Submit</button>\r\n    </fieldset>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;form&gt;\r\n  &lt;fieldset&gt;\r\n    &lt;legend&gt;Legend&lt;/legend&gt;\r\n    &lt;label&gt;Label name&lt;/label&gt;\r\n    &lt;input type="text" placeholder="Type something…"&gt;\r\n    &lt;span class="help-block"&gt;Example block-level help text here.&lt;/span&gt;\r\n    &lt;label class="checkbox"&gt;\r\n      &lt;input type="checkbox"&gt; Check me out\r\n    &lt;/label&gt;\r\n    &lt;button type="submit" class="btn"&gt;Submit&lt;/button&gt;\r\n  &lt;/fieldset&gt;\r\n&lt;/form&gt;\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Optional layouts</h2>\r\n  <p>Included with Bootstrap are three optional form layouts for common use cases.</p>\r\n  \r\n  <h3>Search form</h3>\r\n  <p>Add <code>.form-search</code> to the form and <code>.search-query</code> to the <code>&lt;input&gt;</code> for an extra-rounded text input.</p>\r\n  <form class="bs-example form-search">\r\n    <input type="text" class="input-medium search-query" />\r\n    <button type="submit" class="btn">Search</button>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;form class="form-search"&gt;\r\n  &lt;input type="text" class="input-medium search-query"&gt;\r\n  &lt;button type="submit" class="btn"&gt;Search&lt;/button&gt;\r\n&lt;/form&gt;\r\n</pre>\r\n  \r\n  <h3>Inline form</h3>\r\n  <p>Add <code>.form-inline</code> for left-aligned labels and inline-block controls for a compact layout.</p>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" class="input-small" placeholder="Email" />\r\n    <input type="password" class="input-small" placeholder="Password" />\r\n    <label class="checkbox">\r\n      <input type="checkbox" /> Remember me\r\n    </label>\r\n    <button type="submit" class="btn">Sign in</button>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;form class="form-inline"&gt;\r\n  &lt;input type="text" class="input-small" placeholder="Email"&gt;\r\n  &lt;input type="password" class="input-small" placeholder="Password"&gt;\r\n  &lt;label class="checkbox"&gt;\r\n    &lt;input type="checkbox"&gt; Remember me\r\n  &lt;/label&gt;\r\n  &lt;button type="submit" class="btn"&gt;Sign in&lt;/button&gt;\r\n&lt;/form&gt;\r\n</pre>\r\n  \r\n  <h3>Horizontal form</h3>\r\n  <p>Right align labels and float them to the left to make them appear on the same line as controls. Requires the most markup changes from a default form:</p>\r\n  <ul>\r\n    <li>Add <code>.form-horizontal</code> to the form</li>\r\n    <li>Wrap labels and controls in <code>.control-group</code></li>\r\n    <li>Add <code>.control-label</code> to the label</li>\r\n    <li>Wrap any associated controls in <code>.controls</code> for proper alignment</li>\r\n  </ul>\r\n  <form class="bs-example form-horizontal">\r\n    <div class="control-group">\r\n      <label class="control-label" for="inputEmail">Email</label>\r\n      <div class="controls">\r\n        <input type="text" id="inputEmail" placeholder="Email" />\r\n      </div>\r\n    </div>\r\n    <div class="control-group">\r\n      <label class="control-label" for="inputPassword">Password</label>\r\n      <div class="controls">\r\n        <input type="password" id="inputPassword" placeholder="Password" />\r\n      </div>\r\n    </div>\r\n    <div class="control-group">\r\n      <div class="controls">\r\n        <label class="checkbox">\r\n          <input type="checkbox" /> Remember me\r\n        </label>\r\n        <button type="submit" class="btn">Sign in</button>\r\n      </div>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;form class="form-horizontal"&gt;\r\n  &lt;div class="control-group"&gt;\r\n    &lt;label class="control-label" for="inputEmail"&gt;Email&lt;/label&gt;\r\n    &lt;div class="controls"&gt;\r\n      &lt;input type="text" id="inputEmail" placeholder="Email"&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n  &lt;div class="control-group"&gt;\r\n    &lt;label class="control-label" for="inputPassword"&gt;Password&lt;/label&gt;\r\n    &lt;div class="controls"&gt;\r\n      &lt;input type="password" id="inputPassword" placeholder="Password"&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n  &lt;div class="control-group"&gt;\r\n    &lt;div class="controls"&gt;\r\n      &lt;label class="checkbox"&gt;\r\n        &lt;input type="checkbox"&gt; Remember me\r\n      &lt;/label&gt;\r\n      &lt;button type="submit" class="btn"&gt;Sign in&lt;/button&gt;\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n&lt;/form&gt;\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Supported form controls</h2>\r\n  <p>Examples of standard form controls supported in an example form layout.</p>\r\n  \r\n  <h3>Inputs</h3>\r\n  <p>Most common form control, text-based input fields. Includes support for all HTML5 types: text, password, datetime, datetime-local, date, month, time, week, number, email, url, search, tel, and color.</p>\r\n  <p>Requires the use of a specified <code>type</code> at all times.</p>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" placeholder="Text input" />\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input type="text" placeholder="Text input"&gt;\r\n</pre>\r\n  \r\n  <h3>Textarea</h3>\r\n  <p>Form control which supports multiple lines of text. Change <code>rows</code> attribute as necessary.</p>\r\n  <form class="bs-example form-inline">\r\n    <textarea rows="3"></textarea>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;textarea rows="3"&gt;&lt;/textarea&gt;\r\n</pre>\r\n  \r\n  <h3>Checkboxes and radios</h3>\r\n  <p>Checkboxes are for selecting one or several options in a list while radios are for selecting one option from many.</p>\r\n  <h4>Default (stacked)</h4>\r\n  <form class="bs-example">\r\n    <label class="checkbox">\r\n      <input type="checkbox" value="" />\r\n      Option one is this and that&mdash;be sure to include why it''s great\r\n    </label>\r\n    <br />\r\n    <label class="radio">\r\n      <input type="radio" name="optionsRadios" id="optionsRadios1" value="option1" />\r\n      Option one is this and that&mdash;be sure to include why it''s great\r\n    </label>\r\n    <label class="radio">\r\n      <input type="radio" name="optionsRadios" id="optionsRadios2" value="option2" />\r\n      Option two can be something else and selecting it will deselect option one\r\n    </label>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;label class="checkbox"&gt;\r\n  &lt;input type="checkbox" value=""&gt;\r\n  Option one is this and that&mdash;be sure to include why it''s great\r\n&lt;/label&gt;\r\n\r\n&lt;label class="radio"&gt;\r\n  &lt;input type="radio" name="optionsRadios" id="optionsRadios1" value="option1" checked&gt;\r\n  Option one is this and that&mdash;be sure to include why it''s great\r\n&lt;/label&gt;\r\n&lt;label class="radio"&gt;\r\n  &lt;input type="radio" name="optionsRadios" id="optionsRadios2" value="option2"&gt;\r\n  Option two can be something else and selecting it will deselect option one\r\n&lt;/label&gt;\r\n</pre>\r\n  \r\n  <h4>Inline checkboxes</h4>\r\n  <p>Add the <code>.inline</code> class to a series of checkboxes or radios for controls appear on the same line.</p>\r\n  <form class="bs-example">\r\n    <label class="checkbox inline">\r\n      <input type="checkbox" id="inlineCheckbox1" value="option1" /> 1\r\n    </label>\r\n    <label class="checkbox inline">\r\n      <input type="checkbox" id="inlineCheckbox2" value="option2" /> 2\r\n    </label>\r\n    <label class="checkbox inline">\r\n      <input type="checkbox" id="inlineCheckbox3" value="option3" /> 3\r\n    </label>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;label class="checkbox inline"&gt;\r\n  &lt;input type="checkbox" id="inlineCheckbox1" value="option1"&gt; 1\r\n&lt;/label&gt;\r\n&lt;label class="checkbox inline"&gt;\r\n  &lt;input type="checkbox" id="inlineCheckbox2" value="option2"&gt; 2\r\n&lt;/label&gt;\r\n&lt;label class="checkbox inline"&gt;\r\n  &lt;input type="checkbox" id="inlineCheckbox3" value="option3"&gt; 3\r\n&lt;/label&gt;\r\n</pre>\r\n  \r\n  <h3>Selects</h3>\r\n  <p>Use the default option or specify a <code>multiple="multiple"</code> to show multiple options at once.</p>\r\n  <form class="bs-example">\r\n    <select>\r\n      <option>1</option>\r\n      <option>2</option>\r\n      <option>3</option>\r\n      <option>4</option>\r\n      <option>5</option>\r\n    </select>\r\n    <br />\r\n    <select multiple="multiple">\r\n      <option>1</option>\r\n      <option>2</option>\r\n      <option>3</option>\r\n      <option>4</option>\r\n      <option>5</option>\r\n    </select>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;select&gt;\r\n  &lt;option&gt;1&lt;/option&gt;\r\n  &lt;option&gt;2&lt;/option&gt;\r\n  &lt;option&gt;3&lt;/option&gt;\r\n  &lt;option&gt;4&lt;/option&gt;\r\n  &lt;option&gt;5&lt;/option&gt;\r\n&lt;/select&gt;\r\n\r\n&lt;select multiple="multiple"&gt;\r\n  &lt;option&gt;1&lt;/option&gt;\r\n  &lt;option&gt;2&lt;/option&gt;\r\n  &lt;option&gt;3&lt;/option&gt;\r\n  &lt;option&gt;4&lt;/option&gt;\r\n  &lt;option&gt;5&lt;/option&gt;\r\n&lt;/select&gt;\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Extending form controls</h2>\r\n  <p>Adding on top of existing browser controls, Bootstrap includes other useful form components.</p>\r\n  \r\n  <h3>Prepended and appended inputs</h3>\r\n  <p>Add text or buttons before or after any text-based input. Do note that <code>select</code> elements are not supported here.</p>\r\n  \r\n  <h4>Default options</h4>\r\n  <p>Wrap an <code>.add-on</code> and an <code>input</code> with one of two classes to prepend or append text to an input.</p>\r\n  <form class="bs-example">\r\n    <div class="input-prepend">\r\n      <span class="add-on">@</span>\r\n      <input class="span2" id="prependedInput" type="text" placeholder="Username" />\r\n    </div>\r\n    <br />\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedInput" type="text" />\r\n      <span class="add-on">.00</span>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-prepend"&gt;\r\n  &lt;span class="add-on"&gt;@&lt;/span&gt;\r\n  &lt;input class="span2" id="prependedInput" type="text" placeholder="Username"&gt;\r\n&lt;/div&gt;\r\n&lt;div class="input-append"&gt;\r\n  &lt;input class="span2" id="appendedInput" type="text"&gt;\r\n  &lt;span class="add-on"&gt;.00&lt;/span&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <h4>Combined</h4>\r\n  <p>Use both classes and two instances of <code>.add-on</code> to prepend and append an input.</p>\r\n  <form class="bs-example form-inline">\r\n    <div class="input-prepend input-append">\r\n      <span class="add-on">$</span>\r\n      <input class="span2" id="appendedPrependedInput" type="text" />\r\n      <span class="add-on">.00</span>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-prepend input-append"&gt;\r\n  &lt;span class="add-on"&gt;$&lt;/span&gt;\r\n  &lt;input class="span2" id="appendedPrependedInput" type="text"&gt;\r\n  &lt;span class="add-on"&gt;.00&lt;/span&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <h4>Buttons instead of text</h4>\r\n  <p>Instead of a <code>&lt;span&gt;</code> with text, use a <code>.btn</code> to attach a button (or two) to an input.</p>\r\n  <form class="bs-example">\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedInputButton" type="text" />\r\n      <button class="btn" type="button">Go!</button>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-append"&gt;\r\n  &lt;input class="span2" id="appendedInputButton" type="text"&gt;\r\n  &lt;button class="btn" type="button"&gt;Go!&lt;/button&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  <form class="bs-example">\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedInputButtons" type="text" />\r\n      <button class="btn" type="button">Search</button>\r\n      <button class="btn" type="button">Options</button>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-append"&gt;\r\n  &lt;input class="span2" id="appendedInputButtons" type="text"&gt;\r\n  &lt;button class="btn" type="button"&gt;Search&lt;/button&gt;\r\n  &lt;button class="btn" type="button"&gt;Options&lt;/button&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <h4>Button dropdowns</h4>\r\n  <p></p>\r\n  <form class="bs-example">\r\n    <div class="input-append">\r\n      <input class="span2" id="appendedDropdownButton" type="text" />\r\n      <div class="btn-group">\r\n        <button class="btn dropdown-toggle" data-toggle="dropdown">Action <span class="caret"></span></button>\r\n        <ul class="dropdown-menu">\r\n          <li><a href="#">Action</a></li>\r\n          <li><a href="#">Another action</a></li>\r\n          <li><a href="#">Something else here</a></li>\r\n          <li class="divider"></li>\r\n          <li><a href="#">Separated link</a></li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-append"&gt;\r\n  &lt;input class="span2" id="appendedDropdownButton" type="text"&gt;\r\n  &lt;div class="btn-group"&gt;\r\n    &lt;button class="btn dropdown-toggle" data-toggle="dropdown"&gt;\r\n      Action\r\n      &lt;span class="caret"&gt;&lt;/span&gt;\r\n    &lt;/button&gt;\r\n    &lt;ul class="dropdown-menu"&gt;\r\n      ...\r\n    &lt;/ul&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <form class="bs-example">\r\n    <div class="input-prepend">\r\n      <div class="btn-group">\r\n        <button class="btn dropdown-toggle" data-toggle="dropdown">Action <span class="caret"></span></button>\r\n        <ul class="dropdown-menu">\r\n          <li><a href="#">Action</a></li>\r\n          <li><a href="#">Another action</a></li>\r\n          <li><a href="#">Something else here</a></li>\r\n          <li class="divider"></li>\r\n          <li><a href="#">Separated link</a></li>\r\n        </ul>\r\n      </div>\r\n      <input class="span2" id="prependedDropdownButton" type="text" />\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-prepend"&gt;\r\n  &lt;div class="btn-group"&gt;\r\n    &lt;button class="btn dropdown-toggle" data-toggle="dropdown"&gt;\r\n      Action\r\n      &lt;span class="caret"&gt;&lt;/span&gt;\r\n    &lt;/button&gt;\r\n    &lt;ul class="dropdown-menu"&gt;\r\n      ...\r\n    &lt;/ul&gt;\r\n  &lt;/div&gt;\r\n  &lt;input class="span2" id="prependedDropdownButton" type="text"&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <form class="bs-example">\r\n    <div class="input-prepend input-append">\r\n      <div class="btn-group">\r\n        <button class="btn dropdown-toggle" data-toggle="dropdown">Action <span class="caret"></span></button>\r\n        <ul class="dropdown-menu">\r\n          <li><a href="#">Action</a></li>\r\n          <li><a href="#">Another action</a></li>\r\n          <li><a href="#">Something else here</a></li>\r\n          <li class="divider"></li>\r\n          <li><a href="#">Separated link</a></li>\r\n        </ul>\r\n      </div>\r\n      <input class="span2" id="appendedPrependedDropdownButton" type="text" />\r\n      <div class="btn-group">\r\n        <button class="btn dropdown-toggle" data-toggle="dropdown">Action <span class="caret"></span></button>\r\n        <ul class="dropdown-menu">\r\n          <li><a href="#">Action</a></li>\r\n          <li><a href="#">Another action</a></li>\r\n          <li><a href="#">Something else here</a></li>\r\n          <li class="divider"></li>\r\n          <li><a href="#">Separated link</a></li>\r\n        </ul>\r\n      </div>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="input-prepend input-append"&gt;\r\n  &lt;div class="btn-group"&gt;\r\n    &lt;button class="btn dropdown-toggle" data-toggle="dropdown"&gt;\r\n      Action\r\n      &lt;span class="caret"&gt;&lt;/span&gt;\r\n    &lt;/button&gt;\r\n    &lt;ul class="dropdown-menu"&gt;\r\n      ...\r\n    &lt;/ul&gt;\r\n  &lt;/div&gt;\r\n  &lt;input class="span2" id="appendedPrependedDropdownButton" type="text"&gt;\r\n  &lt;div class="btn-group"&gt;\r\n    &lt;button class="btn dropdown-toggle" data-toggle="dropdown"&gt;\r\n      Action\r\n      &lt;span class="caret"&gt;&lt;/span&gt;\r\n    &lt;/button&gt;\r\n    &lt;ul class="dropdown-menu"&gt;\r\n      ...\r\n    &lt;/ul&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <h4>Search form</h4>\r\n  <form class="bs-example form-search">\r\n    <div class="input-append">\r\n      <input type="text" class="span2 search-query" />\r\n      <button type="submit" class="btn">Search</button>\r\n    </div>\r\n    <div class="input-prepend">\r\n      <button type="submit" class="btn">Search</button>\r\n      <input type="text" class="span2 search-query" />\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;form class="form-search"&gt;\r\n  &lt;div class="input-append"&gt;\r\n    &lt;input type="text" class="span2 search-query"&gt;\r\n    &lt;button type="submit" class="btn"&gt;Search&lt;/button&gt;\r\n  &lt;/div&gt;\r\n  &lt;div class="input-prepend"&gt;\r\n    &lt;button type="submit" class="btn"&gt;Search&lt;/button&gt;\r\n    &lt;input type="text" class="span2 search-query"&gt;\r\n  &lt;/div&gt;\r\n&lt;/form&gt;\r\n</pre>\r\n  \r\n  <h3>Control sizing</h3>\r\n  <p>Use relative sizing classes like <code>.input-large</code> or match your inputs to the grid column sizes using <code>.span*</code> classes.</p>\r\n  \r\n  <h4>Block level inputs</h4>\r\n  <p>Make any <code>&lt;input&gt;</code> or <code>&lt;textarea&gt;</code> element behave like a block level element.</p>\r\n  <form class="bs-example" style="padding-bottom: 15px;">\r\n    <div class="controls">\r\n      <input class="input-block-level" type="text" placeholder=".input-block-level" />\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input class="input-block-level" type="text" placeholder=".input-block-level"&gt;\r\n</pre>\r\n  \r\n  <h4>Relative sizing</h4>\r\n  <form class="bs-example" style="padding-bottom: 15px;">\r\n    <div class="controls docs-input-sizes">\r\n      <input class="input-mini" type="text" placeholder=".input-mini" />\r\n      <input class="input-small" type="text" placeholder=".input-small" />\r\n      <input class="input-medium" type="text" placeholder=".input-medium" />\r\n      <input class="input-large" type="text" placeholder=".input-large" />\r\n      <input class="input-xlarge" type="text" placeholder=".input-xlarge" />\r\n      <input class="input-xxlarge" type="text" placeholder=".input-xxlarge" />\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input class="input-mini" type="text" placeholder=".input-mini"&gt;\r\n&lt;input class="input-small" type="text" placeholder=".input-small"&gt;\r\n&lt;input class="input-medium" type="text" placeholder=".input-medium"&gt;\r\n&lt;input class="input-large" type="text" placeholder=".input-large"&gt;\r\n&lt;input class="input-xlarge" type="text" placeholder=".input-xlarge"&gt;\r\n&lt;input class="input-xxlarge" type="text" placeholder=".input-xxlarge"&gt;\r\n</pre>\r\n  <p>\r\n    <span class="label label-info">Heads up!</span> In future versions, we''ll be altering the use of these relative input classes to match our button sizes. For example, <code>.input-large</code> will increase the padding and font-size of an input.\r\n  </p>\r\n  \r\n  <h4>Grid sizing</h4>\r\n  <p>Use <code>.span1</code> to <code>.span12</code> for inputs that match the same sizes of the grid columns.</p>\r\n  <form class="bs-example" style="padding-bottom: 15px;">\r\n    <div class="controls docs-input-sizes">\r\n      <input class="span1" type="text" placeholder=".span1" />\r\n      <input class="span2" type="text" placeholder=".span2" />\r\n      <input class="span3" type="text" placeholder=".span3" />\r\n      <select class="span1">\r\n        <option>1</option>\r\n        <option>2</option>\r\n        <option>3</option>\r\n        <option>4</option>\r\n        <option>5</option>\r\n      </select>\r\n      <select class="span2">\r\n        <option>1</option>\r\n        <option>2</option>\r\n        <option>3</option>\r\n        <option>4</option>\r\n        <option>5</option>\r\n      </select>\r\n      <select class="span3">\r\n        <option>1</option>\r\n        <option>2</option>\r\n        <option>3</option>\r\n        <option>4</option>\r\n        <option>5</option>\r\n      </select>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input class="span1" type="text" placeholder=".span1"&gt;\r\n&lt;input class="span2" type="text" placeholder=".span2"&gt;\r\n&lt;input class="span3" type="text" placeholder=".span3"&gt;\r\n&lt;select class="span1"&gt;\r\n  ...\r\n&lt;/select&gt;\r\n&lt;select class="span2"&gt;\r\n  ...\r\n&lt;/select&gt;\r\n&lt;select class="span3"&gt;\r\n  ...\r\n&lt;/select&gt;\r\n</pre>\r\n  \r\n  <p>For multiple grid inputs per line, <strong>use the <code>.controls-row</code> modifier class for proper spacing</strong>. It floats the inputs to collapse white-space, sets the proper margins, and the clears the float.</p>\r\n  <form class="bs-example" style="padding-bottom: 15px;">\r\n    <div class="controls">\r\n      <input class="span5" type="text" placeholder=".span5" />\r\n    </div>\r\n    <div class="controls controls-row">\r\n      <input class="span4" type="text" placeholder=".span4" />\r\n      <input class="span1" type="text" placeholder=".span1" />\r\n    </div>\r\n    <div class="controls controls-row">\r\n      <input class="span3" type="text" placeholder=".span3" />\r\n      <input class="span2" type="text" placeholder=".span2" />\r\n    </div>\r\n    <div class="controls controls-row">\r\n      <input class="span2" type="text" placeholder=".span2" />\r\n      <input class="span3" type="text" placeholder=".span3" />\r\n    </div>\r\n    <div class="controls controls-row">\r\n      <input class="span1" type="text" placeholder=".span1" />\r\n      <input class="span4" type="text" placeholder=".span4" />\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="controls"&gt;\r\n  &lt;input class="span5" type="text" placeholder=".span5"&gt;\r\n&lt;/div&gt;\r\n&lt;div class="controls controls-row"&gt;\r\n  &lt;input class="span4" type="text" placeholder=".span4"&gt;\r\n  &lt;input class="span1" type="text" placeholder=".span1"&gt;\r\n&lt;/div&gt;\r\n...\r\n</pre>\r\n  \r\n  <h3>Uneditable inputs</h3>\r\n  <p>Present data in a form that''s not editable without using actual form markup.</p>\r\n  <form class="bs-example">\r\n    <span class="input-xlarge uneditable-input">Some value here</span>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;span class="input-xlarge uneditable-input"&gt;Some value here&lt;/span&gt;\r\n</pre>\r\n  \r\n  <h3>Form actions</h3>\r\n  <p>End a form with a group of actions (buttons). When placed within a <code>.form-horizontal</code>, the buttons will automatically indent to line up with the form controls.</p>\r\n  <form class="bs-example">\r\n    <div class="form-actions">\r\n      <button type="submit" class="btn btn-primary">Save changes</button>\r\n      <button type="button" class="btn">Cancel</button>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="form-actions"&gt;\r\n  &lt;button type="submit" class="btn btn-primary"&gt;Save changes&lt;/button&gt;\r\n  &lt;button type="button" class="btn"&gt;Cancel&lt;/button&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n  <h3>Help text</h3>\r\n  <p>Inline and block level support for help text that appears around form controls.</p>\r\n  <h4>Inline help</h4>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" /> <span class="help-inline">Inline help text</span>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input type="text"&gt;&lt;span class="help-inline"&gt;Inline help text&lt;/span&gt;\r\n</pre>\r\n  \r\n  <h4>Block help</h4>\r\n  <form class="bs-example form-inline">\r\n    <input type="text" />\r\n    <span class="help-block">A longer block of help text that breaks onto a new line and may extend beyond one line.</span>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input type="text"&gt;&lt;span class="help-block"&gt;A longer block of help text that breaks onto a new line and may extend beyond one line.&lt;/span&gt;\r\n</pre>\r\n  \r\n  \r\n  <hr class="bs-separator" />\r\n  \r\n  \r\n  <h2>Form control states</h2>\r\n  <p>Provide feedback to users or visitors with basic feedback states on form controls and labels.</p>\r\n  \r\n  <h3>Input focus</h3>\r\n  <p>We remove the default <code>outline</code> styles on some form controls and apply a <code>box-shadow</code> in its place for <code>:focus</code>.</p>\r\n  <form class="bs-example form-inline">\r\n    <input class="input-xlarge focused" id="focusedInput" type="text" value="This is focused..." />\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input class="input-xlarge" id="focusedInput" type="text" value="This is focused..."&gt;\r\n</pre>\r\n  \r\n  <h3>Disabled inputs</h3>\r\n  <p>Add the <code>disabled</code> attribute on an input to prevent user input and trigger a slightly different look.</p>\r\n  <form class="bs-example form-inline">\r\n    <input class="input-xlarge" id="disabledInput" type="text" placeholder="Disabled input here…" />\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;input class="input-xlarge" id="disabledInput" type="text" placeholder="Disabled input here..." disabled&gt;\r\n</pre>\r\n  \r\n  <h3>Validation states</h3>\r\n  <p>Bootstrap includes validation styles for error, warning, info, and success messages. To use, add the appropriate class to the surrounding <code>.control-group</code>.</p>\r\n  \r\n  <form class="bs-example form-horizontal">\r\n    <div class="control-group warning">\r\n      <label class="control-label" for="inputWarning">Input with warning</label>\r\n      <div class="controls">\r\n        <input type="text" id="inputWarning" />\r\n        <span class="help-inline">Something may have gone wrong</span>\r\n      </div>\r\n    </div>\r\n    <div class="control-group error">\r\n      <label class="control-label" for="inputError">Input with error</label>\r\n      <div class="controls">\r\n        <input type="text" id="inputError" />\r\n        <span class="help-inline">Please correct the error</span>\r\n      </div>\r\n    </div>\r\n    <div class="control-group info">\r\n      <label class="control-label" for="inputInfo">Input with info</label>\r\n      <div class="controls">\r\n        <input type="text" id="inputInfo" />\r\n        <span class="help-inline">Username is taken</span>\r\n      </div>\r\n    </div>\r\n    <div class="control-group success">\r\n      <label class="control-label" for="inputSuccess">Input with success</label>\r\n      <div class="controls">\r\n        <input type="text" id="inputSuccess" />\r\n        <span class="help-inline">Woohoo!</span>\r\n      </div>\r\n    </div>\r\n  </form>\r\n  <pre class="prettyprint linenums">\r\n&lt;div class="control-group warning"&gt;\r\n  &lt;label class="control-label" for="inputWarning"&gt;Input with warning&lt;/label&gt;\r\n  &lt;div class="controls"&gt;\r\n    &lt;input type="text" id="inputWarning"&gt;\r\n    &lt;span class="help-inline"&gt;Something may have gone wrong&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="control-group error"&gt;\r\n  &lt;label class="control-label" for="inputError"&gt;Input with error&lt;/label&gt;\r\n  &lt;div class="controls"&gt;\r\n    &lt;input type="text" id="inputError"&gt;\r\n    &lt;span class="help-inline"&gt;Please correct the error&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class="control-group success"&gt;\r\n  &lt;label class="control-label" for="inputSuccess"&gt;Input with success&lt;/label&gt;\r\n  &lt;div class="controls"&gt;\r\n    &lt;input type="text" id="inputSuccess"&gt;\r\n    &lt;span class="help-inline"&gt;Woohoo!&lt;/span&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n  \r\n</section>\r\n', '', 1, 0, 0, 78, '2012-11-18 13:47:50', 968, '', '2012-11-18 15:55:20', 42, 0, '0000-00-00 00:00:00', '2012-11-18 13:47:50', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, 6, '', '', 1, 7, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(78, 185, 'Buttons', 'buttons', '', '<section id="buttons">\r\n  <h1 class="title">Buttons</h1>\r\n\r\n  <h2>Default buttons</h2>\r\n  <p>Button styles can be applied to anything with the <code>.btn</code> class applied. However, typically you''ll want to apply these to only <code>&lt;a&gt;</code> and <code>&lt;button&gt;</code> elements for the best rendering.</p>\r\n  <table class="table table-bordered table-striped">\r\n    <thead>\r\n      <tr>\r\n        <th>Button</th>\r\n        <th>class=""</th>\r\n        <th>Description</th>\r\n      </tr>\r\n    </thead>\r\n    <tbody>\r\n      <tr>\r\n        <td><button type="button" class="btn">Default</button></td>\r\n        <td><code>btn</code></td>\r\n        <td>Standard gray button with gradient</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-primary">Primary</button></td>\r\n        <td><code>btn btn-primary</code></td>\r\n        <td>Provides extra visual weight and identifies the primary action in a set of buttons</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-info">Info</button></td>\r\n        <td><code>btn btn-info</code></td>\r\n        <td>Used as an alternative to the default styles</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-success">Success</button></td>\r\n        <td><code>btn btn-success</code></td>\r\n        <td>Indicates a successful or positive action</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-warning">Warning</button></td>\r\n        <td><code>btn btn-warning</code></td>\r\n        <td>Indicates caution should be taken with this action</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-danger">Danger</button></td>\r\n        <td><code>btn btn-danger</code></td>\r\n        <td>Indicates a dangerous or potentially negative action</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-inverse">Inverse</button></td>\r\n        <td><code>btn btn-inverse</code></td>\r\n        <td>Alternate dark gray button, not tied to a semantic action or use</td>\r\n      </tr>\r\n      <tr>\r\n        <td><button type="button" class="btn btn-link">Link</button></td>\r\n        <td><code>btn btn-link</code></td>\r\n        <td>Deemphasize a button by making it look like a link while maintaining button behavior</td>\r\n      </tr>\r\n    </tbody>\r\n  </table>\r\n\r\n  <h4>Cross browser compatibility</h4>\r\n  <p>IE9 doesn''t crop background gradients on rounded corners, so we remove it. Related, IE9 jankifies disabled <code>button</code> elements, rendering text gray with a nasty text-shadow that we cannot fix.</p>\r\n\r\n\r\n  <h2>Button sizes</h2>\r\n  <p>Fancy larger or smaller buttons? Add <code>.btn-large</code>, <code>.btn-small</code>, or <code>.btn-mini</code> for additional sizes.</p>\r\n  <div class="bs-example">\r\n    <p>\r\n      <button type="button" class="btn btn-large btn-primary">Large button</button>\r\n      <button type="button" class="btn btn-large">Large button</button>\r\n    </p>\r\n    <p>\r\n      <button type="button" class="btn btn-primary">Default button</button>\r\n      <button type="button" class="btn">Default button</button>\r\n    </p>\r\n    <p>\r\n      <button type="button" class="btn btn-small btn-primary">Small button</button>\r\n      <button type="button" class="btn btn-small">Small button</button>\r\n    </p>\r\n    <p>\r\n      <button type="button" class="btn btn-mini btn-primary">Mini button</button>\r\n      <button type="button" class="btn btn-mini">Mini button</button>\r\n    </p>\r\n  </div>\r\n<pre class="prettyprint linenums">\r\n&lt;p&gt;\r\n&lt;button class="btn btn-large btn-primary" type="button"&gt;Large button&lt;/button&gt;\r\n&lt;button class="btn btn-large" type="button"&gt;Large button&lt;/button&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n&lt;button class="btn btn-primary" type="button"&gt;Default button&lt;/button&gt;\r\n&lt;button class="btn" type="button"&gt;Default button&lt;/button&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n&lt;button class="btn btn-small btn-primary" type="button"&gt;Small button&lt;/button&gt;\r\n&lt;button class="btn btn-small" type="button"&gt;Small button&lt;/button&gt;\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n&lt;button class="btn btn-mini btn-primary" type="button"&gt;Mini button&lt;/button&gt;\r\n&lt;button class="btn btn-mini" type="button"&gt;Mini button&lt;/button&gt;\r\n&lt;/p&gt;\r\n</pre>\r\n  <p>Create block level buttons&mdash;those that span the full width of a parent&mdash; by adding <code>.btn-block</code>.</p>\r\n  <div class="bs-example">\r\n    <div class="well" style="max-width: 400px; margin: 0 auto 10px;">\r\n      <button type="button" class="btn btn-large btn-block btn-primary">Block level button</button>\r\n      <button type="button" class="btn btn-large btn-block">Block level button</button>\r\n    </div>\r\n  </div>\r\n<pre class="prettyprint linenums">\r\n&lt;button class="btn btn-large btn-block btn-primary" type="button"&gt;Block level button&lt;/button&gt;\r\n&lt;button class="btn btn-large btn-block" type="button"&gt;Block level button&lt;/button&gt;\r\n</pre>\r\n\r\n\r\n  <h2>Disabled state</h2>\r\n  <p>Make buttons look unclickable by fading them back 50%.</p>\r\n\r\n  <h3>Anchor element</h3>\r\n  <p>Add the <code>.disabled</code> class to <code>&lt;a&gt;</code> buttons.</p>\r\n  <p class="bs-example">\r\n    <a href="#" class="btn btn-large btn-primary disabled">Primary link</a>\r\n    <a href="#" class="btn btn-large disabled">Link</a>\r\n  </p>\r\n<pre class="prettyprint linenums">\r\n&lt;a href="#" class="btn btn-large btn-primary disabled"&gt;Primary link&lt;/a&gt;\r\n&lt;a href="#" class="btn btn-large disabled"&gt;Link&lt;/a&gt;\r\n</pre>\r\n  <p>\r\n    <span class="label label-info">Heads up!</span>\r\n    We use <code>.disabled</code> as a utility class here, similar to the common <code>.active</code> class, so no prefix is required. Also, this class is only for aesthetic; you must use custom JavaScript to disable links here.\r\n  </p>\r\n\r\n  <h3>Button element</h3>\r\n  <p>Add the <code>disabled</code> attribute to <code>&lt;button&gt;</code> buttons.</p>\r\n  <p class="bs-example">\r\n    <button type="button" class="btn btn-large btn-primary disabled" disabled="disabled">Primary button</button>\r\n    <button type="button" class="btn btn-large">Button</button>\r\n  </p>\r\n<pre class="prettyprint linenums">\r\n&lt;button type="button" class="btn btn-large btn-primary disabled" disabled="disabled"&gt;Primary button&lt;/button&gt;\r\n&lt;button type="button" class="btn btn-large" disabled&gt;Button&lt;/button&gt;\r\n</pre>\r\n\r\n\r\n  <h2>One class, multiple tags</h2>\r\n  <p>Use the <code>.btn</code> class on an <code>&lt;a&gt;</code>, <code>&lt;button&gt;</code>, or <code>&lt;input&gt;</code> element.</p>\r\n  <form class="bs-example">\r\n    <a class="btn" href="">Link</a>\r\n    <button class="btn" type="submit">Button</button>\r\n    <input class="btn" type="button" value="Input" />\r\n    <input class="btn" type="submit" value="Submit" />\r\n  </form>\r\n<pre class="prettyprint linenums">\r\n&lt;a class="btn" href=""&gt;Link&lt;/a&gt;\r\n&lt;button class="btn" type="submit"&gt;Button&lt;/button&gt;\r\n&lt;input class="btn" type="button" value="Input"&gt;\r\n&lt;input class="btn" type="submit" value="Submit"&gt;\r\n</pre>\r\n  <p>As a best practice, try to match the element for your context to ensure matching cross-browser rendering. If you have an <code>input</code>, use an <code>&lt;input type="submit"&gt;</code> for your button.</p>\r\n\r\n</section>', '', 1, 0, 0, 78, '2012-11-18 14:05:06', 968, '', '2012-11-21 08:12:24', 42, 0, '0000-00-00 00:00:00', '2012-11-18 14:05:06', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, 7, '', '', 1, 9, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(79, 186, 'Notice & Alerts', 'notice-alerts', '', '<h1 class="title">Notice & Error</h1>\r\n<h3>Error or danger</h3>\r\n<div class="bs-example">\r\n  <div class="alert alert-error">\r\n    <strong>Oh snap!</strong> Change a few things up and try submitting again.\r\n  </div>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="alert alert-error"&gt;\r\n  ...\r\n&lt;/div&gt;\r\n</pre>\r\n\r\n<h3>Success</h3>\r\n<div class="bs-example">\r\n  <div class="alert alert-success">\r\n    <strong>Well done!</strong> You successfully read this important alert message.\r\n  </div>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="alert alert-success"&gt;\r\n  ...\r\n&lt;/div&gt;\r\n</pre>\r\n\r\n<h3>Information</h3>\r\n<div class="bs-example">\r\n  <div class="alert alert-info">\r\n    <strong>Heads up!</strong> This alert needs your attention, but it''s not super important.\r\n  </div>\r\n</div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="alert alert-info"&gt;\r\n  ...\r\n&lt;/div&gt;\r\n</pre>', '', 1, 0, 0, 78, '2012-11-18 14:07:40', 968, '', '2012-11-21 08:12:24', 42, 0, '0000-00-00 00:00:00', '2012-11-18 14:07:40', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, 8, '', '', 1, 16, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(80, 187, 'Icons', 'icons', '', '<h1 class="title">Icons</h1>\r\n<h2>Font Awesome</h2>\r\n\r\n  <p>Font Awesome is a pictographic language of web-related actions which delivers 220 icons. The Font Awesome webfont, CSS, and LESS files are licensed under CC BY 3.0 and you can find the full bs-examples of usage at <a href="http://fortawesome.github.com/Font-Awesome" target="_blank">Font Awesome - http://fortawesome.github.com/Font-Awesome</a></p>\r\n\r\n<p>Add <code>.icon-CLASS_NAME</code> to any element, best used with a <code>&lt;span&gt;</code>.</p>\r\n\r\n<div class="bs-example">\r\n<h3>Web Icons</h3>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-adjust"> icon-adjust</span><br /><br />\r\n      <span class="icon-asterisk"> icon-asterisk</span><br /><br />\r\n      <span class="icon-ban-circle"> icon-ban-circle</span><br /><br />\r\n      <span class="icon-bar-chart"> icon-bar-chart</span><br /><br />\r\n      <span class="icon-barcode"> icon-barcode</span><br /><br />\r\n      <span class="icon-beaker"> icon-beaker</span><br /><br />\r\n      <span class="icon-bell"> icon-bell</span><br /><br />\r\n      <span class="icon-bolt"> icon-bolt</span><br /><br />\r\n      <span class="icon-book"> icon-book</span><br /><br />\r\n      <span class="icon-bookmark"> icon-bookmark</span><br /><br />\r\n      <span class="icon-bookmark-empty"> icon-bookmark-empty</span><br /><br />\r\n      <span class="icon-briefcase"> icon-briefcase</span><br /><br />\r\n      <span class="icon-bullhorn"> icon-bullhorn</span><br /><br />\r\n      <span class="icon-calendar"> icon-calendar</span><br /><br />\r\n      <span class="icon-camera"> icon-camera</span><br /><br />\r\n      <span class="icon-camera-retro"> icon-camera-retro</span><br /><br />\r\n      <span class="icon-certificate"> icon-certificate</span><br /><br />\r\n      <span class="icon-check"> icon-check</span><br /><br />\r\n      <span class="icon-check-empty"> icon-check-empty</span><br /><br />\r\n      <span class="icon-cloud"> icon-cloud</span><br /><br />\r\n      <span class="icon-cog"> icon-cog</span><br /><br />\r\n      <span class="icon-cogs"> icon-cogs</span><br /><br />\r\n      <span class="icon-comment"> icon-comment</span><br /><br />\r\n      <span class="icon-comment-alt"> icon-comment-alt</span><br /><br />\r\n      <span class="icon-comments"> icon-comments</span><br /><br />\r\n      <span class="icon-comments-alt"> icon-comments-alt</span><br /><br />\r\n      <span class="icon-credit-card"> icon-credit-card</span><br /><br />\r\n      <span class="icon-dashboard"> icon-dashboard</span><br /><br />\r\n      <span class="icon-download"> icon-download</span><br /><br />\r\n      <span class="icon-download-alt"> icon-download-alt</span><br /><br />\r\n      <span class="icon-edit"> icon-edit</span><br /><br />\r\n      <span class="icon-envelope"> icon-envelope</span><br /><br />\r\n      <span class="icon-envelope-alt"> icon-envelope-alt</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-exclamation-sign"> icon-exclamation-sign</span><br /><br />\r\n      <span class="icon-external-link"> icon-external-link</span><br /><br />\r\n      <span class="icon-eye-close"> icon-eye-close</span><br /><br />\r\n      <span class="icon-eye-open"> icon-eye-open</span><br /><br />\r\n      <span class="icon-facetime-video"> icon-facetime-video</span><br /><br />\r\n      <span class="icon-film"> icon-film</span><br /><br />\r\n      <span class="icon-filter"> icon-filter</span><br /><br />\r\n      <span class="icon-fire"> icon-fire</span><br /><br />\r\n      <span class="icon-flag"> icon-flag</span><br /><br />\r\n      <span class="icon-folder-close"> icon-folder-close</span><br /><br />\r\n      <span class="icon-folder-open"> icon-folder-open</span><br /><br />\r\n      <span class="icon-gift"> icon-gift</span><br /><br />\r\n      <span class="icon-glass"> icon-glass</span><br /><br />\r\n      <span class="icon-globe"> icon-globe</span><br /><br />\r\n      <span class="icon-group"> icon-group</span><br /><br />\r\n      <span class="icon-hdd"> icon-hdd</span><br /><br />\r\n      <span class="icon-headphones"> icon-headphones</span><br /><br />\r\n      <span class="icon-heart"> icon-heart</span><br /><br />\r\n      <span class="icon-heart-empty"> icon-heart-empty</span><br /><br />\r\n      <span class="icon-home"> icon-home</span><br /><br />\r\n      <span class="icon-inbox"> icon-inbox</span><br /><br />\r\n      <span class="icon-info-sign"> icon-info-sign</span><br /><br />\r\n      <span class="icon-key"> icon-key</span><br /><br />\r\n      <span class="icon-leaf"> icon-leaf</span><br /><br />\r\n      <span class="icon-legal"> icon-legal</span><br /><br />\r\n      <span class="icon-lemon"> icon-lemon</span><br /><br />\r\n      <span class="icon-lock"> icon-lock</span><br /><br />\r\n      <span class="icon-unlock"> icon-unlock</span><br /><br />\r\n      <span class="icon-magic"> icon-magic</span><br /><br />\r\n      <span class="icon-magnet"> icon-magnet</span><br /><br />\r\n      <span class="icon-map-marker"> icon-map-marker</span><br /><br />\r\n      <span class="icon-minus"> icon-minus</span><br /><br />\r\n      <span class="icon-minus-sign"> icon-minus-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-money"> icon-money</span><br /><br />\r\n      <span class="icon-move"> icon-move</span><br /><br />\r\n      <span class="icon-music"> icon-music</span><br /><br />\r\n      <span class="icon-off"> icon-off</span><br /><br />\r\n      <span class="icon-ok"> icon-ok</span><br /><br />\r\n      <span class="icon-ok-circle"> icon-ok-circle</span><br /><br />\r\n      <span class="icon-ok-sign"> icon-ok-sign</span><br /><br />\r\n      <span class="icon-pencil"> icon-pencil</span><br /><br />\r\n      <span class="icon-picture"> icon-picture</span><br /><br />\r\n      <span class="icon-plane"> icon-plane</span><br /><br />\r\n      <span class="icon-plus"> icon-plus</span><br /><br />\r\n      <span class="icon-plus-sign"> icon-plus-sign</span><br /><br />\r\n      <span class="icon-print"> icon-print</span><br /><br />\r\n      <span class="icon-pushpin"> icon-pushpin</span><br /><br />\r\n      <span class="icon-qrcode"> icon-qrcode</span><br /><br />\r\n      <span class="icon-question-sign"> icon-question-sign</span><br /><br />\r\n      <span class="icon-random"> icon-random</span><br /><br />\r\n      <span class="icon-refresh"> icon-refresh</span><br /><br />\r\n      <span class="icon-remove"> icon-remove</span><br /><br />\r\n      <span class="icon-remove-circle"> icon-remove-circle</span><br /><br />\r\n      <span class="icon-remove-sign"> icon-remove-sign</span><br /><br />\r\n      <span class="icon-reorder"> icon-reorder</span><br /><br />\r\n      <span class="icon-resize-horizontal"> icon-resize-horizontal</span><br /><br />\r\n      <span class="icon-resize-vertical"> icon-resize-vertical</span><br /><br />\r\n      <span class="icon-retweet"> icon-retweet</span><br /><br />\r\n      <span class="icon-road"> icon-road</span><br /><br />\r\n      <span class="icon-rss"> icon-rss</span><br /><br />\r\n      <span class="icon-screenshot"> icon-screenshot</span><br /><br />\r\n      <span class="icon-search"> icon-search</span><br /><br />\r\n      <span class="icon-share"> icon-share</span><br /><br />\r\n      <span class="icon-share-alt"> icon-share-alt</span><br /><br />\r\n      <span class="icon-shopping-cart"> icon-shopping-cart</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-signal"> icon-signal</span><br /><br />\r\n      <span class="icon-signin"> icon-signin</span><br /><br />\r\n      <span class="icon-signout"> icon-signout</span><br /><br />\r\n      <span class="icon-sitemap"> icon-sitemap</span><br /><br />\r\n      <span class="icon-sort"> icon-sort</span><br /><br />\r\n      <span class="icon-sort-down"> icon-sort-down</span><br /><br />\r\n      <span class="icon-sort-up"> icon-sort-up</span><br /><br />\r\n      <span class="icon-star"> icon-star</span><br /><br />\r\n      <span class="icon-star-empty"> icon-star-empty</span><br /><br />\r\n      <span class="icon-star-half"> icon-star-half</span><br /><br />\r\n      <span class="icon-tag"> icon-tag</span><br /><br />\r\n      <span class="icon-tags"> icon-tags</span><br /><br />\r\n      <span class="icon-tasks"> icon-tasks</span><br /><br />\r\n      <span class="icon-thumbs-down"> icon-thumbs-down</span><br /><br />\r\n      <span class="icon-thumbs-up"> icon-thumbs-up</span><br /><br />\r\n      <span class="icon-time"> icon-time</span><br /><br />\r\n      <span class="icon-tint"> icon-tint</span><br /><br />\r\n      <span class="icon-trash"> icon-trash</span><br /><br />\r\n      <span class="icon-trophy"> icon-trophy</span><br /><br />\r\n      <span class="icon-truck"> icon-truck</span><br /><br />\r\n      <span class="icon-umbrella"> icon-umbrella</span><br /><br />\r\n      <span class="icon-upload"> icon-upload</span><br /><br />\r\n      <span class="icon-upload-alt"> icon-upload-alt</span><br /><br />\r\n      <span class="icon-user"> icon-user</span><br /><br />\r\n      <span class="icon-user-md"> icon-user-md</span><br /><br />\r\n      <span class="icon-volume-off"> icon-volume-off</span><br /><br />\r\n      <span class="icon-volume-down"> icon-volume-down</span><br /><br />\r\n      <span class="icon-volume-up"> icon-volume-up</span><br /><br />\r\n      <span class="icon-warning-sign"> icon-warning-sign</span><br /><br />\r\n      <span class="icon-wrench"> icon-wrench</span><br /><br />\r\n      <span class="icon-zoom-in"> icon-zoom-in</span><br /><br />\r\n      <span class="icon-zoom-out"> icon-zoom-out</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Text Editor Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-file"> icon-file</span><br /><br />\r\n      <span class="icon-cut"> icon-cut</span><br /><br />\r\n      <span class="icon-copy"> icon-copy</span><br /><br />\r\n      <span class="icon-paste"> icon-paste</span><br /><br />\r\n      <span class="icon-save"> icon-save</span><br /><br />\r\n      <span class="icon-undo"> icon-undo</span><br /><br />\r\n      <span class="icon-repeat"> icon-repeat</span><br /><br />\r\n      <span class="icon-paper-clip"> icon-paper-clip</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-text-height"> icon-text-height</span><br /><br />\r\n      <span class="icon-text-width"> icon-text-width</span><br /><br />\r\n      <span class="icon-align-left"> icon-align-left</span><br /><br />\r\n      <span class="icon-align-center"> icon-align-center</span><br /><br />\r\n      <span class="icon-align-right"> icon-align-right</span><br /><br />\r\n      <span class="icon-align-justify"> icon-align-justify</span><br /><br />\r\n      <span class="icon-indent-left"> icon-indent-left</span><br /><br />\r\n      <span class="icon-indent-right"> icon-indent-right</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-font"> icon-font</span><br /><br />\r\n      <span class="icon-bold"> icon-bold</span><br /><br />\r\n      <span class="icon-italic"> icon-italic</span><br /><br />\r\n      <span class="icon-strikethrough"> icon-strikethrough</span><br /><br />\r\n      <span class="icon-underline"> icon-underline</span><br /><br />\r\n      <span class="icon-link"> icon-link</span><br /><br />\r\n      <span class="icon-columns"> icon-columns</span><br /><br />\r\n      <span class="icon-table"> icon-table</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-th-large"> icon-th-large</span><br /><br />\r\n      <span class="icon-th"> icon-th</span><br /><br />\r\n      <span class="icon-th-list"> icon-th-list</span><br /><br />\r\n      <span class="icon-list"> icon-list</span><br /><br />\r\n      <span class="icon-list-ol"> icon-list-ol</span><br /><br />\r\n      <span class="icon-list-ul"> icon-list-ul</span><br /><br />\r\n      <span class="icon-list-alt"> icon-list-alt</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Directional Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-arrow-down"> icon-arrow-down</span><br /><br />\r\n      <span class="icon-arrow-left"> icon-arrow-left</span><br /><br />\r\n      <span class="icon-arrow-right"> icon-arrow-right</span><br /><br />\r\n      <span class="icon-arrow-up"> icon-arrow-up</span><br /><br />\r\n      <span class="icon-chevron-down"> icon-chevron-down</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-circle-arrow-down"> icon-circle-arrow-down</span><br /><br />\r\n      <span class="icon-circle-arrow-left"> icon-circle-arrow-left</span><br /><br />\r\n      <span class="icon-circle-arrow-right"> icon-circle-arrow-right</span><br /><br />\r\n      <span class="icon-circle-arrow-up"> icon-circle-arrow-up</span><br /><br />\r\n      <span class="icon-chevron-left"> icon-chevron-left</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-caret-down"> icon-caret-down</span><br /><br />\r\n      <span class="icon-caret-left"> icon-caret-left</span><br /><br />\r\n      <span class="icon-caret-right"> icon-caret-right</span><br /><br />\r\n      <span class="icon-caret-up"> icon-caret-up</span><br /><br />\r\n      <span class="icon-chevron-right"> icon-chevron-right</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-hand-down"> icon-hand-down</span><br /><br />\r\n      <span class="icon-hand-left"> icon-hand-left</span><br /><br />\r\n      <span class="icon-hand-right"> icon-hand-right</span><br /><br />\r\n      <span class="icon-hand-up"> icon-hand-up</span><br /><br />\r\n      <span class="icon-chevron-up"> icon-chevron-up</span><br /><br />\r\n    </div>\r\n  </div>\r\n<div class="clear"></div>\r\n  <div>\r\n    <h3>Video Player Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-play-circle"> icon-play-circle</span><br /><br />\r\n      <span class="icon-play"> icon-play</span><br /><br />\r\n      <span class="icon-pause"> icon-pause</span><br /><br />\r\n      <span class="icon-stop"> icon-stop</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-step-backward"> icon-step-backward</span><br /><br />\r\n      <span class="icon-fast-backward"> icon-fast-backward</span><br /><br />\r\n      <span class="icon-backward"> icon-backward</span><br /><br />\r\n      <span class="icon-forward"> icon-forward</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-fast-forward"> icon-fast-forward</span><br /><br />\r\n      <span class="icon-step-forward"> icon-step-forward</span><br /><br />\r\n      <span class="icon-eject"> icon-eject</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-fullscreen"> icon-fullscreen</span><br /><br />\r\n      <span class="icon-resize-full"> icon-resize-full</span><br /><br />\r\n      <span class="icon-resize-small"> icon-resize-small</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="clear"></div>\r\n  <div>\r\n    <h3>Social Icons</h3>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-phone"> icon-phone</span><br /><br />\r\n      <span class="icon-phone-sign"> icon-phone-sign</span><br /><br />\r\n      <span class="icon-facebook"> icon-facebook</span><br /><br />\r\n      <span class="icon-facebook-sign"> icon-facebook-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-twitter"> icon-twitter</span><br /><br />\r\n      <span class="icon-twitter-sign"> icon-twitter-sign</span><br /><br />\r\n      <span class="icon-github"> icon-github</span><br /><br />\r\n      <span class="icon-github-sign"> icon-github-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-linkedin"> icon-linkedin</span><br /><br />\r\n      <span class="icon-linkedin-sign"> icon-linkedin-sign</span><br /><br />\r\n      <span class="icon-pinterest"> icon-pinterest</span><br /><br />\r\n      <span class="icon-pinterest-sign"> icon-pinterest-sign</span><br /><br />\r\n    </div>\r\n  </div>\r\n  <div class="width-25 width-block">\r\n    <div class="pull-left">\r\n      <span class="icon-google-plus"> icon-google-plus</span><br /><br />\r\n      <span class="icon-google-plus-sign"> icon-google-plus-sign</span><br /><br />\r\n      <span class="icon-sign-blank"> icon-sign-blank</span><br /><br />\r\n    </div>\r\n  </div>\r\n<div class="clear"></div>\r\n</div>\r\n<pre class="prettyprint linenums">&lt;span class="icon-CLASS_NAME"&gt;\r\n  ...\r\n&lt;/span&gt;\r\n&lt;span class="icon-download"&gt;\r\n  ...\r\n&lt;/span&gt;</pre>\r\n<hr />\r\n<section id="examples">\r\n  <h2>More Examples</h2>\r\n  <p>Many examples re-used from the Twitter Bootstrap documentation.</p>\r\n  <div class="row">\r\n    <div class="width-33 width-block">\r\n      <div class="pull-left">\r\n        <div class="well">\r\n          <p>Use Font Awesome icons in:</p>\r\n          <ul class="icons">\r\n            <li><i class="icon-ok"></i>Bulleted lists (like this one)</li>\r\n            <li><i class="icon-ok"></i>Buttons</li>\r\n            <li><i class="icon-ok"></i>Button groups</li>\r\n            <li><i class="icon-ok"></i>Navigation</li>\r\n            <li><i class="icon-ok"></i>Prepended form inputs</li>\r\n            <li><i class="icon-ok"></i>And many more with Custom CSS</li>\r\n          </ul>\r\n        </div>\r\n        </div>\r\n    </div>\r\n    <div class="width-33 width-block">\r\n      <div class="pull-left">\r\n        <p>\r\n          <a class="btn" href="#"><i class="icon-refresh"></i> Refresh</a>\r\n          <a class="btn btn-success" href="#"><i class="icon-shopping-cart icon-large"></i> Checkout</a>\r\n          <a class="btn btn-danger" href="#"><i class="icon-trash icon-large"></i> Delete</a>\r\n        </p>\r\n        <p>\r\n          <a class="btn btn-large btn-primary" href="#"><i class="icon-comment"></i> Comment</a>\r\n          <a class="btn btn-small" href="#"><i class="icon-cog"></i> Settings</a>\r\n          <a class="btn btn-small btn-info" href="#"><i class="icon-info-sign"></i> More Info</a>\r\n        </p>\r\n        <div class="well" style="padding: 8px 0;">\r\n          <ul class="nav nav-list">\r\n            <li class="active"><a href="#"><i class="icon-home"></i> Home</a></li>\r\n            <li><a href="#"><i class="icon-book"></i> Library</a></li>\r\n            <li><a href="#"><i class="icon-pencil"></i> Applications</a></li>\r\n            <li><a href="#"><i class="icon-cogs"></i> Settings</a></li>\r\n          </ul>\r\n        </div>\r\n      </div>\r\n    </div>\r\n    <div class="width-33 width-block">\r\n      <div class="pull-left">\r\n      <div class="btn-toolbar">\r\n        <div class="btn-group">\r\n          <a class="btn" href="#"><i class="icon-align-left"></i></a>\r\n          <a class="btn" href="#"><i class="icon-align-center"></i></a>\r\n          <a class="btn" href="#"><i class="icon-align-right"></i></a>\r\n          <a class="btn" href="#"><i class="icon-align-justify"></i></a>\r\n        </div>\r\n        <div class="btn-group">\r\n          <a class="btn btn-primary" href="#"><i class="icon-user"></i> User</a>\r\n          <a class="btn btn-primary dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon-caret-down"></span></a>\r\n          <ul class="dropdown-menu">\r\n            <li><a href="#"><i class="icon-pencil"></i> Edit</a></li>\r\n            <li><a href="#"><i class="icon-trash"></i> Delete</a></li>\r\n            <li><a href="#"><i class="icon-ban-circle"></i> Ban</a></li>\r\n            <li class="divider"></li>\r\n            <li><a href="#"><i class="i"></i> Make admin</a></li>\r\n          </ul>\r\n        </div>\r\n      </div>\r\n      <form _lpchecked="1">\r\n        <div class="control-group">\r\n          <div class="controls">\r\n            <div class="input-prepend">\r\n              <span class="add-on"><i class="icon-envelope"></i></span>\r\n              <input class="span2" id="inputIcon" type="text" placeholder="Email address" />\r\n            </div>\r\n          </div>\r\n        </div>\r\n        <div class="control-group">\r\n          <div class="controls">\r\n            <div class="input-prepend">\r\n              <span class="add-on"><i class="icon-key"></i></span>\r\n              <input class="span2" id="inputIcon2" type="text" placeholder="Password" />\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </form>\r\n      <div>\r\n                    <span class="rating">\r\n                        <span class="star"></span><span class="star"></span><span class="star"></span><span class="star"></span><span class="star"></span>\r\n                    </span>\r\n      </div>\r\n    </div>\r\n    </div>\r\n  </div>\r\n</section>\r\n<hr />\r\n<h2>Code</h2>\r\n<section>\r\n  <div class="width-30 width-block">\r\n    <div class="pull-left">\r\n      <h3>Inline Icon</h3>\r\n      <p>Place Font Awesome icons just about anywhere with the <code>&lt;i&gt;</code> tag.</p>\r\n    </div>\r\n  </div>\r\n  <div class="width-70 width-block">\r\n    <div class="pull-left">\r\n      <div class="well">\r\n        <div style="font-size: 24px;">\r\n          <i class="icon-camera-retro"></i> icon-camera-retro\r\n        </div>\r\n      </div>\r\n  <pre class="prettyprint linenums">\r\n  &lt;div style="font-size: 24px;"&gt;\r\n    &lt;i class="icon-camera-retro"&gt;&lt;/i&gt; icon-camera-retro\r\n  &lt;/div&gt;\r\n  </pre>\r\n      <div class="alert alert-info"><i class="icon-info-sign"></i> Icon classes are echoed via CSS :before.</div>\r\n      <p>Increase the icon size by using the <code>icon-large</code> class. This increases the size by 33% relative to the font-size of the container.</p>\r\n      <div class="well">\r\n        <div style="font-size: 24px;">\r\n          <i class="icon-camera-retro icon-large"></i> icon-camera-retro\r\n        </div>\r\n      </div>\r\n  <pre class="prettyprint linenums">\r\n  &lt;div style="font-size: 24px;"&gt;\r\n    &lt;i class="icon-camera-retro icon-large"&gt;&lt;/i&gt; icon-camera-retro\r\n  &lt;/div&gt;\r\n  </pre>\r\n    </div>\r\n  </div>\r\n</section>\r\n\r\n', '', 1, 0, 0, 78, '2012-11-18 14:40:48', 968, '', '2012-11-21 08:12:24', 42, 0, '0000-00-00 00:00:00', '2012-11-18 14:40:48', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 0, 9, '', '', 1, 19, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(81, 188, 'Thumbnail & Media', 'thumbnail-media', '', '<h1 class="title">Thumbnails and Media</h1>\r\n\r\n        <section id="images">\r\n          \r\n            <h2>Images</h2>\r\n          \r\n\r\n          <p>Add classes to an <code>&lt;img&gt;</code> element to easily style images in any project.</p>\r\n          <div class="bs-example bs-example-images">\r\n            <img src="http://placehold.it/140x140" class="img-rounded" />\r\n            <img src="http://placehold.it/140x140" class="img-circle" />\r\n            <img src="http://placehold.it/140x140" class="img-polaroid" />\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;img src="..." class="img-rounded"&gt;\r\n&lt;img src="..." class="img-circle"&gt;\r\n&lt;img src="..." class="img-polaroid"&gt;\r\n</pre>\r\n          <p><span class="label label-info">Heads up!</span> <code>.img-rounded</code> and <code>.img-circle</code> do not work in IE7-8 due to lack of <code>border-radius</code> support.</p>\r\n\r\n\r\n        </section>\r\n\r\n        \r\n        <section id="thumbnails">\r\n          \r\n          <h2>Thumbnails <small>Grids of images, videos, text, and more</small></h2>\r\n          \r\n\r\n          <h3>Default thumbnails</h3>\r\n          <p>By default, Bootstrap''s thumbnails are designed to showcase linked images with minimal required markup.</p>\r\n          <div class="row-fluid">\r\n            <ul class="thumbnails">\r\n              <li class="grid3">\r\n                <div class="block">\r\n                <a href="#" class="thumbnail">\r\n                  <img src="http://placehold.it/260x180" alt="" />\r\n                </a>\r\n                </div>\r\n              </li>\r\n              <li class="grid3">\r\n                <div class="block">\r\n                <a href="#" class="thumbnail">\r\n                  <img src="http://placehold.it/260x180" alt="" />\r\n                </a>\r\n                </div>\r\n              </li>\r\n              <li class="grid3">\r\n                <div class="block">\r\n                <a href="#" class="thumbnail">\r\n                  <img src="http://placehold.it/260x180" alt="" />\r\n                </a>\r\n                </div>\r\n              </li>\r\n              <li class="grid3">\r\n                <div class="block">\r\n                <a href="#" class="thumbnail">\r\n                  <img src="http://placehold.it/260x180" alt="" />\r\n                </a>\r\n                </div>\r\n              </li>\r\n            </ul>\r\n          </div>\r\n\r\n          <h3>Highly customizable</h3>\r\n          <p>With a bit of extra markup, it''s possible to add any kind of HTML content like headings, paragraphs, or buttons into thumbnails.</p>\r\n          <div class="row-fluid">\r\n            <ul class="thumbnails">\r\n              <li class="grid4">\r\n                <div class="thumbnail block">\r\n                  <img src="http://placehold.it/300x200" alt="" />\r\n                  <div class="caption">\r\n                    <h3>Thumbnail label</h3>\r\n                    <p>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Nullam id dolor id nibh ultricies vehicula ut id elit.</p>\r\n                    <p><a href="#" class="btn btn-primary">Action</a> <a href="#" class="btn">Action</a></p>\r\n                  </div>\r\n                </div>\r\n              </li>\r\n              <li class="grid4">\r\n                <div class="thumbnail block">\r\n                  <img src="http://placehold.it/300x200" alt="" />\r\n                  <div class="caption">\r\n                    <h3>Thumbnail label</h3>\r\n                    <p>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Nullam id dolor id nibh ultricies vehicula ut id elit.</p>\r\n                    <p><a href="#" class="btn btn-primary">Action</a> <a href="#" class="btn">Action</a></p>\r\n                  </div>\r\n                </div>\r\n              </li>\r\n              <li class="grid4">\r\n                <div class="thumbnail block">\r\n                  <img src="http://placehold.it/300x200" alt="" />\r\n                  <div class="caption">\r\n                    <h3>Thumbnail label</h3>\r\n                    <p>Cras justo odio, dapibus ac facilisis in, egestas eget quam. Donec id elit non mi porta gravida at eget metus. Nullam id dolor id nibh ultricies vehicula ut id elit.</p>\r\n                    <p><a href="#" class="btn btn-primary">Action</a> <a href="#" class="btn">Action</a></p>\r\n                  </div>\r\n                </div>\r\n              </li>\r\n            </ul>\r\n          </div>\r\n\r\n          <h4>Why use thumbnails</h4>\r\n          <p>Thumbnails (previously <code>.media-grid</code> up until v1.4) are great for grids of photos or videos, image search results, retail products, portfolios, and much more. They can be links or static content.</p>\r\n\r\n          <h4>Simple, flexible markup</h4>\r\n          <p>Thumbnail markup is simple&mdash;a <code>ul</code> with any number of <code>li</code> elements is all that is required. It''s also super flexible, allowing for any type of content with just a bit more markup to wrap your contents.</p>\r\n\r\n          <h4>Uses grid column sizes</h4>\r\n          <p>Lastly, the thumbnails component uses existing grid system classes&mdash;like <code>.grid2</code> or <code>.grid3</code>&mdash;for control of thumbnail dimensions.</p>\r\n\r\n          <h3>Markup</h2>\r\n          <p>As mentioned previously, the required markup for thumbnails is light and straightforward. Here''s a look at the default setup <strong>for linked images</strong>:</p>\r\n<pre class="prettyprint linenums">\r\n&lt;ul class="thumbnails block"&gt;\r\n  &lt;li class="grid4"&gt;\r\n    &lt;a href="#" class="thumbnail"&gt;\r\n      &lt;img src="http://placehold.it/300x200" alt=""&gt;\r\n    &lt;/a&gt;\r\n  &lt;/li&gt;\r\n  ...\r\n&lt;/ul&gt;\r\n</pre>\r\n          <p>For custom HTML content in thumbnails, the markup changes slightly. To allow block level content anywhere, we swap the <code>&lt;a&gt;</code> for a <code>&lt;div&gt;</code> like so:</p>\r\n<pre class="prettyprint linenums">\r\n&lt;ul class="thumbnails"&gt;\r\n  &lt;li class="grid4"&gt;\r\n    &lt;div class="thumbnail block"&gt;\r\n      &lt;img src="http://placehold.it/300x200" alt=""&gt;\r\n      &lt;h3&gt;Thumbnail label&lt;/h3&gt;\r\n      &lt;p&gt;Thumbnail caption...&lt;/p&gt;\r\n    &lt;/div&gt;\r\n  &lt;/li&gt;\r\n  ...\r\n&lt;/ul&gt;\r\n</pre>\r\n\r\n          <h3>More examples</h3>\r\n          <p>Explore all your options with the various grid classes available to you. You can also mix and match different sizes.</p>\r\n          <ul class="thumbnails row-fluid">\r\n            <li class="grid4">\r\n              <div class="block">\r\n              <a href="#" class="thumbnail">\r\n                <img src="http://placehold.it/360x270" alt="" />\r\n              </a>\r\n              </div>\r\n            </li>\r\n            <li class="grid3">\r\n              <div class="block">\r\n              <a href="#" class="thumbnail">\r\n                <img src="http://placehold.it/260x120" alt="" />\r\n              </a>\r\n              </div>\r\n            </li>\r\n            <li class="grid2">\r\n              <div class="block">\r\n              <a href="#" class="thumbnail">\r\n                <img src="http://placehold.it/160x120" alt="" />\r\n              </a>\r\n              </div>\r\n            </li>\r\n            <li class="grid3">\r\n              <div class="block">\r\n              <a href="#" class="thumbnail">\r\n                <img src="http://placehold.it/260x120" alt="" />\r\n              </a>\r\n              </div>\r\n            </li>\r\n            <li class="grid2">\r\n              <div class="block">\r\n              <a href="#" class="thumbnail">\r\n                <img src="http://placehold.it/160x120" alt="" />\r\n              </a>\r\n              </div>\r\n            </li>\r\n          </ul>\r\n\r\n        </section>\r\n\r\n        \r\n        <section id="media">\r\n          \r\n            <h2 class="title">Media object</h2>\r\n          \r\n          <p class="lead">Abstract object styles for building various types of components (like blog comments, Tweets, etc) that feature a left- or right-aligned image alongside textual content.</p>\r\n\r\n          <h3>Default example</h3>\r\n          <p>The default media allow to float a media object (images, video, audio) to the left or right of a content block.</p>\r\n          <div class="bs-example">\r\n            <div class="media">\r\n              <a class="pull-left" href="#">\r\n                <img class="media-object" src="http://placehold.it/64x64" />\r\n              </a>\r\n              <div class="media-body">\r\n                <h4 class="media-heading">Media heading</h4>\r\n                Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis. Fusce condimentum nunc ac nisi vulputate fringilla. Donec lacinia congue felis in faucibus.\r\n              </div>\r\n            </div>\r\n            <div class="media">\r\n              <a class="pull-left" href="#">\r\n                <img class="media-object" src="http://placehold.it/64x64" />\r\n              </a>\r\n              <div class="media-body">\r\n                <h4 class="media-heading">Media heading</h4>\r\n                Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis. Fusce condimentum nunc ac nisi vulputate fringilla. Donec lacinia congue felis in faucibus.\r\n                <div class="media">\r\n                  <a class="pull-left" href="#">\r\n                    <img class="media-object" src="http://placehold.it/64x64" />\r\n                  </a>\r\n                  <div class="media-body">\r\n                    <h4 class="media-heading">Media heading</h4>\r\n                    Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis. Fusce condimentum nunc ac nisi vulputate fringilla. Donec lacinia congue felis in faucibus.\r\n                  </div>\r\n                </div>\r\n              </div>\r\n            </div>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="media"&gt;\r\n  &lt;a class="pull-left" href="#"&gt;\r\n    &lt;img class="media-object" src="http://placehold.it/64x64"&gt;\r\n  &lt;/a&gt;\r\n  &lt;div class="media-body"&gt;\r\n    &lt;h4 class="media-heading"&gt;Media heading&lt;/h4&gt;\r\n    ...\r\n\r\n    &lt;!-- Nested media object --&gt;\r\n    &lt;div class="media"&gt;\r\n      ...\r\n    &lt;/div&gt;\r\n  &lt;/div&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n\r\n\r\n          <hr class="bs-separator" />\r\n\r\n\r\n          <h3>Media list</h3>\r\n          <p>With a bit of extra markup, you can use media inside list (useful for comment threads or articles lists).</p>\r\n          <div class="bs-example">\r\n            <ul class="media-list">\r\n              <li class="media">\r\n                <a class="pull-left" href="#">\r\n                  <img class="media-object" src="http://placehold.it/64x64" />\r\n                </a>\r\n                <div class="media-body">\r\n                  <h4 class="media-heading">Media heading</h4>\r\n                  <p>Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis.</p>\r\n                  \r\n                  <div class="media">\r\n                    <a class="pull-left" href="#">\r\n                      <img class="media-object" src="http://placehold.it/64x64" />\r\n                    </a>\r\n                    <div class="media-body">\r\n                      <h4 class="media-heading">Nested media heading</h4>\r\n                      Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis.\r\n                      \r\n                      <div class="media">\r\n                        <a class="pull-left" href="#">\r\n                          <img class="media-object" src="http://placehold.it/64x64" />\r\n                        </a>\r\n                        <div class="media-body">\r\n                          <h4 class="media-heading">Nested media heading</h4>\r\n                          Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis.\r\n                        </div>\r\n                      </div>\r\n                    </div>\r\n                  </div>\r\n                  \r\n                  <div class="media">\r\n                    <a class="pull-left" href="#">\r\n                      <img class="media-object" src="http://placehold.it/64x64" />\r\n                    </a>\r\n                    <div class="media-body">\r\n                      <h4 class="media-heading">Nested media heading</h4>\r\n                      Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis.\r\n                    </div>\r\n                  </div>\r\n                </div>\r\n              </li>\r\n              <li class="media">\r\n                <a class="pull-right" href="#">\r\n                  <img class="media-object" src="http://placehold.it/64x64" />\r\n                </a>\r\n                <div class="media-body">\r\n                  <h4 class="media-heading">Media heading</h4>\r\n                  Cras sit amet nibh libero, in gravida nulla. Nulla vel metus scelerisque ante sollicitudin commodo. Cras purus odio, vestibulum in vulputate at, tempus viverra turpis.\r\n                </div>\r\n              </li>\r\n            </ul>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;ul class="media-list"&gt;\r\n  &lt;li class="media"&gt;\r\n    &lt;a class="pull-left" href="#"&gt;\r\n      &lt;img class="media-object" src="http://placehold.it/64x64"&gt;\r\n    &lt;/a&gt;\r\n    &lt;div class="media-body"&gt;\r\n      &lt;h4 class="media-heading"&gt;Media heading&lt;/h4&gt;\r\n      ...\r\n\r\n      &lt;!-- Nested media object --&gt;\r\n      &lt;div class="media"&gt;\r\n        ...\r\n     &lt;/div&gt;\r\n    &lt;/div&gt;\r\n  &lt;/li&gt;\r\n&lt;/ul&gt;\r\n</pre>\r\n\r\n</section>', '', 1, 0, 0, 78, '2012-11-21 08:27:31', 968, '', '2012-11-21 09:06:32', 42, 0, '0000-00-00 00:00:00', '2012-11-21 08:27:31', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 2, '', '', 1, 10, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(82, 189, 'Label & Badges', 'label-badges', '', '\r\n        <section id="labels-badges">\r\n          \r\n            <h1 class="title">Labels and badges</h1>\r\n          \r\n          <h2>Labels</h2>\r\n          <table class="table table-bordered table-striped">\r\n            <thead>\r\n              <tr>\r\n                <th>Labels</th>\r\n                <th>Markup</th>\r\n              </tr>\r\n            </thead>\r\n            <tbody>\r\n              <tr>\r\n                <td>\r\n                  <span class="label">Default</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="label"&gt;Default&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  <span class="label label-success">Success</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="label label-success"&gt;Success&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  <span class="label label-warning">Warning</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="label label-warning"&gt;Warning&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  <span class="label label-important">Important</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="label label-important"&gt;Important&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  <span class="label label-info">Info</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="label label-info"&gt;Info&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  <span class="label label-inverse">Inverse</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="label label-inverse"&gt;Inverse&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n            </tbody>\r\n          </table>\r\n\r\n          <h2>Badges</h2>\r\n          <table class="table table-bordered table-striped">\r\n            <thead>\r\n              <tr>\r\n                <th>Name</th>\r\n                <th>Example</th>\r\n                <th>Markup</th>\r\n              </tr>\r\n            </thead>\r\n            <tbody>\r\n              <tr>\r\n                <td>\r\n                  Default\r\n                </td>\r\n                <td>\r\n                  <span class="badge">1</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="badge"&gt;1&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  Success\r\n                </td>\r\n                <td>\r\n                  <span class="badge badge-success">2</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="badge badge-success"&gt;2&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  Warning\r\n                </td>\r\n                <td>\r\n                  <span class="badge badge-warning">4</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="badge badge-warning"&gt;4&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  Important\r\n                </td>\r\n                <td>\r\n                  <span class="badge badge-important">6</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="badge badge-important"&gt;6&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  Info\r\n                </td>\r\n                <td>\r\n                  <span class="badge badge-info">8</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="badge badge-info"&gt;8&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n              <tr>\r\n                <td>\r\n                  Inverse\r\n                </td>\r\n                <td>\r\n                  <span class="badge badge-inverse">10</span>\r\n                </td>\r\n                <td>\r\n                  <code>&lt;span class="badge badge-inverse"&gt;10&lt;/span&gt;</code>\r\n                </td>\r\n              </tr>\r\n            </tbody>\r\n          </table>\r\n\r\n        </section>', '', 1, 0, 0, 78, '2012-11-21 08:54:20', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2012-11-21 08:54:20', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 1, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(83, 190, 'Misc', 'misc', '', ' <h1 class="title">Miscellaneous <small>Lightweight utility components</small></h1>\r\n \r\n        <section id="typography">\r\n          \r\n            <h2>Typographic components</h2>\r\n          \r\n\r\n          <h3>Hero unit</h3>\r\n          <p>A lightweight, flexible component to showcase key content on your site. It works well on marketing and content-heavy sites.</p>\r\n          <div class="bs-example">\r\n            <div class="hero-unit">\r\n              <h1>Hello, world!</h1>\r\n              <p>This is a simple hero unit, a simple jumbotron-style component for calling extra attention to featured content or information.</p>\r\n              <p><a class="btn btn-primary btn-large">Learn more</a></p>\r\n            </div>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="hero-unit"&gt;\r\n  &lt;h1&gt;Heading&lt;/h1&gt;\r\n  &lt;p&gt;Tagline&lt;/p&gt;\r\n  &lt;p&gt;\r\n    &lt;a class="btn btn-primary btn-large"&gt;\r\n      Learn more\r\n    &lt;/a&gt;\r\n  &lt;/p&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n\r\n          <h3>Page header</h3>\r\n          <p>A simple shell for an <code>h1</code> to appropriately space out and segment sections of content on a page. It can utilize the <code>h1</code>''s default <code>small</code>, element as well most other components (with additional styles).</p>\r\n          <div class="bs-example">\r\n            <div class="page-header">\r\n              <h1>Example page header <small>Subtext for header</small></h1>\r\n            </div>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="page-header"&gt;\r\n  &lt;h1&gt;Example page header &lt;small&gt;Subtext for header&lt;/small&gt;&lt;/h1&gt;\r\n&lt;/div&gt;\r\n</pre>\r\n\r\n        </section>\r\n\r\n        \r\n        <section id="misc">\r\n          \r\n          <h2>Wells</h2>\r\n          <p>Use the well as a simple effect on an element to give it an inset effect.</p>\r\n          <div class="bs-example">\r\n            <div class="well">\r\n              Look, I''m in a well!\r\n            </div>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="well"&gt;\r\n  ...\r\n&lt;/div&gt;\r\n</pre>\r\n          <h3>Optional classes</h3>\r\n          <p>Control padding and rounded corners with two optional modifier classes.</p>\r\n          <div class="bs-example">\r\n            <div class="well well-large">\r\n              Look, I''m in a well!\r\n            </div>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="well well-large"&gt;\r\n  ...\r\n&lt;/div&gt;\r\n</pre>\r\n          <div class="bs-example">\r\n            <div class="well well-small">\r\n              Look, I''m in a well!\r\n            </div>\r\n          </div>\r\n<pre class="prettyprint linenums">\r\n&lt;div class="well well-small"&gt;\r\n  ...\r\n&lt;/div&gt;\r\n</pre>\r\n\r\n          <h2>Helper classes</h2>\r\n          <p>Simple, focused classes for small display or behavior tweaks.</p>\r\n\r\n          <h4>.pull-left</h4>\r\n          <p>Float an element left</p>\r\n<pre class="prettyprint linenums">\r\nclass="pull-left"\r\n</pre>\r\n<pre class="prettyprint linenums">\r\n.pull-left {\r\n  float: left;\r\n  marginr-right: 15px;\r\n}\r\n</pre>\r\n\r\n          <h4>.pull-right</h4>\r\n          <p>Float an element right</p>\r\n<pre class="prettyprint linenums">\r\nclass="pull-right"\r\n</pre>\r\n<pre class="prettyprint linenums">\r\n.pull-right {\r\n  float: right;\r\n  margin-left: 15px;\r\n}\r\n</pre>\r\n\r\n          <h4>.muted</h4>\r\n          <p>Change an element''s color to <code>#999</code></p>\r\n<pre class="prettyprint linenums">\r\nclass="muted"\r\n</pre>\r\n<pre class="prettyprint linenums">\r\n.muted {\r\n  color: #999;\r\n}\r\n</pre>\r\n\r\n          <h4>.clearfix</h4>\r\n          <p>Clear the <code>float</code> on any element</p>\r\n<pre class="prettyprint linenums">\r\nclass="clearfix"\r\n</pre>\r\n<pre class="prettyprint linenums">\r\n.clearfix {\r\n  *zoom: 1;\r\n  &:before,\r\n  &:after {\r\n    display: table;\r\n    content: "";\r\n  }\r\n  &:after {\r\n    clear: both;\r\n  }\r\n}\r\n</pre>\r\n\r\n        </section>', '', 1, 0, 0, 78, '2012-11-21 09:00:40', 968, '', '2012-11-21 09:02:15', 42, 0, '0000-00-00 00:00:00', '2012-11-21 09:00:40', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 0, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(84, 192, 'Expose Framework', 'expose-framework', '', '<p>Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', 1, 0, 0, 79, '2013-01-20 02:56:09', 968, '', '2013-08-28 10:43:15', 968, 0, '0000-00-00 00:00:00', '2013-01-20 02:56:09', '0000-00-00 00:00:00', '{"image_intro":"images\\/slider\\/web-design.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/slider\\/web-design.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(85, 193, 'Rich Theme Documentation', 'rich-theme-documentation', '', '<p>Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', 1, 0, 0, 79, '2013-01-20 02:58:02', 968, '', '2013-08-28 10:44:08', 968, 0, '0000-00-00 00:00:00', '2013-01-20 02:58:02', '0000-00-00 00:00:00', '{"image_intro":"images\\/slider\\/clip.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/slider\\/clip.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(86, 194, 'Build Your Site Within A Minute', 'build-your-site-within-a-minute', '', '<p>Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', 0, 0, 0, 79, '2013-01-20 02:59:11', 968, '', '2013-06-22 08:24:29', 154, 0, '0000-00-00 00:00:00', '2013-01-20 02:59:11', '0000-00-00 00:00:00', '{"image_intro":"images\\/slider\\/slide1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(87, 195, 'Joomla ecommerce template', 'joomla-ecommerce-template', '', '<p>Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', 1, 0, 0, 79, '2013-01-20 18:44:57', 968, '', '2013-08-28 10:42:18', 968, 0, '0000-00-00 00:00:00', '2013-01-20 18:44:57', '0000-00-00 00:00:00', '{"image_intro":"images\\/slider\\/book.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/slider\\/book.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(88, 197, 'Phasellus', 'anonymous', '', '<p>Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', -2, 0, 0, 80, '2013-01-20 23:31:16', 968, '', '2013-07-02 08:01:59', 154, 0, '0000-00-00 00:00:00', '2013-01-20 23:31:16', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/campus-gallery2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/campus-gallery2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(89, 198, 'Gravida odio', 'matheno', '', '<p>Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec.</p>', '', -2, 0, 0, 80, '2013-01-20 23:31:55', 968, '', '2013-07-02 07:57:50', 154, 0, '0000-00-00 00:00:00', '2013-01-20 23:31:55', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/campus-gallery1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/campus-gallery1.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(90, 199, 'Parallax', 'parallax', '', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum. ', '', -2, 0, 0, 80, '2013-01-20 23:32:22', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-20 23:32:22', '0000-00-00 00:00:00', '{"image_intro":"images\\/recent-work\\/parallax.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 5, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(91, 200, 'Vestibulum', 'crisp', '', '<p>Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', -2, 0, 0, 80, '2013-01-20 23:32:48', 968, '', '2013-07-02 08:28:07', 154, 0, '0000-00-00 00:00:00', '2013-01-20 23:32:48', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/campus-gallery4.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/campus-gallery4.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(92, 201, 'Streamx', 'streamx', '', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum. ', '', -2, 0, 0, 80, '2013-01-20 23:33:20', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-20 23:33:20', '0000-00-00 00:00:00', '{"image_intro":"images\\/recent-work\\/streamx.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(93, 202, 'Maximus', 'maximus', '', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum. ', '', -2, 0, 0, 80, '2013-01-20 23:33:46', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-20 23:33:46', '0000-00-00 00:00:00', '{"image_intro":"images\\/recent-work\\/maximus.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(94, 203, 'Vibration', 'vibration', '', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum. ', '', -2, 0, 0, 80, '2013-01-20 23:34:10', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-20 23:34:10', '0000-00-00 00:00:00', '{"image_intro":"images\\/recent-work\\/vibration.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(95, 204, 'Scelerisque', 'extreme', '', '<p>Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, scelerisque et feugiat a, rutrum et nisi. Sed sed felis turpis. Donec libero mi, vestibulum nec commodo ac, dignissim non sem. Mauris viverra velit vel justo iaculis ut gravida odio vulputate. Nam ut eros id magna blandit interdum. Nunc varius cursus bibendum.</p>', '', -2, 0, 0, 80, '2013-01-20 23:34:49', 968, '', '2013-07-02 08:04:42', 154, 0, '0000-00-00 00:00:00', '2013-01-20 23:34:49', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/campus-gallery3.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/campus-gallery3.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(96, 206, 'John', 'john', '', '<p>Developer</p>', '', -2, 0, 0, 81, '2013-01-21 00:36:41', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-21 00:36:41', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/john.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 7, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(97, 207, 'Ricardo', 'ricardo', '', '<p>Designer</p>', '', -2, 0, 0, 81, '2013-01-21 00:37:13', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-21 00:37:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/ricardo.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 6, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(98, 208, 'Bob', 'bob', '', '<p>Programmer</p>', '', -2, 0, 0, 81, '2013-01-21 00:55:23', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-21 00:55:23', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/bob.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 5, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(99, 209, 'Biddut', 'biddut', '', '<p>Article Writter</p>', '', -2, 0, 0, 81, '2013-01-21 00:56:14', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-21 00:56:14', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/biddut.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 4, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(100, 210, 'Rakib', 'rakib', '', '<p>Designer</p>', '', -2, 0, 0, 81, '2013-01-21 00:57:39', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-21 00:57:39', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/rakib.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(101, 211, 'Morgan', 'morgan', '', '<p>Chief Developer</p>', '', -2, 0, 0, 81, '2013-01-21 00:59:26', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-21 00:59:26', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/morgan.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(102, 212, 'Bablu', 'bablu', '', '<p>SEO Expert</p>', '', -2, 0, 0, 81, '2013-01-21 01:00:20', 968, '', '2013-02-04 11:40:22', 42, 0, '0000-00-00 00:00:00', '2013-01-21 01:00:20', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/bablu.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(103, 215, 'Who we are', 'who-we-are', '', '<p>Ut fermentum felis magna, a mattis metus fermentum ac. Cras feugiat condimentum sapien in fringilla. In iaculis congue bibendum. In hac habitasse platea dictumst. Nulla tempus tellus a lorem mollis volutpat. Etiam nec elit a nisl commodo cursus eget a orci. Quisque elementum quam pulvinar sollicitudin luctus.</p>\r\n  <blockquote>In scelerisque sapien sapien, et ultricies nibh scelerisque sed. Fusce vitae tortor ipsum. Quisque vel fermentum lacus. Sed sit amet nulla congue, congue justo sit amet, semper diam. Nulla auctor sapien sed enim vehicula congue. Phasellus quis quam augue. </blockquote>\r\n<p>Aenean commodo at massa nec porttitor. Suspendisse malesuada dui in blandit tincidunt. Quisque bibendum commodo aliquet. Sed lacus odio, dapibus laoreet erat ac, placerat dapibus metus. Quisque quis pretium magna. Nam rhoncus eleifend mi, eget pulvinar justo blandit ac. Fusce malesuada consectetur accumsan.</p>', '', -2, 0, 0, 82, '2013-01-30 08:26:07', 968, '', '2013-07-17 09:20:49', 154, 0, '0000-00-00 00:00:00', '2013-01-30 08:26:07', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 5, 0, 2, '', '', 1, 87, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(104, 216, 'Our Service', 'our-service', '', '<div class="clearfix">\r\n<div class="width-33" style="float: left;"><img src="images/tab-1.png" border="0" alt="expose framework" title="expose framework" /></div>\r\n<div class="width-60" style="float: right;">\r\n<h2>iPhone Application Development</h2>\r\n<p>Etiam nec elit semper nulla molestie pellentesque. Sed ac dui lacus, non posuere nisl. Donec sit amet pulvinar neque. Suspendisse vel erat sit amet mauris posuere bibendum.Praesent odio sapien, commodo id luctus et, blandit vel odio. Cum sociis natoque penatibus et.</p>\r\n<ul class="width-33 nomargin list-arrow" style="float: left;">\r\n<li><a href="#">Custom UI</a></li>\r\n<li><a href="#">Branding</a></li>\r\n</ul>\r\n<ul class="width-33 nomargin list-arrow" style="float: left;">\r\n<li><a href="#">Custom UI</a></li>\r\n<li><a href="#">Branding</a></li>\r\n</ul>\r\n<ul class="width-33 nomargin list-arrow" style="float: left;">\r\n<li><a href="#">Custom UI</a></li>\r\n<li><a href="#">Branding</a></li>\r\n</ul>\r\n<div class="clear"> </div>\r\n<p style="text-align: center; margin-top: 15px;"><a class="btn" href="#" style="margin-right: 25px;">Read More</a> <a class=" btn btn-primary" href="#">Join Us</a></p>\r\n</div>\r\n</div>\r\n<div class="clearfix" style="margin-top: 30px;">\r\n<div class="width-60" style="float: left;">\r\n<h2>Providing Web Solution</h2>\r\n<p>Etiam nec elit semper nulla molestie pellentesque. Sed ac dui lacus, non posuere nisl. Donec sit amet pulvinar neque. Suspendisse vel erat sit amet mauris posuere bibendum.Praesent odio sapien, commodo id luctus et, blandit vel odio. Cum sociis natoque penatibus et.</p>\r\n<ul class="width-33 nomargin list-arrow" style="float: left;">\r\n<li><a href="#">Custom UI</a></li>\r\n<li><a href="#">Branding</a></li>\r\n</ul>\r\n<ul class="width-33 nomargin list-arrow" style="float: left;">\r\n<li><a href="#">Custom UI</a></li>\r\n<li><a href="#">Branding</a></li>\r\n</ul>\r\n<ul class="width-33 nomargin list-arrow" style="float: left;">\r\n<li><a href="#">Custom UI</a></li>\r\n<li><a href="#">Branding</a></li>\r\n</ul>\r\n<div class="clear"> </div>\r\n<p style="text-align: center; margin-top: 15px;"><a class="btn" href="#" style="margin-right: 25px;">Read More</a> <a class=" btn btn-primary" href="#">Join Us</a></p>\r\n</div>\r\n<div class="width-33" style="float: right;"><img src="images/slider/pie-chart.png" border="0" alt="expose framework" title="expose framework" /></div>\r\n</div>', '', -2, 0, 0, 82, '2013-01-30 08:26:43', 968, '', '2013-02-05 07:56:31', 42, 0, '0000-00-00 00:00:00', '2013-01-30 08:26:43', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 0, 1, '', '', 1, 39, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(105, 217, 'Portfolio', 'portfolio', '', '<p>This is the place where you will get a deeper look over the works we did.</p>', '', -2, 0, 0, 82, '2013-01-30 08:27:45', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-01-30 08:27:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 0, '', '', 1, 163, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(106, 219, 'Extensions', 'extensions', '', '<div style="margin-top: 50px; margin-bottom: 20px;"><img class="pull-left" src="images/extensions/xpertscroller.png" border="0" alt="" width="141" height="142" style="margin-bottom: 25px;" />\r\n<h2>Xpert Scroller</h2>\r\n<p>Xpert Scroller, probably the best tool to present articles for Joomla! Numerous options and possibilities of formatting styles enables Xpert Scroller to be an complex awesome tool for making webpage contents more attractive it also supports K2 component.</p>\r\n<a class="btn btn-small btn-primary" href="http://www.themexpert.com/joomla/extensions/xpert-scroller" target="_blank">Details</a> <a class="btn btn-small btn-primary" href="http://www.themexpert.com/category/11-xpert-scroller" target="_blank">Downlod Now</a> <a class="btn btn-small btn-primary" href="http://www.themexpert.com/forum/forum?f=27" target="_blank">Support</a></div>\r\n<div style="margin-top: 50px;"><img class="pull-left" src="images/extensions/txtabs.png" border="0" alt="" width="141" height="142" />\r\n<h2>Xpert Tabs</h2>\r\n<p>Xpert Tabs, a tab module for presenting contents in a beautiful way in Joomla! Websites. Available in 5 presets, it should be quite adaptive in any type of sites due to its power to load any type contents such as K2, Joomla! articles, modules etc. with different effect.</p>\r\n<a class="btn btn-small btn-primary" href="http://www.themexpert.com/joomla/extensions/xpert-tabs" target="_blank">Details</a> <a class="btn btn-small btn-primary" href="http://www.themexpert.com/category/13-xpert-tabs" target="_blank">Download Now</a> <a class="btn btn-small btn-primary" href="http://www.themexpert.com/forum/forum?f=35&amp;sid=5704ff1803f90ca41b9801a34dbcdf65" target="_blank">Support</a></div>\r\n<div><img class="pull-left" src="images/extensions/xpertgallery.png" border="0" alt="" width="141" height="142" />\r\n<h2>Xpert Gallery</h2>\r\n<p>Xpert Gallery is the next generation gallery module for Joomla. It turns your Joomla content with a beautiful sortable gallery layout. Not only Joomla it support others 3pd component such as K2, EasyBlock, Flickr etc.</p>\r\n<a class="btn btn-small btn-primary" href="#" target="_blank">Details</a> <a class="btn btn-small btn-primary" href="#" target="_blank">Download Now</a> <a class="btn btn-small btn-primary" href="#" target="_blank">Support</a></div>', '', -2, 0, 0, 83, '2013-02-04 09:40:00', 968, '', '2013-02-04 10:13:16', 42, 0, '0000-00-00 00:00:00', '2013-02-04 09:40:00', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 0, 5, '', '', 1, 17, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(107, 220, 'Xpert Slider', 'xpert-slider', '', '<img class="pull-left img-polaroid" src="images/extensions/xpert-slider.jpg" />\r\n<p>A Revolutionary responsive slideshow module made with HTML5, CSS3 and jQuery. Tons of features and animation stand it outside of the crowd. We completely revamped module admin interface and made it super simple and easy to use. With you in mind we made the possibly the best slideshow module for Joomla!</p>\r\n<p>With support of <a target="_blank" href="http://www.getk2.org">K2</a> and <a target="_blank" href="http://stackideas.com/">Easy Blog</a> and of-course Joomla content component, you will get an new experience of using slideshow module inside Joomla!. Built on top of jQuery <a target="_blank" href="http://www.pixedelic.com/plugins/camera/">Camera plugin</a></p>\r\n<p><a class="btn" href="http://www.themexpert.com/joomla-extensions/xpert-slider" target="_blank" style="margin-right: 8px;">Details</a> <a class="btn" href="http://demo.themexpert.com/extensions" target="_blank" style="margin-right: 8px;">Demo</a> <a class="btn" href="http://www.themexpert.com/joomla-extensions/download" target="_blank">Download</a></p>\r\n\r\n', '', 1, 0, 0, 83, '2013-02-04 09:41:18', 968, '', '2013-09-06 12:48:16', 968, 0, '0000-00-00 00:00:00', '2013-02-04 09:41:18', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 16, 0, 4, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(108, 221, 'Xpert Scroller', 'xpert-scroller', '', '<img class="pull-left img-polaroid" src="images/extensions/xpert-scroller.jpg" />\r\n<p>XpertScroller is our next generation extensions based on the GNU General Public License V2. Based on the experiences we have gathered and through hard practice, we created probably the best tool to present articles for Joomla! Numerous options and possibilities of formatting styles enables XpertScroller to be an complex awesome tool for making webpage contents more attractive.</p>\r\n<p>As it supports K2 component, XpertScroller allows the user to choose between using a standard Joomla! article manager and K2 component which offers more appealing possibilities. Horizontal and Vertical layout options will add more artistic look to your site! To give you same experience on both joomla version we''ve implemented J3.0 UI in J2.5 version.</p>\r\n<p><a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/xpert-scroller" target="_blank">Details</a> <a class="btn btn-plus" href="http://demo.themexpert.com/extensions" target="_blank">Demo</a> <a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/download" target="_blank">Download</a></p>', '', -2, 0, 0, 83, '2013-02-04 09:42:04', 968, '', '2013-07-17 05:58:43', 154, 0, '0000-00-00 00:00:00', '2013-02-04 09:42:04', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 0, 3, '', '', 1, 14, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(109, 222, 'Xpert Tabs', 'xpert-tabs', '', '<img class="pull-left img-polaroid" src="images/extensions/xpert-tabs.jpg" />\r\n<p>ThemeXpert is delighted to present its new extension Xpert Tabs, a tab module for presenting contents in a beautiful way in Joomla! Websites. Available in 5 presets, it should be quite adaptive in any type of sites due to its power to load any type contents such as K2, Joomla! articles, modules etc. with different effect.</p>\r\n<p>It is sure to make any site more attractive by positioning top or bottom and easy customization. Xpert tabs has even more features as auto play option and title minimization.</p>\r\n<p><a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/xpert-tabs" target="_blank" style="margin-right: 8px;">Details</a> <a class="btn btn-plus" href="http://demo.themexpert.com/extensions" target="_blank" style="margin-right: 8px;">Demo</a> <a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/download" target="_blank">Download</a></p>', '', 1, 0, 0, 83, '2013-02-04 09:42:57', 968, '', '2013-09-06 12:49:38', 968, 0, '0000-00-00 00:00:00', '2013-02-04 09:42:57', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 0, 2, '', '', 1, 16, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(110, 223, 'Kamal', 'kamal', '', '<p>Programmer</p>', '', -2, 0, 0, 81, '2013-02-04 11:41:27', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-02-04 11:41:27', '0000-00-00 00:00:00', '{"image_intro":"images\\/team\\/kamal.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(111, 225, 'Flexible Layout System', 'lorem-ipsum-dolor', '', '<p>Cras ut est nisi. Aliquam fermentum, odio sed malesuada elementum, lorem felis pulvinar metus, sit amet dictum velit nisl vel ipsum. Nulla sed quam et eros convallis rhoncus. Aenean quis urna vitae elit sollicitudin pretium. Maecenas vitae dictum nisi. Sed vitae turpis sem.</p>\r\n', '\r\n<p>Pellentesque adipiscing ante ipsum, auctor bibendum nunc tristique sit amet. Suspendisse ligula mauris, lobortis vitae ipsum sed, ullamcorper suscipit lacus. Proin porta quam vel semper sollicitudin. In hac habitasse platea dictumst. Integer ultrices tortor nec ligula luctus, nec euismod nulla rutrum. Donec vitae accumsan diam, et facilisis dui. Nulla faucibus tempus placerat. Sed quam ligula, commodo at facilisis non, fringilla ut magna. Nunc tristique cursus volutpat. Maecenas sollicitudin, turpis tempus condimentum accumsan, nisl risus vulputate magna, in consectetur dolor nulla vitae sapien.</p>', -2, 0, 0, 84, '2013-06-20 12:41:12', 968, '', '2013-07-20 18:14:51', 154, 0, '0000-00-00 00:00:00', '2013-06-20 12:41:12', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/frontpage-1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/frontpage-1.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(112, 226, 'SEO Optimized ', 'phasellus-cursus-quam', '', '<p>Quisque ipsum felis, interdum id viverra eget, mattis id elit. Maecenas massa orci, mattis eu placerat vitae, varius ac augue. Vivamus blandit, enim vitae ultrices rutrum, ante tortor varius dolor, in sagittis ligula odio a est. Etiam nibh enim, scelerisque at diam sed, accumsan malesuada nisi.</p>\r\n', '\r\n<p>Interdum et malesuada fames ac ante ipsum primis in faucibus. Phasellus cursus quam pulvinar dictum pretium. Praesent feugiat malesuada nisl vel tincidunt. Praesent eget ipsum vel erat adipiscing rutrum. Quisque nec est non elit congue vulputate a quis dolor. Nulla tristique suscipit ultrices. Proin eu justo at urna bibendum euismod. In eu urna sem. Donec ac dignissim purus, eu adipiscing risus. Nunc est est, tempus non augue et, porta dapibus ante. Maecenas eu tempor magna. Nullam elit tortor, placerat id libero porttitor, euismod dignissim nisl. Cras et enim justo.</p>', -2, 0, 0, 84, '2013-06-20 12:42:19', 968, '', '2013-07-20 18:15:14', 154, 0, '0000-00-00 00:00:00', '2013-06-20 12:42:19', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/frontpage-2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/frontpage-2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 0, '', '', 1, 34, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(113, 228, 'Fast Loading', 'fast-loading', '', '<p>Nulla faucibus tempus placerat. Sed quam ligula, commodo at facilisis non, fringilla ut magna. Nunc tristique cursus volutpat. Maecenas sollicitudin, turpis tempus condimentum accumsan, nisl risus vulputate magna, in consectetur dolor nulla vitae sapien. Quisque ipsum felis, interdum id viverra eget, mattis id elit. Maecenas massa orci, mattis eu placerat vitae, varius ac augue. Vivamus blandit, enim vitae ultrices rutrum, ante tortor varius dolor, in sagittis ligula odio a est. Etiam nibh enim, scelerisque at diam sed, accumsan malesuada nisi. Interdum et malesuada fames ac ante ipsum primis in faucibus. Phasellus cursus quam pulvinar dictum pretium.</p>', '', -2, 0, 0, 85, '2013-06-22 07:50:24', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-06-22 07:50:24', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(114, 229, 'Cross browser Compatible', 'cross-browser-compatible', '', '<p>Proin eu justo at urna bibendum euismod. In eu urna sem. Donec ac dignissim purus, eu adipiscing risus. Nunc est est, tempus non augue et, porta dapibus ante. Maecenas eu tempor magna. Nullam elit tortor, placerat id libero porttitor, euismod dignissim nisl. Cras et enim justo. Suspendisse ornare tincidunt est vitae pretium. Donec mattis quam sed dapibus vestibulum. Aliquam enim eros, venenatis at convallis et, fringilla ac sem. Nam nec vulputate eros, rhoncus fermentum tellus. Nulla sed enim dignissim, pulvinar nisl a, aliquam tellus.</p>', '', -2, 0, 0, 85, '2013-06-22 07:51:33', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-06-22 07:51:33', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(115, 230, 'Unique Design', 'unique-design', '', '<p>Suspendisse sed erat ut nunc adipiscing fermentum. Sed id odio aliquam, iaculis lectus a, congue turpis. In quis arcu auctor eros dictum cursus. Nullam nibh felis, suscipit non tellus sit amet, convallis porta sapien. Proin luctus vel nisi ac sollicitudin. Curabitur vitae sollicitudin arcu. Maecenas scelerisque facilisis diam eu viverra. Nulla nec urna sit amet augue aliquam placerat. Nullam sagittis mi quis imperdiet luctus. Fusce in molestie justo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed non tempus odio, et pulvinar nunc.</p>', '', -2, 0, 0, 85, '2013-06-22 07:52:13', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-06-22 07:52:13', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(116, 232, 'Neil Braine', 'neil-braine', '', '<p>Sed vitae turpis sem. Pellentesque adipiscing ante ipsum, auctor bibendum nunc tristique sit amet. Suspendisse ligula mauris, lobortis vitae ipsum sed, ullamcorper suscipit lacus. Proin porta quam vel semper sollicitudin. In hac habitasse platea dictumst. Integer ultrices tortor nec ligula luctus, nec euismod nulla rutrum. Donec vitae accumsan diam, et facilisis dui.</p>\r\n', '\r\n<p>Nulla faucibus tempus placerat. Sed quam ligula, commodo at facilisis non, fringilla ut magna. Nunc tristique cursus volutpat. Maecenas sollicitudin, turpis tempus condimentum accumsan, nisl risus vulputate magna, in consectetur dolor nulla vitae sapien. Quisque ipsum felis, interdum id viverra eget, mattis id elit. Maecenas massa orci, mattis eu placerat vitae, varius ac augue. Vivamus blandit, enim vitae ultrices rutrum, ante tortor varius dolor, in sagittis ligula odio a est.</p>', -2, 0, 0, 86, '2013-06-22 08:54:50', 968, '', '2013-07-11 09:53:39', 154, 0, '0000-00-00 00:00:00', '2013-06-22 08:54:50', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-1.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/professor-1.png","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 6, 0, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(117, 233, 'Keith Morgan', 'keith-morgan', '', '<p>Proin eu justo at urna bibendum euismod. In eu urna sem. Donec ac dignissim purus, eu adipiscing risus. Nunc est est, tempus non augue et, porta dapibus ante. Maecenas eu tempor magna. Nullam elit tortor, placerat id libero porttitor, euismod dignissim nisl. Cras et enim justo. Suspendisse ornare tincidunt est vitae pretium. Donec mattis quam sed dapibus vestibulum. Aliquam enim eros, venenatis at convallis et, fringilla ac sem.</p>\r\n', '\r\n<p>Nam nec vulputate eros, rhoncus fermentum tellus. Nulla sed enim dignissim, pulvinar nisl a, aliquam tellus. Suspendisse sed erat ut nunc adipiscing fermentum. Sed id odio aliquam, iaculis lectus a, congue turpis. In quis arcu auctor eros dictum cursus. Nullam nibh felis, suscipit non tellus sit amet, convallis porta sapien. Proin luctus vel nisi ac sollicitudin. Curabitur vitae sollicitudin arcu. Maecenas scelerisque facilisis diam eu viverra. Nulla nec urna sit amet augue aliquam placerat.</p>', -2, 0, 0, 86, '2013-06-22 08:56:20', 968, '', '2013-07-11 09:52:09', 154, 0, '0000-00-00 00:00:00', '2013-06-22 08:56:20', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-2.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/professor-2.png","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(118, 235, 'Nullam Lobortis', 'nullam-lobortis', '', '<p>Nullam lobortis vulputate lacinia.</p>', '', -2, 0, 0, 87, '2013-07-02 06:47:31', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-07-02 06:47:31', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/about-us1.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/about-us1.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(119, 236, 'Aliquam', 'aliquam', '', '<p>Aliquam erat volutpat.</p>', '', -2, 0, 0, 87, '2013-07-02 06:48:42', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-07-02 06:48:42', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/about-us2.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/about-us2.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(120, 237, 'Mauris a orci', 'mauris-a-orci', '', '<p>Mauris a orci eu augue cursus lacinia in sed elit.</p>', '', -2, 0, 0, 87, '2013-07-02 07:08:42', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-07-02 07:08:42', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/about-us3.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/about-us3.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(121, 239, 'Albert Ryan', 'albert-ryan', '', '<p>Donec scelerisque molestie mi sit amet vestibulum. Proin rutrum gravida sapien, vel interdum leo consequat ut. Etiam suscipit nibh volutpat tempor malesuada rhoncus volutpat augue, in fermentum lorem. Sed pharetra dapibus felis in venenatis.</p>\r\n', '\r\n<p>Aliquam erat volutpat. Quisque blandit nisi eget urna venenatis fermentum. Pellentesque viverra sapien in ipsum scelerisque accumsan. Sed sit amet cursus elit. Aliquam nec magna eu sapien sollicitudin semper a dapibus nisi. Donec scelerisque molestie mi sit amet vestibulum. Proin rutrum gravida sapien, vel interdum leo consequat ut. Etiam suscipit nibh volutpat tempor malesuada. Duis metus odio, tempor eu tellus a, dapibus dapibus velit. Cras venenatis lacus ut lacinia auctor. In et viverra metus. Proin ac lacinia enim, quis feugiat velit. </p>', -2, 0, 0, 86, '2013-07-08 12:35:57', 968, '', '2013-07-11 10:02:04', 154, 0, '0000-00-00 00:00:00', '2013-07-08 12:35:57', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-3.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/professor-3.png","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(122, 240, 'Jonathon', 'jonathon', '', '<p>Fermentum pellentesque viverra sapien in ipsum scelerisque accumsan. Sed sit amet cursus elit. Aliquam nec magna eu sapien sollicitudin semper a dapibus nisi. Etiam suscipit nibh volutpat tempor malesuada. Aenean eget nulla quis purus lobortis volutpat.</p>\r\n', '\r\n<p>Aliquam erat volutpat. Aenean tellus orci, luctus quis turpis sit amet, tincidunt lobortis eros. Aenean eget nulla quis purus lobortis volutpat. Mauris a orci eu augue cursus lacinia in sed elit. Aenean eu convallis eros. Interdum et malesuada fames ac ante ipsum primis in faucibus. Nulla consectetur eget lectus non mollis. Donec commodo porttitor purus, id ullamcorper sapien aliquet vel. Vivamus sit amet luctus risus. Suspendisse suscipit dolor id felis faucibus, iaculis scelerisque orci vehicula.</p>', -2, 0, 0, 86, '2013-07-11 09:49:03', 968, '', '2013-07-11 09:56:25', 154, 0, '0000-00-00 00:00:00', '2013-07-11 09:49:03', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-4.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/focus\\/professor-4.png","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 4, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(123, 243, 'Xpert Captions', 'xpert-captions', '', '<img src="images/extensions/xpert-captions.jpg" alt="Xpert Captions" class="pull-left img-polaroid"/>\r\n<p>To allow presenting contents in a dazzling way, Themexpert brings a brand new module Xpert Caption. It’s a box and caption plug-in offering numerous effects and sliding options. It adds fade/slide effect and also allows caption and image sliding in multidimensional style.</p>\r\n<p>With its unlimited possibilities and options of displaying a product or an image and its caption, another module like this one is surely hard to find. This module will certainly ornate any site with a glowing beauty and produce a smart, perfect look.</p>\r\n<p><a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/xpert-captions" target="_blank">Details</a> <a class="btn btn-plus" href="http://demo.themexpert.com/extensions" target="_blank">Demo</a> <a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/download" target="_blank">Download</a></p>\r\n', '', -2, 0, 0, 83, '2013-07-16 10:47:23', 968, '', '2013-07-17 05:58:20', 154, 0, '0000-00-00 00:00:00', '2013-07-16 10:47:23', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 1, '', '', 1, 3, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(124, 244, 'Xpert Accordion', 'xpert-accordion', '', '<img src="images/extensions/xpert-accordion.jpg" alt="Xpert Accordion" class="pull-left img-polaroid"/>\r\n<p>Our first Responsive accordion module for Joomla 2.5. The Xpert Accordion is the next revolutionary step forward in the ThemeXpert arena to managing Web page content via accordion.This module will give you essence of responsiveness within module and now you can show accordion to any device you want!</p>\r\n<p>As it supports <a target="_blank" href="http://www.getk2.org">K2</a> and <a target="_blank" href="http://stackideas.com/">Easy Blog</a> component and can load other Modules inside it, Xpert Accordion will give you every possible content type to load inside it.</p>\r\n<p><a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/xpert-accordion" target="_blank">Details</a> <a class="btn btn-plus" href="http://demo.themexpert.com/extensions" target="_blank">Demo</a> <a class="btn btn-plus" href="http://www.themexpert.com/joomla-extensions/download" target="_blank">Download</a></p>\r\n', '', -2, 0, 0, 83, '2013-07-16 10:52:40', 968, '', '2013-07-17 05:57:57', 154, 0, '0000-00-00 00:00:00', '2013-07-16 10:52:40', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 0, '', '', 1, 7, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(125, 246, 'Simon Ding', 'simon-ding', '', '<p>Support</p>\r\n', '', -2, 0, 0, 88, '2013-07-17 07:51:09', 968, '', '2013-07-17 08:16:22', 154, 0, '0000-00-00 00:00:00', '2013-07-17 07:51:09', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-4.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 0, 3, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(126, 247, 'Albert braine', 'albert-braine', '', '<p>Design Wrangler</p>\r\n', '', -2, 0, 0, 88, '2013-07-17 07:52:21', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-07-17 07:52:21', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-2.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 2, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(127, 248, 'Neil Morgan', 'neil-morgan', '', '<p>Web Developer</p>\r\n', '', -2, 0, 0, 88, '2013-07-17 07:53:13', 968, '', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', '2013-07-17 07:53:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-3.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 1, 0, 1, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(128, 249, 'John Ryan', 'john-ryan', '', '<p>Head of Ideas</p>', '', -2, 0, 0, 88, '2013-07-17 07:54:05', 968, '', '2013-07-17 08:15:52', 154, 0, '0000-00-00 00:00:00', '2013-07-17 07:54:05', '0000-00-00 00:00:00', '{"image_intro":"images\\/focus\\/professor-1.png","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":null,"urlatext":"","targeta":"","urlb":null,"urlbtext":"","targetb":"","urlc":null,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, 0, '', '', 1, 0, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__content_frontpage`
--

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(50, 2),
(70, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned DEFAULT NULL,
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10274 ;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"legacy":false,"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_MAILTO_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"legacy":false,"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_BANNERS_XML_DESCRIPTION","group":""}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_checkin","type":"component","creationDate":"Unknown","author":"Joomla! Project","copyright":"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CONTACT_XML_DESCRIPTION","group":""}', '{"show_contact_category":"hide","show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","allow_vcard_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_category_crumb":"0","metakey":"","metadesc":"","robots":"","author":"","rights":"","xreference":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_languages","type":"component","creationDate":"2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_MEDIA_XML_DESCRIPTION","group":""}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html","enable_flash":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0","show_headings":"1","show_name":"1","show_articles":"0","show_link":"1","show_description":"1","show_description_image":"1","display_num":"","show_pagination_limit":"1","show_pagination":"1","show_pagination_results":"1","show_cat_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 'com_search', 'component', 'com_search', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_SEARCH_XML_DESCRIPTION","group":""}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"legacy":false,"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_weblinks","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":""}', '{"show_comp_description":"1","comp_description":"","show_link_hits":"1","show_link_description":"1","show_other_cats":"0","show_headings":"0","show_numbers":"0","show_report":"1","count_clicks":"1","target":"0","link_icons":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CONTENT_XML_DESCRIPTION","group":""}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","show_category":"1","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_author":"1","link_author":"0","show_create_date":"1","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_readmore":"1","show_readmore_title":"0","readmore_limit":"100","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"1","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","show_urls_images_frontend":"1","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"left","float_fulltext":"left","category_layout":"_:blog","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"1","num_intro_articles":"4","num_columns":"1","num_links":"4","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"6":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"7":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"2":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"3":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"4":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"5":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"legacy":false,"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_USERS_XML_DESCRIPTION","group":""}', '{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"1","useractivation":"1","mail_to_admin":"0","captcha":"","frontend_userparams":"1","site_language":"0","mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"1","show_autosuggest":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","sort_order":"relevance","sort_direction":"desc","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stem":"1","stemmer":"porter_en"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, '{"legacy":false,"name":"PHPMailer","type":"library","creationDate":"2001","author":"PHPMailer","copyright":"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2011, Jim Jagielski. All Rights Reserved.","authorEmail":"jimjag@gmail.com","authorUrl":"https:\\/\\/code.google.com\\/a\\/apache-extras.org\\/p\\/phpmailer\\/","version":"5.2","description":"LIB_PHPMAILER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{"legacy":false,"name":"SimplePie","type":"library","creationDate":"2004","author":"SimplePie","copyright":"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon","authorEmail":"","authorUrl":"http:\\/\\/simplepie.org\\/","version":"1.2","description":"LIB_SIMPLEPIE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 'phputf8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"legacy":false,"name":"phputf8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 'Joomla! Platform', 'library', 'joomla', '', 0, 1, 1, 0, '{"legacy":false,"name":"Joomla! Platform","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"11.4","description":"LIB_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters.\\n\\t\\tAll rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_RELATED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"legacy":false,"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"legacy":false,"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"legacy":false,"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"legacy":false,"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(306, 'mod_online', 'module', 'mod_online', '', 1, 1, 1, 0, '', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"legacy":false,"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_STATUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_TITLE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"legacy":false,"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":""}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"MOD_VERSION_XML_DESCRIPTION","group":""}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"legacy":false,"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":""}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"legacy":false,"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"legacy":false,"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_LDAP_XML_DESCRIPTION","group":""}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(404, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"legacy":false,"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":""}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(405, 'plg_content_geshi', 'plugin', 'geshi', 'content', 0, 0, 1, 0, '{"legacy":false,"name":"plg_content_geshi","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"","authorUrl":"qbnz.com\\/highlighter","version":"2.5.0","description":"PLG_CONTENT_GESHI_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(406, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"legacy":false,"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":""}', '{"style":"none"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(407, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 1, '{"legacy":false,"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":""}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 1, '{"legacy":false,"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":""}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 1, '{"legacy":false,"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_VOTE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"legacy":false,"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"1.0","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":""}', '{"linenumbers":"1","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(411, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"legacy":false,"name":"plg_editors_none","type":"plugin","creationDate":"August 2004","author":"Unknown","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"2.5.0","description":"PLG_NONE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 1, '{"legacy":false,"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2013","author":"Moxiecode Systems AB","copyright":"Moxiecode Systems AB","authorEmail":"N\\/A","authorUrl":"tinymce.moxiecode.com\\/","version":"3.5.4.1","description":"PLG_TINY_XML_DESCRIPTION","group":""}', '{"mode":"1","skin":"0","compressed":"0","cleanup_startup":"0","cleanup_save":"2","entity_encoding":"raw","lang_mode":"0","lang_code":"en","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","toolbar":"top","toolbar_align":"left","html_height":"550","html_width":"750","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","format_date":"%Y-%m-%d","inserttime":"1","format_time":"%H:%M:%S","colors":"1","table":"1","smilies":"1","media":"1","hr":"1","directionality":"1","fullscreen":"1","style":"1","layer":"1","xhtmlxtras":"1","visualchars":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advimage":"1","advlink":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","safari":"0","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{"legacy":false,"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"legacy":false,"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"legacy":false,"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"legacy":false,"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_READMORE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(417, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"legacy":false,"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 1, '{"legacy":false,"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_P3P_XML_DESCRIPTION","group":""}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"legacy":false,"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CACHE_XML_DESCRIPTION","group":""}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(425, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"legacy":false,"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":""}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"legacy":false,"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_LOG_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 1, 1, 1, '{"legacy":false,"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_REDIRECT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"legacy":false,"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"legacy":false,"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SEF_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 8, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(430, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"legacy":false,"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(431, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 1, '{"legacy":false,"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":""}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"legacy":false,"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2009 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":""}', '{"autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 1, '{"legacy":false,"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":""}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"legacy":false,"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"legacy":false,"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"legacy":false,"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"legacy":false,"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"legacy":false,"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 1, 1, 0, '{"legacy":false,"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":""}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 1, 1, 0, '{"legacy":false,"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2012 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"1.7.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(500, 'atomic', 'template', 'atomic', '', 0, 1, 1, 0, '{"legacy":false,"name":"atomic","type":"template","creationDate":"10\\/10\\/09","author":"Ron Severdia","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"contact@kontentdesign.com","authorUrl":"http:\\/\\/www.kontentdesign.com","version":"2.5.0","description":"TPL_ATOMIC_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(502, 'bluestork', 'template', 'bluestork', '', 1, 1, 1, 0, '{"legacy":false,"name":"bluestork","type":"template","creationDate":"07\\/02\\/09","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"TPL_BLUESTORK_XML_DESCRIPTION","group":""}', '{"useRoundedCorners":"1","showSiteName":"0","textBig":"0","highContrast":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 'beez_20', 'template', 'beez_20', '', 0, 1, 1, 0, '{"legacy":false,"name":"beez_20","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"2.5.0","description":"TPL_BEEZ2_XML_DESCRIPTION","group":""}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"legacy":false,"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"hathor@tarrconsulting.com","authorUrl":"http:\\/\\/www.tarrconsulting.com","version":"2.5.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":""}', '{"showSiteName":"0","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(505, 'beez5', 'template', 'beez5', '', 0, 1, 1, 0, '{"legacy":false,"name":"beez5","type":"template","creationDate":"21 May 2010","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"2.5.0","description":"TPL_BEEZ5_XML_DESCRIPTION","group":""}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","html5":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 'English (United Kingdom)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"legacy":false,"name":"English (United Kingdom)","type":"language","creationDate":"2008-03-15","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.10","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 'English (United Kingdom)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"legacy":false,"name":"English (United Kingdom)","type":"language","creationDate":"2008-03-15","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.10","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"legacy":false,"name":"files_joomla","type":"file","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2013 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.14","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10021, 'PKG_JOOMLA', 'package', 'pkg_joomla', '', 0, 1, 1, 1, '{"legacy":false,"name":"PKG_JOOMLA","type":"package","creationDate":"2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"2.5.0","description":"PKG_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10067, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 1, 0, '{"legacy":false,"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2012 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"2.5.0","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10068, 'mod_unread', 'module', 'mod_unread', '', 1, 1, 1, 0, '{"legacy":false,"name":"mod_unread","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2011 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"1.6.0","description":"MOD_UNREAD_XML_DESCRIPTION","group":""}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10076, 'lib_fof', 'library', 'lib_fof', '', 0, 1, 1, 0, '{"legacy":false,"name":"lib_fof","type":"library","creationDate":"2012-08-17","author":"Nicholas K. Dionysopoulos \\/ AkeebaBackup.com","copyright":"(C)2011-2012 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"revBD02F3F","description":"Framework-on-Framework (FOF) \\u2013 A rapid component development framework extension for Joomla!","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10118, 'plg_system_expose', 'plugin', 'expose', 'system', 0, 1, 1, 0, '{"legacy":false,"name":"plg_system_expose","type":"plugin","creationDate":"Nov 21, 2011","author":"ThemeXpert","copyright":"(C) 2010 - 2011 ThemeXpert. All rights reserved.","authorEmail":"support@themexpert.com","authorUrl":"http:\\/\\/www.themexpert.com","version":"4.0","description":"Expose System Plugin for Joomla 2.5","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10181, 'Azrul System Mambot For Joomla', 'plugin', 'azrul.system', 'system', 0, 1, 1, 0, '{"legacy":true,"name":"Azrul System Mambot For Joomla","type":"plugin","creationDate":"July 2011","author":"JomSocial Team","copyright":"Copyright 2008 - 2010 by Slashes & Dots Sdn Bhd. All rights reserved","authorEmail":"support@azrul.com","authorUrl":"www.azrul.com","version":"3.0_RC2","description":"\\n\\tAjax System for Joomla, Azrul.com\\/JomSocial.com\\n\\t","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10193, 'My Forum Posts', 'plugin', 'mykunena', 'community', 0, 0, 1, 0, '{"legacy":true,"name":"My Forum Posts","type":"plugin","creationDate":"2012-11-24","author":"Kunena Team","copyright":"(C) 2008 - 2012 Kunena Team. All rights reserved.","authorEmail":"admin@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"2.0.3","description":"PLG_COMMUNITY_MYKUNENA_DESCRIPTION","group":""}', '{"count":"5","coreapp":"0","cache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10226, 'manifest', 'plugin', 'manifest', 'community', 0, 1, 1, 0, '{"legacy":true,"name":"My Forum Posts","type":"plugin","creationDate":"2012-11-24","author":"Kunena Team","copyright":"(C) 2008 - 2012 Kunena Team. All rights reserved.","authorEmail":"admin@kunena.org","authorUrl":"http:\\/\\/www.kunena.org","version":"2.0.3","description":"PLG_COMMUNITY_MYKUNENA_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, -1),
(10229, 'Xpert Slider', 'module', 'mod_xpertslider', '', 0, 1, 0, 0, '{"legacy":false,"name":"Xpert Slider","type":"module","creationDate":"2013-07-15","author":"ThemeXpert","copyright":"Copyright (C) 20010 - 2011 ThemeXpert. All rights reserved.","authorEmail":"support@themexpert.com","authorUrl":"www.themexpert.com","version":"1.3","description":"MOD_XPERTSLIDER_DESC","group":""}', '{"content_source":"joomla","count":"6","title":"1","intro":"1","intro_limit_type":"words","intro_limit":"30","link":"0","jomcatfilter":"0","jom_ordering":"p_dsc","jom_user_id":"0","jom_show_featured":"","k2_catfilter":"0","k2_catid":"","k2_get_children":"1","k2_items_ordering":"","k2_featured_items":"1","k2_popularity_range":"","ezb_catfilter":"0","ezb_ordering":"latest","ezb_featured":"0","lens":"1","controller":"hover","navigation":"dots","loader":"pie","pie_diameter":"38","pie_position":"rightTop","bar_position":"bottom","image_height":"300px","thumb_width":"100","thumb_height":"100","effects":"random","transition":"linear","time":"4000","trans_period":"800","auto_advance":"1","caption_animation":"moveFromLeft","moduleclass_sfx":"","auto_module_id":"1","module_unique_id":"xs_1","load_jquery":"1","jquery_source":"local","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10231, 'lib_xef', 'library', 'lib_xef', '', 0, 1, 1, 0, '{"legacy":false,"name":"lib_xef","type":"library","creationDate":"2013-05-20","author":"Parvez Akther","copyright":"Copyright (C) 2011 - 2011 ThemeXpert","authorEmail":"parvez@themexpert.com","authorUrl":"http:\\/\\/themexpert.com\\/","version":"1.2.3","description":"\\n        Expert Extension Framework (XEF) \\u2013 A rapid extension development framework for all ThemeXpert extensions.\\n    ","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10232, 'Xpert Tabs', 'module', 'mod_xperttabs', '', 0, 1, 0, 0, '{"legacy":false,"name":"Xpert Tabs","type":"module","creationDate":"2013-05-20","author":"ThemeXpert","copyright":"(C) 2008 - 2011 ThemeXpert, LLC. All rights reserved.","authorEmail":"support@themexpert.com","authorUrl":"http:\\/\\/www.themexpert.com","version":"3.5","description":"Xpert Tabs, Next Generation Tab Module For Joomla! designed to show section articles and modules in a pleasing format.Brought to you by ThemeXpert","group":""}', '{"content_source":"joomla","count":"5","tabs_position":"top","tabs_interaction":"click","tabs_title_type":"content","tabs_title_custom":"Tab Title1, Tab Title2, Tab Title3","intro_limit_type":"0","intro_limit":"30","readmore":"1","readmore_label":"Read More","mod_style":"style1","transition":"fade-slide","jomcatfilter":"0","jom_ordering":"p_dsc","jom_user_id":"0","jom_show_featured":"","k2_catfilter":"0","k2_catid":"","k2_get_children":"1","k2_items_ordering":"","k2_featured_items":"1","k2_popularity_range":"","moduleclass_sfx":"","auto_module_id":"1","module_unique_id":"xs_1","load_jquery":"1","jquery_source":"local","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10233, 'virtuemart', 'component', 'com_virtuemart', '', 1, 1, 0, 0, '{"legacy":true,"name":"VIRTUEMART","type":"component","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.","authorEmail":"max|at|virtuemart.net","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10234, 'virtuemart_allinone', 'component', 'com_virtuemart_allinone', '', 1, 1, 0, 0, '{"legacy":true,"name":"VirtueMart_allinone","type":"component","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10235, 'Standard', 'plugin', 'standard', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"VMPAYMENT_STANDARD","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"Standard payment plugin","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10236, 'Paypal', 'plugin', 'paypal', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"VMPAYMENT_PAYPAL","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"<a href=\\"http:\\/\\/paypal.com\\" target=\\"_blank\\">PayPal<\\/a> is a popular\\n\\tpayment provider and available in many countries. \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10237, 'PayZen', 'plugin', 'payzen', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"VM - Payment, PayZen","type":"plugin","creationDate":"July 04 2012","author":"Lyra Network","copyright":"Copyright Lyra Network.","authorEmail":"support@payzen.eu","authorUrl":"http:\\/\\/www.lyra-network.com","version":"2.0.8c","description":"\\n    \\t<a href=\\"http:\\/\\/www.lyra-network.com\\" target=\\"_blank\\">PayZen<\\/a> is a multi bank payment provider. \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10238, 'SystemPay', 'plugin', 'systempay', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"VM - Payment, Systempay","type":"plugin","creationDate":"July 04 2012","author":"Lyra Network","copyright":"Copyright Lyra Network.","authorEmail":"supportvad@lyra-network.com","authorUrl":"http:\\/\\/www.lyra-network.com","version":"2.0.8c","description":"\\n    \\t<a href=\\"http:\\/\\/www.lyra-network.com\\" target=\\"_blank\\">Systempay<\\/a> is a multi bank payment provider. \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10239, 'Moneybookers Credit Cards', 'plugin', 'moneybookers_acc', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Credit Cards","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10240, 'Moneybookers Lastschrift', 'plugin', 'moneybookers_did', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Lastschrift","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10241, 'Moneybookers iDeal', 'plugin', 'moneybookers_idl', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers iDeal","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10242, 'Moneybookers Giropay', 'plugin', 'moneybookers_gir', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Giropay","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10243, 'Moneybookers Sofortueberweisung', 'plugin', 'moneybookers_sft', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Sofortueberweisung","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10244, 'Moneybookers Przelewy24', 'plugin', 'moneybookers_pwy', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Przelewy24","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10245, 'Moneybookers Online Bank Transfer', 'plugin', 'moneybookers_obt', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Bank Transfer","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10246, 'Moneybookers Skrill Digital Wallet', 'plugin', 'moneybookers_wlt', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"Vm Payment plugin Moneybookers Digital Wallet","type":"plugin","creationDate":"April 2012","author":"Skrill Holdings Limited","copyright":"Copyright (C) 2012 Skrill.","authorEmail":"","authorUrl":"http:\\/\\/www.skrill.com","version":"2.0.6","description":"<a href=\\"http:\\/\\/www.skrill.com\\" target=\\"_blank\\">Moneybookers<\\/a> is a popular\\n\\tpayment provider authorised by the Financial Services Authority of the United Kingdom (FSA). \\n    ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10247, 'Authorize.net', 'plugin', 'authorizenet', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"VM Payment - authorize.net AIM","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10248, 'Klarna', 'plugin', 'klarna', 'vmpayment', 0, 1, 1, 0, '{"legacy":true,"name":"VM - Payment, Klarna","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"VMPAYMENT_KLARNA_CONF_PLUGIN_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(10249, 'Heidelpay', 'plugin', 'heidelpay', 'vmpayment', 0, 1, 1, 0, '{"legacy":false,"name":"Heidelpay","type":"plugin","creationDate":"12-Sep-2012","author":"Heidelberger Payment GmbH","copyright":"Copyright Heidelberger Payment GmbH","authorEmail":"info@heidelpay.de","authorUrl":"http:\\/\\/www.heidelpay.de","version":"13.07","description":"<h2>Virtuemart Plugin von:<\\/h2><p><a href=\\"http:\\/\\/www.Heidelpay.de\\" target=\\"_blank\\"><img src=\\"http:\\/\\/www.heidelpay.de\\/gfx\\/logo.gif\\" style=\\"margin-right:20px;\\"\\/><\\/a><\\/p> ","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10250, 'By weight, ZIP and countries', 'plugin', 'weight_countries', 'vmshipment', 0, 1, 1, 0, '{"legacy":true,"name":"VMSHIPMENT_WEIGHT_COUNTRIES","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"VMSHIPMENT_WEIGHT_COUNTRIES_PLUGIN_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10251, 'Customer text input', 'plugin', 'textinput', 'vmcustom', 0, 1, 1, 0, '{"legacy":true,"name":"VMCustom - textinput","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"text input plugin for product","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10252, 'Product specification', 'plugin', 'specification', 'vmcustom', 0, 1, 1, 0, '{"legacy":true,"name":"VMCustom - specification","type":"plugin","creationDate":"January 09 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.18a","description":"text input plugin for product","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10253, 'Stockable variants', 'plugin', 'stockable', 'vmcustom', 0, 1, 1, 0, '{"legacy":true,"name":"VMCUSTOM_STOCKABLE","type":"plugin","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"VMCUSTOM_STOCKABLE_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10254, 'Avalara Tax', 'plugin', 'avalara', 'vmcalculation', 0, 0, 1, 0, '{"legacy":true,"name":"VM - Calculation Avalara Tax","type":"plugin","creationDate":"February 2013","author":"Max Milbers","copyright":"Copyright (C) 2013 iStraxx UG (haftungsbeschr\\u00e4nkt). All rights reserved","authorEmail":"","authorUrl":"http:\\/\\/virtuemart.net","version":"2.0.18b","description":"On demand tax calculation for whole U.S.A.","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10255, 'Virtuemart Product', 'plugin', 'virtuemart', 'search', 0, 1, 1, 0, '{"legacy":false,"name":"plg_search_virtuemart","type":"plugin","creationDate":"January 09 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.18a","description":"Allows Searching of VirtueMart Component","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10256, 'mod_virtuemart_currencies', 'module', 'mod_virtuemart_currencies', '', 0, 1, 1, 0, '{"legacy":true,"name":"mod_virtuemart_currencies","type":"module","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"${PHING.VM.COPYRIGH}","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"MOD_VIRTUEMART_CURRENCIES_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(10257, 'mod_virtuemart_product', 'module', 'mod_virtuemart_product', '', 0, 1, 1, 0, '{"legacy":true,"name":"mod_virtuemart_product","type":"module","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"${PHING.VM.COPYRIGH}","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"MOD_VIRTUEMART_PRODUCT_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(10258, 'mod_virtuemart_search', 'module', 'mod_virtuemart_search', '', 0, 1, 1, 0, '{"legacy":true,"name":"mod_virtuemart_search","type":"module","creationDate":"January 09 2013","author":"The VirtueMart Development Team","copyright":"Copyright (C) 2004-2012 Virtuemart Team. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.18a","description":"MOD_VIRTUEMART_SEARCH_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(10259, 'mod_virtuemart_manufacturer', 'module', 'mod_virtuemart_manufacturer', '', 0, 1, 1, 0, '{"legacy":true,"name":"mod_virtuemart_manufacturer","type":"module","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"${PHING.VM.COPYRIGH}","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"MOD_VIRTUEMART_MANUFACTURER_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(10260, 'mod_virtuemart_cart', 'module', 'mod_virtuemart_cart', '', 0, 1, 1, 0, '{"legacy":true,"name":"VirtueMart Shopping Cart","type":"module","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"${PHING.VM.COPYRIGH}","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"MOD_VIRTUEMART_CART_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10261, 'mod_virtuemart_category', 'module', 'mod_virtuemart_category', '', 0, 1, 1, 0, '{"legacy":true,"name":"mod_virtuemart_category","type":"module","creationDate":"August 20 2013","author":"The VirtueMart Development Team","copyright":"${PHING.VM.COPYRIGH}","authorEmail":"","authorUrl":"http:\\/\\/www.virtuemart.net","version":"2.0.22b","description":"MOD_VIRTUEMART_CATEGORY_DESC","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(10262, 'Xpert Tweets', 'module', 'mod_xperttweets', '', 0, 1, 0, 0, '{"legacy":false,"name":"Xpert Tweets","type":"module","creationDate":"${build.date}","author":"ThemeXpert","copyright":"Copyright (C) 2011 - 2012 ThemeXpert. All rights reserved.","authorEmail":"support@themexpert.com","authorUrl":"www.themexpert.com","version":"1.2","description":"Xpert Tweets is show recent tweets update.","group":""}', '{"layouts":"vertical","style":"basic","count":"15","show_tweet":"user","tweet_term":"themexpert","profile":"0","profile_image":"1","time":"1","source":"0","follow":"0","follow_text":"Follow us on twitter","cache_time":"1900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10270, 'Tx_GravityII', 'template', 'tx_gravityii', '', 0, 1, 1, 0, '{"legacy":false,"name":"Tx_GravityII","type":"template","creationDate":"2013-09-17","author":"ThemeXpert.com","copyright":"Copyright (C) 2013 - 2014 ThemeXpert. All Rights Reserved.","authorEmail":"support@themexpert.com","authorUrl":"http:\\/\\/www.themexpert.com","version":"1.0","description":"EXPOSE_DESCRIPTION","group":""}', '{"style":"blue","stylus-enabled":"0","stylus-module-title-color":"f2560e","stylus-article-title-color":"5bd954","stylus-background-color":"fffff","stylus-background-image":"ffffff","stylus-background-image-repeat":"repeat","stylus-header-bg-color":"555555","stylus-header-text-color":"555555","stylus-header-link-color":"bada55","stylus-header-link-hover-color":"f2560e","stylus-header-image-repeat":"repeat","stylus-top-bg-color":"555555","stylus-top-text-color":"555555","stylus-top-link-color":"bada55","stylus-top-link-hover-color":"f2560e","stylus-top-image-repeat":"repeat","stylus-feature-bg-color":"dddddd","stylus-feature-text-color":"555555","stylus-feature-link-color":"f2560e","stylus-feature-link-hover-color":"3d3a38","stylus-feature-image-repeat":"repeat","stylus-maincontent-bg-color":"dddddd","stylus-maincontent-text-color":"555555","stylus-maincontent-link-color":"f2560e","stylus-maincontent-link-hover-color":"3d3a38","stylus-maincontent-image-repeat":"repeat","stylus-bottom-bg-color":"eeeeee","stylus-bottom-text-color":"222222","stylus-bottom-link-color":"0ea8f0","stylus-bottom-link-hover-color":"0ea8f0","stylus-bottom-image-repeat":"repeat","stylus-footer-bg-color":"000000","stylus-footer-text-color":"ffffff","stylus-footer-link-color":"30a8f4","stylus-footer-link-hover-color":"30a8f4","stylus-footer-image-repeat":"repeat","logo-enabled":"1","logo-type":"image","logo-text":"Expose Framework for Joomla 2.5 and 3.0+","logo-position":"top-1","logo-mobile":"1","logo-display-tagline":"0","date-enabled":"0","date-position":"roof-1","date-formats":"","copyrightinfo-enabled":"1","copyrightinfo-position":"copyright-1","copyrightinfo-text":"EXPOSE_DEFAULT_COPYRIGHT","copyrightinfo-mobile":"0","fontresizer-enabled":"0","fontresizer-position":"roof-5","fontresizer-selector":"body","totop-enabled":"1","totop-position":"absolute","wordformat-enabled":"0","wordformat-selector":"header h2 a","lazyloader-enabled":"1","modernizr-enabled":"0","exposelogo-enabled":"1","exposelogo-type":"light","exposelogo-position":"copyright-1","analytics-enabled":"0","analytics-id":"UA-xxxxxx-x","social-enabled":"1","social-position":"top-5","social-twitter":"http:\\/\\/www.twitter.com\\/ThemeXpert","social-facebook":"http:\\/\\/www.facebook.com\\/ThemeXpert","designedby-enabled":"1","designedby-position":"copyright-1","equalheight-enabled":"1","menu-enabled":"1","menu-style":"mega","menutype":"mainmenu","menu-position":"top-2","menu-animation":"scale-up","menu-animation-sublevel":"slide-right","menu-startlevel":"1","menu-endlevel":"-1","splitmenu-title":"1","splitmenu-title-text":"Sub Menu","splitmenu-style":"vertical","splitmenu-position":"sidebar-b","offcanvas-startlevel":"1","offcanvas-endlevel":"3","responsive-enabled":"1","layouts":"sidebara-content-sidebarb","sidebar-a":"1:3","sidebar-a-chrome":"sidebar-a:standard","sidebar-b":"1:3","sidebar-b-chrome":"sidebar-b:standard","roof":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","roof-chrome":"roof-1:standard,roof-2:standard,roof-3:standard,roof-4:standard,roof-5:standard,roof-6:standard","top":"1:12,2:3,2:9,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","top-chrome":"top-1:standard,top-2:standard,top-3:standard,top-4:standard,top-5:standard,top-6:standard","header":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","header-chrome":"header-1:standard,header-2:standard,header-3:standard,header-4:standard,header-5:standard,header-6:standard","utility":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","utility-chrome":"utility-1:standard,utility-2:standard,utility-3:standard,utility-4:standard,utility-5:standard,utility-6:standard","feature":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","feature-chrome":"feature-1:standard,feature-2:standard,feature-3:standard,feature-4:standard,feature-5:standard,feature-6:standard","maintop":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","maintop-chrome":"maintop-1:standard,maintop-2:standard,maintop-3:standard,maintop-4:standard,maintop-5:standard,maintop-6:standard","contenttop":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3","contenttop-chrome":"contenttop-1:standard,contenttop-2:standard,contenttop-3:standard,contenttop-4:standard","contentbottom":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3","contentbottom-chrome":"contentbottom-1:standard,contentbottom-2:standard,contentbottom-3:standard,contentbottom-4:standard","mainbottom":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","mainbottom-chrome":"mainbottom-1:standard,mainbottom-2:standard,mainbottom-3:standard,mainbottom-4:standard,mainbottom-5:standard,mainbottom-6:standard","bottom":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","bottom-chrome":"bottom-1:standard,bottom-2:standard,bottom-3:standard,bottom-4:standard,bottom-5:standard,bottom-6:standard","footer":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","footer-chrome":"footer-1:standard,footer-2:standard,footer-3:standard,footer-4:standard,footer-5:standard,footer-6:standard","copyright":"1:12,2:6,2:6,3:4,3:4,3:4,4:3,4:3,4:3,4:3,5:3,5:2,5:2,5:2,5:3,6:2,6:2,6:2,6:2,6:2,6:2","copyright-chrome":"copyright-1:standard,copyright-2:standard,copyright-3:standard,copyright-4:standard,copyright-5:standard,copyright-6:standard","absolute":"1:12","absolute-chrome":"absolute:raw","breadcrumbs":"1:12","breadcrumbs-chrome":"breadcrumbs:standard","offcanvas":"1:12","offcanvas-chrome":"offcanvas:raw","webfonts-body-font":"0","webfonts-body-selectors":"body","webfonts-menu-font":"0","webfonts-menu-selectors":"#menu a","webfonts-heading-font":"0","webfonts-heading-selectors":"h1,h3","webfonts-module-font":"0","webfonts-module-selectors":".title","jquery-enabled":"1","jquery-source":"local","jquery-version":"1.8.3","combined-css":"0","minify-css":"0","combined-js":"0","minify-js":"0","cache-time":"2400","component-disable":"0","component-disable-menu-ids":"101","rtl-support":"0","remove-joomla-metainfo":"0","disable-mootools":"0","less-enabled":"0","less-compression":"compressed"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10273, 'Expose Templaet Framework for Joomla 2.5', 'library', 'lib_expose', '', 0, 1, 1, 0, '{"legacy":false,"name":"Expose Templaet Framework for Joomla 2.5","type":"library","creationDate":"7\\/27\\/2013","author":"ThemeXpert","copyright":"Copyright (C) 2010 - 2013 ThemeXpert","authorEmail":"","authorUrl":"http:\\/\\/themexpert.com\\/","version":"4.2.0","description":"Expose is a flexible and powerful rapid development theme framework for joomla 2.5 and 3.x with a very small footprint provides an extensible environment for developing, maintaining, and deploying high quality themes. Choosing Expose allows you to release your themes earlier, host and scale them without problem, and maintain them over time with no hassle.\\n    ","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_filters`
--

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE `#__finder_filters` (
  `filter_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `params` mediumtext,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_links`
--

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=52 ;

--
-- Dumping data for table `#__finder_links`
--

INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(1, 'index.php?option=com_content&view=category&id=80', 'index.php?option=com_content&view=category&id=80', 'Campus Gallery', '', '2013-08-27 14:42:03', '2f09f42cd34e204aed10708e265c41fc', 1, 0, 1, '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-01-20 23:30:20', '0000-00-00 00:00:00', 0, 0, 1, 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),
(2, 'index.php?option=com_content&view=category&id=84', 'index.php?Itemid=435', 'Frontpage', '', '2013-08-27 14:42:04', '3cc7606d1f232703f143adf70dc2b6fa', 1, 0, 1, '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-06-20 12:36:23', '0000-00-00 00:00:00', 0, 0, 1, 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),
(3, 'index.php?option=com_content&view=category&id=85', 'index.php?option=com_content&view=category&id=85', 'Xpert Accordion', '', '2013-08-27 14:42:04', '452d81434df4f762400ad7281d909526', 1, 0, 1, '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-06-22 06:55:17', '0000-00-00 00:00:00', 0, 0, 1, 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),
(4, 'index.php?option=com_content&view=category&id=86', 'index.php?option=com_content&view=category&id=86', 'Scroller - Meet Professor', '', '2013-08-27 14:42:04', '149b0e093cd1df8c04233e392d84022c', 1, 0, 1, '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-06-22 08:50:03', '0000-00-00 00:00:00', 0, 0, 1, 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),
(5, 'index.php?option=com_content&view=category&id=87', 'index.php?option=com_content&view=category&id=87', 'Slider - About Us', '', '2013-08-27 14:42:05', '2c05ddc2485a466376f9a8ae0238adde', 1, 0, 1, '*', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-07-02 06:41:28', '0000-00-00 00:00:00', 0, 0, 1, 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),
(6, 'index.php?option=com_content&view=article&id=88', 'index.php?option=com_content&view=article&id=88:anonymous', 'Phasellus', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-28 14:20:14', '99d9fa3f518d612bbe94a1f1c0df62e8', 1, 0, 1, '*', '2013-01-20 23:31:16', '0000-00-00 00:00:00', '2013-01-20 23:31:16', '0000-00-00 00:00:00', 0, 0, 3, 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),
(7, 'index.php?option=com_content&view=article&id=89', 'index.php?option=com_content&view=article&id=89:matheno', 'Gravida odio', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec.', '2013-08-28 14:20:06', 'edfb8224c16385eb4d971a3c89bf9e65', 1, 0, 1, '*', '2013-01-20 23:31:55', '0000-00-00 00:00:00', '2013-01-20 23:31:55', '0000-00-00 00:00:00', 0, 0, 3, 0x4f3a31393a2246696e646572496e6465786572526573756c74223a31383a7b733a31313a22002a00656c656d656e7473223b613a32343a7b733a323a226964223b733a323a223839223b733a353a22616c696173223b733a373a226d617468656e6f223b733a373a2273756d6d617279223b733a3132393a223c703e53757370656e646973736520706f7375657265206d69206174206c6163757320666575676961742074696e636964756e742e2050686173656c6c7573207072657469756d20616c6971756574206e657175652c20636f6e76616c6c697320706f73756572652066656c697320696d70657264696574206e65632e3c2f703e223b733a343a22626f6479223b733a303a22223b733a353a226361746964223b733a323a223830223b733a31303a22637265617465645f6279223b733a333a22393638223b733a31363a22637265617465645f62795f616c696173223b733a303a22223b733a383a226d6f646966696564223b733a31393a22323031332d30372d30322030373a35373a3530223b733a31313a226d6f6469666965645f6279223b733a333a22313534223b733a363a22706172616d73223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a36383a7b733a31343a2261727469636c655f6c61796f7574223b733a393a225f3a64656661756c74223b733a31303a2273686f775f7469746c65223b733a313a2231223b733a31313a226c696e6b5f7469746c6573223b733a313a2231223b733a31303a2273686f775f696e74726f223b733a313a2231223b733a31333a2273686f775f63617465676f7279223b733a313a2231223b733a31333a226c696e6b5f63617465676f7279223b733a313a2231223b733a32303a2273686f775f706172656e745f63617465676f7279223b733a313a2230223b733a32303a226c696e6b5f706172656e745f63617465676f7279223b733a313a2230223b733a31313a2273686f775f617574686f72223b733a313a2231223b733a31313a226c696e6b5f617574686f72223b733a313a2230223b733a31363a2273686f775f6372656174655f64617465223b733a313a2231223b733a31363a2273686f775f6d6f646966795f64617465223b733a313a2230223b733a31373a2273686f775f7075626c6973685f64617465223b733a313a2230223b733a32303a2273686f775f6974656d5f6e617669676174696f6e223b733a313a2230223b733a393a2273686f775f766f7465223b733a313a2230223b733a31333a2273686f775f726561646d6f7265223b733a313a2231223b733a31393a2273686f775f726561646d6f72655f7469746c65223b733a313a2230223b733a31343a22726561646d6f72655f6c696d6974223b733a333a22313030223b733a31303a2273686f775f69636f6e73223b733a313a2230223b733a31353a2273686f775f7072696e745f69636f6e223b733a313a2230223b733a31353a2273686f775f656d61696c5f69636f6e223b733a313a2230223b733a393a2273686f775f68697473223b733a313a2231223b733a31313a2273686f775f6e6f61757468223b733a313a2230223b733a31333a2275726c735f706f736974696f6e223b733a313a2230223b733a32333a2273686f775f7075626c697368696e675f6f7074696f6e73223b733a313a2231223b733a32303a2273686f775f61727469636c655f6f7074696f6e73223b733a313a2231223b733a32353a2273686f775f75726c735f696d616765735f66726f6e74656e64223b733a313a2231223b733a32343a2273686f775f75726c735f696d616765735f6261636b656e64223b733a313a2231223b733a373a2274617267657461223b693a303b733a373a2274617267657462223b693a303b733a373a2274617267657463223b693a303b733a31313a22666c6f61745f696e74726f223b733a343a226c656674223b733a31343a22666c6f61745f66756c6c74657874223b733a343a226c656674223b733a31353a2263617465676f72795f6c61796f7574223b733a363a225f3a626c6f67223b733a31393a2273686f775f63617465676f72795f7469746c65223b733a313a2230223b733a31363a2273686f775f6465736372697074696f6e223b733a313a2230223b733a32323a2273686f775f6465736372697074696f6e5f696d616765223b733a313a2230223b733a383a226d61784c6576656c223b733a313a2231223b733a32313a2273686f775f656d7074795f63617465676f72696573223b733a313a2230223b733a31363a2273686f775f6e6f5f61727469636c6573223b733a313a2231223b733a31363a2273686f775f7375626361745f64657363223b733a313a2231223b733a32313a2273686f775f6361745f6e756d5f61727469636c6573223b733a313a2230223b733a32313a2273686f775f626173655f6465736372697074696f6e223b733a313a2231223b733a31313a226d61784c6576656c636174223b733a323a222d31223b733a32353a2273686f775f656d7074795f63617465676f726965735f636174223b733a313a2230223b733a32303a2273686f775f7375626361745f646573635f636174223b733a313a2231223b733a32353a2273686f775f6361745f6e756d5f61727469636c65735f636174223b733a313a2231223b733a32303a226e756d5f6c656164696e675f61727469636c6573223b733a313a2231223b733a31383a226e756d5f696e74726f5f61727469636c6573223b733a313a2234223b733a31313a226e756d5f636f6c756d6e73223b733a313a2231223b733a393a226e756d5f6c696e6b73223b733a313a2234223b733a31383a226d756c74695f636f6c756d6e5f6f72646572223b733a313a2230223b733a32343a2273686f775f73756263617465676f72795f636f6e74656e74223b733a313a2230223b733a32313a2273686f775f706167696e6174696f6e5f6c696d6974223b733a313a2231223b733a31323a2266696c7465725f6669656c64223b733a343a2268696465223b733a31333a2273686f775f68656164696e6773223b733a313a2231223b733a31343a226c6973745f73686f775f64617465223b733a313a2230223b733a31313a22646174655f666f726d6174223b733a303a22223b733a31343a226c6973745f73686f775f68697473223b733a313a2231223b733a31363a226c6973745f73686f775f617574686f72223b733a313a2231223b733a31313a226f7264657262795f707269223b733a353a226f72646572223b733a31313a226f7264657262795f736563223b733a353a227264617465223b733a31303a226f726465725f64617465223b733a393a227075626c6973686564223b733a31353a2273686f775f706167696e6174696f6e223b733a313a2232223b733a32333a2273686f775f706167696e6174696f6e5f726573756c7473223b733a313a2231223b733a31343a2273686f775f666565645f6c696e6b223b733a313a2231223b733a31323a22666565645f73756d6d617279223b733a313a2230223b733a31383a22666565645f73686f775f726561646d6f7265223b733a313a2230223b7d7d733a373a226d6574616b6579223b733a303a22223b733a383a226d65746164657363223b733a303a22223b733a383a226d65746164617461223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a343a7b733a363a22726f626f7473223b733a303a22223b733a363a22617574686f72223b733a303a22223b733a363a22726967687473223b733a303a22223b733a31303a22787265666572656e6365223b733a303a22223b7d7d733a373a2276657273696f6e223b733a313a2234223b733a383a226f72646572696e67223b733a313a2236223b733a383a2263617465676f7279223b733a31343a2243616d7075732047616c6c657279223b733a393a226361745f7374617465223b733a323a222d32223b733a31303a226361745f616363657373223b733a313a2231223b733a343a22736c7567223b733a31303a2238393a6d617468656e6f223b733a373a22636174736c7567223b733a31343a2238303a726563656e742d776f726b223b733a363a22617574686f72223b733a31303a2253757065722055736572223b733a363a226c61796f7574223b733a373a2261727469636c65223b733a343a2270617468223b733a34393a22696e6465782e7068702f636f6d706f6e656e742f636f6e74656e742f61727469636c653f69643d38393a6d617468656e6f223b733a31303a226d657461617574686f72223b4e3b7d733a31353a22002a00696e737472756374696f6e73223b613a353a7b693a313b613a333a7b693a303b733a353a227469746c65223b693a313b733a383a227375627469746c65223b693a323b733a323a226964223b7d693a323b613a323a7b693a303b733a373a2273756d6d617279223b693a313b733a343a22626f6479223b7d693a333b613a383a7b693a303b733a343a226d657461223b693a313b733a31303a226c6973745f7072696365223b693a323b733a31303a2273616c655f7072696365223b693a333b733a373a226d6574616b6579223b693a343b733a383a226d65746164657363223b693a353b733a31303a226d657461617574686f72223b693a363b733a363a22617574686f72223b693a373b733a31363a22637265617465645f62795f616c696173223b7d693a343b613a323a7b693a303b733a343a2270617468223b693a313b733a353a22616c696173223b7d693a353b613a313a7b693a303b733a383a22636f6d6d656e7473223b7d7d733a31313a22002a007461786f6e6f6d79223b613a343a7b733a343a2254797065223b613a313a7b733a373a2241727469636c65223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a373a2241727469636c65223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a363a22417574686f72223b613a313a7b733a31303a2253757065722055736572223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31303a2253757065722055736572223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a383a2243617465676f7279223b613a313a7b733a31343a2243616d7075732047616c6c657279223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31343a2243616d7075732047616c6c657279223b733a353a227374617465223b693a2d323b733a363a22616363657373223b693a313b7d7d733a383a224c616e6775616765223b613a313a7b733a313a222a223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a313a222a223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d7d733a333a2275726c223b733a34373a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d3839223b733a353a22726f757465223b733a35353a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d38393a6d617468656e6f223b733a353a227469746c65223b733a31323a2247726176696461206f64696f223b733a31313a226465736372697074696f6e223b733a3132323a2253757370656e646973736520706f7375657265206d69206174206c6163757320666575676961742074696e636964756e742e2050686173656c6c7573207072657469756d20616c6971756574206e657175652c20636f6e76616c6c697320706f73756572652066656c697320696d70657264696574206e65632e223b733a393a227075626c6973686564223b4e3b733a353a227374617465223b693a303b733a363a22616363657373223b733a313a2231223b733a383a226c616e6775616765223b733a313a222a223b733a31383a227075626c6973685f73746172745f64617465223b733a31393a22323031332d30312d32302032333a33313a3535223b733a31363a227075626c6973685f656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a2273746172745f64617465223b733a31393a22323031332d30312d32302032333a33313a3535223b733a383a22656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a226c6973745f7072696365223b4e3b733a31303a2273616c655f7072696365223b4e3b733a373a22747970655f6964223b693a333b7d);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(8, 'index.php?option=com_content&view=article&id=90', 'index.php?option=com_content&view=article&id=90:parallax', 'Parallax', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-27 14:42:06', '926b3da99fa0408577a28e323d451a21', 1, 0, 1, '*', '2013-01-20 23:32:22', '0000-00-00 00:00:00', '2013-01-20 23:32:22', '0000-00-00 00:00:00', 0, 0, 3, 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),
(9, 'index.php?option=com_content&view=article&id=91', 'index.php?option=com_content&view=article&id=91:crisp', 'Vestibulum', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-28 14:20:20', '9430112baf99a505312cbfb77c96de38', 1, 0, 1, '*', '2013-01-20 23:32:48', '0000-00-00 00:00:00', '2013-01-20 23:32:48', '0000-00-00 00:00:00', 0, 0, 3, 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),
(10, 'index.php?option=com_content&view=article&id=92', 'index.php?option=com_content&view=article&id=92:streamx', 'Streamx', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-27 14:42:08', 'b82808687fd9fa512e6034ae02ef9d66', 1, 0, 1, '*', '2013-01-20 23:33:20', '0000-00-00 00:00:00', '2013-01-20 23:33:20', '0000-00-00 00:00:00', 0, 0, 3, 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),
(11, 'index.php?option=com_content&view=article&id=93', 'index.php?option=com_content&view=article&id=93:maximus', 'Maximus', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-27 14:42:09', '317e192919063f8ad3d604c7aaa993e3', 1, 0, 1, '*', '2013-01-20 23:33:46', '0000-00-00 00:00:00', '2013-01-20 23:33:46', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(12, 'index.php?option=com_content&view=article&id=94', 'index.php?option=com_content&view=article&id=94:vibration', 'Vibration', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-27 14:42:09', 'ab40b0479229ee461d71d6c3829c796f', 1, 0, 1, '*', '2013-01-20 23:34:10', '0000-00-00 00:00:00', '2013-01-20 23:34:10', '0000-00-00 00:00:00', 0, 0, 3, 0x4f3a31393a2246696e646572496e6465786572526573756c74223a31383a7b733a31313a22002a00656c656d656e7473223b613a32343a7b733a323a226964223b733a323a223934223b733a353a22616c696173223b733a393a22766962726174696f6e223b733a373a2273756d6d617279223b733a3531343a2253757370656e646973736520706f7375657265206d69206174206c6163757320666575676961742074696e636964756e742e2050686173656c6c7573207072657469756d20616c6971756574206e657175652c20636f6e76616c6c697320706f73756572652066656c697320696d70657264696574206e65632e20446f6e65632068656e6472657269742c2065726174206e6f6e206661756369627573206c6163696e69612c2074656c6c7573206a7573746f2072686f6e637573206d617373612c20766974616520636f6e73656374657475722061726375206469616d20706f7375657265206d657475732e2055742076656c69742065726f732c207363656c65726973717565206574206665756769617420612c2072757472756d206574206e6973692e20536564207365642066656c6973207475727069732e20446f6e6563206c696265726f206d692c20766573746962756c756d206e656320636f6d6d6f646f2061632c206469676e697373696d206e6f6e2073656d2e204d617572697320766976657272612076656c69742076656c206a7573746f20696163756c69732075742067726176696461206f64696f2076756c7075746174652e204e616d2075742065726f73206964206d61676e6120626c616e64697420696e74657264756d2e204e756e63207661726975732063757273757320626962656e64756d2e20223b733a343a22626f6479223b733a303a22223b733a353a226361746964223b733a323a223830223b733a31303a22637265617465645f6279223b733a333a22393638223b733a31363a22637265617465645f62795f616c696173223b733a303a22223b733a383a226d6f646966696564223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31313a226d6f6469666965645f6279223b733a313a2230223b733a363a22706172616d73223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a36383a7b733a31343a2261727469636c655f6c61796f7574223b733a393a225f3a64656661756c74223b733a31303a2273686f775f7469746c65223b733a313a2231223b733a31313a226c696e6b5f7469746c6573223b733a313a2231223b733a31303a2273686f775f696e74726f223b733a313a2231223b733a31333a2273686f775f63617465676f7279223b733a313a2231223b733a31333a226c696e6b5f63617465676f7279223b733a313a2231223b733a32303a2273686f775f706172656e745f63617465676f7279223b733a313a2230223b733a32303a226c696e6b5f706172656e745f63617465676f7279223b733a313a2230223b733a31313a2273686f775f617574686f72223b733a313a2231223b733a31313a226c696e6b5f617574686f72223b733a313a2230223b733a31363a2273686f775f6372656174655f64617465223b733a313a2231223b733a31363a2273686f775f6d6f646966795f64617465223b733a313a2230223b733a31373a2273686f775f7075626c6973685f64617465223b733a313a2230223b733a32303a2273686f775f6974656d5f6e617669676174696f6e223b733a313a2230223b733a393a2273686f775f766f7465223b733a313a2230223b733a31333a2273686f775f726561646d6f7265223b733a313a2231223b733a31393a2273686f775f726561646d6f72655f7469746c65223b733a313a2230223b733a31343a22726561646d6f72655f6c696d6974223b733a333a22313030223b733a31303a2273686f775f69636f6e73223b733a313a2230223b733a31353a2273686f775f7072696e745f69636f6e223b733a313a2230223b733a31353a2273686f775f656d61696c5f69636f6e223b733a313a2230223b733a393a2273686f775f68697473223b733a313a2231223b733a31313a2273686f775f6e6f61757468223b733a313a2230223b733a31333a2275726c735f706f736974696f6e223b733a313a2230223b733a32333a2273686f775f7075626c697368696e675f6f7074696f6e73223b733a313a2231223b733a32303a2273686f775f61727469636c655f6f7074696f6e73223b733a313a2231223b733a32353a2273686f775f75726c735f696d616765735f66726f6e74656e64223b733a313a2231223b733a32343a2273686f775f75726c735f696d616765735f6261636b656e64223b733a313a2231223b733a373a2274617267657461223b693a303b733a373a2274617267657462223b693a303b733a373a2274617267657463223b693a303b733a31313a22666c6f61745f696e74726f223b733a343a226c656674223b733a31343a22666c6f61745f66756c6c74657874223b733a343a226c656674223b733a31353a2263617465676f72795f6c61796f7574223b733a363a225f3a626c6f67223b733a31393a2273686f775f63617465676f72795f7469746c65223b733a313a2230223b733a31363a2273686f775f6465736372697074696f6e223b733a313a2230223b733a32323a2273686f775f6465736372697074696f6e5f696d616765223b733a313a2230223b733a383a226d61784c6576656c223b733a313a2231223b733a32313a2273686f775f656d7074795f63617465676f72696573223b733a313a2230223b733a31363a2273686f775f6e6f5f61727469636c6573223b733a313a2231223b733a31363a2273686f775f7375626361745f64657363223b733a313a2231223b733a32313a2273686f775f6361745f6e756d5f61727469636c6573223b733a313a2230223b733a32313a2273686f775f626173655f6465736372697074696f6e223b733a313a2231223b733a31313a226d61784c6576656c636174223b733a323a222d31223b733a32353a2273686f775f656d7074795f63617465676f726965735f636174223b733a313a2230223b733a32303a2273686f775f7375626361745f646573635f636174223b733a313a2231223b733a32353a2273686f775f6361745f6e756d5f61727469636c65735f636174223b733a313a2231223b733a32303a226e756d5f6c656164696e675f61727469636c6573223b733a313a2231223b733a31383a226e756d5f696e74726f5f61727469636c6573223b733a313a2234223b733a31313a226e756d5f636f6c756d6e73223b733a313a2231223b733a393a226e756d5f6c696e6b73223b733a313a2234223b733a31383a226d756c74695f636f6c756d6e5f6f72646572223b733a313a2230223b733a32343a2273686f775f73756263617465676f72795f636f6e74656e74223b733a313a2230223b733a32313a2273686f775f706167696e6174696f6e5f6c696d6974223b733a313a2231223b733a31323a2266696c7465725f6669656c64223b733a343a2268696465223b733a31333a2273686f775f68656164696e6773223b733a313a2231223b733a31343a226c6973745f73686f775f64617465223b733a313a2230223b733a31313a22646174655f666f726d6174223b733a303a22223b733a31343a226c6973745f73686f775f68697473223b733a313a2231223b733a31363a226c6973745f73686f775f617574686f72223b733a313a2231223b733a31313a226f7264657262795f707269223b733a353a226f72646572223b733a31313a226f7264657262795f736563223b733a353a227264617465223b733a31303a226f726465725f64617465223b733a393a227075626c6973686564223b733a31353a2273686f775f706167696e6174696f6e223b733a313a2232223b733a32333a2273686f775f706167696e6174696f6e5f726573756c7473223b733a313a2231223b733a31343a2273686f775f666565645f6c696e6b223b733a313a2231223b733a31323a22666565645f73756d6d617279223b733a313a2230223b733a31383a22666565645f73686f775f726561646d6f7265223b733a313a2230223b7d7d733a373a226d6574616b6579223b733a303a22223b733a383a226d65746164657363223b733a303a22223b733a383a226d65746164617461223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a343a7b733a363a22726f626f7473223b733a303a22223b733a363a22617574686f72223b733a303a22223b733a363a22726967687473223b733a303a22223b733a31303a22787265666572656e6365223b733a303a22223b7d7d733a373a2276657273696f6e223b733a313a2231223b733a383a226f72646572696e67223b733a313a2231223b733a383a2263617465676f7279223b733a31343a2243616d7075732047616c6c657279223b733a393a226361745f7374617465223b733a323a222d32223b733a31303a226361745f616363657373223b733a313a2231223b733a343a22736c7567223b733a31323a2239343a766962726174696f6e223b733a373a22636174736c7567223b733a31343a2238303a726563656e742d776f726b223b733a363a22617574686f72223b733a31303a2253757065722055736572223b733a363a226c61796f7574223b733a373a2261727469636c65223b733a343a2270617468223b733a35313a22696e6465782e7068702f636f6d706f6e656e742f636f6e74656e742f61727469636c653f69643d39343a766962726174696f6e223b733a31303a226d657461617574686f72223b4e3b7d733a31353a22002a00696e737472756374696f6e73223b613a353a7b693a313b613a333a7b693a303b733a353a227469746c65223b693a313b733a383a227375627469746c65223b693a323b733a323a226964223b7d693a323b613a323a7b693a303b733a373a2273756d6d617279223b693a313b733a343a22626f6479223b7d693a333b613a383a7b693a303b733a343a226d657461223b693a313b733a31303a226c6973745f7072696365223b693a323b733a31303a2273616c655f7072696365223b693a333b733a373a226d6574616b6579223b693a343b733a383a226d65746164657363223b693a353b733a31303a226d657461617574686f72223b693a363b733a363a22617574686f72223b693a373b733a31363a22637265617465645f62795f616c696173223b7d693a343b613a323a7b693a303b733a343a2270617468223b693a313b733a353a22616c696173223b7d693a353b613a313a7b693a303b733a383a22636f6d6d656e7473223b7d7d733a31313a22002a007461786f6e6f6d79223b613a343a7b733a343a2254797065223b613a313a7b733a373a2241727469636c65223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a373a2241727469636c65223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a363a22417574686f72223b613a313a7b733a31303a2253757065722055736572223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31303a2253757065722055736572223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a383a2243617465676f7279223b613a313a7b733a31343a2243616d7075732047616c6c657279223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31343a2243616d7075732047616c6c657279223b733a353a227374617465223b693a2d323b733a363a22616363657373223b693a313b7d7d733a383a224c616e6775616765223b613a313a7b733a313a222a223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a313a222a223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d7d733a333a2275726c223b733a34373a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d3934223b733a353a22726f757465223b733a35373a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d39343a766962726174696f6e223b733a353a227469746c65223b733a393a22566962726174696f6e223b733a31313a226465736372697074696f6e223b733a3531333a2253757370656e646973736520706f7375657265206d69206174206c6163757320666575676961742074696e636964756e742e2050686173656c6c7573207072657469756d20616c6971756574206e657175652c20636f6e76616c6c697320706f73756572652066656c697320696d70657264696574206e65632e20446f6e65632068656e6472657269742c2065726174206e6f6e206661756369627573206c6163696e69612c2074656c6c7573206a7573746f2072686f6e637573206d617373612c20766974616520636f6e73656374657475722061726375206469616d20706f7375657265206d657475732e2055742076656c69742065726f732c207363656c65726973717565206574206665756769617420612c2072757472756d206574206e6973692e20536564207365642066656c6973207475727069732e20446f6e6563206c696265726f206d692c20766573746962756c756d206e656320636f6d6d6f646f2061632c206469676e697373696d206e6f6e2073656d2e204d617572697320766976657272612076656c69742076656c206a7573746f20696163756c69732075742067726176696461206f64696f2076756c7075746174652e204e616d2075742065726f73206964206d61676e6120626c616e64697420696e74657264756d2e204e756e63207661726975732063757273757320626962656e64756d2e223b733a393a227075626c6973686564223b4e3b733a353a227374617465223b693a303b733a363a22616363657373223b733a313a2231223b733a383a226c616e6775616765223b733a313a222a223b733a31383a227075626c6973685f73746172745f64617465223b733a31393a22323031332d30312d32302032333a33343a3130223b733a31363a227075626c6973685f656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a2273746172745f64617465223b733a31393a22323031332d30312d32302032333a33343a3130223b733a383a22656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a226c6973745f7072696365223b4e3b733a31303a2273616c655f7072696365223b4e3b733a373a22747970655f6964223b693a333b7d),
(13, 'index.php?option=com_content&view=article&id=95', 'index.php?option=com_content&view=article&id=95:extreme', 'Scelerisque', 'Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus lacinia, tellus justo rhoncus massa, vitae consectetur arcu diam posuere metus. Ut velit eros, sc', '2013-08-28 14:20:16', '70698a80eb97442de6bb1425c7137509', 1, 0, 1, '*', '2013-01-20 23:34:49', '0000-00-00 00:00:00', '2013-01-20 23:34:49', '0000-00-00 00:00:00', 0, 0, 3, 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),
(14, 'index.php?option=com_content&view=article&id=111', 'index.php?option=com_content&view=article&id=111:lorem-ipsum-dolor', 'Flexible Layout System', 'Cras ut est nisi. Aliquam fermentum, odio sed malesuada elementum, lorem felis pulvinar metus, sit amet dictum velit nisl vel ipsum. Nulla sed quam et eros convallis rhoncus. Aenean quis urna vitae elit sollicitudin pretium. Maecenas vitae dictum nisi. Se', '2013-08-28 14:20:04', '2b98780f5e2d8ab3607e493e73a72c8b', 1, 0, 1, '*', '2013-06-20 12:41:12', '0000-00-00 00:00:00', '2013-06-20 12:41:12', '0000-00-00 00:00:00', 0, 0, 3, 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),
(15, 'index.php?option=com_content&view=article&id=112', 'index.php?option=com_content&view=article&id=112:phasellus-cursus-quam', 'SEO Optimized ', 'Quisque ipsum felis, interdum id viverra eget, mattis id elit. Maecenas massa orci, mattis eu placerat vitae, varius ac augue. Vivamus blandit, enim vitae ultrices rutrum, ante tortor varius dolor, in sagittis ligula odio a est. Etiam nibh enim, scelerisq', '2013-08-28 14:20:17', '5c138433807cae3117046decf85c0f5b', 1, 0, 1, '*', '2013-06-20 12:42:19', '0000-00-00 00:00:00', '2013-06-20 12:42:19', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(16, 'index.php?option=com_content&view=article&id=113', 'index.php?option=com_content&view=article&id=113:fast-loading', 'Fast Loading', 'Nulla faucibus tempus placerat. Sed quam ligula, commodo at facilisis non, fringilla ut magna. Nunc tristique cursus volutpat. Maecenas sollicitudin, turpis tempus condimentum accumsan, nisl risus vulputate magna, in consectetur dolor nulla vitae sapien. ', '2013-08-28 14:20:03', '0091ed373e24b904c6f422ed46489a8d', 1, 0, 1, '*', '2013-06-22 07:50:24', '0000-00-00 00:00:00', '2013-06-22 07:50:24', '0000-00-00 00:00:00', 0, 0, 3, 0x4f3a31393a2246696e646572496e6465786572526573756c74223a31383a7b733a31313a22002a00656c656d656e7473223b613a32343a7b733a323a226964223b733a333a22313133223b733a353a22616c696173223b733a31323a22666173742d6c6f6164696e67223b733a373a2273756d6d617279223b733a3636363a223c703e4e756c6c612066617563696275732074656d70757320706c6163657261742e20536564207175616d206c6967756c612c20636f6d6d6f646f20617420666163696c69736973206e6f6e2c206672696e67696c6c61207574206d61676e612e204e756e63207472697374697175652063757273757320766f6c75747061742e204d616563656e617320736f6c6c696369747564696e2c207475727069732074656d70757320636f6e64696d656e74756d20616363756d73616e2c206e69736c2072697375732076756c707574617465206d61676e612c20696e20636f6e736563746574757220646f6c6f72206e756c6c612076697461652073617069656e2e205175697371756520697073756d2066656c69732c20696e74657264756d206964207669766572726120656765742c206d617474697320696420656c69742e204d616563656e6173206d61737361206f7263692c206d617474697320657520706c6163657261742076697461652c207661726975732061632061756775652e20566976616d757320626c616e6469742c20656e696d20766974616520756c7472696365732072757472756d2c20616e746520746f72746f722076617269757320646f6c6f722c20696e207361676974746973206c6967756c61206f64696f2061206573742e20457469616d206e69626820656e696d2c207363656c65726973717565206174206469616d207365642c20616363756d73616e206d616c657375616461206e6973692e20496e74657264756d206574206d616c6573756164612066616d657320616320616e746520697073756d207072696d697320696e2066617563696275732e2050686173656c6c757320637572737573207175616d2070756c76696e61722064696374756d207072657469756d2e3c2f703e223b733a343a22626f6479223b733a303a22223b733a353a226361746964223b733a323a223835223b733a31303a22637265617465645f6279223b733a333a22393638223b733a31363a22637265617465645f62795f616c696173223b733a303a22223b733a383a226d6f646966696564223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31313a226d6f6469666965645f6279223b733a313a2230223b733a363a22706172616d73223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a36383a7b733a31343a2261727469636c655f6c61796f7574223b733a393a225f3a64656661756c74223b733a31303a2273686f775f7469746c65223b733a313a2231223b733a31313a226c696e6b5f7469746c6573223b733a313a2231223b733a31303a2273686f775f696e74726f223b733a313a2231223b733a31333a2273686f775f63617465676f7279223b733a313a2231223b733a31333a226c696e6b5f63617465676f7279223b733a313a2231223b733a32303a2273686f775f706172656e745f63617465676f7279223b733a313a2230223b733a32303a226c696e6b5f706172656e745f63617465676f7279223b733a313a2230223b733a31313a2273686f775f617574686f72223b733a313a2231223b733a31313a226c696e6b5f617574686f72223b733a313a2230223b733a31363a2273686f775f6372656174655f64617465223b733a313a2231223b733a31363a2273686f775f6d6f646966795f64617465223b733a313a2230223b733a31373a2273686f775f7075626c6973685f64617465223b733a313a2230223b733a32303a2273686f775f6974656d5f6e617669676174696f6e223b733a313a2230223b733a393a2273686f775f766f7465223b733a313a2230223b733a31333a2273686f775f726561646d6f7265223b733a313a2231223b733a31393a2273686f775f726561646d6f72655f7469746c65223b733a313a2230223b733a31343a22726561646d6f72655f6c696d6974223b733a333a22313030223b733a31303a2273686f775f69636f6e73223b733a313a2230223b733a31353a2273686f775f7072696e745f69636f6e223b733a313a2230223b733a31353a2273686f775f656d61696c5f69636f6e223b733a313a2230223b733a393a2273686f775f68697473223b733a313a2231223b733a31313a2273686f775f6e6f61757468223b733a313a2230223b733a31333a2275726c735f706f736974696f6e223b733a313a2230223b733a32333a2273686f775f7075626c697368696e675f6f7074696f6e73223b733a313a2231223b733a32303a2273686f775f61727469636c655f6f7074696f6e73223b733a313a2231223b733a32353a2273686f775f75726c735f696d616765735f66726f6e74656e64223b733a313a2231223b733a32343a2273686f775f75726c735f696d616765735f6261636b656e64223b733a313a2231223b733a373a2274617267657461223b693a303b733a373a2274617267657462223b693a303b733a373a2274617267657463223b693a303b733a31313a22666c6f61745f696e74726f223b733a343a226c656674223b733a31343a22666c6f61745f66756c6c74657874223b733a343a226c656674223b733a31353a2263617465676f72795f6c61796f7574223b733a363a225f3a626c6f67223b733a31393a2273686f775f63617465676f72795f7469746c65223b733a313a2230223b733a31363a2273686f775f6465736372697074696f6e223b733a313a2230223b733a32323a2273686f775f6465736372697074696f6e5f696d616765223b733a313a2230223b733a383a226d61784c6576656c223b733a313a2231223b733a32313a2273686f775f656d7074795f63617465676f72696573223b733a313a2230223b733a31363a2273686f775f6e6f5f61727469636c6573223b733a313a2231223b733a31363a2273686f775f7375626361745f64657363223b733a313a2231223b733a32313a2273686f775f6361745f6e756d5f61727469636c6573223b733a313a2230223b733a32313a2273686f775f626173655f6465736372697074696f6e223b733a313a2231223b733a31313a226d61784c6576656c636174223b733a323a222d31223b733a32353a2273686f775f656d7074795f63617465676f726965735f636174223b733a313a2230223b733a32303a2273686f775f7375626361745f646573635f636174223b733a313a2231223b733a32353a2273686f775f6361745f6e756d5f61727469636c65735f636174223b733a313a2231223b733a32303a226e756d5f6c656164696e675f61727469636c6573223b733a313a2231223b733a31383a226e756d5f696e74726f5f61727469636c6573223b733a313a2234223b733a31313a226e756d5f636f6c756d6e73223b733a313a2231223b733a393a226e756d5f6c696e6b73223b733a313a2234223b733a31383a226d756c74695f636f6c756d6e5f6f72646572223b733a313a2230223b733a32343a2273686f775f73756263617465676f72795f636f6e74656e74223b733a313a2230223b733a32313a2273686f775f706167696e6174696f6e5f6c696d6974223b733a313a2231223b733a31323a2266696c7465725f6669656c64223b733a343a2268696465223b733a31333a2273686f775f68656164696e6773223b733a313a2231223b733a31343a226c6973745f73686f775f64617465223b733a313a2230223b733a31313a22646174655f666f726d6174223b733a303a22223b733a31343a226c6973745f73686f775f68697473223b733a313a2231223b733a31363a226c6973745f73686f775f617574686f72223b733a313a2231223b733a31313a226f7264657262795f707269223b733a353a226f72646572223b733a31313a226f7264657262795f736563223b733a353a227264617465223b733a31303a226f726465725f64617465223b733a393a227075626c6973686564223b733a31353a2273686f775f706167696e6174696f6e223b733a313a2232223b733a32333a2273686f775f706167696e6174696f6e5f726573756c7473223b733a313a2231223b733a31343a2273686f775f666565645f6c696e6b223b733a313a2231223b733a31323a22666565645f73756d6d617279223b733a313a2230223b733a31383a22666565645f73686f775f726561646d6f7265223b733a313a2230223b7d7d733a373a226d6574616b6579223b733a303a22223b733a383a226d65746164657363223b733a303a22223b733a383a226d65746164617461223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a343a7b733a363a22726f626f7473223b733a303a22223b733a363a22617574686f72223b733a303a22223b733a363a22726967687473223b733a303a22223b733a31303a22787265666572656e6365223b733a303a22223b7d7d733a373a2276657273696f6e223b733a313a2231223b733a383a226f72646572696e67223b733a313a2232223b733a383a2263617465676f7279223b733a31353a225870657274204163636f7264696f6e223b733a393a226361745f7374617465223b733a323a222d32223b733a31303a226361745f616363657373223b733a313a2231223b733a343a22736c7567223b733a31363a223131333a666173742d6c6f6164696e67223b733a373a22636174736c7567223b733a31383a2238353a78706572742d6163636f7264696f6e223b733a363a22617574686f72223b733a31303a2253757065722055736572223b733a363a226c61796f7574223b733a373a2261727469636c65223b733a343a2270617468223b733a35353a22696e6465782e7068702f636f6d706f6e656e742f636f6e74656e742f61727469636c653f69643d3131333a666173742d6c6f6164696e67223b733a31303a226d657461617574686f72223b4e3b7d733a31353a22002a00696e737472756374696f6e73223b613a353a7b693a313b613a333a7b693a303b733a353a227469746c65223b693a313b733a383a227375627469746c65223b693a323b733a323a226964223b7d693a323b613a323a7b693a303b733a373a2273756d6d617279223b693a313b733a343a22626f6479223b7d693a333b613a383a7b693a303b733a343a226d657461223b693a313b733a31303a226c6973745f7072696365223b693a323b733a31303a2273616c655f7072696365223b693a333b733a373a226d6574616b6579223b693a343b733a383a226d65746164657363223b693a353b733a31303a226d657461617574686f72223b693a363b733a363a22617574686f72223b693a373b733a31363a22637265617465645f62795f616c696173223b7d693a343b613a323a7b693a303b733a343a2270617468223b693a313b733a353a22616c696173223b7d693a353b613a313a7b693a303b733a383a22636f6d6d656e7473223b7d7d733a31313a22002a007461786f6e6f6d79223b613a343a7b733a343a2254797065223b613a313a7b733a373a2241727469636c65223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a373a2241727469636c65223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a363a22417574686f72223b613a313a7b733a31303a2253757065722055736572223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31303a2253757065722055736572223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a383a2243617465676f7279223b613a313a7b733a31353a225870657274204163636f7264696f6e223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31353a225870657274204163636f7264696f6e223b733a353a227374617465223b693a2d323b733a363a22616363657373223b693a313b7d7d733a383a224c616e6775616765223b613a313a7b733a313a222a223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a313a222a223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d7d733a333a2275726c223b733a34383a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d313133223b733a353a22726f757465223b733a36313a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d3131333a666173742d6c6f6164696e67223b733a353a227469746c65223b733a31323a2246617374204c6f6164696e67223b733a31313a226465736372697074696f6e223b733a3635393a224e756c6c612066617563696275732074656d70757320706c6163657261742e20536564207175616d206c6967756c612c20636f6d6d6f646f20617420666163696c69736973206e6f6e2c206672696e67696c6c61207574206d61676e612e204e756e63207472697374697175652063757273757320766f6c75747061742e204d616563656e617320736f6c6c696369747564696e2c207475727069732074656d70757320636f6e64696d656e74756d20616363756d73616e2c206e69736c2072697375732076756c707574617465206d61676e612c20696e20636f6e736563746574757220646f6c6f72206e756c6c612076697461652073617069656e2e205175697371756520697073756d2066656c69732c20696e74657264756d206964207669766572726120656765742c206d617474697320696420656c69742e204d616563656e6173206d61737361206f7263692c206d617474697320657520706c6163657261742076697461652c207661726975732061632061756775652e20566976616d757320626c616e6469742c20656e696d20766974616520756c7472696365732072757472756d2c20616e746520746f72746f722076617269757320646f6c6f722c20696e207361676974746973206c6967756c61206f64696f2061206573742e20457469616d206e69626820656e696d2c207363656c65726973717565206174206469616d207365642c20616363756d73616e206d616c657375616461206e6973692e20496e74657264756d206574206d616c6573756164612066616d657320616320616e746520697073756d207072696d697320696e2066617563696275732e2050686173656c6c757320637572737573207175616d2070756c76696e61722064696374756d207072657469756d2e223b733a393a227075626c6973686564223b4e3b733a353a227374617465223b693a303b733a363a22616363657373223b733a313a2231223b733a383a226c616e6775616765223b733a313a222a223b733a31383a227075626c6973685f73746172745f64617465223b733a31393a22323031332d30362d32322030373a35303a3234223b733a31363a227075626c6973685f656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a2273746172745f64617465223b733a31393a22323031332d30362d32322030373a35303a3234223b733a383a22656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a226c6973745f7072696365223b4e3b733a31303a2273616c655f7072696365223b4e3b733a373a22747970655f6964223b693a333b7d),
(17, 'index.php?option=com_content&view=article&id=114', 'index.php?option=com_content&view=article&id=114:cross-browser-compatible', 'Cross browser Compatible', 'Proin eu justo at urna bibendum euismod. In eu urna sem. Donec ac dignissim purus, eu adipiscing risus. Nunc est est, tempus non augue et, porta dapibus ante. Maecenas eu tempor magna. Nullam elit tortor, placerat id libero porttitor, euismod dignissim ni', '2013-08-28 14:20:03', '78e1c423732bc3e8dafd3df857499cc1', 1, 0, 1, '*', '2013-06-22 07:51:33', '0000-00-00 00:00:00', '2013-06-22 07:51:33', '0000-00-00 00:00:00', 0, 0, 3, 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),
(18, 'index.php?option=com_content&view=article&id=115', 'index.php?option=com_content&view=article&id=115:unique-design', 'Unique Design', 'Suspendisse sed erat ut nunc adipiscing fermentum. Sed id odio aliquam, iaculis lectus a, congue turpis. In quis arcu auctor eros dictum cursus. Nullam nibh felis, suscipit non tellus sit amet, convallis porta sapien. Proin luctus vel nisi ac sollicitudin', '2013-08-28 14:20:18', '0603e7c2e18c1ecb6fbad79849d52179', 1, 0, 1, '*', '2013-06-22 07:52:13', '0000-00-00 00:00:00', '2013-06-22 07:52:13', '0000-00-00 00:00:00', 0, 0, 3, 0x4f3a31393a2246696e646572496e6465786572526573756c74223a31383a7b733a31313a22002a00656c656d656e7473223b613a32343a7b733a323a226964223b733a333a22313135223b733a353a22616c696173223b733a31333a22756e697175652d64657369676e223b733a373a2273756d6d617279223b733a3538363a223c703e53757370656e6469737365207365642065726174207574206e756e632061646970697363696e67206665726d656e74756d2e20536564206964206f64696f20616c697175616d2c20696163756c6973206c656374757320612c20636f6e677565207475727069732e20496e2071756973206172637520617563746f722065726f732064696374756d206375727375732e204e756c6c616d206e6962682066656c69732c207375736369706974206e6f6e2074656c6c75732073697420616d65742c20636f6e76616c6c697320706f7274612073617069656e2e2050726f696e206c75637475732076656c206e69736920616320736f6c6c696369747564696e2e2043757261626974757220766974616520736f6c6c696369747564696e20617263752e204d616563656e6173207363656c6572697371756520666163696c69736973206469616d20657520766976657272612e204e756c6c61206e65632075726e612073697420616d657420617567756520616c697175616d20706c6163657261742e204e756c6c616d207361676974746973206d69207175697320696d70657264696574206c75637475732e20467573636520696e206d6f6c6573746965206a7573746f2e2043756d20736f63696973206e61746f7175652070656e617469627573206574206d61676e6973206469732070617274757269656e74206d6f6e7465732c206e61736365747572207269646963756c7573206d75732e20536564206e6f6e2074656d707573206f64696f2c2065742070756c76696e6172206e756e632e3c2f703e223b733a343a22626f6479223b733a303a22223b733a353a226361746964223b733a323a223835223b733a31303a22637265617465645f6279223b733a333a22393638223b733a31363a22637265617465645f62795f616c696173223b733a303a22223b733a383a226d6f646966696564223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31313a226d6f6469666965645f6279223b733a313a2230223b733a363a22706172616d73223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a36383a7b733a31343a2261727469636c655f6c61796f7574223b733a393a225f3a64656661756c74223b733a31303a2273686f775f7469746c65223b733a313a2231223b733a31313a226c696e6b5f7469746c6573223b733a313a2231223b733a31303a2273686f775f696e74726f223b733a313a2231223b733a31333a2273686f775f63617465676f7279223b733a313a2231223b733a31333a226c696e6b5f63617465676f7279223b733a313a2231223b733a32303a2273686f775f706172656e745f63617465676f7279223b733a313a2230223b733a32303a226c696e6b5f706172656e745f63617465676f7279223b733a313a2230223b733a31313a2273686f775f617574686f72223b733a313a2231223b733a31313a226c696e6b5f617574686f72223b733a313a2230223b733a31363a2273686f775f6372656174655f64617465223b733a313a2231223b733a31363a2273686f775f6d6f646966795f64617465223b733a313a2230223b733a31373a2273686f775f7075626c6973685f64617465223b733a313a2230223b733a32303a2273686f775f6974656d5f6e617669676174696f6e223b733a313a2230223b733a393a2273686f775f766f7465223b733a313a2230223b733a31333a2273686f775f726561646d6f7265223b733a313a2231223b733a31393a2273686f775f726561646d6f72655f7469746c65223b733a313a2230223b733a31343a22726561646d6f72655f6c696d6974223b733a333a22313030223b733a31303a2273686f775f69636f6e73223b733a313a2230223b733a31353a2273686f775f7072696e745f69636f6e223b733a313a2230223b733a31353a2273686f775f656d61696c5f69636f6e223b733a313a2230223b733a393a2273686f775f68697473223b733a313a2231223b733a31313a2273686f775f6e6f61757468223b733a313a2230223b733a31333a2275726c735f706f736974696f6e223b733a313a2230223b733a32333a2273686f775f7075626c697368696e675f6f7074696f6e73223b733a313a2231223b733a32303a2273686f775f61727469636c655f6f7074696f6e73223b733a313a2231223b733a32353a2273686f775f75726c735f696d616765735f66726f6e74656e64223b733a313a2231223b733a32343a2273686f775f75726c735f696d616765735f6261636b656e64223b733a313a2231223b733a373a2274617267657461223b693a303b733a373a2274617267657462223b693a303b733a373a2274617267657463223b693a303b733a31313a22666c6f61745f696e74726f223b733a343a226c656674223b733a31343a22666c6f61745f66756c6c74657874223b733a343a226c656674223b733a31353a2263617465676f72795f6c61796f7574223b733a363a225f3a626c6f67223b733a31393a2273686f775f63617465676f72795f7469746c65223b733a313a2230223b733a31363a2273686f775f6465736372697074696f6e223b733a313a2230223b733a32323a2273686f775f6465736372697074696f6e5f696d616765223b733a313a2230223b733a383a226d61784c6576656c223b733a313a2231223b733a32313a2273686f775f656d7074795f63617465676f72696573223b733a313a2230223b733a31363a2273686f775f6e6f5f61727469636c6573223b733a313a2231223b733a31363a2273686f775f7375626361745f64657363223b733a313a2231223b733a32313a2273686f775f6361745f6e756d5f61727469636c6573223b733a313a2230223b733a32313a2273686f775f626173655f6465736372697074696f6e223b733a313a2231223b733a31313a226d61784c6576656c636174223b733a323a222d31223b733a32353a2273686f775f656d7074795f63617465676f726965735f636174223b733a313a2230223b733a32303a2273686f775f7375626361745f646573635f636174223b733a313a2231223b733a32353a2273686f775f6361745f6e756d5f61727469636c65735f636174223b733a313a2231223b733a32303a226e756d5f6c656164696e675f61727469636c6573223b733a313a2231223b733a31383a226e756d5f696e74726f5f61727469636c6573223b733a313a2234223b733a31313a226e756d5f636f6c756d6e73223b733a313a2231223b733a393a226e756d5f6c696e6b73223b733a313a2234223b733a31383a226d756c74695f636f6c756d6e5f6f72646572223b733a313a2230223b733a32343a2273686f775f73756263617465676f72795f636f6e74656e74223b733a313a2230223b733a32313a2273686f775f706167696e6174696f6e5f6c696d6974223b733a313a2231223b733a31323a2266696c7465725f6669656c64223b733a343a2268696465223b733a31333a2273686f775f68656164696e6773223b733a313a2231223b733a31343a226c6973745f73686f775f64617465223b733a313a2230223b733a31313a22646174655f666f726d6174223b733a303a22223b733a31343a226c6973745f73686f775f68697473223b733a313a2231223b733a31363a226c6973745f73686f775f617574686f72223b733a313a2231223b733a31313a226f7264657262795f707269223b733a353a226f72646572223b733a31313a226f7264657262795f736563223b733a353a227264617465223b733a31303a226f726465725f64617465223b733a393a227075626c6973686564223b733a31353a2273686f775f706167696e6174696f6e223b733a313a2232223b733a32333a2273686f775f706167696e6174696f6e5f726573756c7473223b733a313a2231223b733a31343a2273686f775f666565645f6c696e6b223b733a313a2231223b733a31323a22666565645f73756d6d617279223b733a313a2230223b733a31383a22666565645f73686f775f726561646d6f7265223b733a313a2230223b7d7d733a373a226d6574616b6579223b733a303a22223b733a383a226d65746164657363223b733a303a22223b733a383a226d65746164617461223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a343a7b733a363a22726f626f7473223b733a303a22223b733a363a22617574686f72223b733a303a22223b733a363a22726967687473223b733a303a22223b733a31303a22787265666572656e6365223b733a303a22223b7d7d733a373a2276657273696f6e223b733a313a2231223b733a383a226f72646572696e67223b733a313a2230223b733a383a2263617465676f7279223b733a31353a225870657274204163636f7264696f6e223b733a393a226361745f7374617465223b733a323a222d32223b733a31303a226361745f616363657373223b733a313a2231223b733a343a22736c7567223b733a31373a223131353a756e697175652d64657369676e223b733a373a22636174736c7567223b733a31383a2238353a78706572742d6163636f7264696f6e223b733a363a22617574686f72223b733a31303a2253757065722055736572223b733a363a226c61796f7574223b733a373a2261727469636c65223b733a343a2270617468223b733a35363a22696e6465782e7068702f636f6d706f6e656e742f636f6e74656e742f61727469636c653f69643d3131353a756e697175652d64657369676e223b733a31303a226d657461617574686f72223b4e3b7d733a31353a22002a00696e737472756374696f6e73223b613a353a7b693a313b613a333a7b693a303b733a353a227469746c65223b693a313b733a383a227375627469746c65223b693a323b733a323a226964223b7d693a323b613a323a7b693a303b733a373a2273756d6d617279223b693a313b733a343a22626f6479223b7d693a333b613a383a7b693a303b733a343a226d657461223b693a313b733a31303a226c6973745f7072696365223b693a323b733a31303a2273616c655f7072696365223b693a333b733a373a226d6574616b6579223b693a343b733a383a226d65746164657363223b693a353b733a31303a226d657461617574686f72223b693a363b733a363a22617574686f72223b693a373b733a31363a22637265617465645f62795f616c696173223b7d693a343b613a323a7b693a303b733a343a2270617468223b693a313b733a353a22616c696173223b7d693a353b613a313a7b693a303b733a383a22636f6d6d656e7473223b7d7d733a31313a22002a007461786f6e6f6d79223b613a343a7b733a343a2254797065223b613a313a7b733a373a2241727469636c65223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a373a2241727469636c65223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a363a22417574686f72223b613a313a7b733a31303a2253757065722055736572223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31303a2253757065722055736572223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a383a2243617465676f7279223b613a313a7b733a31353a225870657274204163636f7264696f6e223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31353a225870657274204163636f7264696f6e223b733a353a227374617465223b693a2d323b733a363a22616363657373223b693a313b7d7d733a383a224c616e6775616765223b613a313a7b733a313a222a223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a313a222a223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d7d733a333a2275726c223b733a34383a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d313135223b733a353a22726f757465223b733a36323a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d3131353a756e697175652d64657369676e223b733a353a227469746c65223b733a31333a22556e697175652044657369676e223b733a31313a226465736372697074696f6e223b733a3537393a2253757370656e6469737365207365642065726174207574206e756e632061646970697363696e67206665726d656e74756d2e20536564206964206f64696f20616c697175616d2c20696163756c6973206c656374757320612c20636f6e677565207475727069732e20496e2071756973206172637520617563746f722065726f732064696374756d206375727375732e204e756c6c616d206e6962682066656c69732c207375736369706974206e6f6e2074656c6c75732073697420616d65742c20636f6e76616c6c697320706f7274612073617069656e2e2050726f696e206c75637475732076656c206e69736920616320736f6c6c696369747564696e2e2043757261626974757220766974616520736f6c6c696369747564696e20617263752e204d616563656e6173207363656c6572697371756520666163696c69736973206469616d20657520766976657272612e204e756c6c61206e65632075726e612073697420616d657420617567756520616c697175616d20706c6163657261742e204e756c6c616d207361676974746973206d69207175697320696d70657264696574206c75637475732e20467573636520696e206d6f6c6573746965206a7573746f2e2043756d20736f63696973206e61746f7175652070656e617469627573206574206d61676e6973206469732070617274757269656e74206d6f6e7465732c206e61736365747572207269646963756c7573206d75732e20536564206e6f6e2074656d707573206f64696f2c2065742070756c76696e6172206e756e632e223b733a393a227075626c6973686564223b4e3b733a353a227374617465223b693a303b733a363a22616363657373223b733a313a2231223b733a383a226c616e6775616765223b733a313a222a223b733a31383a227075626c6973685f73746172745f64617465223b733a31393a22323031332d30362d32322030373a35323a3133223b733a31363a227075626c6973685f656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a2273746172745f64617465223b733a31393a22323031332d30362d32322030373a35323a3133223b733a383a22656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a226c6973745f7072696365223b4e3b733a31303a2273616c655f7072696365223b4e3b733a373a22747970655f6964223b693a333b7d),
(19, 'index.php?option=com_content&view=article&id=116', 'index.php?option=com_content&view=article&id=116:neil-braine', 'Neil Braine', 'Sed vitae turpis sem. Pellentesque adipiscing ante ipsum, auctor bibendum nunc tristique sit amet. Suspendisse ligula mauris, lobortis vitae ipsum sed, ullamcorper suscipit lacus. Proin porta quam vel semper sollicitudin. In hac habitasse platea dictumst.', '2013-08-28 14:20:12', '00c986addeb1e2e558eac0be31e8d6a8', 1, 0, 1, '*', '2013-06-22 08:54:50', '0000-00-00 00:00:00', '2013-06-22 08:54:50', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(20, 'index.php?option=com_content&view=article&id=117', 'index.php?option=com_content&view=article&id=117:keith-morgan', 'Keith Morgan', 'Proin eu justo at urna bibendum euismod. In eu urna sem. Donec ac dignissim purus, eu adipiscing risus. Nunc est est, tempus non augue et, porta dapibus ante. Maecenas eu tempor magna. Nullam elit tortor, placerat id libero porttitor, euismod dignissim ni', '2013-08-28 14:20:10', '2de9e6d0a06f9ccaafb9032274738a5f', 1, 0, 1, '*', '2013-06-22 08:56:20', '0000-00-00 00:00:00', '2013-06-22 08:56:20', '0000-00-00 00:00:00', 0, 0, 3, 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),
(21, 'index.php?option=com_content&view=article&id=121', 'index.php?option=com_content&view=article&id=121:albert-ryan', 'Albert Ryan', 'Donec scelerisque molestie mi sit amet vestibulum. Proin rutrum gravida sapien, vel interdum leo consequat ut. Etiam suscipit nibh volutpat tempor malesuada rhoncus volutpat augue, in fermentum lorem. Sed pharetra dapibus felis in venenatis.', '2013-08-28 14:19:59', 'cf350ede75969d0bd372fd1806fcdc17', 1, 0, 1, '*', '2013-07-08 12:35:57', '0000-00-00 00:00:00', '2013-07-08 12:35:57', '0000-00-00 00:00:00', 0, 0, 3, 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),
(22, 'index.php?option=com_content&view=article&id=122', 'index.php?option=com_content&view=article&id=122:jonathon', 'Jonathon', 'Fermentum pellentesque viverra sapien in ipsum scelerisque accumsan. Sed sit amet cursus elit. Aliquam nec magna eu sapien sollicitudin semper a dapibus nisi. Etiam suscipit nibh volutpat tempor malesuada. Aenean eget nulla quis purus lobortis volutpat.', '2013-08-28 14:20:08', 'cc3e13701b673a2ed20fca76300d49dd', 1, 0, 1, '*', '2013-07-11 09:49:03', '0000-00-00 00:00:00', '2013-07-11 09:49:03', '0000-00-00 00:00:00', 0, 0, 3, 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),
(23, 'index.php?option=com_content&view=article&id=118', 'index.php?option=com_content&view=article&id=118:nullam-lobortis', 'Nullam Lobortis', 'Nullam lobortis vulputate lacinia.', '2013-08-28 14:20:13', '5eb422d4eca41aaa327b9c136f25af97', 1, 0, 1, '*', '2013-07-02 06:47:31', '0000-00-00 00:00:00', '2013-07-02 06:47:31', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(24, 'index.php?option=com_content&view=article&id=119', 'index.php?option=com_content&view=article&id=119:aliquam', 'Aliquam', 'Aliquam erat volutpat.', '2013-09-06 18:51:10', 'ea867119488923b598dd319066bdeb03', 1, 0, 1, '*', '2013-07-02 06:48:42', '0000-00-00 00:00:00', '2013-07-02 06:48:42', '0000-00-00 00:00:00', 0, 0, 3, 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),
(25, 'index.php?option=com_content&view=article&id=120', 'index.php?option=com_content&view=article&id=120:mauris-a-orci', 'Mauris a orci', 'Mauris a orci eu augue cursus lacinia in sed elit.', '2013-09-06 18:51:11', '51d39d9077f5a9c182313ed05f41ab0d', 1, 0, 1, '*', '2013-07-02 07:08:42', '0000-00-00 00:00:00', '2013-07-02 07:08:42', '0000-00-00 00:00:00', 0, 0, 3, 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),
(26, 'index.php?option=com_content&view=article&id=102', 'index.php?option=com_content&view=article&id=102:bablu', 'Bablu', 'SEO Expert', '2013-08-28 14:20:00', '86ca9835321e83d0898f179d4a9ccabd', 1, 0, 1, '*', '2013-01-21 01:00:20', '0000-00-00 00:00:00', '2013-01-21 01:00:20', '0000-00-00 00:00:00', 0, 0, 3, 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),
(27, 'index.php?option=com_content&view=article&id=99', 'index.php?option=com_content&view=article&id=99:biddut', 'Biddut', 'Article Writter', '2013-08-28 14:20:01', '688005805f1a318591583ed3afbbe1c7', 1, 0, 1, '*', '2013-01-21 00:56:14', '0000-00-00 00:00:00', '2013-01-21 00:56:14', '0000-00-00 00:00:00', 0, 0, 3, 0x4f3a31393a2246696e646572496e6465786572526573756c74223a31383a7b733a31313a22002a00656c656d656e7473223b613a32343a7b733a323a226964223b733a323a223939223b733a353a22616c696173223b733a363a22626964647574223b733a373a2273756d6d617279223b733a32323a223c703e41727469636c6520577269747465723c2f703e223b733a343a22626f6479223b733a303a22223b733a353a226361746964223b733a323a223831223b733a31303a22637265617465645f6279223b733a333a22393638223b733a31363a22637265617465645f62795f616c696173223b733a303a22223b733a383a226d6f646966696564223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31313a226d6f6469666965645f6279223b733a313a2230223b733a363a22706172616d73223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a36383a7b733a31343a2261727469636c655f6c61796f7574223b733a393a225f3a64656661756c74223b733a31303a2273686f775f7469746c65223b733a313a2231223b733a31313a226c696e6b5f7469746c6573223b733a313a2231223b733a31303a2273686f775f696e74726f223b733a313a2231223b733a31333a2273686f775f63617465676f7279223b733a313a2231223b733a31333a226c696e6b5f63617465676f7279223b733a313a2231223b733a32303a2273686f775f706172656e745f63617465676f7279223b733a313a2230223b733a32303a226c696e6b5f706172656e745f63617465676f7279223b733a313a2230223b733a31313a2273686f775f617574686f72223b733a313a2231223b733a31313a226c696e6b5f617574686f72223b733a313a2230223b733a31363a2273686f775f6372656174655f64617465223b733a313a2231223b733a31363a2273686f775f6d6f646966795f64617465223b733a313a2230223b733a31373a2273686f775f7075626c6973685f64617465223b733a313a2230223b733a32303a2273686f775f6974656d5f6e617669676174696f6e223b733a313a2230223b733a393a2273686f775f766f7465223b733a313a2230223b733a31333a2273686f775f726561646d6f7265223b733a313a2231223b733a31393a2273686f775f726561646d6f72655f7469746c65223b733a313a2230223b733a31343a22726561646d6f72655f6c696d6974223b733a333a22313030223b733a31303a2273686f775f69636f6e73223b733a313a2230223b733a31353a2273686f775f7072696e745f69636f6e223b733a313a2230223b733a31353a2273686f775f656d61696c5f69636f6e223b733a313a2230223b733a393a2273686f775f68697473223b733a313a2231223b733a31313a2273686f775f6e6f61757468223b733a313a2230223b733a31333a2275726c735f706f736974696f6e223b733a313a2230223b733a32333a2273686f775f7075626c697368696e675f6f7074696f6e73223b733a313a2231223b733a32303a2273686f775f61727469636c655f6f7074696f6e73223b733a313a2231223b733a32353a2273686f775f75726c735f696d616765735f66726f6e74656e64223b733a313a2231223b733a32343a2273686f775f75726c735f696d616765735f6261636b656e64223b733a313a2231223b733a373a2274617267657461223b693a303b733a373a2274617267657462223b693a303b733a373a2274617267657463223b693a303b733a31313a22666c6f61745f696e74726f223b733a343a226c656674223b733a31343a22666c6f61745f66756c6c74657874223b733a343a226c656674223b733a31353a2263617465676f72795f6c61796f7574223b733a363a225f3a626c6f67223b733a31393a2273686f775f63617465676f72795f7469746c65223b733a313a2230223b733a31363a2273686f775f6465736372697074696f6e223b733a313a2230223b733a32323a2273686f775f6465736372697074696f6e5f696d616765223b733a313a2230223b733a383a226d61784c6576656c223b733a313a2231223b733a32313a2273686f775f656d7074795f63617465676f72696573223b733a313a2230223b733a31363a2273686f775f6e6f5f61727469636c6573223b733a313a2231223b733a31363a2273686f775f7375626361745f64657363223b733a313a2231223b733a32313a2273686f775f6361745f6e756d5f61727469636c6573223b733a313a2230223b733a32313a2273686f775f626173655f6465736372697074696f6e223b733a313a2231223b733a31313a226d61784c6576656c636174223b733a323a222d31223b733a32353a2273686f775f656d7074795f63617465676f726965735f636174223b733a313a2230223b733a32303a2273686f775f7375626361745f646573635f636174223b733a313a2231223b733a32353a2273686f775f6361745f6e756d5f61727469636c65735f636174223b733a313a2231223b733a32303a226e756d5f6c656164696e675f61727469636c6573223b733a313a2231223b733a31383a226e756d5f696e74726f5f61727469636c6573223b733a313a2234223b733a31313a226e756d5f636f6c756d6e73223b733a313a2231223b733a393a226e756d5f6c696e6b73223b733a313a2234223b733a31383a226d756c74695f636f6c756d6e5f6f72646572223b733a313a2230223b733a32343a2273686f775f73756263617465676f72795f636f6e74656e74223b733a313a2230223b733a32313a2273686f775f706167696e6174696f6e5f6c696d6974223b733a313a2231223b733a31323a2266696c7465725f6669656c64223b733a343a2268696465223b733a31333a2273686f775f68656164696e6773223b733a313a2231223b733a31343a226c6973745f73686f775f64617465223b733a313a2230223b733a31313a22646174655f666f726d6174223b733a303a22223b733a31343a226c6973745f73686f775f68697473223b733a313a2231223b733a31363a226c6973745f73686f775f617574686f72223b733a313a2231223b733a31313a226f7264657262795f707269223b733a353a226f72646572223b733a31313a226f7264657262795f736563223b733a353a227264617465223b733a31303a226f726465725f64617465223b733a393a227075626c6973686564223b733a31353a2273686f775f706167696e6174696f6e223b733a313a2232223b733a32333a2273686f775f706167696e6174696f6e5f726573756c7473223b733a313a2231223b733a31343a2273686f775f666565645f6c696e6b223b733a313a2231223b733a31323a22666565645f73756d6d617279223b733a313a2230223b733a31383a22666565645f73686f775f726561646d6f7265223b733a313a2230223b7d7d733a373a226d6574616b6579223b733a303a22223b733a383a226d65746164657363223b733a303a22223b733a383a226d65746164617461223b4f3a393a224a5265676973747279223a313a7b733a373a22002a0064617461223b4f3a383a22737464436c617373223a343a7b733a363a22726f626f7473223b733a303a22223b733a363a22617574686f72223b733a303a22223b733a363a22726967687473223b733a303a22223b733a31303a22787265666572656e6365223b733a303a22223b7d7d733a373a2276657273696f6e223b733a313a2231223b733a383a226f72646572696e67223b733a313a2234223b733a383a2263617465676f7279223b733a31323a225465616d204d656d62657273223b733a393a226361745f7374617465223b733a323a222d32223b733a31303a226361745f616363657373223b733a313a2231223b733a343a22736c7567223b733a393a2239393a626964647574223b733a373a22636174736c7567223b733a31353a2238313a7465616d2d6d656d62657273223b733a363a22617574686f72223b733a31303a2253757065722055736572223b733a363a226c61796f7574223b733a373a2261727469636c65223b733a343a2270617468223b733a34383a22696e6465782e7068702f636f6d706f6e656e742f636f6e74656e742f61727469636c653f69643d39393a626964647574223b733a31303a226d657461617574686f72223b4e3b7d733a31353a22002a00696e737472756374696f6e73223b613a353a7b693a313b613a333a7b693a303b733a353a227469746c65223b693a313b733a383a227375627469746c65223b693a323b733a323a226964223b7d693a323b613a323a7b693a303b733a373a2273756d6d617279223b693a313b733a343a22626f6479223b7d693a333b613a383a7b693a303b733a343a226d657461223b693a313b733a31303a226c6973745f7072696365223b693a323b733a31303a2273616c655f7072696365223b693a333b733a373a226d6574616b6579223b693a343b733a383a226d65746164657363223b693a353b733a31303a226d657461617574686f72223b693a363b733a363a22617574686f72223b693a373b733a31363a22637265617465645f62795f616c696173223b7d693a343b613a323a7b693a303b733a343a2270617468223b693a313b733a353a22616c696173223b7d693a353b613a313a7b693a303b733a383a22636f6d6d656e7473223b7d7d733a31313a22002a007461786f6e6f6d79223b613a343a7b733a343a2254797065223b613a313a7b733a373a2241727469636c65223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a373a2241727469636c65223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a363a22417574686f72223b613a313a7b733a31303a2253757065722055736572223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31303a2253757065722055736572223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d733a383a2243617465676f7279223b613a313a7b733a31323a225465616d204d656d62657273223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a31323a225465616d204d656d62657273223b733a353a227374617465223b693a2d323b733a363a22616363657373223b693a313b7d7d733a383a224c616e6775616765223b613a313a7b733a313a222a223b4f3a373a224a4f626a656374223a343a7b733a31303a22002a005f6572726f7273223b613a303a7b7d733a353a227469746c65223b733a313a222a223b733a353a227374617465223b693a313b733a363a22616363657373223b693a313b7d7d7d733a333a2275726c223b733a34373a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d3939223b733a353a22726f757465223b733a35343a22696e6465782e7068703f6f7074696f6e3d636f6d5f636f6e74656e7426766965773d61727469636c652669643d39393a626964647574223b733a353a227469746c65223b733a363a22426964647574223b733a31313a226465736372697074696f6e223b733a31353a2241727469636c652057726974746572223b733a393a227075626c6973686564223b4e3b733a353a227374617465223b693a303b733a363a22616363657373223b733a313a2231223b733a383a226c616e6775616765223b733a313a222a223b733a31383a227075626c6973685f73746172745f64617465223b733a31393a22323031332d30312d32312030303a35363a3134223b733a31363a227075626c6973685f656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a2273746172745f64617465223b733a31393a22323031332d30312d32312030303a35363a3134223b733a383a22656e645f64617465223b733a31393a22303030302d30302d30302030303a30303a3030223b733a31303a226c6973745f7072696365223b4e3b733a31303a2273616c655f7072696365223b4e3b733a373a22747970655f6964223b693a333b7d),
(28, 'index.php?option=com_content&view=article&id=98', 'index.php?option=com_content&view=article&id=98:bob', 'Bob', 'Programmer', '2013-08-28 14:20:02', 'a5c4574bf91748d0d4842acc02816610', 1, 0, 1, '*', '2013-01-21 00:55:23', '0000-00-00 00:00:00', '2013-01-21 00:55:23', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(29, 'index.php?option=com_content&view=article&id=96', 'index.php?option=com_content&view=article&id=96:john', 'John', 'Developer', '2013-08-28 14:20:06', '988e1859e595b6670abbc7037ca7bdab', 1, 0, 1, '*', '2013-01-21 00:36:41', '0000-00-00 00:00:00', '2013-01-21 00:36:41', '0000-00-00 00:00:00', 0, 0, 3, 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),
(30, 'index.php?option=com_content&view=article&id=110', 'index.php?option=com_content&view=article&id=110:kamal', 'Kamal', 'Programmer', '2013-08-28 14:20:09', 'a91940e0595145c6823793c51c21c4f2', 1, 0, 1, '*', '2013-02-04 11:41:27', '0000-00-00 00:00:00', '2013-02-04 11:41:27', '0000-00-00 00:00:00', 0, 0, 3, 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),
(31, 'index.php?option=com_content&view=article&id=101', 'index.php?option=com_content&view=article&id=101:morgan', 'Morgan', 'Chief Developer', '2013-08-28 14:20:10', '6c8682db12ea9c6557d5b1c04c2d4232', 1, 0, 1, '*', '2013-01-21 00:59:26', '0000-00-00 00:00:00', '2013-01-21 00:59:26', '0000-00-00 00:00:00', 0, 0, 3, 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),
(32, 'index.php?option=com_content&view=article&id=100', 'index.php?option=com_content&view=article&id=100:rakib', 'Rakib', 'Designer', '2013-08-28 14:20:14', '622995ce96ce2a2ae7706c3740135a81', 1, 0, 1, '*', '2013-01-21 00:57:39', '0000-00-00 00:00:00', '2013-01-21 00:57:39', '0000-00-00 00:00:00', 0, 0, 3, 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),
(33, 'index.php?option=com_content&view=article&id=97', 'index.php?option=com_content&view=article&id=97:ricardo', 'Ricardo', 'Designer', '2013-08-28 14:20:15', '41f958be3166bdf70ae7783e38c061f7', 1, 0, 1, '*', '2013-01-21 00:37:13', '0000-00-00 00:00:00', '2013-01-21 00:37:13', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(34, 'index.php?option=com_content&view=article&id=124', 'index.php?option=com_content&view=article&id=124:xpert-accordion&catid=83:extensions&Itemid=635', 'Xpert Accordion', 'Our first Responsive accordion module for Joomla 2.5. The Xpert Accordion is the next revolutionary step forward in the ThemeXpert arena to managing Web page content via accordion.This module will give you essence of responsiveness within module and now y', '2013-08-28 14:20:20', '024ff4e681256c3d7cf904efc6fb4c2f', 1, 0, 1, '*', '2013-07-16 10:52:40', '0000-00-00 00:00:00', '2013-07-16 10:52:40', '0000-00-00 00:00:00', 0, 0, 3, 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),
(35, 'index.php?option=com_content&view=article&id=123', 'index.php?option=com_content&view=article&id=123:xpert-captions&catid=83:extensions&Itemid=636', 'Xpert Captions', 'To allow presenting contents in a dazzling way, Themexpert brings a brand new module Xpert Caption. It’s a box and caption plug-in offering numerous effects and sliding options. It adds fade/slide effect and also allows caption and image sliding in multid', '2013-08-28 14:20:21', '257862fd7d9e4bdff0839a12969a22fb', 1, 0, 1, '*', '2013-07-16 10:47:23', '0000-00-00 00:00:00', '2013-07-16 10:47:23', '0000-00-00 00:00:00', 0, 0, 3, 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),
(36, 'index.php?option=com_content&view=article&id=108', 'index.php?option=com_content&view=article&id=108:xpert-scroller&catid=83:extensions&Itemid=586', 'Xpert Scroller', 'XpertScroller is our next generation extensions based on the GNU General Public License V2. Based on the experiences we have gathered and through hard practice, we created probably the best tool to present articles for Joomla! Numerous options and possibi', '2013-08-28 14:20:22', '3f394ecdb8c518eddfa155237ae914a3', 1, 0, 1, '*', '2013-02-04 09:42:04', '0000-00-00 00:00:00', '2013-02-04 09:42:04', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(37, 'index.php?option=com_content&view=article&id=87', 'index.php?option=com_content&view=article&id=87:joomla-ecommerce-template&catid=79:slider', 'Joomla ecommerce template', 'Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus ', '2013-08-28 16:42:18', 'd7a3a4f0d9f0cf748108760c40a4fb2a', 1, 1, 1, '*', '2013-01-20 18:44:57', '0000-00-00 00:00:00', '2013-01-20 18:44:57', '0000-00-00 00:00:00', 0, 0, 3, 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),
(38, 'index.php?option=com_content&view=article&id=84', 'index.php?option=com_content&view=article&id=84:expose-framework&catid=79:slider', 'Expose Framework', 'Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus ', '2013-08-28 16:43:15', '983306e1ce458b3344085b2c52376a83', 1, 1, 1, '*', '2013-01-20 02:56:09', '0000-00-00 00:00:00', '2013-01-20 02:56:09', '0000-00-00 00:00:00', 0, 0, 3, 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),
(39, 'index.php?option=com_content&view=article&id=85', 'index.php?option=com_content&view=article&id=85:rich-theme-documentation&catid=79:slider', 'Rich Theme Documentation', 'Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus ', '2013-08-28 16:44:09', 'f15e097e498d8ccd6d82f58b0904b718', 1, 1, 1, '*', '2013-01-20 02:58:02', '0000-00-00 00:00:00', '2013-01-20 02:58:02', '0000-00-00 00:00:00', 0, 0, 3, 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),
(40, 'index.php?option=com_content&view=article&id=86', 'index.php?option=com_content&view=article&id=86:build-your-site-within-a-minute&catid=79:slider', 'Build Your Site Within A Minute', 'Aenean nec augue vel orci congue faucibus. Proin at ante non lorem placerat mollis quis a dolor. Suspendisse posuere mi at lacus feugiat tincidunt. Phasellus pretium aliquet neque, convallis posuere felis imperdiet nec. Donec hendrerit, erat non faucibus ', '2013-08-28 16:44:19', 'e280cf7cf4c6466b6ae65ab1cecb24fa', 1, 0, 1, '*', '2013-01-20 02:59:11', '0000-00-00 00:00:00', '2013-01-20 02:59:11', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(41, 'index.php?option=com_content&view=article&id=107', 'index.php?option=com_content&view=article&id=107:xpert-slider&catid=83:extensions&Itemid=585', 'Xpert Slider', 'A Revolutionary responsive slideshow module made with HTML5, CSS3 and jQuery. Tons of features and animation stand it outside of the crowd. We completely revamped module admin interface and made it super simple and easy to use. With you in mind we made th', '2013-09-06 18:48:17', '7de917c71f08d7c1fa66dc97bd129b6e', 1, 1, 1, '*', '2013-02-04 09:41:18', '0000-00-00 00:00:00', '2013-02-04 09:41:18', '0000-00-00 00:00:00', 0, 0, 3, 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),
(42, 'index.php?option=com_content&view=article&id=109', 'index.php?option=com_content&view=article&id=109:xpert-tabs&catid=83:extensions&Itemid=587', 'Xpert Tabs', 'ThemeXpert is delighted to present its new extension Xpert Tabs, a tab module for presenting contents in a beautiful way in Joomla! Websites. Available in 5 presets, it should be quite adaptive in any type of sites due to its power to load any type conten', '2013-09-06 18:49:39', '3ea24cd6e14493c9fd3dcf998831b87e', 1, 1, 1, '*', '2013-02-04 09:42:57', '0000-00-00 00:00:00', '2013-02-04 09:42:57', '0000-00-00 00:00:00', 0, 0, 3, 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),
(43, 'index.php?option=com_content&view=article&id=126', 'index.php?option=com_content&view=article&id=126:albert-braine&catid=88:about-us', 'Albert braine', 'Design Wrangler', '2013-09-06 18:51:09', '936517d63181d96562a7ef0f18de6770', 1, 0, 1, '*', '2013-07-17 07:52:21', '0000-00-00 00:00:00', '2013-07-17 07:52:21', '0000-00-00 00:00:00', 0, 0, 3, 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),
(44, 'index.php?option=com_content&view=article&id=128', 'index.php?option=com_content&view=article&id=128:john-ryan&catid=88:about-us', 'John Ryan', 'Head of Ideas', '2013-09-06 18:51:10', 'dc1d9634f8e5cbe1c7bde3b30cc9ca62', 1, 0, 1, '*', '2013-07-17 07:54:05', '0000-00-00 00:00:00', '2013-07-17 07:54:05', '0000-00-00 00:00:00', 0, 0, 3, 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);
INSERT INTO `#__finder_links` (`link_id`, `url`, `route`, `title`, `description`, `indexdate`, `md5sum`, `published`, `state`, `access`, `language`, `publish_start_date`, `publish_end_date`, `start_date`, `end_date`, `list_price`, `sale_price`, `type_id`, `object`) VALUES
(45, 'index.php?option=com_content&view=article&id=127', 'index.php?option=com_content&view=article&id=127:neil-morgan&catid=88:about-us', 'Neil Morgan', 'Web Developer', '2013-09-06 18:51:11', '8e5d140e25b27a47ddf08153c17769d9', 1, 0, 1, '*', '2013-07-17 07:53:13', '0000-00-00 00:00:00', '2013-07-17 07:53:13', '0000-00-00 00:00:00', 0, 0, 3, 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),
(46, 'index.php?option=com_content&view=article&id=125', 'index.php?option=com_content&view=article&id=125:simon-ding&catid=88:about-us', 'Simon Ding', 'Support', '2013-09-06 18:51:12', 'd5a240d5b19852bca576ea0c2d77dd0e', 1, 0, 1, '*', '2013-07-17 07:51:09', '0000-00-00 00:00:00', '2013-07-17 07:51:09', '0000-00-00 00:00:00', 0, 0, 3, 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