<?php
defined('_JEXEC') or die('Restricted access');

/**
 * @author Valérie Isaksen
 * @version $Id$
 * @package VirtueMart
 * @subpackage payment
 * @copyright Copyright (C) 2004-Copyright (C) 2004-2013 Virtuemart Team. All rights reserved.   - All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.net
 */
if (!class_exists('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentSofort extends vmPSPlugin {
	const RELEASE = 'VM 2.0.22b';
	const SU_SOFORTBANKING = 'su';


	function __construct (& $subject, $config) {

		parent::__construct($subject, $config);

		$this->_loggable = TRUE;
		$this->tableFields = array_keys($this->getTableSQLFields());
		$this->_tablepkey = 'id'; //virtuemart_sofort_id';
		$this->_tableId = 'id'; //'virtuemart_sofort_id';
		$varsToPush = $this->getVarsToPush();

		$this->setConfigParameterable($this->_configTableFieldName, $varsToPush);

	}

	/**
	 * @return string
	 */
	public function getVmPluginCreateTableSQL () {

		return $this->createTableSQL('Payment Sofort Table');
	}

	/**
	 * @return array
	 */
	function getTableSQLFields () {

		$SQLfields = array(
			'id' => 'int(11) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id' => 'int(1) UNSIGNED',
			'order_number' => 'char(64)',
			'virtuemart_paymentmethod_id' => 'mediumint(1) UNSIGNED',
			'payment_name' => 'varchar(1000)',
			'payment_order_total' => 'decimal(15,5) NOT NULL',
			'payment_currency' => 'smallint(1)',
			'email_currency' => 'smallint(1)',
			'cost_per_transaction' => 'decimal(10,2)',
			'cost_percent_total' => 'decimal(10,2)',
			'tax_id' => 'smallint(1)',
			'sofort_custom' => 'varchar(255)',
			'security' => 'varchar(50)',
			'sofort_response_amount' => 'decimal(15,5) NOT NULL',
			'sofort_response_currency' => 'varchar(50)',
			'sofort_response_status' => 'varchar(50)',
			'sofort_response_status_reason' => 'varchar(50)',
			'sofort_response_transaction' => 'varchar(100)',
			'sofort_response_invoice' => 'varchar(1000)'
		);
		return $SQLfields;
	}

	/**
	 * @param $cart
	 * @param $order
	 * @return bool|null
	 */
	function plgVmConfirmedOrder ($cart, $order) {

		if (!($method = $this->getVmPluginMethod($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}

		$this->sendTransactionRequest($method,$cart, $order);


	}


	function displayErrors ($errors) {

		foreach ($errors as $error) {
			// TODO
			vmInfo(JText::sprintf('VMPAYMENT_SOFORT_ERROR_FROM', $error ['message'], $error ['field'], $error ['code']));
			if ($error ['message'] == 401) {
				vmdebug('check you payment parameters: custom_id, project_id, api key');
			}
		}
	}


	function sendTransactionRequest ($method, $cart, $order, $doRedirect = true) {


		$session = JFactory::getSession();
		$return_context = $session->getId();

//$this->_debug = $method->debug;
		//$this->logInfo('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');
		vmdebug('SOFORT plgVmConfirmedOrder');
		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		if (!class_exists('VirtueMartModelCurrency')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
		}
		if (!class_exists ('CurrencyDisplay')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
		}

		if (!class_exists('TableVendors')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'tables' . DS . 'vendors.php');
		}

		$this->getPaymentCurrency($method);
		$email_currency = $this->getEmailCurrency($method);
		$currency_code_3 = shopFunctions::getCurrencyByID($method->payment_currency, 'currency_code_3');
		$paymentCurrency = CurrencyDisplay::getInstance($method->payment_currency);
		$totalInPaymentCurrency = round($paymentCurrency->convertCurrencyTo($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2);
		$cd = CurrencyDisplay::getInstance($cart->pricesCurrency);
		if ($totalInPaymentCurrency <= 0) {
			vmInfo(JText::_('VMPAYMENT_SOFORT_AMOUNT_INCORRECT').$totalInPaymentCurrency);
			return FALSE;
		}
// Prepare data that should be stored in the database
		$dbValues['order_number'] = $order['details']['BT']->order_number;
		$dbValues['payment_name'] = $this->renderPluginName($method, 'create_order');
		$dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
		$dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		$dbValues['cost_percent_total'] = $method->cost_percent_total;
		$dbValues['payment_currency'] = $method->payment_currency;
		$dbValues['email_currency'] = $email_currency;
		$dbValues['payment_order_total'] = $totalInPaymentCurrency;
		$dbValues['tax_id'] = $method->tax_id;
		$dbValues['sofort_custom'] = $return_context;

		$security = self::getSecurityKey();
		$dbValues['security'] = $security;


		vmdebug('SOFORT plgVmConfirmedOrder ... after storePSPluginInternalData', $security);

		if (!class_exists('SofortLib')) {
			require(JPATH_ROOT . DS . 'plugins' . DS . 'vmpayment' . DS . 'sofort' . DS . 'sofort' . DS . 'library' . DS . 'sofortLib.php');
		}
		$sofort = new SofortLib_Multipay($method->configuration_key);
		$sofort->setVersion(self::RELEASE);
		$sofort->setAmount($totalInPaymentCurrency, $currency_code_3);
		$sofort->setReason($order['details']['BT']->order_number);
		$sofort->setSuccessUrl(self::getSuccessUrl($order));
		$sofort->setAbortUrl(self::getCancelUrl($order));
		$sofort->setNotificationUrl(self::getNotificationUrl($security, $order['details']['BT']->order_number));
		$sofort->setSofortueberweisung();
		$sofort->setSofortueberweisungCustomerprotection($method->buyer_protection);
		$sofort->sendRequest();
		vmdebug('SOFORT plgVmConfirmedOrder ... SofortLib_Multipay ... sendRequest()');
		if ($sofort->isError()) {
			$errors = $sofort->getErrors();
			vmdebug('SOFORT plgVmConfirmedOrder ... SofortLib_Multipay ... getErrors()', $errors);
			$this->displayErrors($errors);
			// TODO redirect to cancel URL
			//return $cancel_url;
			return;
		}
		$url = $sofort->getPaymentUrl();

		$dbValues['sofort_response_transaction'] = $sofort->getTransactionId();
		vmdebug('storePSPluginInternalData', $dbValues);
		$this->storePSPluginInternalData($dbValues);
		if ($doRedirect) {
			$mainframe = JFactory::getApplication();
			$mainframe->redirect($url);
		}

	}

	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetPaymentCurrency ($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}
		$this->getPaymentCurrency($method);
		$paymentCurrencyId = $method->payment_currency;
	}

	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetEmailCurrency ($virtuemart_paymentmethod_id, $virtuemart_order_id, &$emailCurrencyId) {

		if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($method->payment_element)) {
			return FALSE;
		}
		if (!($payments = $this->getDatasByOrderId($virtuemart_order_id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}
		//vmdebug('plgVmgetEmailCurrency', $payments);

		if (empty($payments[0]->email_currency)) {
			$vendorId = 1; //VirtueMartModelVendor::getLoggedVendor();
			$db = JFactory::getDBO();
			$q = 'SELECT   `vendor_currency` FROM `#__virtuemart_vendors` WHERE `virtuemart_vendor_id`=' . $vendorId;
			$db->setQuery($q);
			$emailCurrencyId = $db->loadResult();
		} else {
			$emailCurrencyId = $payments[0]->email_currency;
		}

	}

	/**
	 * @param $html
	 * @return bool|null|string
	 */
	function plgVmOnPaymentResponseReceived (&$html) {

		if (!class_exists('VirtueMartCart')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		if (!class_exists('shopFunctionsF')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}
		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}

		// the payment itself should send the parameter needed.
		$virtuemart_paymentmethod_id = JRequest::getInt('pm', 0);
		$order_number = JRequest::getString('on', 0);

		if (!($method = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
			//vmdebug('plgVmOnPaymentResponseReceived NOT getVmPluginMethod');
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($method->payment_element)) {
			//vmdebug('SOFORT plgVmOnPaymentResponseReceived NOT selectedThisElement');
			return NULL;
		}

		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
			//vmdebug('SOFORT plgVmOnPaymentResponseReceived NOT getOrderIdByOrderNumber');
			return NULL;
		}
		if (!($paymentTables = $this->getDatasByOrderId($virtuemart_order_id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}

		$orderModel = VmModel::getModel('orders');
		$order = $orderModel->getOrder($virtuemart_order_id);
		// may be we did not receive the notification
		// Thus the call of the success-URL should check, if the notification has already been arrived at the shop  .
		//If this is not true, a transaction detail request (step 4) should be triggered with the call of the success-URL,

		if (count($paymentTables) == 1) {
			$cart = VirtueMartCart::getCart();
			$this->sendTransactionRequest($cart, $order, false);
		}

		$html = $this->_getPaymentResponseHtml($method, $order, $paymentTables);
		//We delete the old stuff
		// get the correct cart / session
		$cart = VirtueMartCart::getCart();
		$cart->emptyCart();
		return TRUE;
	}

	/**
	 * @return bool|null
	 */
	function plgVmOnUserPaymentCancel () {


		$order_number = JRequest::getString('on', '');
		$virtuemart_paymentmethod_id = JRequest::getInt('pm', '');
		if (empty($order_number) or empty($virtuemart_paymentmethod_id) or !$this->selectedThisByMethodId($virtuemart_paymentmethod_id)) {
			vmdebug('plgVmOnUserPaymentCancel', $order_number, $virtuemart_paymentmethod_id);
			return NULL;
		}
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
			return NULL;
		}
		if (!($paymentTable = $this->getDataByOrderId($virtuemart_order_id))) {
			return NULL;
		}
		vmdebug('plgVmOnUserPaymentCancel', 'VMPAYMENT_SOFORT_PAYMENT_CANCELLED');

		VmInfo(Jtext::_('VMPAYMENT_SOFORT_PAYMENT_CANCELLED'));
		$session = JFactory::getSession();
		$return_context = $session->getId();
		if (strcmp($paymentTable->sofort_custom, $return_context) === 0) {
			vmDebug('handlePaymentUserCancel');
			$this->handlePaymentUserCancel($virtuemart_order_id);
		} else {
			vmDebug('Return context', $paymentTable->sofort_custom, $return_context);

		}
		return TRUE;
	}

	/*
		 * plgVmOnPaymentNotification() - This event is fired by Offline Payment. It can be used to validate the payment data as entered by the user.
		 * Return:
		 * Parameters:
		 *  None
		 *  @author Valerie Isaksen
		 */

	/**
	 * @return bool|null
	 */
	function plgVmOnPaymentNotification () {

		$this->_debug = true;

		if (!class_exists('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		$order_number = JRequest::getString('on', '');
		if (empty($order_number)) {
			$this->logInfo('plgVmOnPaymentNotification EMPTY order number' . $order_number, 'message');
			return FALSE;
		}
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
			$this->logInfo('plgVmOnPaymentNotification NO getOrderIdByOrderNumber ' . $order_number, 'message');
			return FALSE;
		}
		if (!($payments = $this->getDatasByOrderId($virtuemart_order_id))) {
			$this->logInfo('plgVmOnPaymentNotification NO getDatasByOrderId ' . $virtuemart_order_id, 'message');
			return FALSE;
		}
		$this->logInfo('plgVmOnPaymentNotification OK ', 'message');

		$method = $this->getVmPluginMethod($payments[0]->virtuemart_paymentmethod_id);
		if (!class_exists('SofortLib')) {
			require(JPATH_ROOT . DS . 'plugins' . DS . 'vmpayment' . DS . 'sofort' . DS . 'sofort' . DS . 'library' . DS . 'sofortLib.php');

		}

		$sofortLib_Notification = new SofortLib_Notification();
		$transactionId = $sofortLib_Notification->getNotification();

		//no valid parameters/xml
		if (empty($transactionId) || $sofortLib_Notification->isError()) {
			$this->logInfo('plgVmOnPaymentNotification NO transaaction or $sofortLib_Notification is error \n', 'message');
			return FALSE;
		}
		$this->logInfo('plgVmOnPaymentNotification transaction ' . $transactionId, 'message');

		$sofortLib_TransactionData = new SofortLib_TransactionData($method->configuration_key);
		$sofortLib_TransactionData->setTransaction($transactionId)->sendRequest();
		$this->logInfo('plgVmOnPaymentNotification setTransaction OK', 'message');

		// check that secret , and order are identical
		$security = JRequest::getString('security', '');
		if ($security != $payments[0]->security) {
			$this->logInfo('plgVmOnPaymentNotification SECURITY not the one expected GOT: ' . $security . ' stored: ' . $payments[0]->security, 'message');

			$emailBody = "Hello,\n\nerror while receiving a SOFORT NOTIFICATION" . "\n";
			$emailBody .= "for order number: " . $order_number . "\n";
			$emailBody .= "security token received: " . $security . "\n";
			$emailBody .= "security token expected: " . $payments[0]->security . "\n";
			$this->sendEmailToVendorAndAdmins(JText::_('VMPAYMENT_SOFORT_ERROR_NOTIFICATION'), $emailBody);
			return false;
		}
/*
		$this->logInfo('plgVmOnPaymentNotification check security OK', 'message');
		$this->logInfo('plgVmOnPaymentNotification isLoss?' . $sofortLib_TransactionData->isLoss() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification isPending?' . $sofortLib_TransactionData->isPending() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification isSofortvorkasse?' . $sofortLib_TransactionData->isSofortvorkasse() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification isSofortrechnung?' . $sofortLib_TransactionData->isSofortrechnung() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification getStatusReason?' . $sofortLib_TransactionData->getStatusReason() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification isReceived?' . $sofortLib_TransactionData->isReceived() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification isRefunded?' . $sofortLib_TransactionData->isRefunded() . ' ', 'message');
		$this->logInfo('plgVmOnPaymentNotification getPaymentMethod?' . $sofortLib_TransactionData->getPaymentMethod() . ' ', 'message');
*/

		$paymentMethod = $sofortLib_TransactionData->getPaymentMethod();
		if ($paymentMethod != self::SU_SOFORTBANKING) {
			// answer not expected
			$this->logInfo('plgVmOnPaymentNotification not the one one expected?' . $paymentMethod . ' ' . self::SU_SOFORTBANKING, 'message');
			$emailBody = "Hello,\n\nerror while receiving a SOFORT NOTIFICATION" . "\n";
			$emailBody .= "Payment method is " . $paymentMethod . " Should be SU \n";
			$this->sendEmailToVendorAndAdmins(JText::_('VMPAYMENT_SOFORT_ERROR_NOTIFICATION'), $emailBody);
			return false;
		}
		$this->logInfo('plgVmOnPaymentNotification so', 'message');

		$sofort_data['sofort_response_amount'] = $sofortLib_TransactionData->getAmount();
		$sofort_data['sofort_response_currency'] = $sofortLib_TransactionData->getCurrency();

		// check that the amount is the same
		if (!$this->_checkAmountAndCurrency($sofort_data, $payments)) {
			return false;
		}

		$modelOrder = VmModel::getModel('orders');
		$order = array();
		$status = 'status_' . $sofortLib_TransactionData->getStatus();
		//$this->logInfo('plgVmOnPaymentNotification getStatus:' .$status. ' '.var_export($method, true) , 'message');

		$order['customer_notified'] = true;
		$order['order_status'] = $method->$status;
		$order['comments'] = JText::_('VMPAYMENT_SOFORT_RESPONSE_STATUS_REASON_' . $sofortLib_TransactionData->getStatusReason());

		$sofort_data['sofort_response_status_reason'] = $sofortLib_TransactionData->getStatusReason();
		$sofort_data['sofort_response_transaction'] = $sofortLib_TransactionData->getTransaction();
		$sofort_data['payment_name'] = str_replace(array('\t', '\n'), '', $this->renderPluginName($method));
		$sofort_data['virtuemart_order_id'] = $payments[0]->virtuemart_order_id;
		$sofort_data['order_number'] = $payments[0]->order_number;
		$sofort_data['virtuemart_paymentmethod_id'] = $payments[0]->virtuemart_paymentmethod_id;
		$sofort_data['sofort_response_status'] = $sofortLib_TransactionData->getStatus();;
		$sofort_data['sofort_response_status_reason'] = $sofortLib_TransactionData->getStatusReason();

		$this->logInfo('storePSPluginInternalData before storePSPluginInternalData ' . var_export($sofort_data, true), 'message');

		$this->storePSPluginInternalData($sofort_data);

		$modelOrder->updateStatusForOneOrder($payments[0]->virtuemart_order_id, $order, TRUE);
	}

	function _checkAmountAndCurrency ($sofort_data, $payments) {
		$payment_currency_code_3 = shopFunctions::getCurrencyByID($payments[0]->payment_currency, 'currency_code_3');
		if (($sofort_data['sofort_response_amount'] != $payments[0]->payment_order_total) or ($sofort_data['sofort_response_currency'] != $payment_currency_code_3)) {
			$this->logInfo('plgVmOnPaymentNotification _checkAmountAndCurrency' . $sofort_data['sofort_response_amount'] . ' ' . $payments[0]->payment_order_total, 'message');
			$this->logInfo('plgVmOnPaymentNotification _checkAmountAndCurrency' . $sofort_data['sofort_response_currency'] . ' ' . $payment_currency_code_3, 'message');
			$emailBody = "Hello,\n\nerror while receiving a SOFORT NOTIFICATION" . "\n";
			$emailBody .= "for order number: " . $payments[0]->order_number . "\n";
			$emailBody .= "Amount received: " . $sofort_data['sofort_response_amount'] . "\n";
			$emailBody .= "Amount expected: " . $payments[0]->payment_order_total . "\n";
			$emailBody .= "Currency received: " . $sofort_data['sofort_response_currency'] . "\n";
			$emailBody .= "Currency expected: " . $payment_currency_code_3 . "\n";
			$this->sendEmailToVendorAndAdmins(JText::_('VMPAYMENT_SOFORT_ERROR_NOTIFICATION'), $emailBody);

			return false;
		}
		return true;
	}

	/**
	 * Display stored payment data for an order
	 * @param  int $virtuemart_order_id
	 * @param  int $payment_method_id
	 * @see components/com_virtuemart/helpers/vmPSPlugin::plgVmOnShowOrderBEPayment()
	 */
	function plgVmOnShowOrderBEPayment ($virtuemart_order_id, $payment_method_id) {

		if (!$this->selectedThisByMethodId($payment_method_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($payments = $this->getDatasByOrderId($virtuemart_order_id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}

		$html = '<table class="adminlist" width="50%">' . "\n";
		$html .= $this->getHtmlHeaderBE();
		$code = "sofort_response_";
		$first = TRUE;
		foreach ($payments as $payment) {
			$html .= '<tr class="row1"><td>' . JText::_('COM_VIRTUEMART_DATE') . '</td><td align="left">' . $payment->created_on . '</td></tr>';
			// Now only the first entry has this data when creating the order
			if ($first) {
				$html .= $this->getHtmlRowBE('SOFORT_PAYMENT_NAME', $payment->payment_name);
				// keep that test to have it backwards compatible. Old version was deleting that column  when receiving an IPN notification
				if ($payment->payment_order_total and  $payment->payment_order_total != 0.00) {
					$html .= $this->getHtmlRowBE('SOFORT_PAYMENT_ORDER_TOTAL', $payment->payment_order_total . " " . shopFunctions::getCurrencyByID($payment->payment_currency, 'currency_code_3'));
				}
				if ($payment->email_currency and  $payment->email_currency != 0) {
					$html .= $this->getHtmlRowBE('SOFORT_PAYMENT_EMAIL_CURRENCY', shopFunctions::getCurrencyByID($payment->email_currency, 'currency_code_3'));
				}
				if ($payment->email_currency and  $payment->email_currency != 0) {
					$html .= $this->getHtmlRowBE('SOFORT_RESPONSE_TRANSACTION', $payment->sofort_response_transaction);
				}
				$first = FALSE;
			} else {
				foreach ($payment as $key => $value) {
					// only displays if there is a value or the value is different from 0.00 and the value
					if ($value) {
						if (substr($key, 0, strlen($code)) == $code) {
							$html .= $this->getHtmlRowBE($key, $value);
						}
					}
				}
			}
		}
		$html .= '</table>' . "\n";
		return $html;
	}


	/**
	 * @param $method
	 * @param $order
	 * @return string
	 */
	function _getPaymentResponseHtml ($method, $order, $paymentTables) {
		VmConfig::loadJLang('com_virtuemart_orders', TRUE);
		if (!class_exists('CurrencyDisplay')
		) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');
		}

		if (!class_exists('VirtueMartCart')) {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
		}

		$cart = VirtueMartCart::getCart();

		$paymentCurrency = CurrencyDisplay::getInstance($order['details']['BT']->order_currency);
		$totalInPaymentCurrency = $paymentCurrency->priceDisplay($order['details']['BT']->order_total, $order['details']['BT']->order_currency);
		$currencyDisplay = CurrencyDisplay::getInstance($cart->pricesCurrency);
		$nb = count($paymentTables);
		$pluginName = $this->renderPluginName($method, $where = 'post_payment');
		$html = $this->renderByLayout('post_payment', array(
		                                                   'order' => $order,
		                                                   'paymentInfos' => $paymentTables[$nb - 1],
		                                                   'pluginName' => $pluginName,
		                                                   'totalInPaymentCurrency' => $totalInPaymentCurrency
		                                              ));
		//vmdebug('_getPaymentResponseHtml', $html,$pluginName,$paypalTable );

		return $html;
	}

	/*
		 * @param $method plugin
	 *  @param $where from where tis function is called
		 */

	protected function renderPluginName ($method, $where = 'checkout') {

		$display_logos = "";

		$logos = $method->payment_logos;
		if (!empty($logos)) {
			$display_logos = $this->displayLogos($logos) . ' ';
		}
		$payment_name = $method->payment_name;
		$html = $this->renderByLayout('render_pluginname', array(
		                                                        'where' => $where,
		                                                        'logo' => $display_logos,
		                                                        'payment_name' => $payment_name,
		                                                        'payment_description' => $method->payment_desc,
		                                                   ));

		return $html;
	}

	/**
	 * @param VirtueMartCart $cart
	 * @param                $method
	 * @param                $cart_prices
	 * @return int
	 */
	function getCosts (VirtueMartCart $cart, $method, $cart_prices) {

		if (preg_match('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
	}

	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 * @author: Valerie Isaksen
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices) {

		$this->convert($method);

		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

		$amount = $cart_prices['salesPrice'];
		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));

		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array($method->countries)) {
				$countries[0] = $method->countries;
			} else {
				$countries = $method->countries;
			}
		}
		// probably did not gave his BT:ST address
		if (!is_array($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (in_array($address['virtuemart_country_id'], $countries) || count($countries) == 0) {
			if ($amount_cond) {
				return TRUE;
			}
		}

		return FALSE;
	}

	/**
	 * @param $method
	 */
	function convert ($method) {

		$method->min_amount = (float)$method->min_amount;
		$method->max_amount = (float)$method->max_amount;
	}

	/**
	 * We must reimplement this triggers for joomla 1.7
	 */

	/**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the standard method to create the tables
	 *
	 * @author Valérie Isaksen
	 *
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {

		return $this->onStoreInstallPluginTable($jplugin_id);
	}

	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 * @author Valérie isaksen
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not vlaid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart, &$msg) {

		return $this->OnSelectCheck($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 *
	 * @author Valerie Isaksen
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {
		//return $this->displayListFE($cart, $selected, $htmlIn);


		if ($this->getPluginMethods($cart->vendorId) === 0) {
			if (empty($this->_name)) {
				$app = JFactory::getApplication();
				$app->enqueueMessage(JText::_('COM_VIRTUEMART_CART_NO_' . strtoupper($this->_psType)));
				return false;
			} else {
				return false;
			}
		}
		$htmla = array();
		$html = '';
		VmConfig::loadJLang('com_virtuemart');
		$currency = CurrencyDisplay::getInstance();
		foreach ($this->methods as $method) {
			if ($this->checkConditions($cart, $method, $cart->pricesUnformatted)) {
				$pricesUnformatted = $cart->pricesUnformatted;
				$methodSalesPrice = $this->calculateSalesPrice($cart, $method, $pricesUnformatted);

				$logo = $this->displayLogos($method->payment_logos);
				$payment_cost = '';
				if ($methodSalesPrice) {
					$payment_cost = $currency->priceDisplay($methodSalesPrice);
				}
				if ($selected == $method->virtuemart_paymentmethod_id) {
					$checked = 'checked="checked"';
				} else {
					$checked = '';
				}
				$html .= $this->renderByLayout('display_payment', array(
				                                                       'plugin' => $method,
				                                                       'checked' => $checked,
				                                                       'payment_logo' => $logo,
				                                                       'payment_cost' => $payment_cost,
				                                                  ));

				$htmla[] = $html;
			}
		}
		if (!empty($htmla)) {
			$htmlIn[] = $htmla;
		}

		return true;
	}


	/*
		 * plgVmonSelectedCalculatePricePayment
		 * Calculate the price (value, tax_id) of the selected method
		 * It is called by the calculator
		 * This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
		 * @author Valerie Isaksen
		 * @cart: VirtueMartCart the current cart
		 * @cart_prices: array the new cart prices
		 * @return null if the method was not selected, false if the payment is not valid any more, true otherwise
		 *
		 *
		 */

	/**
	 * @param VirtueMartCart $cart
	 * @param array          $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgVmOnSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice($cart, $cart_prices, $cart_prices_name);
	}

	/**
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @author Valerie Isaksen
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected($cart, $cart_prices, $paymentCounter);
	}

	/**
	 * This method is fired when showing the order details in the frontend.
	 * It displays the method-specific data.
	 *
	 * @param integer $order_id The order ID
	 * @return mixed Null for methods that aren't active, text (HTML) otherwise
	 * @author Valerie Isaksen
	 */
	public function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {


		if (!($this->selectedThisByMethodId($virtuemart_paymentmethod_id))) {
			return NULL;
		}
		$payments = $this->getDatasByOrderId($virtuemart_order_id);
		$nb = count($payments);

		$payment_name = $this->renderByLayout('order_fe', array(
		                                                       'paymentInfos' => $payments[$nb - 1],
		                                                       'paymentName' => $payments[0]->payment_name,
		                                                  ));
	}

	/**
	 * This event is fired during the checkout process. It can be used to validate the
	 * method data as entered by the user.
	 *
	 * @return boolean True when the data was valid, false otherwise. If the plugin is not activated, it should return null.

	public function plgVmOnCheckoutCheckDataPayment($psType, VirtueMartCart $cart) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing when printing an Order
	 * It displays the the payment method-specific data.
	 *
	 * @param integer $order_number The order number
	 * @param integer $method_id  method used for this order
	 * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
	 * @author Valerie Isaksen
	 */
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {

		return $this->onShowOrderPrint($order_number, $method_id);
	}

	/**
	 * Save updated order data to the method specific table
	 *
	 * @param array $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.

	public function plgVmOnUpdateOrderPayment(  $_formData) {
	return null;
	}
	 */
	/**
	 * Save updated orderline data to the method specific table
	 *
	 * @param array $_formData Form data
	 * @return mixed, True on success, false on failures (the rest of the save-process will be
	 * skipped!), or null when this method is not actived.

	public function plgVmOnUpdateOrderLine(  $_formData) {
	return null;
	}
	 */
	/**
	 * plgVmOnEditOrderLineBE
	 * This method is fired when editing the order line details in the backend.
	 * It can be used to add line specific package codes
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise

	public function plgVmOnEditOrderLineBE(  $_orderId, $_lineId) {
	return null;
	}
	 */

	/**
	 * This method is fired when showing the order details in the frontend, for every orderline.
	 * It can be used to display line specific package codes, e.g. with a link to external tracking and
	 * tracing systems
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise

	public function plgVmOnShowOrderLineFE(  $_orderId, $_lineId) {
	return null;
	}
	 */
	function plgVmDeclarePluginParamsPayment ($name, $id, &$data) {

		return $this->declarePluginParams('payment', $name, $id, $data);
	}

	/**
	 * @param $name
	 * @param $id
	 * @param $table
	 * @return bool
	 */
	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table) {

		return $this->setOnTablePluginParams($name, $id, $table);
	}


	static function   getSuccessUrl ($order) {
		return substr(JURI::root(false,''),0,-1). JROUTE::_("index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&pm=" . $order['details']['BT']->virtuemart_paymentmethod_id . '&on=' . $order['details']['BT']->order_number . "&Itemid=" . JRequest::getInt('Itemid'), false);
	}

	static function   getCancelUrl ($order) {
		return substr(JURI::root(false,''),0,-1). JROUTE::_("index.php?option=com_virtuemart&view=pluginresponse&task=pluginUserPaymentCancel&pm=" . $order['details']['BT']->virtuemart_paymentmethod_id . '&on=' . $order['details']['BT']->order_number . '&Itemid=' . JRequest::getInt('Itemid'), false);
	}

	static function   getNotificationUrl ($security, $order_number) {

		return substr(JURI::root(false,''),0,-1) . JROUTE::_("index.php?option=com_virtuemart&view=pluginresponse&task=pluginnotification&tmpl=component&&security=" . $security . "&on=" . $order_number, false);
	}

	static function getSecurityKey () {
		if (!class_exists('SofortLib_SofortueberweisungClassic')) {
			require(JPATH_ROOT . DS . 'plugins' . DS . 'vmpayment' . DS . 'sofort' . DS . 'sofort' . DS . 'library' . DS . 'sofortLib_sofortueberweisung_classic.php');
		}
		return SofortLib_SofortueberweisungClassic::generatePassword();
	}
}

// No closing tag
