/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Color;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JTextArea;
import wjhk.jupload2.policies.UploadPolicy;

public class JUploadTextArea
extends JTextArea {
    public static final int MAX_LOG_WINDOW_LENGTH = 800000;
    public static final int SIZE_TO_TRUNCATE_TO = 640000;
    UploadPolicy uploadPolicy;
    private BlockingQueue<String> messages;
    LogMessageThread logMessageThread = null;

    public JUploadTextArea(int rows, int columns, UploadPolicy uploadPolicy) {
        super(rows, columns);
        this.uploadPolicy = uploadPolicy;
        this.messages = new LinkedBlockingQueue<String>();
        this.setBackground(new Color(255, 255, 203));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.logMessageThread = new LogMessageThread(this);
        this.logMessageThread.setName(this.logMessageThread.getClass().getName());
        this.logMessageThread.start();
    }

    public final void displayMsg(String str) {
        try {
            this.messages.put(str);
        }
        catch (InterruptedException e) {
            System.out.println("WARNING - [" + this.getClass().getName() + "] Message lost due to " + e.getClass().getName() + " (" + str + ")");
        }
    }

    public void unload() {
        this.logMessageThread.unload();
    }

    static class LogMessageThread
    extends Thread {
        private JUploadTextArea textArea;
        boolean isRunning = true;
        int textLength = 0;

        LogMessageThread(JUploadTextArea textArea) {
            this.textArea = textArea;
            this.setDaemon(true);
        }

        public void run() {
            String nextMessage = null;
            while (true) {
                try {
                    while (true) {
                        nextMessage = (String)this.textArea.messages.take();
                        if (this.textLength > 800000) {
                            String content = this.textArea.getText() + nextMessage;
                            String newContent = content.substring(content.length() - 640000, content.length());
                            this.textArea.setText(newContent);
                            this.textLength = 640000;
                        } else {
                            this.textArea.append(nextMessage);
                            this.textLength += nextMessage.length();
                        }
                        this.textArea.setCaretPosition(this.textLength - 1);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.isRunning) continue;
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public void unload() {
            this.isRunning = false;
            this.interrupt();
        }
    }
}

