/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.context;

import java.awt.Cursor;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import wjhk.jupload2.context.DefaultJUploadContext;
import wjhk.jupload2.exception.JUploadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUploadContextExecutable
extends DefaultJUploadContext {
    static final String DEFAULT_PROPERTIES_FILE = "/conf/default_daemon.properties";
    static final String DAEMON_PROPERTIES_FILE = "/conf/daemon.properties";
    private JFrame jframe = null;
    protected Properties defaultProperties = null;
    protected Properties daemonProperties = null;

    protected JUploadContextExecutable() {
    }

    public JUploadContextExecutable(JFrame jframe, String propertiesURL) {
        if (jframe == null) {
            throw new IllegalArgumentException("theApplet may not be null");
        }
        this.jframe = jframe;
        this.defaultProperties = this.loadPropertiesFromFileInJar(DEFAULT_PROPERTIES_FILE, null);
        this.daemonProperties = propertiesURL == null ? this.loadPropertiesFromFileInJar(DAEMON_PROPERTIES_FILE, this.defaultProperties) : this.loadPropertiesFromURL(propertiesURL, this.defaultProperties);
        this.init(this.jframe);
    }

    Properties loadPropertiesFromFileInJar(String filename, Properties defaultProperties) {
        Properties properties = new Properties(defaultProperties);
        try {
            InputStream isProperties = Class.forName("wjhk.jupload2.JUploadApplet").getResourceAsStream(filename);
            properties.load(isProperties);
            isProperties.close();
        }
        catch (IOException e1) {
            System.out.println("Error while loading " + filename + " (" + e1.getClass().getName() + ")");
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            System.out.println("Error while loading " + filename + " (" + e1.getClass().getName() + ")");
            e1.printStackTrace();
        }
        return properties;
    }

    private Properties loadPropertiesFromURL(String propertiesURL, Properties defaultProperties) {
        Properties properties = new Properties(defaultProperties);
        try {
            URL url = new URL(propertiesURL);
            URLConnection urlConnection = url.openConnection();
            properties.load(urlConnection.getInputStream());
        }
        catch (MalformedURLException e) {
            System.out.println("Error while loading url " + propertiesURL + " (" + e.getClass().getName() + ")");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error while loading url " + propertiesURL + " (" + e.getClass().getName() + ")");
            e.printStackTrace();
        }
        return properties;
    }

    @Override
    public String getParameter(String key, String def) {
        String paramStr = this.daemonProperties.getProperty(key) != null ? this.daemonProperties.getProperty(key) : def;
        this.displayDebugParameterValue(key, paramStr);
        return paramStr;
    }

    @Override
    public int getParameter(String key, int def) {
        String paramDef = Integer.toString(def);
        String paramStr = this.daemonProperties.getProperty(key) != null ? this.daemonProperties.getProperty(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseInt(paramStr, def);
    }

    @Override
    public float getParameter(String key, float def) {
        String paramDef = Float.toString(def);
        String paramStr = this.daemonProperties.getProperty(key) != null ? this.daemonProperties.getProperty(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseFloat(paramStr, def);
    }

    @Override
    public long getParameter(String key, long def) {
        String paramDef = Long.toString(def);
        String paramStr = this.daemonProperties.getProperty(key) != null ? this.daemonProperties.getProperty(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseLong(paramStr, def);
    }

    @Override
    public boolean getParameter(String key, boolean def) {
        String paramDef = def ? "true" : "false";
        String paramStr = this.daemonProperties.getProperty(key) != null ? this.daemonProperties.getProperty(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseBoolean(paramStr, def);
    }

    @Override
    public void displayURL(String url, boolean success) {
        throw new UnsupportedOperationException("JUploadContextExecution.displayURL(): Not implemented yet!");
    }

    @Override
    public JApplet getApplet() {
        throw new UnsupportedOperationException("Can't use getApplet(), when using the JUploadDaemon!");
    }

    @Override
    public Cursor getCursor() {
        return this.jframe.getCursor();
    }

    @Override
    public String normalizeURL(String url) throws JUploadException {
        return url;
    }

    @Override
    public void readCookieAndUserAgentFromNavigator(Vector<String> headers) {
        throw new UnsupportedOperationException("Can't use readCookieAndUserAgentFromNavigator(), when using the JUploadDaemon!");
    }

    @Override
    public Cursor setCursor(Cursor cursor) {
        Cursor previousCursor = this.jframe.getCursor();
        this.jframe.setCursor(cursor);
        return previousCursor;
    }

    @Override
    public void showStatus(String status) {
    }
}

